/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc.async;

import com.google.cloud.bigtable.config.RetryOptions;
import com.google.cloud.bigtable.grpc.async.AbstractRetryingRpcListener;
import com.google.cloud.bigtable.grpc.async.BigtableAsyncRpc;
import io.grpc.CallOptions;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.util.concurrent.ScheduledExecutorService;

public class RetryingUnaryRpcCallListener<RequestT, ResponseT>
extends AbstractRetryingRpcListener<RequestT, ResponseT, ResponseT> {
    static final StatusRuntimeException NO_VALUE_SET_EXCEPTION = Status.INTERNAL.withDescription("No value received for unary call").asRuntimeException();
    private ResponseT value;

    public RetryingUnaryRpcCallListener(RetryOptions retryOptions, RequestT request, BigtableAsyncRpc<RequestT, ResponseT> retryableRpc, CallOptions callOptions, ScheduledExecutorService executorService, Metadata metadata) {
        super(retryOptions, request, retryableRpc, callOptions, executorService, metadata);
    }

    public void onMessage(ResponseT message) {
        this.value = message;
        this.completionFuture.set(this.value);
    }

    @Override
    protected void onOK() {
        if (this.value == null) {
            this.completionFuture.setException((Throwable)NO_VALUE_SET_EXCEPTION);
        }
    }
}

