/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc.async;

import com.google.api.client.util.NanoClock;
import com.google.cloud.bigtable.config.Logger;
import com.google.cloud.bigtable.grpc.async.ResourceLimiter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.GuardedBy;

public class OperationAccountant {
    protected static final Logger LOG = new Logger(OperationAccountant.class);
    private static final long DEFAULT_FINISH_WAIT_MILLIS = 250L;
    private static final long INTERVAL_NO_SUCCESS_WARNING_NANOS = TimeUnit.SECONDS.toNanos(30L);
    private final ResourceLimiter resourceLimiter;
    private final NanoClock clock;
    private final long finishWaitMillis;
    private final AtomicLong complexOperationIdGenerator = new AtomicLong();
    private ReentrantLock lock = new ReentrantLock();
    private Condition flushedCondition = this.lock.newCondition();
    @GuardedBy(value="lock")
    private Set<Long> operations = new HashSet<Long>();
    @GuardedBy(value="lock")
    private Map<Long, ComplexOperationStalenessHandler> complexOperations = new HashMap<Long, ComplexOperationStalenessHandler>();
    private long noSuccessCheckDeadlineNanos;
    private int noSuccessWarningCount;

    public OperationAccountant(ResourceLimiter resourceLimiter) {
        this(resourceLimiter, NanoClock.SYSTEM, 250L);
    }

    @VisibleForTesting
    OperationAccountant(ResourceLimiter resourceLimiter, NanoClock clock, long finishWaitMillis) {
        this.resourceLimiter = resourceLimiter;
        this.clock = clock;
        this.finishWaitMillis = finishWaitMillis;
        this.resetNoSuccessWarningDeadline();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long registerOperationWithHeapSize(long heapSize) throws InterruptedException {
        long id = this.resourceLimiter.registerOperationWithHeapSize(heapSize);
        this.lock.lock();
        try {
            this.operations.add(id);
        }
        finally {
            this.lock.unlock();
        }
        return id;
    }

    public <T> FutureCallback<T> addCallback(ListenableFuture<T> future, final long id) {
        FutureCallback callback = new FutureCallback<T>(){

            public void onSuccess(T result) {
                OperationAccountant.this.onOperationCompletion(id);
            }

            public void onFailure(Throwable t) {
                OperationAccountant.this.onOperationCompletion(id);
            }
        };
        Futures.addCallback(future, (FutureCallback)callback);
        return callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> long registerComplexOperation(ComplexOperationStalenessHandler handler) {
        long id = this.complexOperationIdGenerator.incrementAndGet();
        this.lock.lock();
        try {
            this.complexOperations.put(id, handler);
        }
        finally {
            this.lock.unlock();
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitCompletion() throws InterruptedException {
        boolean performedWarning = false;
        this.lock.lock();
        try {
            while (!this.isFlushed()) {
                this.flushedCondition.await(this.finishWaitMillis, TimeUnit.MILLISECONDS);
                long now = this.clock.nanoTime();
                if (now < this.noSuccessCheckDeadlineNanos) continue;
                ImmutableList toCheck = ImmutableList.copyOf(this.complexOperations.values());
                this.lock.unlock();
                try {
                    for (ComplexOperationStalenessHandler stalenessHandler : toCheck) {
                        stalenessHandler.performRetryIfStale();
                    }
                }
                finally {
                    this.lock.lock();
                }
                if (this.isFlushed()) break;
                this.logNoSuccessWarning(now);
                this.resetNoSuccessWarningDeadline();
                performedWarning = true;
            }
            if (performedWarning) {
                LOG.info("awaitCompletion() completed", new Object[0]);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void logNoSuccessWarning(long now) {
        long lastUpdateNanos = now - this.noSuccessCheckDeadlineNanos + INTERVAL_NO_SUCCESS_WARNING_NANOS;
        long lastUpdated = TimeUnit.NANOSECONDS.toSeconds(lastUpdateNanos);
        LOG.warn("No operations completed within the last %d seconds. There are still %d simple operations and %d complex operations in progress.", lastUpdated, this.operations.size(), this.complexOperations.size());
        ++this.noSuccessWarningCount;
    }

    public long getMaxHeapSize() {
        return this.resourceLimiter.getMaxHeapSize();
    }

    public boolean hasInflightOperations() {
        this.lock.lock();
        try {
            boolean bl = !this.isFlushed();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean isFlushed() {
        return this.operations.isEmpty() && this.complexOperations.isEmpty();
    }

    private void resetNoSuccessWarningDeadline() {
        this.noSuccessCheckDeadlineNanos = this.clock.nanoTime() + INTERVAL_NO_SUCCESS_WARNING_NANOS;
    }

    @VisibleForTesting
    int getNoSuccessWarningCount() {
        return this.noSuccessWarningCount;
    }

    @VisibleForTesting
    void onOperationCompletion(long id) {
        this.resourceLimiter.markCanBeCompleted(id);
        this.lock.lock();
        try {
            this.operations.remove(id);
            if (this.isFlushed()) {
                this.flushedCondition.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
        this.resetNoSuccessWarningDeadline();
    }

    public void onComplexOperationCompletion(long id) {
        this.lock.lock();
        try {
            this.complexOperations.remove(id);
            if (this.isFlushed()) {
                this.flushedCondition.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
        this.resetNoSuccessWarningDeadline();
    }

    public static interface ComplexOperationStalenessHandler {
        public void performRetryIfStale();
    }
}

