/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc.async;

import com.google.cloud.bigtable.grpc.async.BigtableAsyncRpc;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;

public interface BigtableAsyncUtilities {
    public <RequestT, ResponseT> BigtableAsyncRpc<RequestT, ResponseT> createAsyncRpc(MethodDescriptor<RequestT, ResponseT> var1, Predicate<RequestT> var2);

    public static class Default
    implements BigtableAsyncUtilities {
        private final Channel channel;

        public Default(Channel channel) {
            this.channel = channel;
        }

        @Override
        public <RequestT, ResponseT> BigtableAsyncRpc<RequestT, ResponseT> createAsyncRpc(final MethodDescriptor<RequestT, ResponseT> method, final Predicate<RequestT> isRetryable) {
            final BigtableAsyncRpc.RpcMetrics metrics = BigtableAsyncRpc.RpcMetrics.createRpcMetrics(method);
            return new BigtableAsyncRpc<RequestT, ResponseT>(){

                @Override
                public boolean isRetryable(RequestT request) {
                    return isRetryable.apply(request);
                }

                @Override
                public MethodDescriptor<RequestT, ResponseT> getMethodDescriptor() {
                    return method;
                }

                @Override
                public BigtableAsyncRpc.RpcMetrics getRpcMetrics() {
                    return metrics;
                }

                @Override
                public ClientCall<RequestT, ResponseT> newCall(CallOptions callOptions) {
                    return Default.this.channel.newCall(method, callOptions);
                }

                @Override
                public void start(ClientCall<RequestT, ResponseT> call, RequestT request, ClientCall.Listener<ResponseT> listener, Metadata metadata) {
                    call.start(listener, metadata);
                    call.request(1);
                    try {
                        call.sendMessage(request);
                    }
                    catch (Throwable t) {
                        call.cancel("Exception in sendMessage.", t);
                        throw Throwables.propagate((Throwable)t);
                    }
                    try {
                        call.halfClose();
                    }
                    catch (Throwable t) {
                        call.cancel("Exception in halfClose.", t);
                        throw Throwables.propagate((Throwable)t);
                    }
                }
            };
        }
    }
}

