/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc.async;

import com.google.api.client.util.BackOff;
import com.google.api.client.util.Sleeper;
import com.google.cloud.bigtable.config.Logger;
import com.google.cloud.bigtable.config.RetryOptions;
import com.google.cloud.bigtable.grpc.async.BigtableAsyncRpc;
import com.google.cloud.bigtable.grpc.io.ChannelPool;
import com.google.cloud.bigtable.grpc.scanner.BigtableRetriesExhaustedException;
import com.google.cloud.bigtable.metrics.Timer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.ListenableFuture;
import io.grpc.CallOptions;
import io.grpc.ClientCall;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public abstract class AbstractRetryingRpcListener<RequestT, ResponseT, ResultT>
extends ClientCall.Listener<ResponseT>
implements Runnable {
    protected static final Logger LOG = new Logger(AbstractRetryingRpcListener.class);
    protected BackOff currentBackoff;
    @VisibleForTesting
    Sleeper sleeper = Sleeper.DEFAULT;
    protected final BigtableAsyncRpc<RequestT, ResponseT> rpc;
    protected final RetryOptions retryOptions;
    protected final ScheduledExecutorService retryExecutorService;
    private final RequestT request;
    private final CallOptions callOptions;
    private final Metadata originalMetadata;
    protected int failedCount = 0;
    protected final GrpcFuture<ResultT> completionFuture;
    protected Object callLock = new String("");
    protected ClientCall<RequestT, ResponseT> call;
    private Timer.Context operationTimerContext;
    protected Timer.Context rpcTimerContext;

    public AbstractRetryingRpcListener(RetryOptions retryOptions, RequestT request, BigtableAsyncRpc<RequestT, ResponseT> retryableRpc, CallOptions callOptions, ScheduledExecutorService retryExecutorService, Metadata originalMetadata) {
        this.retryOptions = retryOptions;
        this.request = request;
        this.rpc = retryableRpc;
        this.callOptions = callOptions;
        this.retryExecutorService = retryExecutorService;
        this.originalMetadata = originalMetadata;
        this.completionFuture = this.createCompletionFuture();
    }

    protected GrpcFuture<ResultT> createCompletionFuture() {
        return new GrpcFuture();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClose(Status status, Metadata trailers) {
        Object object = this.callLock;
        synchronized (object) {
            this.call = null;
        }
        this.rpcTimerContext.close();
        Status.Code code = status.getCode();
        if (code == Status.Code.OK) {
            this.operationTimerContext.close();
            this.onOK();
            return;
        }
        if (code == Status.Code.CANCELLED) {
            this.operationTimerContext.close();
            return;
        }
        if (!this.retryOptions.enableRetries() || !this.retryOptions.isRetryable(code) || !this.isRequestRetryable() && code != Status.Code.UNAUTHENTICATED) {
            this.rpc.getRpcMetrics().markFailure();
            this.operationTimerContext.close();
            this.setException((Exception)status.asRuntimeException());
            return;
        }
        long nextBackOff = this.getNextBackoff();
        ++this.failedCount;
        if (nextBackOff == -1L) {
            this.rpc.getRpcMetrics().markRetriesExhasted();
            this.operationTimerContext.close();
            String message = String.format("Exhausted retries after %d failures.", this.failedCount);
            StatusRuntimeException cause = status.asRuntimeException();
            this.setException(new BigtableRetriesExhaustedException(message, (Throwable)cause));
            return;
        }
        String channelId = ChannelPool.extractIdentifier(trailers);
        LOG.info("Retrying failed call. Failure #%d, got: %s on channel %s", status.getCause(), this.failedCount, status, channelId);
        this.rpc.getRpcMetrics().markRetry();
        this.retryExecutorService.schedule(this, nextBackOff, TimeUnit.MILLISECONDS);
    }

    protected boolean isRequestRetryable() {
        return this.rpc.isRetryable(this.getRetryRequest());
    }

    protected void setException(Exception exception) {
        this.completionFuture.setException(exception);
    }

    protected abstract void onOK();

    private long getNextBackoff() {
        if (this.currentBackoff == null) {
            this.currentBackoff = this.retryOptions.createBackoff();
        }
        try {
            return this.currentBackoff.nextBackOffMillis();
        }
        catch (IOException e) {
            return -1L;
        }
    }

    public ListenableFuture<ResultT> getCompletionFuture() {
        return this.completionFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.rpcTimerContext = this.rpc.getRpcMetrics().timeRpc();
        Metadata metadata = new Metadata();
        metadata.merge(this.originalMetadata);
        Object object = this.callLock;
        synchronized (object) {
            this.call = this.rpc.newCall(this.callOptions);
        }
        this.rpc.start(this.call, this.getRetryRequest(), this, metadata);
    }

    protected RequestT getRetryRequest() {
        return this.request;
    }

    public void start() {
        this.operationTimerContext = this.rpc.getRpcMetrics().timeOperation();
        this.run();
    }

    public synchronized void cancel() {
        this.cancel("User requested cancelation.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancel(String message) {
        Object object = this.callLock;
        synchronized (object) {
            if (this.call != null) {
                this.call.cancel(message, null);
                this.call = null;
            }
        }
    }

    protected class GrpcFuture<RespT>
    extends AbstractFuture<RespT> {
        protected GrpcFuture() {
        }

        protected void interruptTask() {
            AbstractRetryingRpcListener.this.cancel("Request interrupted.");
        }

        protected boolean set(@Nullable RespT resp) {
            return super.set(resp);
        }

        protected boolean setException(Throwable throwable) {
            return super.setException(throwable);
        }
    }
}

