/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc;

import com.google.bigtable.v2.MutateRowsRequest;
import com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.v2.RowSet;
import com.google.cloud.bigtable.config.CallOptionsConfig;
import io.grpc.CallOptions;
import io.grpc.Deadline;
import io.grpc.MethodDescriptor;
import java.util.concurrent.TimeUnit;

public interface CallOptionsFactory {
    public <RequestT> CallOptions create(MethodDescriptor<RequestT, ?> var1, RequestT var2);

    public static class ConfiguredCallOptionsFactory
    implements CallOptionsFactory {
        private final CallOptionsConfig config;

        public ConfiguredCallOptionsFactory(CallOptionsConfig config) {
            this.config = config;
        }

        @Override
        public <RequestT> CallOptions create(MethodDescriptor<RequestT, ?> descriptor, RequestT request) {
            if (!this.config.isUseTimeout() || request == null) {
                return CallOptions.DEFAULT;
            }
            int timeout = this.config.getShortRpcTimeoutMs();
            if (this.isLongRequest(request)) {
                timeout = this.config.getLongRpcTimeoutMs();
            }
            return CallOptions.DEFAULT.withDeadline(Deadline.after((long)timeout, (TimeUnit)TimeUnit.MILLISECONDS));
        }

        boolean isLongRequest(Object request) {
            Class<?> requestClass = request.getClass();
            return requestClass == MutateRowsRequest.class || requestClass == ReadRowsRequest.class && !this.isGet((ReadRowsRequest)request);
        }

        private boolean isGet(ReadRowsRequest request) {
            RowSet rowSet = request.getRows();
            return rowSet != null && rowSet.getRowRangesCount() == 0 && rowSet.getRowKeysCount() == 1;
        }
    }

    public static class Default
    implements CallOptionsFactory {
        @Override
        public <RequestT> CallOptions create(MethodDescriptor<RequestT, ?> descriptor, RequestT request) {
            return CallOptions.DEFAULT;
        }
    }
}

