/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc;

import com.google.common.base.Preconditions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BigtableSnapshotName {
    private static final Pattern PATTERN = Pattern.compile("projects/[^/]+/instances/([^/]+)/clusters/([^/]+)/snapshots/([^/]+)");
    private final String snapshotName;
    private final String instanceId;
    private final String clusterId;
    private final String snapshotId;

    public BigtableSnapshotName(String snapshotName) {
        this.snapshotName = snapshotName;
        Matcher matcher = PATTERN.matcher(snapshotName);
        Preconditions.checkArgument((boolean)matcher.matches(), (Object)"Malformed snapshot name");
        this.instanceId = matcher.group(1);
        this.clusterId = matcher.group(2);
        this.snapshotId = matcher.group(3);
    }

    public String toString() {
        return this.snapshotName;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    public String getSnapshotName() {
        return this.snapshotName;
    }
}

