/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc;

import com.google.bigtable.v2.BigtableGrpc;
import com.google.bigtable.v2.CheckAndMutateRowRequest;
import com.google.bigtable.v2.CheckAndMutateRowResponse;
import com.google.bigtable.v2.MutateRowRequest;
import com.google.bigtable.v2.MutateRowResponse;
import com.google.bigtable.v2.MutateRowsRequest;
import com.google.bigtable.v2.MutateRowsResponse;
import com.google.bigtable.v2.Mutation;
import com.google.bigtable.v2.ReadModifyWriteRowRequest;
import com.google.bigtable.v2.ReadModifyWriteRowResponse;
import com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.v2.ReadRowsResponse;
import com.google.bigtable.v2.Row;
import com.google.bigtable.v2.SampleRowKeysRequest;
import com.google.bigtable.v2.SampleRowKeysResponse;
import com.google.cloud.bigtable.config.BigtableOptions;
import com.google.cloud.bigtable.config.RetryOptions;
import com.google.cloud.bigtable.grpc.BigtableDataClient;
import com.google.cloud.bigtable.grpc.CallOptionsFactory;
import com.google.cloud.bigtable.grpc.async.AbstractRetryingRpcListener;
import com.google.cloud.bigtable.grpc.async.BigtableAsyncRpc;
import com.google.cloud.bigtable.grpc.async.BigtableAsyncUtilities;
import com.google.cloud.bigtable.grpc.async.RetryingCollectingClientCallListener;
import com.google.cloud.bigtable.grpc.async.RetryingUnaryRpcCallListener;
import com.google.cloud.bigtable.grpc.io.ChannelPool;
import com.google.cloud.bigtable.grpc.io.GoogleCloudResourcePrefixInterceptor;
import com.google.cloud.bigtable.grpc.scanner.FlatRow;
import com.google.cloud.bigtable.grpc.scanner.FlatRowConverter;
import com.google.cloud.bigtable.grpc.scanner.ReadRowsRetryListener;
import com.google.cloud.bigtable.grpc.scanner.ResponseQueueReader;
import com.google.cloud.bigtable.grpc.scanner.ResultScanner;
import com.google.cloud.bigtable.grpc.scanner.ResumingStreamingResultScanner;
import com.google.cloud.bigtable.grpc.scanner.RowMerger;
import com.google.cloud.bigtable.grpc.scanner.ScanHandler;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;

public class BigtableDataGrpcClient
implements BigtableDataClient {
    @VisibleForTesting
    public static final Predicate<MutateRowRequest> IS_RETRYABLE_MUTATION = new Predicate<MutateRowRequest>(){

        public boolean apply(MutateRowRequest mutateRowRequest) {
            return mutateRowRequest != null && BigtableDataGrpcClient.allCellsHaveTimestamps(mutateRowRequest.getMutationsList());
        }
    };
    @VisibleForTesting
    public static final Predicate<MutateRowsRequest> ARE_RETRYABLE_MUTATIONS = new Predicate<MutateRowsRequest>(){

        public boolean apply(MutateRowsRequest mutateRowsRequest) {
            if (mutateRowsRequest == null) {
                return false;
            }
            for (MutateRowsRequest.Entry entry : mutateRowsRequest.getEntriesList()) {
                if (BigtableDataGrpcClient.allCellsHaveTimestamps(entry.getMutationsList())) continue;
                return false;
            }
            return true;
        }
    };
    @VisibleForTesting
    public static final Predicate<CheckAndMutateRowRequest> IS_RETRYABLE_CHECK_AND_MUTATE = new Predicate<CheckAndMutateRowRequest>(){

        public boolean apply(CheckAndMutateRowRequest checkAndMutateRowRequest) {
            return checkAndMutateRowRequest != null && BigtableDataGrpcClient.allCellsHaveTimestamps(checkAndMutateRowRequest.getTrueMutationsList()) && BigtableDataGrpcClient.allCellsHaveTimestamps(checkAndMutateRowRequest.getFalseMutationsList());
        }
    };
    private static Function<FlatRow, Row> FLAT_ROW_TRANSFORMER = new Function<FlatRow, Row>(){

        public Row apply(FlatRow input) {
            return FlatRowConverter.convert(input);
        }
    };
    private static Function<List<ReadRowsResponse>, List<FlatRow>> FLAT_ROW_LIST_TRANSFORMER = new Function<List<ReadRowsResponse>, List<FlatRow>>(){

        public List<FlatRow> apply(List<ReadRowsResponse> responses) {
            return RowMerger.toRows(responses);
        }
    };
    private static Function<List<ReadRowsResponse>, List<Row>> ROW_LIST_TRANSFORMER = new Function<List<ReadRowsResponse>, List<Row>>(){

        public List<Row> apply(List<ReadRowsResponse> responses) {
            return Lists.transform(RowMerger.toRows(responses), (Function)FLAT_ROW_TRANSFORMER);
        }
    };
    private final ScheduledExecutorService retryExecutorService;
    private final RetryOptions retryOptions;
    private CallOptionsFactory callOptionsFactory = new CallOptionsFactory.Default();
    private final BigtableAsyncRpc<SampleRowKeysRequest, SampleRowKeysResponse> sampleRowKeysAsync;
    private final BigtableAsyncRpc<ReadRowsRequest, ReadRowsResponse> readRowsAsync;
    private final BigtableAsyncRpc<MutateRowRequest, MutateRowResponse> mutateRowRpc;
    private final BigtableAsyncRpc<MutateRowsRequest, MutateRowsResponse> mutateRowsRpc;
    private final BigtableAsyncRpc<CheckAndMutateRowRequest, CheckAndMutateRowResponse> checkAndMutateRpc;
    private final BigtableAsyncRpc<ReadModifyWriteRowRequest, ReadModifyWriteRowResponse> readWriteModifyRpc;

    private static final boolean allCellsHaveTimestamps(Iterable<Mutation> mutations) {
        for (Mutation mut : mutations) {
            if (mut.getSetCell().getTimestampMicros() > 0L) continue;
            return false;
        }
        return true;
    }

    public BigtableDataGrpcClient(ChannelPool channelPool, ScheduledExecutorService retryExecutorService, BigtableOptions bigtableOptions) {
        this(retryExecutorService, bigtableOptions, new BigtableAsyncUtilities.Default((Channel)channelPool));
    }

    @VisibleForTesting
    BigtableDataGrpcClient(ScheduledExecutorService retryExecutorService, BigtableOptions bigtableOptions, BigtableAsyncUtilities asyncUtilities) {
        this.retryExecutorService = retryExecutorService;
        this.retryOptions = bigtableOptions.getRetryOptions();
        this.sampleRowKeysAsync = asyncUtilities.createAsyncRpc(BigtableGrpc.METHOD_SAMPLE_ROW_KEYS, Predicates.alwaysTrue());
        this.readRowsAsync = asyncUtilities.createAsyncRpc(BigtableGrpc.METHOD_READ_ROWS, Predicates.alwaysTrue());
        this.mutateRowRpc = asyncUtilities.createAsyncRpc(BigtableGrpc.METHOD_MUTATE_ROW, this.getMutationRetryableFunction(IS_RETRYABLE_MUTATION));
        this.mutateRowsRpc = asyncUtilities.createAsyncRpc(BigtableGrpc.METHOD_MUTATE_ROWS, this.getMutationRetryableFunction(ARE_RETRYABLE_MUTATIONS));
        this.checkAndMutateRpc = asyncUtilities.createAsyncRpc(BigtableGrpc.METHOD_CHECK_AND_MUTATE_ROW, this.getMutationRetryableFunction(IS_RETRYABLE_CHECK_AND_MUTATE));
        this.readWriteModifyRpc = asyncUtilities.createAsyncRpc(BigtableGrpc.METHOD_READ_MODIFY_WRITE_ROW, Predicates.alwaysFalse());
    }

    @Override
    public void setCallOptionsFactory(CallOptionsFactory callOptionsFactory) {
        this.callOptionsFactory = callOptionsFactory;
    }

    private <T> Predicate<T> getMutationRetryableFunction(Predicate<T> isRetryableMutation) {
        if (this.retryOptions.allowRetriesWithoutTimestamp()) {
            return Predicates.alwaysTrue();
        }
        return isRetryableMutation;
    }

    @Override
    public MutateRowResponse mutateRow(MutateRowRequest request) {
        return this.getBlockingUnaryResult(request, this.mutateRowRpc, request.getTableName());
    }

    @Override
    public ListenableFuture<MutateRowResponse> mutateRowAsync(MutateRowRequest request) {
        return this.getUnaryFuture(request, this.mutateRowRpc, request.getTableName());
    }

    @Override
    public List<MutateRowsResponse> mutateRows(MutateRowsRequest request) {
        return this.getBlockingStreamingResult(request, this.mutateRowsRpc, request.getTableName());
    }

    @Override
    public ListenableFuture<List<MutateRowsResponse>> mutateRowsAsync(MutateRowsRequest request) {
        return this.getStreamingFuture(request, this.mutateRowsRpc, request.getTableName());
    }

    @Override
    public CheckAndMutateRowResponse checkAndMutateRow(CheckAndMutateRowRequest request) {
        return this.getBlockingUnaryResult(request, this.checkAndMutateRpc, request.getTableName());
    }

    @Override
    public ListenableFuture<CheckAndMutateRowResponse> checkAndMutateRowAsync(CheckAndMutateRowRequest request) {
        return this.getUnaryFuture(request, this.checkAndMutateRpc, request.getTableName());
    }

    @Override
    public ReadModifyWriteRowResponse readModifyWriteRow(ReadModifyWriteRowRequest request) {
        return this.getBlockingUnaryResult(request, this.readWriteModifyRpc, request.getTableName());
    }

    @Override
    public ListenableFuture<ReadModifyWriteRowResponse> readModifyWriteRowAsync(ReadModifyWriteRowRequest request) {
        return this.getUnaryFuture(request, this.readWriteModifyRpc, request.getTableName());
    }

    @Override
    public ImmutableList<SampleRowKeysResponse> sampleRowKeys(SampleRowKeysRequest request) {
        return ImmutableList.copyOf(this.getBlockingStreamingResult(request, this.sampleRowKeysAsync, request.getTableName()));
    }

    @Override
    public ListenableFuture<List<SampleRowKeysResponse>> sampleRowKeysAsync(SampleRowKeysRequest request) {
        return this.getStreamingFuture(request, this.sampleRowKeysAsync, request.getTableName());
    }

    @Override
    public ListenableFuture<List<Row>> readRowsAsync(ReadRowsRequest request) {
        return Futures.transform(this.getStreamingFuture(request, this.readRowsAsync, request.getTableName()), ROW_LIST_TRANSFORMER);
    }

    @Override
    public ListenableFuture<List<FlatRow>> readFlatRowsAsync(ReadRowsRequest request) {
        return Futures.transform(this.getStreamingFuture(request, this.readRowsAsync, request.getTableName()), FLAT_ROW_LIST_TRANSFORMER);
    }

    protected <ReqT, RespT> ListenableFuture<List<RespT>> getStreamingFuture(ReqT request, BigtableAsyncRpc<ReqT, RespT> rpc, String tableName) {
        return BigtableDataGrpcClient.getCompletionFuture(this.createStreamingListener(request, rpc, tableName));
    }

    private <ReqT, RespT> List<RespT> getBlockingStreamingResult(ReqT request, BigtableAsyncRpc<ReqT, RespT> rpc, String tableName) {
        return (List)BigtableDataGrpcClient.getBlockingResult(this.createStreamingListener(request, rpc, tableName));
    }

    private <ReqT, RespT> ListenableFuture<RespT> getUnaryFuture(ReqT request, BigtableAsyncRpc<ReqT, RespT> rpc, String tableName) {
        return BigtableDataGrpcClient.getCompletionFuture(this.createUnaryListener(request, rpc, tableName));
    }

    private <ReqT, RespT> RespT getBlockingUnaryResult(ReqT request, BigtableAsyncRpc<ReqT, RespT> rpc, String tableName) {
        return (RespT)BigtableDataGrpcClient.getBlockingResult(this.createUnaryListener(request, rpc, tableName));
    }

    private <ReqT, RespT> RetryingUnaryRpcCallListener<ReqT, RespT> createUnaryListener(ReqT request, BigtableAsyncRpc<ReqT, RespT> rpc, String tableName) {
        CallOptions callOptions = this.getCallOptions(rpc.getMethodDescriptor(), request);
        return new RetryingUnaryRpcCallListener<ReqT, RespT>(this.retryOptions, request, rpc, callOptions, this.retryExecutorService, this.createMetadata(tableName));
    }

    private <ReqT, RespT> RetryingCollectingClientCallListener<ReqT, RespT> createStreamingListener(ReqT request, BigtableAsyncRpc<ReqT, RespT> rpc, String tableName) {
        CallOptions callOptions = this.getCallOptions(rpc.getMethodDescriptor(), request);
        return new RetryingCollectingClientCallListener<ReqT, RespT>(this.retryOptions, request, rpc, callOptions, this.retryExecutorService, this.createMetadata(tableName));
    }

    private <ReqT> CallOptions getCallOptions(MethodDescriptor<ReqT, ?> methodDescriptor, ReqT request) {
        return this.callOptionsFactory.create(methodDescriptor, request);
    }

    private static <ReqT, RespT, OutputT> ListenableFuture<OutputT> getCompletionFuture(AbstractRetryingRpcListener<ReqT, RespT, OutputT> listener) {
        listener.start();
        return listener.getCompletionFuture();
    }

    private static <ReqT, RespT, OutputT> OutputT getBlockingResult(AbstractRetryingRpcListener<ReqT, RespT, OutputT> listener) {
        try {
            listener.start();
            return (OutputT)listener.getCompletionFuture().get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            listener.cancel();
            throw Status.CANCELLED.withCause((Throwable)e).asRuntimeException();
        }
        catch (ExecutionException e) {
            listener.cancel();
            throw Status.fromThrowable((Throwable)e).asRuntimeException();
        }
    }

    private Metadata createMetadata(String tableName) {
        Metadata metadata = new Metadata();
        if (tableName != null) {
            metadata.put(GoogleCloudResourcePrefixInterceptor.GRPC_RESOURCE_PREFIX_KEY, (Object)tableName);
        }
        return metadata;
    }

    @Override
    public ResultScanner<Row> readRows(ReadRowsRequest request) {
        final ResultScanner<FlatRow> delegate = this.readFlatRows(request);
        return new ResultScanner<Row>(){

            @Override
            public void close() throws IOException {
                delegate.close();
            }

            public Row[] next(int count) throws IOException {
                FlatRow[] flatRows = (FlatRow[])delegate.next(count);
                Row[] rows = new Row[flatRows.length];
                for (int i = 0; i < flatRows.length; ++i) {
                    rows[i] = FlatRowConverter.convert(flatRows[i]);
                }
                return rows;
            }

            @Override
            public Row next() throws IOException {
                return FlatRowConverter.convert((FlatRow)delegate.next());
            }

            @Override
            public int available() {
                return delegate.available();
            }
        };
    }

    @Override
    public ResultScanner<FlatRow> readFlatRows(ReadRowsRequest request) {
        ResponseQueueReader reader = new ResponseQueueReader(this.retryOptions.getStreamingBufferSize());
        ReadRowsRetryListener listener = this.createReadRowsRetryListener(request, reader);
        return new ResumingStreamingResultScanner(reader, listener);
    }

    @Override
    public ScanHandler readFlatRows(ReadRowsRequest request, StreamObserver<FlatRow> observer) {
        return this.createReadRowsRetryListener(request, observer);
    }

    private ReadRowsRetryListener createReadRowsRetryListener(ReadRowsRequest request, StreamObserver<FlatRow> observer) {
        ReadRowsRetryListener listener = new ReadRowsRetryListener(observer, this.retryOptions, request, this.readRowsAsync, this.getCallOptions(this.readRowsAsync.getMethodDescriptor(), request), this.retryExecutorService, this.createMetadata(request.getTableName()));
        listener.start();
        return listener;
    }
}

