/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.config;

import com.google.api.client.util.BackOff;
import com.google.api.client.util.ExponentialBackOff;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import io.grpc.Status;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class RetryOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static int DEFAULT_STREAMING_BUFFER_SIZE = 60;
    public static final boolean DEFAULT_ENABLE_GRPC_RETRIES = true;
    public static final Set<Status.Code> DEFAULT_ENABLE_GRPC_RETRIES_SET = ImmutableSet.of((Object)Status.Code.DEADLINE_EXCEEDED, (Object)Status.Code.INTERNAL, (Object)Status.Code.UNAVAILABLE, (Object)Status.Code.ABORTED, (Object)Status.Code.UNAUTHENTICATED);
    public static final int DEFAULT_READ_PARTIAL_ROW_TIMEOUT_MS = (int)TimeUnit.MILLISECONDS.convert(60L, TimeUnit.SECONDS);
    public static final int DEFAULT_INITIAL_BACKOFF_MILLIS = 5;
    public static final double DEFAULT_BACKOFF_MULTIPLIER = 2.0;
    public static final int DEFAULT_MAX_ELAPSED_BACKOFF_MILLIS = (int)TimeUnit.MILLISECONDS.convert(60L, TimeUnit.SECONDS);
    public static final int DEFAULT_MAX_SCAN_TIMEOUT_RETRIES = 3;
    private final boolean retriesEnabled;
    private final boolean allowRetriesWithoutTimestamp;
    private final int initialBackoffMillis;
    private final int maxElaspedBackoffMillis;
    private final double backoffMultiplier;
    private final int streamingBufferSize;
    private final int readPartialRowTimeoutMillis;
    private final int maxScanTimeoutRetries;
    private final ImmutableSet<Status.Code> statusToRetryOn;

    public RetryOptions(boolean retriesEnabled, boolean allowRetriesWithoutTimestamp, int initialBackoffMillis, double backoffMultiplier, int maxElaspedBackoffMillis, int streamingBufferSize, int readPartialRowTimeoutMillis, int maxScanTimeoutRetries, Set<Status.Code> statusToRetryOn) {
        this.retriesEnabled = retriesEnabled;
        this.allowRetriesWithoutTimestamp = allowRetriesWithoutTimestamp;
        this.initialBackoffMillis = initialBackoffMillis;
        this.maxElaspedBackoffMillis = maxElaspedBackoffMillis;
        this.backoffMultiplier = backoffMultiplier;
        this.streamingBufferSize = streamingBufferSize;
        this.readPartialRowTimeoutMillis = readPartialRowTimeoutMillis;
        this.maxScanTimeoutRetries = maxScanTimeoutRetries;
        this.statusToRetryOn = ImmutableSet.copyOf(statusToRetryOn);
    }

    public int getInitialBackoffMillis() {
        return this.initialBackoffMillis;
    }

    public int getMaxElaspedBackoffMillis() {
        return this.maxElaspedBackoffMillis;
    }

    public double getBackoffMultiplier() {
        return this.backoffMultiplier;
    }

    public boolean enableRetries() {
        return this.retriesEnabled;
    }

    public boolean allowRetriesWithoutTimestamp() {
        return this.allowRetriesWithoutTimestamp;
    }

    public boolean retryOnDeadlineExceeded() {
        return this.statusToRetryOn.contains((Object)Status.Code.DEADLINE_EXCEEDED);
    }

    public int getStreamingBufferSize() {
        return this.streamingBufferSize;
    }

    public int getReadPartialRowTimeoutMillis() {
        return this.readPartialRowTimeoutMillis;
    }

    public int getMaxScanTimeoutRetries() {
        return this.maxScanTimeoutRetries;
    }

    public boolean isRetryable(Status.Code code) {
        return this.statusToRetryOn.contains((Object)code);
    }

    public BackOff createBackoff() {
        return this.createBackoffBuilder().build();
    }

    @VisibleForTesting
    protected ExponentialBackOff.Builder createBackoffBuilder() {
        return new ExponentialBackOff.Builder().setInitialIntervalMillis(this.getInitialBackoffMillis()).setMaxElapsedTimeMillis(this.getMaxElaspedBackoffMillis()).setMultiplier(this.getBackoffMultiplier());
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != RetryOptions.class) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        RetryOptions other = (RetryOptions)obj;
        return this.retriesEnabled == other.retriesEnabled && this.allowRetriesWithoutTimestamp == other.allowRetriesWithoutTimestamp && Objects.equals(this.statusToRetryOn, other.statusToRetryOn) && this.initialBackoffMillis == other.initialBackoffMillis && this.maxElaspedBackoffMillis == other.maxElaspedBackoffMillis && this.backoffMultiplier == other.backoffMultiplier && this.streamingBufferSize == other.streamingBufferSize && this.readPartialRowTimeoutMillis == other.readPartialRowTimeoutMillis && this.maxScanTimeoutRetries == other.maxScanTimeoutRetries;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("retriesEnabled", this.retriesEnabled).add("allowRetriesWithoutTimestamp", this.allowRetriesWithoutTimestamp).add("statusToRetryOn", this.statusToRetryOn).add("initialBackoffMillis", this.initialBackoffMillis).add("maxElaspedBackoffMillis", this.maxElaspedBackoffMillis).add("backoffMultiplier", this.backoffMultiplier).add("streamingBufferSize", this.streamingBufferSize).add("readPartialRowTimeoutMillis", this.readPartialRowTimeoutMillis).add("maxScanTimeoutRetries", this.maxScanTimeoutRetries).toString();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder {
        private boolean enableRetries = true;
        private int initialBackoffMillis = 5;
        private double backoffMultiplier = 2.0;
        private int maxElaspedBackoffMillis = DEFAULT_MAX_ELAPSED_BACKOFF_MILLIS;
        private int streamingBufferSize = DEFAULT_STREAMING_BUFFER_SIZE;
        private int readPartialRowTimeoutMillis = DEFAULT_READ_PARTIAL_ROW_TIMEOUT_MS;
        private int maxScanTimeoutRetries = 3;
        private Set<Status.Code> statusToRetryOn = new HashSet<Status.Code>(DEFAULT_ENABLE_GRPC_RETRIES_SET);
        private boolean allowRetriesWithoutTimestamp;

        public Builder() {
        }

        public Builder(RetryOptions options) {
            this.enableRetries = options.retriesEnabled;
            this.initialBackoffMillis = options.initialBackoffMillis;
            this.backoffMultiplier = options.backoffMultiplier;
            this.maxElaspedBackoffMillis = options.maxElaspedBackoffMillis;
            this.streamingBufferSize = options.streamingBufferSize;
            this.readPartialRowTimeoutMillis = options.readPartialRowTimeoutMillis;
            this.maxScanTimeoutRetries = options.maxScanTimeoutRetries;
            this.statusToRetryOn = new HashSet<Status.Code>((Collection<Status.Code>)options.statusToRetryOn);
            this.allowRetriesWithoutTimestamp = options.allowRetriesWithoutTimestamp;
        }

        public Builder setEnableRetries(boolean enabled) {
            this.enableRetries = enabled;
            return this;
        }

        public Builder setRetryOnDeadlineExceeded(boolean enabled) {
            if (enabled) {
                this.statusToRetryOn.add(Status.Code.DEADLINE_EXCEEDED);
            } else {
                this.statusToRetryOn.remove(Status.Code.DEADLINE_EXCEEDED);
            }
            return this;
        }

        public Builder setInitialBackoffMillis(int initialBackoffMillis) {
            this.initialBackoffMillis = initialBackoffMillis;
            return this;
        }

        public Builder setBackoffMultiplier(double multiplier) {
            this.backoffMultiplier = multiplier;
            return this;
        }

        public Builder setMaxElapsedBackoffMillis(int maxElaspedBackoffMillis) {
            this.maxElaspedBackoffMillis = maxElaspedBackoffMillis;
            return this;
        }

        public Builder setStreamingBufferSize(int streamingBufferSize) {
            this.streamingBufferSize = streamingBufferSize;
            return this;
        }

        public Builder setReadPartialRowTimeoutMillis(int timeout) {
            this.readPartialRowTimeoutMillis = timeout;
            return this;
        }

        public Builder setMaxScanTimeoutRetries(int maxScanTimeoutRetries) {
            this.maxScanTimeoutRetries = maxScanTimeoutRetries;
            return this;
        }

        public Builder addStatusToRetryOn(Status.Code code) {
            this.statusToRetryOn.add(code);
            return this;
        }

        public Builder setAllowRetriesWithoutTimestamp(boolean allowRetriesWithoutTimestamp) {
            this.allowRetriesWithoutTimestamp = allowRetriesWithoutTimestamp;
            return this;
        }

        public RetryOptions build() {
            return new RetryOptions(this.enableRetries, this.allowRetriesWithoutTimestamp, this.initialBackoffMillis, this.backoffMultiplier, this.maxElaspedBackoffMillis, this.streamingBufferSize, this.readPartialRowTimeoutMillis, this.maxScanTimeoutRetries, (Set<Status.Code>)ImmutableSet.copyOf(this.statusToRetryOn));
        }
    }
}

