/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util.testing.logging;

import com.google.cloud.hadoop.util.testing.logging.AssertingHandler;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.CheckReturnValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public final class ExpectedLogMessages
implements TestRule {
    private static final Logger GOOGLE_LOGGER = Logger.getLogger("com.google");
    private final Logger logger;
    private final AssertingHandler handler;
    private final List<String> expectedRegexs = new ArrayList<String>();
    private final AtomicBoolean handlerHasBeenAdded = new AtomicBoolean(false);

    private ExpectedLogMessages(Logger logger, AssertingHandler handler) {
        this.logger = logger;
        this.handler = handler;
    }

    public static ExpectedLogMessages none() {
        return ExpectedLogMessages.forLogger(GOOGLE_LOGGER);
    }

    public static ExpectedLogMessages any() {
        return ExpectedLogMessages.forLogger(GOOGLE_LOGGER).allow(".*");
    }

    public static ExpectedLogMessages containing(String regex) {
        return ExpectedLogMessages.forLogger(GOOGLE_LOGGER).allow(regex);
    }

    public static ExpectedLogMessages forLogger(String name) {
        return ExpectedLogMessages.forLogger(Logger.getLogger((String)Preconditions.checkNotNull((Object)name)));
    }

    public static ExpectedLogMessages forLogger(Logger logger) {
        return new ExpectedLogMessages(logger, new AssertingHandler(new String[0]));
    }

    public static ExpectedLogMessages forLogger(Class<?> loggerClass) {
        return ExpectedLogMessages.forLogger(loggerClass.getCanonicalName());
    }

    public ExpectedLogMessages allow(String regex) {
        this.handler.addIgnoredRegexes((String)Preconditions.checkNotNull((Object)regex));
        return this;
    }

    public ExpectedLogMessages filter(Logger logger, Level level) {
        return this.filter(logger.getName(), level);
    }

    public ExpectedLogMessages filter(Class<?> loggerClass, Level level) {
        return this.filter(loggerClass.getCanonicalName(), level);
    }

    public ExpectedLogMessages filter(String loggerName, Level level) {
        Preconditions.checkArgument((boolean)loggerName.startsWith(this.logger.getName()), (String)"%s is not a child logger of %s", (Object)loggerName, (Object)this.logger.getName());
        this.logger.setLevel(level);
        this.handler.appendConfiguration(loggerName + ".level = " + String.valueOf(Preconditions.checkNotNull((Object)level)));
        return this;
    }

    public ExpectedLogMessages expect(String regex) {
        this.expectedRegexs.add((String)Preconditions.checkNotNull((Object)regex));
        return this;
    }

    public ExpectedLogMessages expect(String regex, int numTimes) {
        Preconditions.checkNotNull((Object)regex);
        this.expectedRegexs.addAll(Collections.nCopies(numTimes, regex));
        return this;
    }

    public ExpectedLogMessages setMinimumLevel(Level level) {
        return this.filter(this.logger, (Level)Preconditions.checkNotNull((Object)level));
    }

    public ExpectedLogMessages setCaptureAllThreads(boolean captureAllThreads) {
        this.handler.setCaptureAllThreads(captureAllThreads);
        return this;
    }

    public void clear() {
        this.handler.clear();
    }

    @CheckReturnValue
    public ImmutableList<LogRecord> getRecords() {
        return this.handler.getLogRecords();
    }

    @CheckReturnValue
    public ImmutableList<String> getFormattedRecords() {
        return this.handler.getFormattedLogRecords();
    }

    @Deprecated
    public void captureLogs() {
        this.addHandler();
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                ExpectedLogMessages.this.addHandler();
                base.evaluate();
                try {
                    ExpectedLogMessages.this.handler.assertContainsRegex((String[])Iterables.toArray(ExpectedLogMessages.this.expectedRegexs, String.class));
                }
                finally {
                    ExpectedLogMessages.this.logger.removeHandler(ExpectedLogMessages.this.handler);
                    ExpectedLogMessages.this.handler.close();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addHandler() {
        Preconditions.checkState((!this.handlerHasBeenAdded.getAndSet(true) ? 1 : 0) != 0, (Object)"Handler has already been added");
        LogManager logManager = LogManager.getLogManager();
        synchronized (logManager) {
            this.logger.addHandler(this.handler);
        }
    }
}

