/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util.testing.logging;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import com.google.errorprone.annotations.FormatMethod;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.Assert;

public class AssertingHandler
extends Handler {
    private static final Logger logger = Logger.getLogger(AssertingHandler.class.getName());
    private static final Pattern CONFIG_PATTERN = Pattern.compile("\\s*(\\S*)\\.level\\s*[:=]\\s*(\\S+)\\s*");
    private static final Level DEFAULT_LEVEL = Level.WARNING;
    private Queue<LogRecord> logRecords;
    private String[] defaultAssertionMessages = new String[0];
    private Set<String> ignoredMessages;
    private final Set<Pattern> ignoredPatterns;
    private Map<LogRecord, AutomaticallyGeneratedThrowable> logExceptionMap;
    private final Map<Logger, Level> configMaps = new HashMap<Logger, Level>();
    private final ThreadLocal<AssertingHandler> handlerForThread = new InheritableThreadLocal<AssertingHandler>();
    private boolean captureAllThreads;
    private final AssertionError constructionTrace = new AssertionError((Object)(this.getClass().getName() + " constructed at:"));
    private final Filter filter = record -> {
        if (record.getLoggerName() == null) {
            return false;
        }
        Level messageLevel = record.getLevel();
        for (Logger logger = Logger.getLogger(record.getLoggerName()); logger != null; logger = logger.getParent()) {
            Level cutoffLevel = this.configMaps.get(logger);
            if (cutoffLevel == null) continue;
            return messageLevel.intValue() >= cutoffLevel.intValue();
        }
        return messageLevel.intValue() >= DEFAULT_LEVEL.intValue();
    };

    public AssertingHandler(String ... configs) {
        this.setLevel(DEFAULT_LEVEL);
        this.logRecords = new ConcurrentLinkedQueue<LogRecord>();
        this.logExceptionMap = new ConcurrentHashMap<LogRecord, AutomaticallyGeneratedThrowable>();
        this.ignoredMessages = new HashSet<String>();
        this.ignoredPatterns = new HashSet<Pattern>();
        if (configs.length > 0) {
            this.appendConfiguration(configs);
        }
        this.handlerForThread.set(this);
    }

    @Override
    public void publish(LogRecord record) {
        if ((this.captureAllThreads || this == this.handlerForThread.get()) && this.isLoggable(record)) {
            if (record.getThrown() == null) {
                this.logExceptionMap.put(record, new AutomaticallyGeneratedThrowable());
            }
            this.logRecords.add(record);
        }
    }

    @Override
    public void flush() {
    }

    public void clear() {
        this.logRecords.clear();
    }

    @Override
    public void close() throws SecurityException {
        this.logRecords = null;
        this.defaultAssertionMessages = null;
        this.ignoredMessages = null;
        this.logExceptionMap = null;
    }

    public void setCaptureAllThreads(boolean captureAllThreads) {
        this.captureAllThreads = captureAllThreads;
    }

    public ImmutableList<LogRecord> getLogRecords() {
        return ImmutableList.copyOf(this.logRecords);
    }

    public ImmutableList<String> getFormattedLogRecords() {
        return (ImmutableList)this.logRecords.stream().map(this::logRecordToString).collect(ImmutableList.toImmutableList());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (LogRecord logRecord : this.logRecords) {
            sb.append(this.logRecordToStringWithStackTrace(logRecord));
        }
        return sb.toString();
    }

    private String logRecordToString(LogRecord logRecord) {
        StringBuilder sb = new StringBuilder();
        this.formatRecordMessage(sb, logRecord);
        Throwable thrown = logRecord.getThrown();
        if (thrown != null) {
            sb.append(thrown);
        }
        return sb.toString().trim();
    }

    private String logRecordToStringWithStackTrace(LogRecord logRecord) {
        StringBuilder sb = new StringBuilder();
        this.formatRecordMessage(sb, logRecord);
        Throwable thrown = logRecord.getThrown();
        if (thrown == null) {
            thrown = this.logExceptionMap.get(logRecord);
        }
        sb.append(Throwables.getStackTraceAsString((Throwable)thrown));
        return sb.toString().trim();
    }

    private void formatRecordMessage(StringBuilder builder, LogRecord logRecord) {
        String message = new SimpleFormatter().formatMessage(logRecord);
        builder.append(logRecord.getLevel()).append(": ").append(message).append("\n");
    }

    public void setDefaultAssertion(String ... messages) {
        this.defaultAssertionMessages = (String[])messages.clone();
    }

    public void addIgnoredMessages(String ... messages) {
        for (String message : messages) {
            this.ignoredMessages.add(message.trim());
        }
    }

    public void addIgnoredRegexes(String ... regexes) {
        for (String regex : regexes) {
            this.ignoredPatterns.add(Pattern.compile(regex));
        }
    }

    public void assertEqual(String ... expectedMessages) {
        this.doAssert(new MessageComparisonWithEqual(), expectedMessages);
    }

    public void assertContainsRegex(String ... expectedRegexs) {
        this.doAssert(new MessageComparisonWithFind(), expectedRegexs);
    }

    public void defaultAssertion() {
        this.doAssert(new MessageComparisonWithEqual(), this.defaultAssertionMessages);
    }

    private void doAssert(MessageComparison mc, String ... expected) {
        LogRecord logRecord;
        Iterator iter = this.logRecords.iterator();
        int expectInd = 0;
        int seenInd = 0;
        while (expectInd < expected.length && iter.hasNext()) {
            logRecord = (LogRecord)iter.next();
            if (mc.isSame(expected[expectInd], this.logRecordToString(logRecord))) {
                ++expectInd;
                ++seenInd;
                continue;
            }
            if (this.ignoredMessages.contains(this.logRecordToString(logRecord).trim()) || this.containsIgnoreRegex(logRecord)) {
                ++seenInd;
                continue;
            }
            logger.warning(this.logRecordToStringWithStackTrace(logRecord));
            this.assertEquals(String.format("The supplied regex did not match the given log in expected message #%d, logged message #%d. Perhaps your log has special characters?\nRegex: %s\nLog: %s", expectInd, seenInd, expected[expectInd], this.logRecordToString(logRecord)), expected[expectInd], this.logRecordToString(logRecord));
            this.fail("The supplied regex did not match the given log in expected message #%d, logged message #%d (NOTE: The regex must not be exactly equal to the log, please use regex notation to match with log lines).\nRegex: %s\nLog: %s", expectInd, seenInd, expected[expectInd], this.logRecordToString(logRecord));
        }
        if (expectInd < expected.length) {
            this.fail("Expected message #%s unseen: %s", expectInd, expected[expectInd]);
        } else {
            while (iter.hasNext()) {
                logRecord = (LogRecord)iter.next();
                if (this.ignoredMessages.contains(this.logRecordToString(logRecord).trim()) || this.containsIgnoreRegex(logRecord)) {
                    ++seenInd;
                    continue;
                }
                String recordAndTrace = this.logRecordToStringWithStackTrace(logRecord);
                this.fail("Log message #%s (logger: %s) unexpected: %s", seenInd, logRecord.getLoggerName(), recordAndTrace);
            }
        }
        this.logRecords.clear();
    }

    private boolean containsIgnoreRegex(LogRecord logRecord) {
        String logString = this.logRecordToString(logRecord);
        for (Pattern pattern : this.ignoredPatterns) {
            if (!pattern.matcher(logString).find()) continue;
            return true;
        }
        return false;
    }

    private void assertEquals(String message, String expected, String actual) {
        try {
            Truth.assertWithMessage((String)message).that(actual).isEqualTo((Object)expected);
        }
        catch (AssertionError t) {
            throw (AssertionError)((Object)((Throwable)((Object)t)).initCause((Throwable)((Object)this.constructionTrace)));
        }
    }

    @FormatMethod
    private void fail(String message, Object ... args) {
        try {
            Assert.fail((String)String.format(message, args));
        }
        catch (AssertionError t) {
            throw (AssertionError)((Object)((Throwable)((Object)t)).initCause((Throwable)((Object)this.constructionTrace)));
        }
    }

    public void appendConfiguration(String ... configs) {
        for (String config : configs) {
            this.parseToConfigMap(config);
        }
        this.setFilter(this.filter);
    }

    private void parseToConfigMap(String config) throws IllegalArgumentException {
        Matcher matcher = CONFIG_PATTERN.matcher(config);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Malformed configuration input format");
        }
        Level level = Level.parse(matcher.group(2));
        if (matcher.group(1) != null) {
            this.configMaps.put(Logger.getLogger(matcher.group(1)), level);
        } else {
            this.configMaps.put(Logger.getLogger(""), level);
        }
        if (this.getLevel().intValue() > level.intValue()) {
            this.setLevel(level);
        }
    }

    private static class AutomaticallyGeneratedThrowable
    extends Exception {
        private static final long serialVersionUID = 1L;

        private AutomaticallyGeneratedThrowable() {
        }
    }

    protected static class MessageComparisonWithFind
    implements MessageComparison {
        protected MessageComparisonWithFind() {
        }

        @Override
        public boolean isSame(String expectedMessage, String actualMessage) {
            return Pattern.compile(expectedMessage).matcher(actualMessage).find();
        }
    }

    protected static class MessageComparisonWithEqual
    implements MessageComparison {
        protected MessageComparisonWithEqual() {
        }

        @Override
        public boolean isSame(String expectedMessage, String actualMessage) {
            return expectedMessage.trim().equals(actualMessage);
        }
    }

    public static interface MessageComparison {
        public boolean isSame(String var1, String var2);
    }
}

