/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util.testing;

import java.io.IOException;
import java.io.InputStream;
import org.junit.Assert;

public class ThrowingInputStream
extends InputStream {
    private final Throwable readException;
    private final Throwable closeException;

    public ThrowingInputStream(Throwable readException) {
        this(readException, null);
    }

    public ThrowingInputStream(Throwable readException, Throwable closeException) {
        this.readException = readException;
        this.closeException = closeException;
    }

    @Override
    public int available() {
        return 1;
    }

    @Override
    public int read() {
        ThrowingInputStream.throwUnchecked(this.readException);
        Assert.fail((String)"Exception should have been thrown");
        return -1;
    }

    @Override
    public void close() throws IOException {
        if (this.closeException != null) {
            ThrowingInputStream.throwUnchecked(this.closeException);
        }
        super.close();
    }

    public static void throwUnchecked(Throwable e) {
        ThrowingInputStream.throwAny(e);
        Assert.fail((String)String.format("Exception '%s' should have been thrown", e));
    }

    private static <E extends Throwable> void throwAny(Throwable e) throws E {
        throw e;
    }
}

