/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.cloud.hadoop.util.ITraceFactory;
import com.google.cloud.hadoop.util.ITraceOperation;
import com.google.cloud.hadoop.util.ThreadTrace;
import com.google.cloud.hadoop.util.TraceFactory;
import com.google.cloud.hadoop.util.TraceOperation;
import com.google.common.reflect.TypeToken;
import com.google.common.truth.Truth;
import com.google.gson.Gson;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TraceFactoryTest {
    private TestLogHandler assertingHandler;
    private static final Logger LOGGER = Logger.getLogger(TraceOperation.class.getName());
    private String name;
    private String context;
    private String name2;

    @Before
    public void setUp() throws IOException {
        this.assertingHandler = new TestLogHandler();
        LOGGER.setUseParentHandlers(false);
        LOGGER.addHandler(this.assertingHandler);
        LOGGER.setLevel(Level.INFO);
        this.name = this.getRandomString();
        this.name2 = this.getRandomString();
        this.context = this.getRandomString();
    }

    @After
    public void verifyAndRemoveAssertingHandler() {
        LOGGER.removeHandler(this.assertingHandler);
    }

    @Test
    public void disabled_uses_singleton() {
        ITraceFactory first = TraceFactory.get((boolean)false);
        ITraceFactory second = TraceFactory.get((boolean)false);
        Truth.assertThat((Object)first).isEqualTo((Object)second);
    }

    @Test
    public void enabled_creates_new() {
        ITraceFactory first = TraceFactory.get((boolean)true);
        ITraceFactory second = TraceFactory.get((boolean)true);
        Truth.assertThat((Object)first).isNotEqualTo((Object)second);
        Truth.assertThat(this.assertingHandler.logs).hasSize(0);
    }

    @Test
    public void enabled_creates_trace() {
        ITraceFactory traceFactory = TraceFactory.get((boolean)true);
        TraceFactoryTest.assertThreadTraceIsNull();
        try (ITraceOperation traceOperation = traceFactory.createRootWithLogging(this.name, (Object)this.context);){
            ThreadTrace tt = TraceFactoryTest.getThreadTrace();
            Truth.assertThat((Object)tt).isNotNull();
            Truth.assertThat((String)tt.getTrackingId()).startsWith(String.format("%s(%s)", this.name, this.context));
            Truth.assertThat(this.assertingHandler.logs).hasSize(0);
        }
        TraceFactoryTest.assertThreadTraceIsNull();
        Truth.assertThat(this.assertingHandler.logs).hasSize(1);
        Truth.assertThat((Integer)this.getEventAtLogIndex(0).size()).isEqualTo((Object)1);
        this.assertEventAtIndex(0, 0, Map.of("name", this.name, "type", "MERGED"));
    }

    @Test
    public void multiple_nested_trace_operations() {
        ITraceFactory traceFactory = TraceFactory.get((boolean)true);
        TraceFactoryTest.assertThreadTraceIsNull();
        try (ITraceOperation traceOperation = traceFactory.createRootWithLogging(this.name, (Object)this.context);){
            try (ITraceOperation operation = TraceOperation.addToExistingTrace((String)this.name2);){
                ThreadTrace tt = TraceFactoryTest.getThreadTrace();
                Truth.assertThat((Object)tt).isNotNull();
                Truth.assertThat((String)tt.getTrackingId()).startsWith(String.format("%s(%s)", this.name, this.context));
                Truth.assertThat(this.assertingHandler.logs).hasSize(0);
            }
            Truth.assertThat(this.assertingHandler.logs).hasSize(0);
        }
        TraceFactoryTest.assertThreadTraceIsNull();
        Truth.assertThat(this.assertingHandler.logs).hasSize(1);
        Truth.assertThat((Integer)this.getEventAtLogIndex(0).size()).isEqualTo((Object)3);
        this.assertEventAtIndex(0, 0, Map.of("name", this.name, "type", "START"));
        this.assertEventAtIndex(0, 1, Map.of("name", this.name2, "type", "MERGED"));
        this.assertEventAtIndex(0, 2, Map.of("name", this.name, "type", "END"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void multithreaded_trace_operations() throws ExecutionException, InterruptedException {
        ITraceFactory traceFactory = TraceFactory.get((boolean)true);
        int threadPoolSize = 2;
        ExecutorService threadPool = Executors.newFixedThreadPool(threadPoolSize);
        try {
            TraceFactoryTest.assertThreadTraceIsNull();
            List<String> expectedSubEventNames = this.runMultithreaded(traceFactory, threadPool, 10);
            TraceFactoryTest.assertThreadTraceIsNull();
            Truth.assertThat(this.assertingHandler.logs).hasSize(1);
            Truth.assertThat((Integer)this.getEventAtLogIndex(0).size()).isEqualTo((Object)1);
            this.validateSubEvents(0, threadPoolSize, expectedSubEventNames);
        }
        finally {
            threadPool.shutdown();
        }
    }

    @Test
    public void multiple_sequential_trace_operations() {
        ThreadTrace tt;
        ITraceFactory traceFactory = TraceFactory.get((boolean)true);
        TraceFactoryTest.assertThreadTraceIsNull();
        try (ITraceOperation traceOperation = traceFactory.createRootWithLogging(this.name, (Object)this.context);){
            tt = TraceFactoryTest.getThreadTrace();
            Truth.assertThat((Object)tt).isNotNull();
            Truth.assertThat((String)tt.getTrackingId()).startsWith(String.format("%s(%s)", this.name, this.context));
            Truth.assertThat(this.assertingHandler.logs).hasSize(0);
        }
        TraceFactoryTest.assertThreadTraceIsNull();
        traceOperation = traceFactory.createRootWithLogging(this.name2, (Object)this.context);
        try {
            tt = TraceFactoryTest.getThreadTrace();
            Truth.assertThat((Object)tt).isNotNull();
            Truth.assertThat((String)tt.getTrackingId()).startsWith(String.format("%s(%s)", this.name2, this.context));
            Truth.assertThat(this.assertingHandler.logs).hasSize(1);
        }
        finally {
            if (traceOperation != null) {
                traceOperation.close();
            }
        }
        Truth.assertThat(this.assertingHandler.logs).hasSize(2);
        Truth.assertThat((Integer)this.getEventAtLogIndex(1).size()).isEqualTo((Object)1);
        this.assertEventAtIndex(1, 0, Map.of("name", this.name2, "type", "MERGED"));
    }

    @Test
    public void max_events_test() {
        ITraceFactory traceFactory = TraceFactory.get((boolean)true);
        TraceFactoryTest.assertThreadTraceIsNull();
        try (ITraceOperation traceOperation = traceFactory.createRootWithLogging(this.name, (Object)this.context);){
            ThreadTrace tt = TraceFactoryTest.getThreadTrace();
            Truth.assertThat((Object)tt).isNotNull();
            Truth.assertThat((String)tt.getTrackingId()).startsWith(String.format("%s(%s)", this.name, this.context));
            Truth.assertThat(this.assertingHandler.logs).hasSize(0);
            for (int i = 0; i < 40; ++i) {
                ITraceOperation to = TraceOperation.addToExistingTrace((String)Integer.toString(i));
                if (to == null) continue;
                to.close();
            }
        }
        Truth.assertThat(this.assertingHandler.logs).hasSize(1);
        Truth.assertThat((Integer)this.getEventAtLogIndex(0).size()).isEqualTo((Object)20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void max_subevents_test() throws ExecutionException, InterruptedException {
        ITraceFactory traceFactory = TraceFactory.get((boolean)true);
        int threadPoolSize = 2;
        ExecutorService threadPool = Executors.newFixedThreadPool(threadPoolSize);
        try {
            TraceFactoryTest.assertThreadTraceIsNull();
            this.runMultithreaded(traceFactory, threadPool, 100);
            TraceFactoryTest.assertThreadTraceIsNull();
            Truth.assertThat(this.assertingHandler.logs).hasSize(1);
            Truth.assertThat((Integer)this.getEventAtLogIndex(0).size()).isEqualTo((Object)1);
            this.validateSubEventsSize(0, threadPoolSize, threadPoolSize * 20);
        }
        finally {
            threadPool.shutdown();
        }
    }

    @Test
    public void disabled_doesnot_have_trace() {
        ITraceFactory traceFactory = TraceFactory.get((boolean)false);
        TraceFactoryTest.assertThreadTraceIsNull();
        try (ITraceOperation to = traceFactory.createRootWithLogging(this.getRandomString(), (Object)this.getRandomString());){
            TraceFactoryTest.assertThreadTraceIsNull();
        }
        TraceFactoryTest.assertThreadTraceIsNull();
    }

    private List<String> runMultithreaded(ITraceFactory traceFactory, ExecutorService threadPool, int numOperations) {
        ArrayList<String> subEventNames = new ArrayList<String>();
        ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>();
        try (ITraceOperation to = traceFactory.createRootWithLogging(this.name, (Object)this.context);){
            for (int i = 0; i < numOperations; ++i) {
                String eventName = String.format("op_%d", i);
                subEventNames.add(eventName);
                Future<Object> future2 = threadPool.submit(() -> {
                    try (ITraceOperation child = TraceOperation.getChildTrace((ThreadTrace)to.getTrace(), (String)eventName);){
                        Object var3_3 = null;
                        return var3_3;
                    }
                });
                futures.add(future2);
            }
            futures.forEach(future -> {
                try {
                    future.get();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            ArrayList<String> arrayList = subEventNames;
            return arrayList;
        }
    }

    private void validateSubEvents(int logIndex, int expectedSize, List<String> expectedSubEventNames) {
        Map<String, List<Map<String, Object>>> subEvents = this.getSubEventsAtIndex(logIndex);
        Truth.assertThat(subEvents).hasSize(expectedSize);
        ArrayList allSubEvents = new ArrayList();
        for (String threadId : subEvents.keySet()) {
            allSubEvents.addAll(subEvents.get(threadId));
        }
        ArrayList<String> opNames = new ArrayList<String>();
        for (Map theEvent : allSubEvents) {
            opNames.add((String)theEvent.get("name"));
        }
        Truth.assertThat(allSubEvents).hasSize(expectedSubEventNames.size());
        Collections.sort(opNames);
        Collections.sort(expectedSubEventNames);
        Truth.assertThat(opNames).isEqualTo(expectedSubEventNames);
    }

    private void validateSubEventsSize(int logIndex, int threadPoolSize, int expectedSubEventSize) {
        Map<String, List<Map<String, Object>>> subEvents = this.getSubEventsAtIndex(logIndex);
        Truth.assertThat(subEvents).hasSize(threadPoolSize);
        ArrayList allSubEvents = new ArrayList();
        for (String threadId : subEvents.keySet()) {
            allSubEvents.addAll(subEvents.get(threadId));
        }
        ArrayList<String> opNames = new ArrayList<String>();
        for (Map theEvent : allSubEvents) {
            opNames.add((String)theEvent.get("name"));
        }
        Truth.assertThat(allSubEvents).hasSize(expectedSubEventSize);
    }

    private void assertEventAtIndex(int logIndex, int eventIndex, Map<String, String> expected) {
        ArrayList<Object> events = this.getEventAtLogIndex(logIndex);
        Map theEvent = (Map)events.get(eventIndex);
        for (String key : expected.keySet()) {
            Truth.assertThat(theEvent.get(key)).isEqualTo((Object)expected.get(key));
        }
        System.out.println(theEvent);
    }

    private ArrayList<Object> getEventAtLogIndex(int index) {
        return (ArrayList)this.assertingHandler.logs.get(index).get("events");
    }

    private Map<String, List<Map<String, Object>>> getSubEventsAtIndex(int index) {
        return (Map)this.assertingHandler.logs.get(index).get("subEvents");
    }

    private static void assertThreadTraceIsNull() {
        Truth.assertThat((Object)TraceFactoryTest.getThreadTrace()).isNull();
    }

    private String getRandomString() {
        return Integer.toString(ThreadLocalRandom.current().nextInt());
    }

    private static ThreadTrace getThreadTrace() {
        return TraceOperation.current();
    }

    static class TestLogHandler
    extends Handler {
        private static final Gson gson = new Gson();
        private List<HashMap<String, Object>> logs = new ArrayList<HashMap<String, Object>>();

        TestLogHandler() {
        }

        @Override
        public void publish(LogRecord record) {
            HashMap parsed = (HashMap)gson.fromJson(record.getMessage(), new TypeToken<HashMap<String, Object>>(){}.getType());
            this.logs.add(parsed);
            System.out.println(parsed);
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }

        List<HashMap<String, Object>> getLogs() {
            return this.logs;
        }
    }
}

