/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.cloud.hadoop.util.GcsJsonApiEvent;
import com.google.cloud.hadoop.util.RequestTracker;
import com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TestRequestTracker
extends RequestTracker {
    private final List<GcsJsonApiEvent> events = new ArrayList<GcsJsonApiEvent>();

    public List<GcsJsonApiEvent> getEvents() {
        return this.events;
    }

    protected void postToEventQueue(GcsJsonApiEvent event) {
        this.events.add(event);
    }

    void verifyEvents(List<ExpectedEventDetails> expectedEvents) {
        List<GcsJsonApiEvent> actualEvents = this.getEvents();
        Truth.assertThat((Integer)actualEvents.size()).isEqualTo((Object)expectedEvents.size());
        for (int i = 0; i < actualEvents.size(); ++i) {
            GcsJsonApiEvent actual = actualEvents.get(i);
            ExpectedEventDetails expected = expectedEvents.get(i);
            Truth.assertThat((Comparable)actual.getEventType()).isEqualTo((Object)expected.eventType);
            Truth.assertThat((String)actual.getContext().toString()).contains((CharSequence)expected.context.toString());
            GcsJsonApiEvent.EventType eventType = actual.getEventType();
            if (eventType == GcsJsonApiEvent.EventType.RESPONSE) {
                this.verifyNotEmpty(actual, "DURATION");
            }
            if (eventType == GcsJsonApiEvent.EventType.BACKOFF) {
                this.verifyNotEmpty(actual, "BACKOFF_TIME");
            }
            for (String key : expected.properties.keySet()) {
                if (key.equals("BACKOFF_TIME")) {
                    long backOffTime = (Long)actual.getProperty(key);
                    int expectedBackoffTime = (Integer)expected.properties.get("BACKOFF_TIME");
                    Truth.assertThat((Long)backOffTime).isAtLeast(expectedBackoffTime);
                    Truth.assertThat((Long)backOffTime).isLessThan(expectedBackoffTime + 10);
                    continue;
                }
                Truth.assertThat((Object)actual.getProperty(key)).isEqualTo(expected.properties.get(key));
            }
        }
    }

    private void verifyNotEmpty(GcsJsonApiEvent actual, String duration) {
        Truth.assertThat((Object)actual.getProperty(duration)).isNotNull();
    }

    public static class ExpectedEventDetails {
        final GcsJsonApiEvent.EventType eventType;
        final String context;
        Map<String, Object> properties = new HashMap<String, Object>();

        private ExpectedEventDetails(GcsJsonApiEvent.EventType eventType, String url) {
            this.eventType = eventType;
            this.context = url;
        }

        public static ExpectedEventDetails getStarted(String url) {
            return new ExpectedEventDetails(GcsJsonApiEvent.EventType.STARTED, url);
        }

        public static ExpectedEventDetails getResponse(String url, int statusCode) {
            ExpectedEventDetails result = new ExpectedEventDetails(GcsJsonApiEvent.EventType.RESPONSE, url);
            result.properties.put("STATUS_CODE", statusCode);
            return result;
        }

        public static ExpectedEventDetails getBackoff(String url, int retryCount) {
            ExpectedEventDetails result = new ExpectedEventDetails(GcsJsonApiEvent.EventType.BACKOFF, url);
            result.properties.put("RETRY_COUNT", retryCount);
            return result;
        }

        public static ExpectedEventDetails getBackoff(String url, int retryCount, int backOff) {
            ExpectedEventDetails result = new ExpectedEventDetails(GcsJsonApiEvent.EventType.BACKOFF, url);
            result.properties.put("RETRY_COUNT", retryCount);
            result.properties.put("BACKOFF_TIME", backOff);
            return result;
        }

        public static ExpectedEventDetails getException(String url) {
            return new ExpectedEventDetails(GcsJsonApiEvent.EventType.EXCEPTION, url);
        }
    }
}

