/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.auth.Credentials;
import com.google.cloud.hadoop.util.RequestTracker;
import com.google.cloud.hadoop.util.RetryHttpInitializer;
import com.google.cloud.hadoop.util.RetryHttpInitializerOptions;
import com.google.cloud.hadoop.util.TestRequestTracker;
import com.google.cloud.hadoop.util.testing.FakeCredentials;
import com.google.cloud.hadoop.util.testing.MockHttpTransportHelper;
import com.google.cloud.hadoop.util.testing.ThrowingInputStream;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.truth.Truth;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class RetryHttpInitializerTest {
    public static final String URL = "http://fake-url.com";
    private TestRequestTracker requestTracker;

    @Before
    public void beforeTest() {
        this.requestTracker = new TestRequestTracker();
    }

    @Test
    public void testConstructorNullCredentials() {
        this.createRetryHttpInitializer(null);
    }

    @Test
    public void successfulRequest_authenticated() throws IOException {
        String authHeaderValue = "Bearer: y2.WAKiHahzxGS_sP30RpjNUF";
        HttpRequestFactory requestFactory = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.emptyResponse((int)200)}).createRequestFactory((HttpRequestInitializer)this.createRetryHttpInitializer(new FakeCredentials(authHeaderValue)));
        HttpRequest req = requestFactory.buildGetRequest(new GenericUrl(URL));
        Truth.assertThat((Map)req.getHeaders()).containsAtLeast((Object)"user-agent", (Object)ImmutableList.of((Object)"foo-user-agent"), new Object[]{"header-key", "header-value", "authorization", ImmutableList.of((Object)authHeaderValue)});
        HttpResponse res = req.execute();
        Truth.assertThat((Object)res).isNotNull();
        Truth.assertThat((String)((String)req.getHeaders().get((Object)"x-goog-api-client"))).contains((CharSequence)"gccl-invocation-id/");
        Truth.assertThat((Integer)res.getStatusCode()).isEqualTo((Object)200);
        this.requestTracker.verifyEvents(List.of(TestRequestTracker.ExpectedEventDetails.getStarted(URL), TestRequestTracker.ExpectedEventDetails.getResponse(URL, 200)));
    }

    @Test
    public void forbiddenResponse_failsWithoutRetries() throws IOException {
        String authHeaderValue = "Bearer: y2.WAKiHahzxGS_a1b2c3d40RpjNUF";
        HttpRequestFactory requestFactory = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.emptyResponse((int)403)}).createRequestFactory((HttpRequestInitializer)this.createRetryHttpInitializer(new FakeCredentials(authHeaderValue)));
        HttpRequest req = requestFactory.buildGetRequest(new GenericUrl(URL));
        Truth.assertThat((Map)req.getHeaders()).containsAtLeast((Object)"user-agent", (Object)ImmutableList.of((Object)"foo-user-agent"), new Object[]{"header-key", "header-value", "authorization", ImmutableList.of((Object)authHeaderValue)});
        HttpResponseException thrown = (HttpResponseException)Assert.assertThrows(HttpResponseException.class, () -> ((HttpRequest)req).execute());
        Truth.assertThat((String)((String)req.getHeaders().get((Object)"x-goog-api-client"))).contains((CharSequence)"gccl-invocation-id/");
        Truth.assertThat((Integer)thrown.getStatusCode()).isEqualTo((Object)403);
        this.requestTracker.verifyEvents(List.of(TestRequestTracker.ExpectedEventDetails.getStarted(URL), TestRequestTracker.ExpectedEventDetails.getResponse(URL, 403)));
    }

    @Test
    public void serverErrorResponse_succeedsAfterRetries() throws Exception {
        this.errorCodeResponse_succeedsAfterRetries(503);
    }

    @Test
    public void rateLimitExceededResponse_succeedsAfterRetries() throws Exception {
        this.errorCodeResponse_succeedsAfterRetries(429);
    }

    private void errorCodeResponse_succeedsAfterRetries(int statusCode) throws Exception {
        String authHeaderValue = "Bearer: y2.WAKiHahzxGS_a1bd40RjNUF";
        HttpRequestFactory requestFactory = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.emptyResponse((int)statusCode), MockHttpTransportHelper.emptyResponse((int)statusCode), MockHttpTransportHelper.emptyResponse((int)200)}).createRequestFactory((HttpRequestInitializer)this.createRetryHttpInitializer(new FakeCredentials(authHeaderValue)));
        HttpRequest req = requestFactory.buildGetRequest(new GenericUrl(URL));
        Truth.assertThat((Map)req.getHeaders()).containsAtLeast((Object)"user-agent", (Object)ImmutableList.of((Object)"foo-user-agent"), new Object[]{"header-key", "header-value", "authorization", ImmutableList.of((Object)authHeaderValue)});
        HttpResponse res = req.execute();
        Truth.assertThat((String)((String)req.getHeaders().get((Object)"x-goog-api-client"))).contains((CharSequence)"gccl-invocation-id/");
        Truth.assertThat((Object)res).isNotNull();
        Truth.assertThat((Integer)res.getStatusCode()).isEqualTo((Object)200);
        this.requestTracker.verifyEvents(List.of(TestRequestTracker.ExpectedEventDetails.getStarted(URL), TestRequestTracker.ExpectedEventDetails.getResponse(URL, statusCode), TestRequestTracker.ExpectedEventDetails.getBackoff(URL, 0), TestRequestTracker.ExpectedEventDetails.getResponse(URL, statusCode), TestRequestTracker.ExpectedEventDetails.getBackoff(URL, 1), TestRequestTracker.ExpectedEventDetails.getResponse(URL, 200)));
    }

    @Test
    public void errorCodeResponse_failsAfterMaxRetries() throws Exception {
        int statusCode = 429;
        String authHeaderValue = "Bearer: y2.WAKiHahzxGS_a1bd40RjNUF";
        HttpRequestFactory requestFactory = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.emptyResponse((int)statusCode), MockHttpTransportHelper.emptyResponse((int)statusCode), MockHttpTransportHelper.emptyResponse((int)statusCode), MockHttpTransportHelper.emptyResponse((int)statusCode), MockHttpTransportHelper.emptyResponse((int)statusCode), MockHttpTransportHelper.emptyResponse((int)statusCode), MockHttpTransportHelper.emptyResponse((int)statusCode)}).createRequestFactory((HttpRequestInitializer)this.createRetryHttpInitializer(new FakeCredentials(authHeaderValue)));
        HttpRequest req = requestFactory.buildGetRequest(new GenericUrl(URL));
        Truth.assertThat((Map)req.getHeaders()).containsAtLeast((Object)"user-agent", (Object)ImmutableList.of((Object)"foo-user-agent"), new Object[]{"header-key", "header-value", "authorization", ImmutableList.of((Object)authHeaderValue)});
        try {
            HttpResponse httpResponse = req.execute();
        }
        catch (HttpResponseException httpResponseException) {
            // empty catch block
        }
        this.requestTracker.verifyEvents(List.of(TestRequestTracker.ExpectedEventDetails.getStarted(URL), TestRequestTracker.ExpectedEventDetails.getResponse(URL, statusCode), TestRequestTracker.ExpectedEventDetails.getBackoff(URL, 0), TestRequestTracker.ExpectedEventDetails.getResponse(URL, statusCode), TestRequestTracker.ExpectedEventDetails.getBackoff(URL, 1), TestRequestTracker.ExpectedEventDetails.getResponse(URL, statusCode), TestRequestTracker.ExpectedEventDetails.getBackoff(URL, 2), TestRequestTracker.ExpectedEventDetails.getResponse(URL, statusCode), TestRequestTracker.ExpectedEventDetails.getBackoff(URL, 3), TestRequestTracker.ExpectedEventDetails.getResponse(URL, statusCode), TestRequestTracker.ExpectedEventDetails.getBackoff(URL, 4), TestRequestTracker.ExpectedEventDetails.getResponse(URL, statusCode)));
    }

    @Test
    public void ioExceptionResponse_succeedsAfterRetries() throws Exception {
        String authHeaderValue = "Bearer: y2.WAKiHahzxGS_a1bd4jNUF";
        HttpRequestFactory requestFactory = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.inputStreamResponse((String)"Content-Length", (Object)1, (InputStream)new ThrowingInputStream(new IOException("read IOException"))), MockHttpTransportHelper.emptyResponse((int)200)}).createRequestFactory((HttpRequestInitializer)this.createRetryHttpInitializer(new FakeCredentials(authHeaderValue)));
        HttpRequest req = requestFactory.buildGetRequest(new GenericUrl(URL));
        Truth.assertThat((Map)req.getHeaders()).containsAtLeast((Object)"user-agent", (Object)ImmutableList.of((Object)"foo-user-agent"), new Object[]{"header-key", "header-value", "authorization", ImmutableList.of((Object)authHeaderValue)});
        HttpResponse res = req.execute();
        Truth.assertThat((String)((String)req.getHeaders().get((Object)"x-goog-api-client"))).contains((CharSequence)"gccl-invocation-id/");
        Truth.assertThat((Object)res).isNotNull();
        Truth.assertThat((Integer)res.getStatusCode()).isEqualTo((Object)200);
        this.requestTracker.verifyEvents(List.of(TestRequestTracker.ExpectedEventDetails.getStarted(URL), TestRequestTracker.ExpectedEventDetails.getResponse(URL, 200)));
    }

    private TestRetryHttpInitializer createRetryHttpInitializer(Credentials credentials) {
        return new TestRetryHttpInitializer(credentials, RetryHttpInitializerOptions.builder().setDefaultUserAgent("foo-user-agent").setHttpHeaders((Map)ImmutableMap.of((Object)"header-key", (Object)"header-value")).setMaxRequestRetries(5).setConnectTimeout(Duration.ofSeconds(5L)).setReadTimeout(Duration.ofSeconds(5L)).build());
    }

    private class TestRetryHttpInitializer
    extends RetryHttpInitializer {
        private boolean isInitialized;

        public TestRetryHttpInitializer(Credentials credentials, RetryHttpInitializerOptions build) {
            super(credentials, build);
        }

        protected RequestTracker getRequestTracker(HttpRequest request) {
            if (!this.isInitialized) {
                RetryHttpInitializerTest.this.requestTracker.init(request);
                this.isInitialized = true;
            }
            return RetryHttpInitializerTest.this.requestTracker;
        }
    }
}

