/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.api.client.testing.util.MockSleeper;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.Sleeper;
import com.google.cloud.hadoop.util.ResilientOperation;
import com.google.cloud.hadoop.util.RetryBoundedBackOff;
import com.google.cloud.hadoop.util.RetryDeterminer;
import com.google.common.truth.Truth;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ResilientOperationTest {
    @Test
    public void testValidCallHasNoRetries() throws Exception {
        MockSleeper sleeper = new MockSleeper();
        CallableTester callTester = new CallableTester(new ArrayList<Exception>());
        RetryBoundedBackOff backoff = new RetryBoundedBackOff((BackOff)new BackOffTester(), 3);
        ResilientOperation.retry((Callable)callTester, (BackOff)backoff, (RetryDeterminer)RetryDeterminer.DEFAULT, Exception.class, (Sleeper)sleeper);
        Truth.assertThat((Integer)callTester.timesCalled()).isEqualTo((Object)1);
        Truth.assertThat((Integer)sleeper.getCount()).isEqualTo((Object)0);
    }

    @Test
    public void testCallFailsOnBadException() throws Exception {
        MockSleeper sleeper = new MockSleeper();
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        exceptions.add(new IllegalArgumentException("FakeException"));
        CallableTester callTester = new CallableTester(exceptions);
        RetryBoundedBackOff backoff = new RetryBoundedBackOff((BackOff)new BackOffTester(), 3);
        IllegalArgumentException thrown = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> ResilientOperationTest.lambda$testCallFailsOnBadException$0(callTester, (BackOff)backoff, sleeper));
        Truth.assertThat((Throwable)thrown).hasMessageThat().contains((CharSequence)"FakeException");
        Truth.assertThat((Integer)callTester.timesCalled()).isEqualTo((Object)1);
        this.verifySleeper(sleeper, 0);
    }

    @Test
    public void testCallRetriesAndFails() throws Exception {
        MockSleeper sleeper = new MockSleeper();
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        exceptions.add(new SocketTimeoutException("socket"));
        exceptions.add(new SocketTimeoutException("socket"));
        exceptions.add(new IllegalArgumentException("FakeException"));
        CallableTester callTester = new CallableTester(exceptions);
        RetryBoundedBackOff backoff = new RetryBoundedBackOff((BackOff)new BackOffTester(), 5);
        IllegalArgumentException thrown = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> ResilientOperationTest.lambda$testCallRetriesAndFails$1(callTester, (BackOff)backoff, sleeper));
        Truth.assertThat((Throwable)thrown).hasMessageThat().contains((CharSequence)"FakeException");
        Truth.assertThat((Integer)callTester.timesCalled()).isEqualTo((Object)3);
        this.verifySleeper(sleeper, 2);
    }

    @Test
    public void testCallRetriesAndFailsWithSocketErrors() throws Exception {
        MockSleeper sleeper = new MockSleeper();
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        exceptions.add(new SocketTimeoutException("socket"));
        exceptions.add(new SocketTimeoutException("socket"));
        exceptions.add(new IOException("FakeException"));
        CallableTester callTester = new CallableTester(exceptions);
        RetryBoundedBackOff backoff = new RetryBoundedBackOff((BackOff)new BackOffTester(), 5);
        IOException thrown = (IOException)Assert.assertThrows(IOException.class, () -> ResilientOperationTest.lambda$testCallRetriesAndFailsWithSocketErrors$2(callTester, (BackOff)backoff, sleeper));
        Truth.assertThat((Throwable)thrown).hasMessageThat().contains((CharSequence)"FakeException");
        Truth.assertThat((Integer)callTester.timesCalled()).isEqualTo((Object)3);
        this.verifySleeper(sleeper, 2);
    }

    public void verifySleeper(MockSleeper sleeper, int retry) {
        Truth.assertThat((Integer)retry).isEqualTo((Object)sleeper.getCount());
        if (retry == 0) {
            return;
        }
        Truth.assertThat((Long)((long)Math.pow(2.0, retry))).isEqualTo((Object)sleeper.getLastMillis());
    }

    @Test
    public void testCallMaxRetries() throws Exception {
        MockSleeper sleeper = new MockSleeper();
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        exceptions.add(new SocketTimeoutException("socket"));
        exceptions.add(new SocketTimeoutException("socket2"));
        exceptions.add(new SocketTimeoutException("socket3"));
        CallableTester callTester = new CallableTester(exceptions);
        RetryBoundedBackOff backoff = new RetryBoundedBackOff((BackOff)new BackOffTester(), 2);
        SocketTimeoutException thrown = (SocketTimeoutException)Assert.assertThrows(SocketTimeoutException.class, () -> ResilientOperationTest.lambda$testCallMaxRetries$3(callTester, (BackOff)backoff, sleeper));
        Truth.assertThat((Throwable)thrown).hasMessageThat().contains((CharSequence)"socket3");
        Truth.assertThat((Integer)callTester.timesCalled()).isEqualTo((Object)3);
        this.verifySleeper(sleeper, 2);
    }

    @Test
    public void testCallRetriesAndSucceeds() throws Exception {
        MockSleeper sleeper = new MockSleeper();
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        exceptions.add(new SocketTimeoutException("socket"));
        exceptions.add(new SocketTimeoutException("socket2"));
        exceptions.add(new SocketTimeoutException("socket3"));
        CallableTester callTester = new CallableTester(exceptions);
        RetryBoundedBackOff backoff = new RetryBoundedBackOff((BackOff)new BackOffTester(), 3);
        Truth.assertThat((Integer)((Integer)ResilientOperation.retry((Callable)callTester, (BackOff)backoff, (RetryDeterminer)RetryDeterminer.DEFAULT, Exception.class, (Sleeper)sleeper))).isEqualTo((Object)3);
        Truth.assertThat((Integer)callTester.timesCalled()).isEqualTo((Object)4);
        this.verifySleeper(sleeper, 3);
    }

    private static /* synthetic */ void lambda$testCallMaxRetries$3(CallableTester callTester, BackOff backoff, MockSleeper sleeper) throws Throwable {
        ResilientOperation.retry((Callable)callTester, (BackOff)backoff, (RetryDeterminer)RetryDeterminer.DEFAULT, Exception.class, (Sleeper)sleeper);
    }

    private static /* synthetic */ void lambda$testCallRetriesAndFailsWithSocketErrors$2(CallableTester callTester, BackOff backoff, MockSleeper sleeper) throws Throwable {
        ResilientOperation.retry((Callable)callTester, (BackOff)backoff, (RetryDeterminer)RetryDeterminer.SOCKET_ERRORS, IOException.class, (Sleeper)sleeper);
    }

    private static /* synthetic */ void lambda$testCallRetriesAndFails$1(CallableTester callTester, BackOff backoff, MockSleeper sleeper) throws Throwable {
        ResilientOperation.retry((Callable)callTester, (BackOff)backoff, (RetryDeterminer)RetryDeterminer.DEFAULT, Exception.class, (Sleeper)sleeper);
    }

    private static /* synthetic */ void lambda$testCallFailsOnBadException$0(CallableTester callTester, BackOff backoff, MockSleeper sleeper) throws Throwable {
        ResilientOperation.retry((Callable)callTester, (BackOff)backoff, (RetryDeterminer)RetryDeterminer.DEFAULT, Exception.class, (Sleeper)sleeper);
    }

    private static class BackOffTester
    implements BackOff {
        int counter = 1;

        private BackOffTester() {
        }

        public void reset() {
            this.counter = 1;
        }

        public long nextBackOffMillis() {
            this.counter *= 2;
            return this.counter;
        }
    }

    private static class CallableTester
    implements Callable<Integer> {
        int called = 0;
        ArrayList<Exception> exceptions;

        public CallableTester(ArrayList<Exception> exceptions) {
            this.exceptions = exceptions;
        }

        @Override
        public Integer call() throws Exception {
            if (this.called < this.exceptions.size()) {
                throw this.exceptions.get(this.called++);
            }
            return this.called++;
        }

        public int timesCalled() {
            return this.called;
        }
    }
}

