/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.cloud.hadoop.util.TestRequestTracker;
import com.google.cloud.hadoop.util.testing.MockHttpTransportHelper;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import junit.framework.TestCase;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class RequestTrackerTest
extends TestCase {
    private static final String URL = "http://fake-url.com";
    public static final int STATUS_CODE = 200;
    private TestRequestTracker tracker;
    private HttpResponse response;
    private HttpRequest request;

    @Before
    public void setup() throws IOException {
        this.request = RequestTrackerTest.getHttpRequest(200);
        this.response = this.request.execute();
        this.tracker = new TestRequestTracker();
        this.tracker.init(this.response.getRequest());
    }

    @Test
    public void testOnResponse() throws IOException {
        this.tracker.verifyEvents(List.of(TestRequestTracker.ExpectedEventDetails.getStarted(URL)));
        this.tracker.trackResponse(this.response);
        this.tracker.verifyEvents(List.of(TestRequestTracker.ExpectedEventDetails.getStarted(URL), TestRequestTracker.ExpectedEventDetails.getResponse(URL, 200)));
    }

    @Test
    public void testOnIOException() throws IOException {
        this.tracker.trackIOException();
        this.tracker.verifyEvents(List.of(TestRequestTracker.ExpectedEventDetails.getStarted(URL), TestRequestTracker.ExpectedEventDetails.getException(URL)));
    }

    @Test
    public void testOnUnsuccessfulResponseHandler() {
        this.tracker.trackUnsuccessfulResponseHandler(this.response);
        this.tracker.verifyEvents(List.of(TestRequestTracker.ExpectedEventDetails.getStarted(URL), TestRequestTracker.ExpectedEventDetails.getResponse(URL, 200)));
    }

    @Test
    public void testBackOff() {
        this.tracker.trackUnsuccessfulResponseHandler(this.response);
        int backOff1 = this.doBackOffRandom();
        this.tracker.verifyEvents(List.of(TestRequestTracker.ExpectedEventDetails.getStarted(URL), TestRequestTracker.ExpectedEventDetails.getResponse(URL, 200), TestRequestTracker.ExpectedEventDetails.getBackoff(URL, 0, backOff1)));
        int backOff2 = this.doBackOffRandom();
        this.tracker.verifyEvents(List.of(TestRequestTracker.ExpectedEventDetails.getStarted(URL), TestRequestTracker.ExpectedEventDetails.getResponse(URL, 200), TestRequestTracker.ExpectedEventDetails.getBackoff(URL, 0, backOff1), TestRequestTracker.ExpectedEventDetails.getBackoff(URL, 0, backOff2)));
    }

    private int doBackOffRandom() {
        int backoffTime = ThreadLocalRandom.current().nextInt(1, 20000);
        this.tracker.trackBackOffCompleted(System.currentTimeMillis() - (long)backoffTime);
        return backoffTime;
    }

    @Test
    public void testRetryEvents() {
        this.tracker.trackUnsuccessfulResponseHandler(this.response);
        this.tracker.trackRetryStarted();
        int backOff1 = this.doBackOffRandom();
        this.tracker.verifyEvents(List.of(TestRequestTracker.ExpectedEventDetails.getStarted(URL), TestRequestTracker.ExpectedEventDetails.getResponse(URL, 200), TestRequestTracker.ExpectedEventDetails.getBackoff(URL, 1, backOff1)));
        this.tracker.trackUnsuccessfulResponseHandler(this.response);
        this.tracker.trackRetryStarted();
        int backOff2 = this.doBackOffRandom();
        this.tracker.verifyEvents(List.of(TestRequestTracker.ExpectedEventDetails.getStarted(URL), TestRequestTracker.ExpectedEventDetails.getResponse(URL, 200), TestRequestTracker.ExpectedEventDetails.getBackoff(URL, 1, backOff1), TestRequestTracker.ExpectedEventDetails.getResponse(URL, 200), TestRequestTracker.ExpectedEventDetails.getBackoff(URL, 2, backOff2)));
    }

    @Test
    public void testRetrySkipped() {
        this.tracker.trackUnsuccessfulResponseHandler(this.response);
        this.tracker.trackRetryStarted();
        int backOff1 = this.doBackOffRandom();
        this.tracker.trackUnsuccessfulResponseHandler(this.response);
        this.tracker.trackRetrySkipped(true);
        this.tracker.verifyEvents(List.of(TestRequestTracker.ExpectedEventDetails.getStarted(URL), TestRequestTracker.ExpectedEventDetails.getResponse(URL, 200), TestRequestTracker.ExpectedEventDetails.getBackoff(URL, 1, backOff1), TestRequestTracker.ExpectedEventDetails.getResponse(URL, 200)));
    }

    private static HttpRequest getHttpRequest(int statusCode) throws IOException {
        return MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.emptyResponse((int)statusCode)}).createRequestFactory().buildGetRequest(new GenericUrl(URL));
    }
}

