/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.cloud.hadoop.util.PropertyUtil;
import com.google.common.truth.Truth;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class PropertyUtilTest {
    @Test
    public void defaultValueIsReturnedWhenNoFile() {
        Truth.assertThat((String)PropertyUtil.getPropertyOrDefault(this.getClass(), (String)"NonExistentFile", (String)"testKey", (String)"NotFound")).isEqualTo((Object)"NotFound");
    }

    @Test
    public void defaultValueIsReturnedWhenKeyNotFound() {
        Truth.assertThat((String)PropertyUtil.getPropertyOrDefault(this.getClass(), (String)"test.properties", (String)"testKey2", (String)"NotFound")).isEqualTo((Object)"NotFound");
    }

    @Test
    public void valueIsReturnedForFoundKeyAndFile() {
        Truth.assertThat((String)PropertyUtil.getPropertyOrDefault(this.getClass(), (String)"test.properties", (String)"testKey", (String)"NotFound")).isEqualTo((Object)"testValue");
    }

    @Test
    public void valueWithWhitespaceIsReadProperly() {
        Truth.assertThat((String)PropertyUtil.getPropertyOrDefault(this.getClass(), (String)"test.properties", (String)"whitespaceKey", (String)"NotFound")).isEqualTo((Object)"test value with whitespace");
    }

    @Test
    public void valueWithEscapedCharactersIsReadUnescaped() {
        Truth.assertThat((String)PropertyUtil.getPropertyOrDefault(this.getClass(), (String)"test.properties", (String)"escapedValueKey", (String)"NotFound")).isEqualTo((Object)"http://www.example.com");
    }

    @Test
    public void keysAfterCommentsAreFound() {
        Truth.assertThat((String)PropertyUtil.getPropertyOrDefault(this.getClass(), (String)"test.properties", (String)"postCommentKey", (String)"NotFound")).isEqualTo((Object)"postCommentValue");
    }
}

