/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.cloud.hadoop.util.ErrorTypeExtractor;
import com.google.cloud.hadoop.util.GrpcErrorTypeExtractor;
import com.google.common.truth.Truth;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import org.junit.Test;

public class GrpcErrorTypeExtractorTest {
    private static final GrpcErrorTypeExtractor typeExtractor = GrpcErrorTypeExtractor.INSTANCE;

    @Test
    public void testNotFound() {
        StatusRuntimeException ex = new StatusRuntimeException(Status.NOT_FOUND);
        Truth.assertThat((Comparable)typeExtractor.getErrorType((Exception)ex)).isEqualTo((Object)ErrorTypeExtractor.ErrorType.NOT_FOUND);
    }

    @Test
    public void testOutOfRange() {
        StatusRuntimeException ex = new StatusRuntimeException(Status.OUT_OF_RANGE);
        Truth.assertThat((Comparable)typeExtractor.getErrorType((Exception)ex)).isEqualTo((Object)ErrorTypeExtractor.ErrorType.OUT_OF_RANGE);
    }

    @Test
    public void testBucketAlreadyExistsFailedPreconditionException() {
        Exception ex = new Exception((Throwable)new StatusRuntimeException(Status.FAILED_PRECONDITION.withDescription("Your previous request to create the named bucket succeeded and you already own it.")));
        Truth.assertThat((Boolean)typeExtractor.bucketAlreadyExists(ex)).isEqualTo((Object)true);
    }

    @Test
    public void testBucketAlreadyExists() {
        Exception ex = new Exception((Throwable)new StatusRuntimeException(Status.ALREADY_EXISTS));
        Truth.assertThat((Boolean)typeExtractor.bucketAlreadyExists(ex)).isEqualTo((Object)true);
    }

    @Test
    public void testBucketAlreadyExistsInvalidException() {
        StatusRuntimeException ex = new StatusRuntimeException(Status.ABORTED);
        Truth.assertThat((Boolean)typeExtractor.bucketAlreadyExists((Exception)ex)).isEqualTo((Object)false);
    }
}

