/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.cloud.hadoop.util.GcsJsonApiEvent;
import com.google.cloud.hadoop.util.testing.MockHttpTransportHelper;
import com.google.common.truth.Truth;
import java.io.IOException;
import java.util.concurrent.ThreadLocalRandom;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GcsJsonApiEventTest {
    private static final String URL = "http://fake-url.com";

    @Test
    public void testGetResponseEvent() throws IOException {
        int duration = Math.abs(ThreadLocalRandom.current().nextInt(1000000));
        GcsJsonApiEvent event = GcsJsonApiEvent.getResponseEvent((HttpResponse)this.getResponse(), (long)duration, (Object)URL);
        Truth.assertThat((String)event.getContext().toString()).isEqualTo((Object)URL);
        Truth.assertThat((String)event.getMethod()).isEqualTo((Object)"GET");
        Truth.assertThat((Comparable)event.getEventType()).isEqualTo((Object)GcsJsonApiEvent.EventType.RESPONSE);
        Truth.assertThat((Object)event.getProperty("DURATION")).isEqualTo((Object)duration);
    }

    @Test
    public void testGetExceptionEvent() throws IOException {
        GcsJsonApiEvent event = GcsJsonApiEvent.getExceptionEvent((HttpRequest)this.getResponse().getRequest(), (Object)URL);
        Truth.assertThat((String)event.getContext().toString()).isEqualTo((Object)URL);
        Truth.assertThat((String)event.getMethod()).isEqualTo((Object)"GET");
        Truth.assertThat((Comparable)event.getEventType()).isEqualTo((Object)GcsJsonApiEvent.EventType.EXCEPTION);
    }

    private HttpResponse getResponse() throws IOException {
        return MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.emptyResponse((int)200)}).createRequestFactory().buildGetRequest(new GenericUrl(URL)).execute();
    }

    @Test
    public void testGetNonExistingProperty() throws IOException {
        GcsJsonApiEvent event = GcsJsonApiEvent.getResponseEvent((HttpResponse)this.getResponse(), (long)1L, (Object)URL);
        Truth.assertThat((Object)event.getProperty("foo")).isNull();
    }
}

