/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.api.client.util.BackOff;
import com.google.cloud.hadoop.util.RetryBoundedBackOff;
import com.google.common.truth.Truth;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class RetryBoundedBackOffTest {
    @Test
    public void testValidCallHasNoRetries() throws Exception {
        IllegalArgumentException thrown = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> new RetryBoundedBackOff((BackOff)new BackOffTester(), -7));
        Truth.assertThat((Throwable)thrown).hasMessageThat().contains((CharSequence)"Maximum number of retries must not be less than 0.");
    }

    @Test
    public void stopsAfterAttempts() throws Exception {
        RetryBoundedBackOff backoff = new RetryBoundedBackOff((BackOff)new BackOffTester(), 5);
        for (int i = 0; i < 5; ++i) {
            Truth.assertThat((Integer)(i + 1)).isEqualTo((Object)backoff.nextBackOffMillis());
        }
        Truth.assertThat((Long)backoff.nextBackOffMillis()).isEqualTo((Object)-1L);
        Truth.assertThat((Long)backoff.nextBackOffMillis()).isEqualTo((Object)-1L);
    }

    @Test
    public void resetsCorrectly() throws Exception {
        int i;
        RetryBoundedBackOff backoff = new RetryBoundedBackOff((BackOff)new BackOffTester(), 5);
        for (i = 0; i < 5; ++i) {
            Truth.assertThat((Integer)(i + 1)).isEqualTo((Object)backoff.nextBackOffMillis());
        }
        Truth.assertThat((Long)backoff.nextBackOffMillis()).isEqualTo((Object)-1L);
        Truth.assertThat((Long)backoff.nextBackOffMillis()).isEqualTo((Object)-1L);
        backoff.reset();
        for (i = 0; i < 3; ++i) {
            Truth.assertThat((Integer)(i + 1)).isEqualTo((Object)backoff.nextBackOffMillis());
        }
        backoff.reset();
        for (i = 0; i < 5; ++i) {
            Truth.assertThat((Integer)(i + 1)).isEqualTo((Object)backoff.nextBackOffMillis());
        }
        Truth.assertThat((Long)backoff.nextBackOffMillis()).isEqualTo((Object)-1L);
        Truth.assertThat((Long)backoff.nextBackOffMillis()).isEqualTo((Object)-1L);
    }

    public class BackOffTester
    implements BackOff {
        public int counter = 0;

        public void reset() {
            this.counter = 0;
        }

        public long nextBackOffMillis() throws IOException {
            return ++this.counter;
        }
    }
}

