/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.cloud.hadoop.util.HttpTransportFactory;
import com.google.common.truth.Truth;
import java.net.URI;
import java.net.URISyntaxException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class HttpTransportFactoryTest {
    @Test
    public void testParseProxyAddress() throws Exception {
        String address = "foo-host:1234";
        URI expectedUri = HttpTransportFactoryTest.getURI(null, "foo-host", 1234);
        URI uri = HttpTransportFactory.parseProxyAddress((String)address);
        Truth.assertThat((Comparable)uri).isEqualTo((Object)expectedUri);
    }

    @Test
    public void testParseProxyAddressHttp() throws Exception {
        String address = "http://foo-host:1234";
        URI expectedUri = HttpTransportFactoryTest.getURI("http", "foo-host", 1234);
        URI uri = HttpTransportFactory.parseProxyAddress((String)address);
        Truth.assertThat((Comparable)uri).isEqualTo((Object)expectedUri);
    }

    @Test
    public void testParseProxyAddressHttps() throws Exception {
        String address = "https://foo-host:1234";
        URI expectedUri = HttpTransportFactoryTest.getURI("https", "foo-host", 1234);
        URI uri = HttpTransportFactory.parseProxyAddress((String)address);
        Truth.assertThat((Comparable)uri).isEqualTo((Object)expectedUri);
    }

    @Test
    public void testParseProxyAddressInvalidScheme() throws Exception {
        String address = "socks5://foo-host:1234";
        IllegalArgumentException thrown = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> HttpTransportFactory.parseProxyAddress((String)address));
        Truth.assertThat((Throwable)thrown).hasMessageThat().contains((CharSequence)"HTTP proxy address 'socks5://foo-host:1234' has invalid scheme 'socks5'.");
    }

    @Test
    public void testParseProxyAddressNoHost() throws Exception {
        String address = ":1234";
        IllegalArgumentException thrown = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> HttpTransportFactory.parseProxyAddress((String)address));
        Truth.assertThat((Throwable)thrown).hasMessageThat().contains((CharSequence)"Proxy address ':1234' has no host.");
    }

    @Test
    public void testParseProxyAddressNoPort() throws Exception {
        String address = "foo-host";
        IllegalArgumentException thrown = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> HttpTransportFactory.parseProxyAddress((String)address));
        Truth.assertThat((Throwable)thrown).hasMessageThat().contains((CharSequence)"Proxy address 'foo-host' has no port.");
    }

    @Test
    public void testParseProxyAddressInvalidSyntax() throws Exception {
        String address = "foo-host-with-illegal-char^:1234";
        IllegalArgumentException thrown = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> HttpTransportFactory.parseProxyAddress((String)address));
        Truth.assertThat((Throwable)thrown).hasMessageThat().contains((CharSequence)"Invalid proxy address 'foo-host-with-illegal-char^:1234'.");
    }

    @Test
    public void testParseProxyAddressWithPath() throws Exception {
        String address = "foo-host:1234/some/path";
        IllegalArgumentException thrown = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> HttpTransportFactory.parseProxyAddress((String)address));
        Truth.assertThat((Throwable)thrown).hasMessageThat().contains((CharSequence)"Invalid proxy address 'foo-host:1234/some/path'.");
    }

    private static URI getURI(String scheme, String host, int port) throws URISyntaxException {
        return new URI(scheme, null, host, port, null, null, null);
    }
}

