/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.auto.value.AutoValue;
import com.google.cloud.hadoop.util.AutoValue_CredentialOptions;
import com.google.cloud.hadoop.util.HttpTransportFactory;
import javax.annotation.Nullable;

@AutoValue
public abstract class CredentialOptions {
    static final boolean SERVICE_ACCOUNT_ENABLED_DEFAULT = true;
    static final boolean NULL_CREDENTIALS_ENABLED_DEFAULT = false;
    static final HttpTransportFactory.HttpTransportType HTTP_TRANSPORT_TYPE_DEFAULT = HttpTransportFactory.DEFAULT_TRANSPORT_TYPE;
    static final String TOKEN_SERVER_URL_DEFAULT = "https://oauth2.googleapis.com/token";

    public static Builder builder() {
        return new AutoValue_CredentialOptions.Builder().setServiceAccountEnabled(true).setNullCredentialEnabled(false).setTransportType(HTTP_TRANSPORT_TYPE_DEFAULT).setTokenServerUrl(TOKEN_SERVER_URL_DEFAULT);
    }

    public abstract boolean isServiceAccountEnabled();

    @Nullable
    public abstract String getServiceAccountPrivateKeyId();

    @Nullable
    public abstract String getServiceAccountPrivateKey();

    @Nullable
    public abstract String getServiceAccountEmail();

    @Nullable
    public abstract String getServiceAccountKeyFile();

    @Nullable
    public abstract String getServiceAccountJsonKeyFile();

    @Nullable
    public abstract String getClientId();

    @Nullable
    public abstract String getClientSecret();

    @Nullable
    public abstract String getOAuthCredentialFile();

    public abstract boolean isNullCredentialEnabled();

    public abstract HttpTransportFactory.HttpTransportType getTransportType();

    public abstract String getTokenServerUrl();

    @Nullable
    public abstract String getProxyAddress();

    @Nullable
    public abstract String getProxyUsername();

    @Nullable
    public abstract String getProxyPassword();

    public abstract Builder toBuilder();

    public final String toString() {
        return "CredentialOptions{\n" + "serviceAccountEnabled: " + this.isServiceAccountEnabled() + '\n' + "serviceAccountPrivateKeyId: " + HttpTransportFactory.toSecretString(this.getServiceAccountPrivateKeyId()) + '\n' + "serviceAccountPrivateKey: " + HttpTransportFactory.toSecretString(this.getServiceAccountPrivateKey()) + '\n' + "serviceAccountEmail: " + this.getServiceAccountEmail() + '\n' + "serviceAccountKeyfile: " + this.getServiceAccountKeyFile() + '\n' + "serviceAccountJsonKeyFile: " + this.getServiceAccountJsonKeyFile() + '\n' + "clientId: " + HttpTransportFactory.toSecretString(this.getClientId()) + '\n' + "clientSecret: " + HttpTransportFactory.toSecretString(this.getClientSecret()) + '\n' + "oAuthCredentialFile: " + this.getOAuthCredentialFile() + '\n' + "nullCredentialEnabled: " + this.isNullCredentialEnabled() + '\n' + "transportType: " + (Object)((Object)this.getTransportType()) + '\n' + "tokenServerUrl: " + this.getTokenServerUrl() + '\n' + "proxyAddress: " + this.getProxyAddress() + '\n' + "proxyUsername: " + HttpTransportFactory.toSecretString(this.getProxyUsername()) + '\n' + "proxyPassword: " + HttpTransportFactory.toSecretString(this.getProxyPassword()) + '\n' + "}";
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setServiceAccountEnabled(boolean var1);

        public abstract Builder setServiceAccountPrivateKeyId(String var1);

        public abstract Builder setServiceAccountPrivateKey(String var1);

        public abstract Builder setServiceAccountEmail(String var1);

        public abstract Builder setServiceAccountKeyFile(String var1);

        public abstract Builder setServiceAccountJsonKeyFile(String var1);

        public abstract Builder setClientId(String var1);

        public abstract Builder setClientSecret(String var1);

        public abstract Builder setOAuthCredentialFile(String var1);

        public abstract Builder setNullCredentialEnabled(boolean var1);

        public abstract Builder setTransportType(HttpTransportFactory.HttpTransportType var1);

        public abstract Builder setTokenServerUrl(String var1);

        public abstract Builder setProxyAddress(String var1);

        public abstract Builder setProxyUsername(String var1);

        public abstract Builder setProxyPassword(String var1);

        public abstract CredentialOptions build();
    }
}

