/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util.testing;

import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.testing.http.HttpTesting;
import com.google.api.client.testing.http.MockHttpTransport;
import com.google.api.client.testing.http.MockLowLevelHttpRequest;
import com.google.api.client.testing.http.MockLowLevelHttpResponse;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;

public final class MockHttpTransportHelper {
    private static final int UNKNOWN_CONTENT_LENGTH = -1;
    public static final JacksonFactory JSON_FACTORY = JacksonFactory.getDefaultInstance();

    private MockHttpTransportHelper() {
    }

    public static HttpResponse fakeResponse(String header, Object headerValue, InputStream content) throws IOException {
        return MockHttpTransportHelper.fakeResponse((Map<String, Object>)ImmutableMap.of((Object)header, (Object)headerValue), content);
    }

    public static HttpResponse fakeResponse(final Map<String, Object> headers, final InputStream content) throws IOException {
        MockHttpTransport transport = new MockHttpTransport(){

            public LowLevelHttpRequest buildRequest(String method, String url) {
                return new MockLowLevelHttpRequest(){

                    public LowLevelHttpResponse execute() {
                        MockLowLevelHttpResponse response = new MockLowLevelHttpResponse();
                        headers.forEach((h, hv) -> response.addHeader(h, String.valueOf(hv)));
                        return response.setContent(content);
                    }
                };
            }
        };
        HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        return request.execute();
    }

    public static MockHttpTransport mockTransport(final LowLevelHttpResponse ... responsesIn) {
        return new MockHttpTransport(){
            int responsesIndex = 0;
            final LowLevelHttpResponse[] responses = responsesIn;

            public LowLevelHttpRequest buildRequest(String method, String url) {
                return new MockLowLevelHttpRequest(){

                    public LowLevelHttpResponse execute() {
                        return responses[responsesIndex++];
                    }
                };
            }
        };
    }

    public static MockHttpTransport mockBatchTransport(final int requestsPerBatch, final LowLevelHttpResponse ... responses) {
        return new MockHttpTransport(){
            int responsesIndex = 0;

            public LowLevelHttpRequest buildRequest(String method, String url) {
                return new MockLowLevelHttpRequest(){

                    public LowLevelHttpResponse execute() {
                        String boundary = "batch_pK7JBAk73-E=_AA5eFwv4m2Q=";
                        String contentId = "";
                        MockLowLevelHttpResponse response = new MockLowLevelHttpResponse().setStatusCode(200).setContentType("multipart/mixed; boundary=" + boundary);
                        StringBuilder batchResponse = new StringBuilder();
                        for (int i = 0; i < requestsPerBatch; ++i) {
                            try {
                                LowLevelHttpResponse resp = responses[responsesIndex++];
                                batchResponse.append(String.format("\n--%s\n", boundary)).append("Content-Type: application/http\n").append(String.format("Content-ID: <response-%s%d>\n\n", contentId, i + 1)).append(String.format("HTTP/1.1 %s OK\n", resp.getStatusCode())).append(String.format("Content-Length: %s\n\n", resp.getContentLength())).append(CharStreams.toString((Readable)new InputStreamReader(resp.getContent(), StandardCharsets.UTF_8))).append('\n');
                                continue;
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        batchResponse.append(String.format("\n--%s--\n", boundary));
                        return response.setContent(batchResponse.toString());
                    }
                };
            }
        };
    }

    public static MockLowLevelHttpResponse emptyResponse(int statusCode) {
        return new MockLowLevelHttpResponse().setStatusCode(statusCode);
    }

    public static MockLowLevelHttpResponse dataRangeResponse(byte[] content, long rangeStart, long totalSize) {
        long rangeEnd = rangeStart + (long)content.length - 1L;
        return MockHttpTransportHelper.dataResponse(content).addHeader("Content-Range", rangeStart + "-" + rangeEnd + "/" + totalSize);
    }

    public static MockLowLevelHttpResponse jsonDataResponse(Object object) throws IOException {
        return MockHttpTransportHelper.dataResponse(JSON_FACTORY.toByteArray(object));
    }

    public static MockLowLevelHttpResponse dataResponse(byte[] content) {
        return MockHttpTransportHelper.dataResponse((Map<String, Object>)ImmutableMap.of((Object)"Content-Length", (Object)String.valueOf(content.length)), content);
    }

    public static MockLowLevelHttpResponse dataResponse(Map<String, Object> headers, byte[] content) {
        return MockHttpTransportHelper.setHeaders(new MockLowLevelHttpResponse(), headers, content.length).setContent(content);
    }

    public static MockLowLevelHttpResponse jsonErrorResponse(ErrorResponses errorResponse) throws IOException {
        GoogleJsonError.ErrorInfo errorInfo = new GoogleJsonError.ErrorInfo();
        errorInfo.setReason(errorResponse.getErrorReason());
        errorInfo.setDomain(errorResponse.getErrorDomain());
        errorInfo.setFactory((JsonFactory)JSON_FACTORY);
        GoogleJsonError jsonError = new GoogleJsonError();
        jsonError.setCode(errorResponse.getErrorCode());
        jsonError.setErrors((List)ImmutableList.of((Object)errorInfo));
        jsonError.setMessage(errorResponse.getErrorMessage());
        jsonError.setFactory((JsonFactory)JSON_FACTORY);
        GenericJson errorResponseJson = new GenericJson();
        errorResponseJson.set("error", (Object)jsonError);
        errorResponseJson.setFactory((JsonFactory)JSON_FACTORY);
        return new MockLowLevelHttpResponse().setContent(errorResponseJson.toPrettyString()).setContentType("application/json; charset=UTF-8").setStatusCode(errorResponse.getResponseCode());
    }

    public static MockLowLevelHttpResponse inputStreamResponse(String header, Object headerValue, InputStream content) {
        return MockHttpTransportHelper.inputStreamResponse((Map<String, Object>)ImmutableMap.of((Object)header, (Object)headerValue), content);
    }

    public static MockLowLevelHttpResponse inputStreamResponse(Map<String, Object> headers, InputStream content) {
        return MockHttpTransportHelper.setHeaders(new MockLowLevelHttpResponse(), headers, -1L).setContent(content);
    }

    private static MockLowLevelHttpResponse setHeaders(MockLowLevelHttpResponse response, Map<String, Object> headers, long defaultContentLength) {
        Object contentLength = headers.getOrDefault("Content-Length", defaultContentLength);
        Object contentEncoding = headers.get("Content-Encoding");
        headers.forEach((h, hv) -> response.addHeader(h, String.valueOf(hv)));
        if (!response.getHeaderNames().contains("x-goog-generation")) {
            response.addHeader("x-goog-generation", "1");
        }
        return response.setContentLength(Long.parseLong(String.valueOf(contentLength))).setContentEncoding(contentEncoding == null ? null : String.valueOf(contentEncoding));
    }

    public static enum ErrorResponses {
        GONE(410, 503, "backendError", "Backend Error", "global"),
        NOT_FOUND(404, "notFound", "Not Found", "global"),
        RANGE_NOT_SATISFIABLE(416, "requestedRangeNotSatisfiable", "Request range not satisfiable", "global"),
        RATE_LIMITED(429, "rateLimitExceeded", "The total number of changes ...", "usageLimits"),
        SERVER_ERROR(500, "backendError", "Backend Error", "global");

        private final int responseCode;
        private final int errorCode;
        private final String errorReason;
        private final String errorMessage;
        private final String errorDomain;

        private ErrorResponses(int statusCode, String errorReason, String errorMessage, String errorDomain) {
            this(statusCode, statusCode, errorReason, errorMessage, errorDomain);
        }

        private ErrorResponses(int responseCode, int errorCode, String errorReason, String errorMessage, String errorDomain) {
            this.responseCode = responseCode;
            this.errorCode = errorCode;
            this.errorReason = errorReason;
            this.errorMessage = errorMessage;
            this.errorDomain = errorDomain;
        }

        public int getResponseCode() {
            return this.responseCode;
        }

        public int getErrorCode() {
            return this.errorCode;
        }

        public String getErrorReason() {
            return this.errorReason;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public String getErrorDomain() {
            return this.errorDomain;
        }
    }
}

