/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.CredentialStore;
import com.google.api.client.auth.oauth2.TokenRequest;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.extensions.java6.auth.oauth2.AuthorizationCodeInstalledApp;
import com.google.api.client.extensions.java6.auth.oauth2.FileCredentialStore;
import com.google.api.client.extensions.java6.auth.oauth2.VerificationCodeReceiver;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeFlow;
import com.google.api.client.googleapis.auth.oauth2.GoogleClientSecrets;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.compute.ComputeCredential;
import com.google.api.client.googleapis.extensions.java6.auth.oauth2.GooglePromptReceiver;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpBackOffIOExceptionHandler;
import com.google.api.client.http.HttpBackOffUnsuccessfulResponseHandler;
import com.google.api.client.http.HttpIOExceptionHandler;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.HttpUnsuccessfulResponseHandler;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.json.webtoken.JsonWebSignature;
import com.google.api.client.json.webtoken.JsonWebToken;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.ExponentialBackOff;
import com.google.api.client.util.ObjectParser;
import com.google.api.client.util.PemReader;
import com.google.api.client.util.SecurityUtils;
import com.google.cloud.hadoop.util.CredentialOptions;
import com.google.cloud.hadoop.util.HttpTransportFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.flogger.GoogleLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.List;

public class CredentialFactory {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    static final String CREDENTIAL_ENV_VAR = "GOOGLE_APPLICATION_CREDENTIALS";
    public static final ImmutableList<String> GCS_SCOPES = ImmutableList.of((Object)"https://www.googleapis.com/auth/devstorage.full_control");
    private static final JsonFactory JSON_FACTORY = new JacksonFactory();
    private static HttpTransport staticHttpTransport = null;
    private final CredentialOptions options;
    private HttpTransport transport;

    private static synchronized HttpTransport getStaticHttpTransport() throws IOException, GeneralSecurityException {
        if (staticHttpTransport == null) {
            staticHttpTransport = HttpTransportFactory.createHttpTransport(HttpTransportFactory.HttpTransportType.JAVA_NET);
        }
        return staticHttpTransport;
    }

    @VisibleForTesting
    static synchronized void setStaticHttpTransport(HttpTransport transport) {
        staticHttpTransport = transport;
    }

    public CredentialFactory(CredentialOptions options) {
        this.options = options;
    }

    @Deprecated
    public static Credential getCredentialFromMetadataServiceAccount() throws IOException, GeneralSecurityException {
        ((GoogleLogger.Api)logger.atFine()).log("getCredentialFromMetadataServiceAccount()");
        ComputeCredentialWithRetry cred = new ComputeCredentialWithRetry(new ComputeCredential.Builder(CredentialFactory.getStaticHttpTransport(), JSON_FACTORY).setRequestInitializer((HttpRequestInitializer)new CredentialHttpRetryInitializer()));
        try {
            cred.refreshToken();
        }
        catch (IOException e) {
            throw new IOException("Error getting access token from metadata server at: " + cred.getTokenServerEncodedUrl(), e);
        }
        return cred;
    }

    @Deprecated
    public static Credential getCredentialFromPrivateKeyServiceAccount(String serviceAccountEmail, String privateKeyFile, List<String> scopes, HttpTransport transport, String tokenServerUrl) throws IOException, GeneralSecurityException {
        ((GoogleLogger.Api)logger.atFine()).log("getCredentialFromPrivateKeyServiceAccount(%s, %s, %s)", (Object)serviceAccountEmail, (Object)privateKeyFile, scopes);
        return new GoogleCredentialWithRetry(new GoogleCredential.Builder().setTransport(transport).setJsonFactory(JSON_FACTORY).setServiceAccountId(serviceAccountEmail).setServiceAccountScopes(scopes).setServiceAccountPrivateKeyFromP12File(new File(privateKeyFile)).setRequestInitializer((HttpRequestInitializer)new CredentialHttpRetryInitializer()), tokenServerUrl);
    }

    private static Credential getCredentialFromJsonKeyFile(String serviceAccountJsonKeyFile, List<String> scopes, HttpTransport transport, String tokenServerUrl) throws IOException, GeneralSecurityException {
        ((GoogleLogger.Api)logger.atFine()).log("getCredentialFromJsonKeyFile(%s, %s)", (Object)serviceAccountJsonKeyFile, scopes);
        try (FileInputStream fis = new FileInputStream(serviceAccountJsonKeyFile);){
            GoogleCredentialWithRetry googleCredentialWithRetry = GoogleCredentialWithRetry.fromGoogleCredential(GoogleCredential.fromStream((InputStream)fis, (HttpTransport)transport, (JsonFactory)JSON_FACTORY).createScoped(scopes), tokenServerUrl);
            return googleCredentialWithRetry;
        }
    }

    private static Credential getCredentialsFromSAParameters(String privateKeyId, String privateKeyPem, String serviceAccountEmail, List<String> scopes, HttpTransport transport, String tokenServerUrl) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("getServiceAccountCredentialFromHadoopConfiguration(%s)", (Object)serviceAccountEmail);
        if (serviceAccountEmail == null || privateKeyPem == null || privateKeyId == null) {
            throw new IOException("Error reading service account credential from stream, expecting, 'client_email', 'private_key' and 'private_key_id'.");
        }
        PrivateKey privateKey = CredentialFactory.privateKeyFromPkcs8(privateKeyPem);
        GoogleCredential.Builder builder = new GoogleCredential.Builder().setTransport(transport).setJsonFactory(JSON_FACTORY).setServiceAccountId(serviceAccountEmail).setServiceAccountScopes(scopes).setServiceAccountPrivateKey(privateKey).setServiceAccountPrivateKeyId(privateKeyId);
        return new GoogleCredentialWithRetry(builder, tokenServerUrl);
    }

    @Deprecated
    public static Credential getCredentialFromFileCredentialStoreForInstalledApp(String clientId, String clientSecret, String filePath, List<String> scopes, HttpTransport transport, String tokenServerUrl) throws IOException, GeneralSecurityException {
        ((GoogleLogger.Api)logger.atFine()).log("getCredentialFromFileCredentialStoreForInstalledApp(%s, %s, %s, %s)", (Object)clientId, (Object)clientSecret, (Object)filePath, scopes);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)clientId) ? 1 : 0) != 0, (Object)"clientId must not be null or empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)clientSecret) ? 1 : 0) != 0, (Object)"clientSecret must not be null or empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)filePath) ? 1 : 0) != 0, (Object)"filePath must not be null or empty");
        Preconditions.checkNotNull(scopes, (Object)"scopes must not be null");
        GoogleClientSecrets.Details details = new GoogleClientSecrets.Details().setClientId(clientId).setClientSecret(clientSecret);
        GoogleClientSecrets clientSecrets = new GoogleClientSecrets().setInstalled(details);
        FileCredentialStore credentialStore = new FileCredentialStore(new File(filePath), JSON_FACTORY);
        GoogleAuthorizationCodeFlow flow = new GoogleAuthorizationCodeFlow.Builder(transport, JSON_FACTORY, clientSecrets, scopes).setCredentialStore((CredentialStore)credentialStore).setRequestInitializer((HttpRequestInitializer)new CredentialHttpRetryInitializer()).setTokenServerUrl(new GenericUrl(tokenServerUrl)).build();
        return new AuthorizationCodeInstalledApp((AuthorizationCodeFlow)flow, (VerificationCodeReceiver)new GooglePromptReceiver()).authorize("user");
    }

    private static boolean hasApplicationDefaultCredentialsConfigured() {
        return System.getenv(CREDENTIAL_ENV_VAR) != null;
    }

    private static Credential getApplicationDefaultCredentials(List<String> scopes, HttpTransport transport, String tokenServerUrl) throws IOException, GeneralSecurityException {
        ((GoogleLogger.Api)logger.atFine()).log("getApplicationDefaultCredential(%s)", scopes);
        return GoogleCredentialWithRetry.fromGoogleCredential(GoogleCredential.getApplicationDefault((HttpTransport)transport, (JsonFactory)JSON_FACTORY).createScoped(scopes), tokenServerUrl);
    }

    private static PrivateKey privateKeyFromPkcs8(String privateKeyPem) throws IOException {
        StringReader reader = new StringReader(privateKeyPem.replace("\\n", System.lineSeparator()));
        PemReader.Section section = PemReader.readFirstSectionAndClose((Reader)reader, (String)"PRIVATE KEY");
        if (section == null) {
            throw new IOException("Invalid PKCS8 data.");
        }
        byte[] bytes = section.getBase64DecodedBytes();
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(bytes);
        try {
            KeyFactory keyFactory = SecurityUtils.getRsaKeyFactory();
            return keyFactory.generatePrivate(keySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException exception) {
            throw new IOException("Unexpected expcetion reading PKCS data", exception);
        }
    }

    public Credential getCredential(List<String> scopes) throws IOException, GeneralSecurityException {
        if (this.options.isServiceAccountEnabled()) {
            ((GoogleLogger.Api)logger.atFine()).log("Using service account credentials");
            if (this.shouldUseMetadataService()) {
                ((GoogleLogger.Api)logger.atFine()).log("Getting service account credentials from meta data service.");
                return CredentialFactory.getCredentialFromMetadataServiceAccount();
            }
            if (!Strings.isNullOrEmpty((String)this.options.getServiceAccountPrivateKeyId())) {
                ((GoogleLogger.Api)logger.atFine()).log("Attempting to get credentials from Configuration");
                Preconditions.checkState((!Strings.isNullOrEmpty((String)this.options.getServiceAccountPrivateKey()) ? 1 : 0) != 0, (Object)"privateKeyId must be set if using credentials configured directly in configuration");
                Preconditions.checkState((!Strings.isNullOrEmpty((String)this.options.getServiceAccountEmail()) ? 1 : 0) != 0, (Object)"clientEmail must be set if using credentials configured directly in configuration");
                Preconditions.checkArgument((boolean)Strings.isNullOrEmpty((String)this.options.getServiceAccountKeyFile()), (Object)"A P12 key file may not be specified at the same time as credentials via configuration.");
                Preconditions.checkArgument((boolean)Strings.isNullOrEmpty((String)this.options.getServiceAccountJsonKeyFile()), (Object)"A JSON key file may not be specified at the same time as credentials via configuration.");
                return CredentialFactory.getCredentialsFromSAParameters(this.options.getServiceAccountPrivateKeyId(), this.options.getServiceAccountPrivateKey(), this.options.getServiceAccountEmail(), scopes, this.getTransport(), this.options.getTokenServerUrl());
            }
            if (!Strings.isNullOrEmpty((String)this.options.getServiceAccountJsonKeyFile())) {
                ((GoogleLogger.Api)logger.atFine()).log("Using JSON keyfile %s", (Object)this.options.getServiceAccountJsonKeyFile());
                Preconditions.checkArgument((boolean)Strings.isNullOrEmpty((String)this.options.getServiceAccountKeyFile()), (Object)"A P12 key file may not be specified at the same time as a JSON key file.");
                Preconditions.checkArgument((boolean)Strings.isNullOrEmpty((String)this.options.getServiceAccountEmail()), (Object)"Service account email may not be specified at the same time as a JSON key file.");
                return CredentialFactory.getCredentialFromJsonKeyFile(this.options.getServiceAccountJsonKeyFile(), scopes, this.getTransport(), this.options.getTokenServerUrl());
            }
            if (!Strings.isNullOrEmpty((String)this.options.getServiceAccountKeyFile())) {
                Preconditions.checkState((!Strings.isNullOrEmpty((String)this.options.getServiceAccountEmail()) ? 1 : 0) != 0, (Object)"Email must be set if using service account auth and a key file is specified.");
                ((GoogleLogger.Api)logger.atFine()).log("Using service account email %s and private key file %s", (Object)this.options.getServiceAccountEmail(), (Object)this.options.getServiceAccountKeyFile());
                return CredentialFactory.getCredentialFromPrivateKeyServiceAccount(this.options.getServiceAccountEmail(), this.options.getServiceAccountKeyFile(), scopes, this.getTransport(), this.options.getTokenServerUrl());
            }
            if (CredentialFactory.shouldUseApplicationDefaultCredentials()) {
                ((GoogleLogger.Api)logger.atFine()).log("Getting Application Default Credentials");
                return CredentialFactory.getApplicationDefaultCredentials(scopes, this.getTransport(), this.options.getTokenServerUrl());
            }
        } else {
            if (this.options.getOAuthCredentialFile() != null && this.options.getClientId() != null && this.options.getClientSecret() != null) {
                ((GoogleLogger.Api)logger.atFine()).log("Using installed app credentials in file %s", (Object)this.options.getOAuthCredentialFile());
                return CredentialFactory.getCredentialFromFileCredentialStoreForInstalledApp(this.options.getClientId(), this.options.getClientSecret(), this.options.getOAuthCredentialFile(), scopes, this.getTransport(), this.options.getTokenServerUrl());
            }
            if (this.options.isNullCredentialEnabled()) {
                ((GoogleLogger.Api)logger.atWarning()).log("Allowing null credentials for unit testing. This should not be used in production");
                return null;
            }
        }
        ((GoogleLogger.Api)logger.atSevere()).log("Credential configuration is not valid. Configuration: %s", (Object)this);
        throw new IllegalStateException("No valid credential configuration discovered.");
    }

    private boolean shouldUseMetadataService() {
        return Strings.isNullOrEmpty((String)this.options.getServiceAccountKeyFile()) && Strings.isNullOrEmpty((String)this.options.getServiceAccountJsonKeyFile()) && Strings.isNullOrEmpty((String)this.options.getServiceAccountPrivateKey()) && !CredentialFactory.shouldUseApplicationDefaultCredentials();
    }

    private static boolean shouldUseApplicationDefaultCredentials() {
        return CredentialFactory.hasApplicationDefaultCredentialsConfigured();
    }

    private HttpTransport getTransport() throws IOException {
        if (this.transport == null) {
            this.transport = HttpTransportFactory.createHttpTransport(this.options.getTransportType(), this.options.getProxyAddress(), this.options.getProxyUsername(), this.options.getProxyPassword());
        }
        return this.transport;
    }

    @VisibleForTesting
    void setTransport(HttpTransport transport) {
        this.transport = transport;
    }

    public static class ComputeCredentialWithRetry
    extends ComputeCredential {
        public ComputeCredentialWithRetry(ComputeCredential.Builder builder) {
            super(builder);
        }

        protected TokenResponse executeRefreshToken() throws IOException {
            HttpRequest request = this.getTransport().createRequestFactory(this.getRequestInitializer()).buildGetRequest(new GenericUrl(this.getTokenServerEncodedUrl())).setParser((ObjectParser)new JsonObjectParser(this.getJsonFactory()));
            request.getHeaders().set("Metadata-Flavor", (Object)"Google");
            return (TokenResponse)request.execute().parseAs(TokenResponse.class);
        }
    }

    public static class GoogleCredentialWithRetry
    extends GoogleCredential {
        private static final int DEFAULT_TOKEN_EXPIRATION_SECONDS = 3600;

        static GoogleCredentialWithRetry fromGoogleCredential(GoogleCredential credential, String tokenServerUrl) {
            GoogleCredential.Builder builder = new GoogleCredential.Builder().setServiceAccountPrivateKey(credential.getServiceAccountPrivateKey()).setServiceAccountPrivateKeyId(credential.getServiceAccountPrivateKeyId()).setServiceAccountId(credential.getServiceAccountId()).setServiceAccountUser(credential.getServiceAccountUser()).setServiceAccountScopes(credential.getServiceAccountScopes()).setTokenServerEncodedUrl(credential.getTokenServerEncodedUrl()).setTransport(credential.getTransport()).setClientAuthentication(credential.getClientAuthentication()).setJsonFactory(credential.getJsonFactory()).setClock(credential.getClock()).setRequestInitializer((HttpRequestInitializer)new CredentialHttpRetryInitializer());
            GoogleCredentialWithRetry withRetry = new GoogleCredentialWithRetry(builder, tokenServerUrl);
            if (credential.getRefreshToken() != null) {
                withRetry.setRefreshToken(credential.getRefreshToken());
            }
            return withRetry;
        }

        GoogleCredentialWithRetry(GoogleCredential.Builder builder, String tokenServerUrl) {
            super(builder.setTokenServerEncodedUrl(tokenServerUrl));
        }

        protected TokenResponse executeRefreshToken() throws IOException {
            if (this.getServiceAccountPrivateKey() == null) {
                return super.executeRefreshToken();
            }
            JsonWebSignature.Header header = new JsonWebSignature.Header().setAlgorithm("RS256").setType("JWT").setKeyId(this.getServiceAccountPrivateKeyId());
            long currentTime = this.getClock().currentTimeMillis();
            JsonWebToken.Payload payload = new JsonWebToken.Payload().setIssuer(this.getServiceAccountId()).setAudience((Object)this.getTokenServerEncodedUrl()).setIssuedAtTimeSeconds(Long.valueOf(currentTime / 1000L)).setExpirationTimeSeconds(Long.valueOf(currentTime / 1000L + 3600L)).setSubject(this.getServiceAccountUser());
            payload.put("scope", (Object)Joiner.on((char)' ').join((Iterable)this.getServiceAccountScopes()));
            try {
                String assertion = JsonWebSignature.signUsingRsaSha256((PrivateKey)this.getServiceAccountPrivateKey(), (JsonFactory)this.getJsonFactory(), (JsonWebSignature.Header)header, (JsonWebToken.Payload)payload);
                TokenRequest request = new TokenRequest(this.getTransport(), this.getJsonFactory(), new GenericUrl(this.getTokenServerEncodedUrl()), "urn:ietf:params:oauth:grant-type:jwt-bearer").setRequestInitializer(this.getRequestInitializer());
                request.put("assertion", (Object)assertion);
                return request.execute();
            }
            catch (GeneralSecurityException e) {
                throw new IOException("Failed to refresh token", e);
            }
        }
    }

    public static class CredentialHttpRetryInitializer
    implements HttpRequestInitializer {
        public void initialize(HttpRequest httpRequest) throws IOException {
            httpRequest.setIOExceptionHandler((HttpIOExceptionHandler)new HttpBackOffIOExceptionHandler((BackOff)new ExponentialBackOff()));
            httpRequest.setUnsuccessfulResponseHandler((HttpUnsuccessfulResponseHandler)new HttpBackOffUnsuccessfulResponseHandler((BackOff)new ExponentialBackOff()));
        }
    }
}

