/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.api.client.util.BackOff;
import com.google.api.client.util.Preconditions;
import java.io.IOException;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class RetryBoundedBackOff
implements BackOff {
    private int retriesAttempted = 0;
    private final int maxRetries;
    private BackOff backoff;

    public RetryBoundedBackOff(int maxRetries, BackOff backoff) {
        Preconditions.checkArgument((maxRetries >= 0 ? 1 : 0) != 0, (Object)"Maximum number of retries must not be less than 0.");
        this.backoff = backoff;
        this.maxRetries = maxRetries;
    }

    public void reset() throws IOException {
        this.backoff.reset();
        this.retriesAttempted = 0;
    }

    public long nextBackOffMillis() throws IOException {
        if (this.retriesAttempted >= this.maxRetries) {
            return -1L;
        }
        long next = this.backoff.nextBackOffMillis();
        if (next == -1L) {
            return -1L;
        }
        ++this.retriesAttempted;
        return next;
    }
}

