/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.github.stefanbirkner.systemlambda.SystemLambda;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.testing.http.MockHttpTransport;
import com.google.cloud.hadoop.util.CredentialFactory;
import com.google.cloud.hadoop.util.HadoopConfigurationProperty;
import com.google.cloud.hadoop.util.HadoopCredentialConfiguration;
import com.google.cloud.hadoop.util.HttpTransportFactory;
import com.google.cloud.hadoop.util.testing.HadoopConfigurationUtils;
import com.google.cloud.hadoop.util.testing.MockHttpTransportHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import com.google.common.truth.Truth;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class HadoopCredentialConfigurationTest {
    private static final Map<String, Object> expectedDefaultConfiguration = new HashMap<String, Object>(){
        {
            this.put(".auth.access.token.provider.impl", null);
            this.put(".auth.null.enable", false);
            this.put(".auth.service.account.email", null);
            this.put(".service.account.auth.email", null);
            this.put(".auth.service.account.enable", true);
            this.put(".enable.service.account.auth", true);
            this.put(".auth.service.account.json.keyfile", null);
            this.put(".auth.service.account.keyfile", null);
            this.put(".service.account.auth.keyfile", null);
            this.put(".auth.service.account.private.key", null);
            this.put(".auth.service.account.private.key.id", null);
            this.put(".token.server.url", "https://oauth2.googleapis.com/token");
            this.put(".http.transport.type", HttpTransportFactory.HttpTransportType.JAVA_NET);
            this.put(".proxy.address", null);
            this.put(".proxy.password", null);
            this.put(".proxy.username", null);
            this.put(".auth.impersonation.service.account", null);
            this.put(".auth.impersonation.service.account.for.user.", ImmutableMap.of());
            this.put(".auth.impersonation.service.account.for.group.", ImmutableMap.of());
        }
    };
    private static final ImmutableList<String> TEST_SCOPES = ImmutableList.of((Object)"scope1", (Object)"scope2");
    private Configuration configuration;

    private static String getConfigKey(HadoopConfigurationProperty<?> suffixProperty) {
        return "google.cloud" + suffixProperty.getKey();
    }

    @Before
    public void setUp() {
        this.configuration = new Configuration();
    }

    private CredentialFactory getCredentialFactory() {
        CredentialFactory credentialFactory = HadoopCredentialConfiguration.getCredentialFactory((Configuration)this.configuration, (String[])new String[0]);
        credentialFactory.setTransport((HttpTransport)new MockHttpTransport());
        return credentialFactory;
    }

    @Test
    public void nullCredentialsAreCreatedForTesting() throws Exception {
        this.configuration.setBoolean(HadoopCredentialConfigurationTest.getConfigKey(HadoopCredentialConfiguration.ENABLE_SERVICE_ACCOUNTS_SUFFIX), false);
        this.configuration.setBoolean(HadoopCredentialConfigurationTest.getConfigKey(HadoopCredentialConfiguration.ENABLE_NULL_CREDENTIAL_SUFFIX), true);
        CredentialFactory credentialFactory = this.getCredentialFactory();
        Truth.assertThat((Object)credentialFactory.getCredential(TEST_SCOPES)).isNull();
    }

    @Test
    public void exceptionIsThrownForNoServiceAccountEmail() {
        this.configuration.set(HadoopCredentialConfigurationTest.getConfigKey(HadoopCredentialConfiguration.SERVICE_ACCOUNT_KEYFILE_SUFFIX), "aFile");
        IllegalArgumentException thrown = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, this::getCredentialFactory);
        Truth.assertThat((Throwable)thrown).hasMessageThat().isEqualTo((Object)"Email must be set if using service account auth and a key file is specified.");
    }

    @Test
    public void exceptionIsThrownForNoCredentialOptions() {
        this.configuration.setBoolean(HadoopCredentialConfigurationTest.getConfigKey(HadoopCredentialConfiguration.ENABLE_SERVICE_ACCOUNTS_SUFFIX), false);
        IllegalArgumentException thrown = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, this::getCredentialFactory);
        Truth.assertThat((Throwable)thrown).hasMessageThat().startsWith("No valid credential configuration discovered:");
    }

    @Test
    public void metadataServiceIsUsedByDefault() throws Exception {
        TokenResponse token = new TokenResponse().setAccessToken("metadata-test-token");
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)token)});
        CredentialFactory.setStaticHttpTransport((HttpTransport)transport);
        CredentialFactory credentialFactory = this.getCredentialFactory();
        Credential credential = credentialFactory.getCredential(TEST_SCOPES);
        Truth.assertThat((String)credential.getAccessToken()).isEqualTo((Object)"metadata-test-token");
    }

    @Test
    public void applicationDefaultServiceAccountWhenConfigured() throws Exception {
        CredentialFactory credentialFactory = this.getCredentialFactory();
        CredentialFactory.GoogleCredentialWithRetry credential = (CredentialFactory.GoogleCredentialWithRetry)SystemLambda.withEnvironmentVariable((String)"GOOGLE_APPLICATION_CREDENTIALS", (String)HadoopCredentialConfigurationTest.getStringPath("test-credential.json")).execute(() -> credentialFactory.getCredential(TEST_SCOPES));
        Truth.assertThat((String)credential.getServiceAccountId()).isEqualTo((Object)"test-email@gserviceaccount.com");
        Truth.assertThat((String)credential.getServiceAccountPrivateKeyId()).isEqualTo((Object)"test-key-id");
    }

    @Test
    public void p12KeyFileUsedWhenConfigured() throws Exception {
        this.configuration.set(HadoopCredentialConfigurationTest.getConfigKey(HadoopCredentialConfiguration.SERVICE_ACCOUNT_EMAIL_SUFFIX), "foo@example.com");
        this.configuration.set(HadoopCredentialConfigurationTest.getConfigKey(HadoopCredentialConfiguration.SERVICE_ACCOUNT_KEYFILE_SUFFIX), HadoopCredentialConfigurationTest.getStringPath("test-key.p12"));
        CredentialFactory credentialFactory = this.getCredentialFactory();
        CredentialFactory.GoogleCredentialWithRetry credential = (CredentialFactory.GoogleCredentialWithRetry)credentialFactory.getCredential(TEST_SCOPES);
        Truth.assertThat((String)credential.getServiceAccountId()).isEqualTo((Object)"foo@example.com");
    }

    @Test
    public void jsonKeyFileUsedWhenConfigured() throws Exception {
        this.configuration.set(HadoopCredentialConfigurationTest.getConfigKey(HadoopCredentialConfiguration.SERVICE_ACCOUNT_JSON_KEYFILE_SUFFIX), HadoopCredentialConfigurationTest.getStringPath("test-credential.json"));
        CredentialFactory credentialFactory = this.getCredentialFactory();
        CredentialFactory.GoogleCredentialWithRetry credential = (CredentialFactory.GoogleCredentialWithRetry)credentialFactory.getCredential(TEST_SCOPES);
        Truth.assertThat((String)credential.getServiceAccountId()).isEqualTo((Object)"test-email@gserviceaccount.com");
        Truth.assertThat((String)credential.getServiceAccountPrivateKeyId()).isEqualTo((Object)"test-key-id");
    }

    @Test
    public void configurationSAUsedWhenConfigured() throws Exception {
        this.configuration.set(HadoopCredentialConfigurationTest.getConfigKey(HadoopCredentialConfiguration.SERVICE_ACCOUNT_EMAIL_SUFFIX), "foo@example.com");
        this.configuration.set(HadoopCredentialConfigurationTest.getConfigKey(HadoopCredentialConfiguration.SERVICE_ACCOUNT_PRIVATE_KEY_ID_SUFFIX), "privatekey");
        this.configuration.set(HadoopCredentialConfigurationTest.getConfigKey(HadoopCredentialConfiguration.SERVICE_ACCOUNT_PRIVATE_KEY_SUFFIX), Resources.toString((URL)HadoopCredentialConfigurationTest.getPath("test-key.txt").toUri().toURL(), (Charset)StandardCharsets.UTF_8));
        CredentialFactory credentialFactory = this.getCredentialFactory();
        CredentialFactory.GoogleCredentialWithRetry credential = (CredentialFactory.GoogleCredentialWithRetry)credentialFactory.getCredential(TEST_SCOPES);
        Truth.assertThat((String)credential.getServiceAccountId()).isEqualTo((Object)"foo@example.com");
        Truth.assertThat((String)credential.getServiceAccountPrivateKeyId()).isEqualTo((Object)"privatekey");
    }

    @Test
    public void customTokenServerUrl() throws Exception {
        this.configuration.set(HadoopCredentialConfigurationTest.getConfigKey(HadoopCredentialConfiguration.SERVICE_ACCOUNT_JSON_KEYFILE_SUFFIX), HadoopCredentialConfigurationTest.getStringPath("test-credential.json"));
        this.configuration.set(HadoopCredentialConfigurationTest.getConfigKey(HadoopCredentialConfiguration.TOKEN_SERVER_URL_SUFFIX), "https://test.oauth.com/token");
        CredentialFactory credentialFactory = this.getCredentialFactory();
        CredentialFactory.GoogleCredentialWithRetry credential = (CredentialFactory.GoogleCredentialWithRetry)credentialFactory.getCredential(TEST_SCOPES);
        Truth.assertThat((String)credential.getTokenServerEncodedUrl()).isEqualTo((Object)"https://test.oauth.com/token");
    }

    @Test
    public void defaultPropertiesValues() {
        Truth.assertThat((Map)HadoopConfigurationUtils.getDefaultProperties(HadoopCredentialConfiguration.class)).containsExactlyEntriesIn(expectedDefaultConfiguration);
    }

    private static String getStringPath(String resource) throws Exception {
        return HadoopCredentialConfigurationTest.getPath(resource).toString();
    }

    private static Path getPath(String resource) throws Exception {
        String filePath = Resources.getResource((String)resource).getFile();
        return Paths.get(System.getProperty("os.name").toLowerCase().contains("win") && filePath.startsWith("/") ? filePath.substring(1) : filePath, new String[0]);
    }
}

