/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.cloud.hadoop.util.HadoopConfigurationProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import org.apache.hadoop.conf.Configuration;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class HadoopConfigurationPropertyTest {
    @Test
    public void testPropertyCreation_withNullDeprecationKey() {
        HadoopConfigurationProperty newKeyWithoutDeprecatedKey = new HadoopConfigurationProperty("actual.key", (Object)0, (String[])null);
        Truth.assertThat((Integer)((Integer)newKeyWithoutDeprecatedKey.getDefault())).isEqualTo((Object)0);
    }

    @Test
    public void getStringCollection_throwsExceptionOnNonCollectionProperty() {
        Configuration config = new Configuration();
        HadoopConfigurationProperty stringKey = new HadoopConfigurationProperty("actual.key", (Object)"default-string", new String[0]);
        HadoopConfigurationProperty integerKey = new HadoopConfigurationProperty("actual.key", (Object)1, new String[0]);
        HadoopConfigurationProperty collectionKey = new HadoopConfigurationProperty("collection.key", (Object)ImmutableList.of((Object)"key1", (Object)"key2"), new String[0]);
        Assert.assertThrows(IllegalStateException.class, () -> stringKey.getStringCollection(config));
        Assert.assertThrows(IllegalStateException.class, () -> integerKey.getStringCollection(config));
        Truth.assertThat((Iterable)collectionKey.getStringCollection(config)).containsExactly(new Object[]{"key1", "key2"}).inOrder();
    }
}

