/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.util.Clock;
import com.google.cloud.hadoop.util.AccessTokenProvider;
import com.google.cloud.hadoop.util.CredentialFromAccessTokenProviderClassFactory;
import com.google.cloud.hadoop.util.HadoopCredentialConfiguration;
import com.google.cloud.hadoop.util.testing.TestingAccessTokenProvider;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnit4.class)
public class CredentialFromAccessTokenProviderClassFactoryTest {
    private static final String TEST_PROPERTY_PREFIX = "test.prefix";
    private Configuration config;
    @Mock
    private Clock clock;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.config = new Configuration();
        this.config.setClass(TEST_PROPERTY_PREFIX + HadoopCredentialConfiguration.ACCESS_TOKEN_PROVIDER_IMPL_SUFFIX.getKey(), TestingAccessTokenProvider.class, AccessTokenProvider.class);
    }

    @Test
    public void testCreateCredentialFromProviderClassFactory() throws IOException, GeneralSecurityException {
        Credential credential = CredentialFromAccessTokenProviderClassFactory.credential((Configuration)this.config, (List)ImmutableList.of((Object)TEST_PROPERTY_PREFIX), (Collection)ImmutableList.of());
        Truth.assertThat((String)credential.getAccessToken()).isEqualTo((Object)"invalid-access-token");
        Truth.assertThat((Long)credential.getExpirationTimeMilliseconds()).isEqualTo((Object)TestingAccessTokenProvider.EXPIRATION_TIME_MILLISECONDS);
    }

    @Test
    public void testCreateCredentialFromAccessTokenProvider() {
        TestingAccessTokenProvider accessTokenProvider = new TestingAccessTokenProvider();
        GoogleCredential credential = CredentialFromAccessTokenProviderClassFactory.GoogleCredentialWithAccessTokenProvider.fromAccessTokenProvider((Clock)this.clock, (AccessTokenProvider)accessTokenProvider);
        Truth.assertThat((String)credential.getAccessToken()).isEqualTo((Object)"invalid-access-token");
        Truth.assertThat((Long)credential.getExpirationTimeMilliseconds()).isEqualTo((Object)TestingAccessTokenProvider.EXPIRATION_TIME_MILLISECONDS);
    }
}

