/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.cloud.hadoop.util.ConfigurationUtil;
import com.google.cloud.hadoop.util.HadoopConfigurationProperty;
import com.google.common.collect.Lists;
import com.google.common.truth.Truth;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ConfigurationUtilTest {
    private static final HadoopConfigurationProperty<String> PROPERTY_ONE = new HadoopConfigurationProperty("test-key");
    private static final String VALUE_ONE = "test-value";
    private static final HadoopConfigurationProperty<String> PROPERTY_TWO = new HadoopConfigurationProperty("test-key2");
    private static final String VALUE_TWO = "test-value2";

    @Test
    public void testSingleStringGetMandatoryConfig() throws IOException {
        Configuration config = new Configuration();
        Assert.assertThrows(IOException.class, () -> ConfigurationUtil.getMandatoryConfig((Configuration)config, PROPERTY_ONE));
        config.set(PROPERTY_ONE.getKey(), "");
        Assert.assertThrows(IOException.class, () -> ConfigurationUtil.getMandatoryConfig((Configuration)config, PROPERTY_ONE));
        config.set(PROPERTY_ONE.getKey(), VALUE_ONE);
        Truth.assertThat((String)ConfigurationUtil.getMandatoryConfig((Configuration)config, PROPERTY_ONE)).isEqualTo((Object)VALUE_ONE);
    }

    @Test
    public void testListGetMandatoryConfig() throws IOException {
        Configuration config = new Configuration();
        config.set(PROPERTY_ONE.getKey(), VALUE_ONE);
        Assert.assertThrows(IOException.class, () -> ConfigurationUtil.getMandatoryConfig((Configuration)config, (List)Lists.newArrayList((Object[])new HadoopConfigurationProperty[]{PROPERTY_ONE, PROPERTY_TWO})));
        config.set(PROPERTY_TWO.getKey(), "");
        Assert.assertThrows(IOException.class, () -> ConfigurationUtil.getMandatoryConfig((Configuration)config, (List)Lists.newArrayList((Object[])new HadoopConfigurationProperty[]{PROPERTY_ONE, PROPERTY_TWO})));
        config.set(PROPERTY_TWO.getKey(), VALUE_TWO);
        HashMap<String, String> expectedMap = new HashMap<String, String>();
        expectedMap.put(PROPERTY_ONE.getKey(), VALUE_ONE);
        expectedMap.put(PROPERTY_TWO.getKey(), VALUE_TWO);
        Truth.assertThat((Map)ConfigurationUtil.getMandatoryConfig((Configuration)config, (List)Lists.newArrayList((Object[])new HadoopConfigurationProperty[]{PROPERTY_ONE, PROPERTY_TWO}))).isEqualTo(expectedMap);
    }
}

