/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flogger.backend.system;

import com.google.common.flogger.backend.LoggerBackend;
import com.google.common.flogger.backend.Platform;
import com.google.common.flogger.backend.Tags;
import com.google.common.flogger.backend.slf4j.Slf4jBackendFactory;
import com.google.common.flogger.backend.system.BackendFactory;
import com.google.common.flogger.backend.system.Clock;
import com.google.common.flogger.backend.system.EmptyLoggingContext;
import com.google.common.flogger.backend.system.LoggingContext;
import com.google.common.flogger.backend.system.StackBasedCallerFinder;
import com.google.common.flogger.backend.system.SystemClock;
import com.google.common.flogger.util.StaticMethodCaller;
import java.util.logging.Level;

public class DefaultPlatform
extends Platform {
    private static final String BACKEND_FACTORY = "flogger.backend_factory";
    private static final String LOGGING_CONTEXT = "flogger.logging_context";
    private static final String CLOCK = "flogger.clock";
    private final BackendFactory backendFactory;
    private final LoggingContext context;
    private final Clock clock;
    private final Platform.LogCallerFinder callerFinder;

    public DefaultPlatform() {
        BackendFactory factory = (BackendFactory)StaticMethodCaller.callGetterFromSystemProperty((String)BACKEND_FACTORY, BackendFactory.class);
        this.backendFactory = factory != null ? factory : Slf4jBackendFactory.getInstance();
        LoggingContext context = (LoggingContext)StaticMethodCaller.callGetterFromSystemProperty((String)LOGGING_CONTEXT, LoggingContext.class);
        this.context = context != null ? context : EmptyLoggingContext.getInstance();
        Clock clock = (Clock)StaticMethodCaller.callGetterFromSystemProperty((String)CLOCK, Clock.class);
        this.clock = clock != null ? clock : SystemClock.getInstance();
        this.callerFinder = StackBasedCallerFinder.getInstance();
    }

    DefaultPlatform(BackendFactory factory, LoggingContext context, Clock clock, Platform.LogCallerFinder callerFinder) {
        this.backendFactory = factory;
        this.context = context;
        this.clock = clock;
        this.callerFinder = callerFinder;
    }

    protected Platform.LogCallerFinder getCallerFinderImpl() {
        return this.callerFinder;
    }

    protected LoggerBackend getBackendImpl(String className) {
        return this.backendFactory.create(className);
    }

    protected boolean shouldForceLoggingImpl(String loggerName, Level level, boolean isEnabled) {
        return this.context.shouldForceLogging(loggerName, level, isEnabled);
    }

    protected Tags getInjectedTagsImpl() {
        return this.context.getTags();
    }

    protected long getCurrentTimeNanosImpl() {
        return this.clock.getCurrentTimeNanos();
    }

    protected String getConfigInfoImpl() {
        return "Platform: " + ((Object)((Object)this)).getClass().getName() + "\nBackendFactory: " + this.backendFactory + "\nClock: " + this.clock + "\nLoggingContext: " + this.context + "\nLogCallerFinder: " + this.callerFinder + "\n";
    }
}

