/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.core.BetaApi;
import com.google.api.gax.paging.Page;
import com.google.cloud.Policy;
import com.google.cloud.ReadChannel;
import com.google.cloud.WriteChannel;
import com.google.cloud.hadoop.gcsio.StorageClientProvider;
import com.google.cloud.storage.Acl;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.BlobWriteSession;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.BucketInfo;
import com.google.cloud.storage.CopyWriter;
import com.google.cloud.storage.HmacKey;
import com.google.cloud.storage.Notification;
import com.google.cloud.storage.NotificationInfo;
import com.google.cloud.storage.PostPolicyV4;
import com.google.cloud.storage.ServiceAccount;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageBatch;
import com.google.cloud.storage.StorageOptions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class StorageClientWrapper
implements Storage {
    private final Storage storage;
    private final StorageClientProvider storageClientProvider;

    public StorageClientWrapper(Storage storage, StorageClientProvider storageClientProvider) {
        this.storage = storage;
        this.storageClientProvider = storageClientProvider;
    }

    Storage getStorage() {
        return this.storage;
    }

    public void close() {
        this.storageClientProvider.close(this);
    }

    public Bucket create(BucketInfo bucketInfo, Storage.BucketTargetOption ... options) {
        return this.storage.create(bucketInfo, options);
    }

    public Blob create(BlobInfo blobInfo, Storage.BlobTargetOption ... options) {
        return this.storage.create(blobInfo, options);
    }

    public Blob create(BlobInfo blobInfo, byte[] content, Storage.BlobTargetOption ... options) {
        return this.storage.create(blobInfo, content, options);
    }

    public Blob create(BlobInfo blobInfo, byte[] content, int offset, int length, Storage.BlobTargetOption ... options) {
        return this.storage.create(blobInfo, content, offset, length, options);
    }

    @Deprecated
    public Blob create(BlobInfo blobInfo, InputStream content, Storage.BlobWriteOption ... options) {
        return this.storage.create(blobInfo, content, options);
    }

    public Blob createFrom(BlobInfo blobInfo, Path path, Storage.BlobWriteOption ... options) throws IOException {
        return this.storage.createFrom(blobInfo, path, options);
    }

    public Blob createFrom(BlobInfo blobInfo, Path path, int bufferSize, Storage.BlobWriteOption ... options) throws IOException {
        return this.storage.createFrom(blobInfo, path, bufferSize, options);
    }

    public Blob createFrom(BlobInfo blobInfo, InputStream content, Storage.BlobWriteOption ... options) throws IOException {
        return this.storage.createFrom(blobInfo, content, options);
    }

    public Blob createFrom(BlobInfo blobInfo, InputStream content, int bufferSize, Storage.BlobWriteOption ... options) throws IOException {
        return this.storage.createFrom(blobInfo, content, bufferSize, options);
    }

    public Bucket get(String bucket, Storage.BucketGetOption ... options) {
        return this.storage.get(bucket, options);
    }

    public Bucket lockRetentionPolicy(BucketInfo bucketInfo, Storage.BucketTargetOption ... options) {
        return this.storage.lockRetentionPolicy(bucketInfo, options);
    }

    public Blob get(String bucket, String blob, Storage.BlobGetOption ... options) {
        return this.storage.get(bucket, blob, options);
    }

    public Blob get(BlobId blobId, Storage.BlobGetOption ... options) {
        return this.storage.get(blobId, options);
    }

    public Blob get(BlobId blobId) {
        return this.storage.get(blobId);
    }

    public Blob restore(BlobId blobId, Storage.BlobRestoreOption ... options) {
        return this.storage.restore(blobId, options);
    }

    public Page<Bucket> list(Storage.BucketListOption ... options) {
        return this.storage.list(options);
    }

    public Page<Blob> list(String bucket, Storage.BlobListOption ... options) {
        return this.storage.list(bucket, options);
    }

    public Bucket update(BucketInfo bucketInfo, Storage.BucketTargetOption ... options) {
        return this.storage.update(bucketInfo, options);
    }

    public Blob update(BlobInfo blobInfo, Storage.BlobTargetOption ... options) {
        return this.storage.update(blobInfo, options);
    }

    public Blob update(BlobInfo blobInfo) {
        return this.storage.update(blobInfo);
    }

    public boolean delete(String bucket, Storage.BucketSourceOption ... options) {
        return this.storage.delete(bucket, options);
    }

    public boolean delete(String bucket, String blob, Storage.BlobSourceOption ... options) {
        return this.storage.delete(bucket, blob, options);
    }

    public boolean delete(BlobId blobId, Storage.BlobSourceOption ... options) {
        return this.storage.delete(blobId, options);
    }

    public boolean delete(BlobId blobId) {
        return this.storage.delete(blobId);
    }

    public Blob compose(Storage.ComposeRequest composeRequest) {
        return this.storage.compose(composeRequest);
    }

    public CopyWriter copy(Storage.CopyRequest copyRequest) {
        return this.storage.copy(copyRequest);
    }

    public byte[] readAllBytes(String bucket, String blob, Storage.BlobSourceOption ... options) {
        return this.storage.readAllBytes(bucket, blob, options);
    }

    public byte[] readAllBytes(BlobId blob, Storage.BlobSourceOption ... options) {
        return this.storage.readAllBytes(blob, options);
    }

    public StorageBatch batch() {
        return this.storage.batch();
    }

    public ReadChannel reader(String bucket, String blob, Storage.BlobSourceOption ... options) {
        return this.storage.reader(bucket, blob, options);
    }

    public ReadChannel reader(BlobId blob, Storage.BlobSourceOption ... options) {
        return this.storage.reader(blob, options);
    }

    public void downloadTo(BlobId blob, Path path, Storage.BlobSourceOption ... options) {
        this.storage.downloadTo(blob, path, options);
    }

    public void downloadTo(BlobId blob, OutputStream outputStream, Storage.BlobSourceOption ... options) {
        this.storage.downloadTo(blob, outputStream, options);
    }

    public WriteChannel writer(BlobInfo blobInfo, Storage.BlobWriteOption ... options) {
        return this.storage.writer(blobInfo, options);
    }

    public WriteChannel writer(URL signedUrl) {
        return this.storage.writer(signedUrl);
    }

    public URL signUrl(BlobInfo blobInfo, long duration, TimeUnit unit, Storage.SignUrlOption ... options) {
        return this.storage.signUrl(blobInfo, duration, unit, options);
    }

    public PostPolicyV4 generateSignedPostPolicyV4(BlobInfo blobInfo, long duration, TimeUnit unit, PostPolicyV4.PostFieldsV4 fields, PostPolicyV4.PostConditionsV4 conditions, Storage.PostPolicyV4Option ... options) {
        return this.storage.generateSignedPostPolicyV4(blobInfo, duration, unit, fields, conditions, options);
    }

    public PostPolicyV4 generateSignedPostPolicyV4(BlobInfo blobInfo, long duration, TimeUnit unit, PostPolicyV4.PostFieldsV4 fields, Storage.PostPolicyV4Option ... options) {
        return this.storage.generateSignedPostPolicyV4(blobInfo, duration, unit, fields, options);
    }

    public PostPolicyV4 generateSignedPostPolicyV4(BlobInfo blobInfo, long duration, TimeUnit unit, PostPolicyV4.PostConditionsV4 conditions, Storage.PostPolicyV4Option ... options) {
        return this.storage.generateSignedPostPolicyV4(blobInfo, duration, unit, conditions, options);
    }

    public PostPolicyV4 generateSignedPostPolicyV4(BlobInfo blobInfo, long duration, TimeUnit unit, Storage.PostPolicyV4Option ... options) {
        return this.storage.generateSignedPostPolicyV4(blobInfo, duration, unit, options);
    }

    public List<Blob> get(BlobId ... blobIds) {
        return this.storage.get(blobIds);
    }

    public List<Blob> get(Iterable<BlobId> blobIds) {
        return this.storage.get(blobIds);
    }

    public List<Blob> update(BlobInfo ... blobInfos) {
        return this.storage.update(blobInfos);
    }

    public List<Blob> update(Iterable<BlobInfo> blobInfos) {
        return this.storage.update(blobInfos);
    }

    public List<Boolean> delete(BlobId ... blobIds) {
        return this.storage.delete(blobIds);
    }

    public List<Boolean> delete(Iterable<BlobId> blobIds) {
        return this.storage.delete(blobIds);
    }

    public Acl getAcl(String bucket, Acl.Entity entity, Storage.BucketSourceOption ... options) {
        return this.storage.getAcl(bucket, entity, options);
    }

    public Acl getAcl(String bucket, Acl.Entity entity) {
        return this.storage.getAcl(bucket, entity);
    }

    public boolean deleteAcl(String bucket, Acl.Entity entity, Storage.BucketSourceOption ... options) {
        return this.storage.deleteAcl(bucket, entity, options);
    }

    public boolean deleteAcl(String bucket, Acl.Entity entity) {
        return this.storage.deleteAcl(bucket, entity);
    }

    public Acl createAcl(String bucket, Acl acl, Storage.BucketSourceOption ... options) {
        return this.storage.createAcl(bucket, acl, options);
    }

    public Acl createAcl(String bucket, Acl acl) {
        return this.storage.createAcl(bucket, acl);
    }

    public Acl updateAcl(String bucket, Acl acl, Storage.BucketSourceOption ... options) {
        return this.storage.updateAcl(bucket, acl, options);
    }

    public Acl updateAcl(String bucket, Acl acl) {
        return this.storage.updateAcl(bucket, acl);
    }

    public List<Acl> listAcls(String bucket, Storage.BucketSourceOption ... options) {
        return this.storage.listAcls(bucket, options);
    }

    public List<Acl> listAcls(String bucket) {
        return this.storage.listAcls(bucket);
    }

    public Acl getDefaultAcl(String bucket, Acl.Entity entity) {
        return this.storage.getDefaultAcl(bucket, entity);
    }

    public boolean deleteDefaultAcl(String bucket, Acl.Entity entity) {
        return this.storage.deleteDefaultAcl(bucket, entity);
    }

    public Acl createDefaultAcl(String bucket, Acl acl) {
        return this.storage.createDefaultAcl(bucket, acl);
    }

    public Acl updateDefaultAcl(String bucket, Acl acl) {
        return this.storage.updateDefaultAcl(bucket, acl);
    }

    public List<Acl> listDefaultAcls(String bucket) {
        return this.storage.listDefaultAcls(bucket);
    }

    public Acl getAcl(BlobId blob, Acl.Entity entity) {
        return this.storage.getAcl(blob, entity);
    }

    public boolean deleteAcl(BlobId blob, Acl.Entity entity) {
        return this.storage.deleteAcl(blob, entity);
    }

    public Acl createAcl(BlobId blob, Acl acl) {
        return this.storage.createAcl(blob, acl);
    }

    public Acl updateAcl(BlobId blob, Acl acl) {
        return this.storage.updateAcl(blob, acl);
    }

    public List<Acl> listAcls(BlobId blob) {
        return this.storage.listAcls(blob);
    }

    public HmacKey createHmacKey(ServiceAccount serviceAccount, Storage.CreateHmacKeyOption ... options) {
        return this.storage.createHmacKey(serviceAccount, options);
    }

    public Page<HmacKey.HmacKeyMetadata> listHmacKeys(Storage.ListHmacKeysOption ... options) {
        return this.storage.listHmacKeys(options);
    }

    public HmacKey.HmacKeyMetadata getHmacKey(String accessId, Storage.GetHmacKeyOption ... options) {
        return this.storage.getHmacKey(accessId, options);
    }

    public void deleteHmacKey(HmacKey.HmacKeyMetadata metadata, Storage.DeleteHmacKeyOption ... options) {
        this.storage.deleteHmacKey(metadata, options);
    }

    public HmacKey.HmacKeyMetadata updateHmacKeyState(HmacKey.HmacKeyMetadata metadata, HmacKey.HmacKeyState state, Storage.UpdateHmacKeyOption ... options) {
        return this.storage.updateHmacKeyState(metadata, state, options);
    }

    public Policy getIamPolicy(String bucket, Storage.BucketSourceOption ... options) {
        return this.storage.getIamPolicy(bucket, options);
    }

    public Policy setIamPolicy(String bucket, Policy policy, Storage.BucketSourceOption ... options) {
        return this.storage.setIamPolicy(bucket, policy, options);
    }

    public List<Boolean> testIamPermissions(String bucket, List<String> permissions, Storage.BucketSourceOption ... options) {
        return this.storage.testIamPermissions(bucket, permissions, options);
    }

    public ServiceAccount getServiceAccount(String projectId) {
        return this.storage.getServiceAccount(projectId);
    }

    public Notification createNotification(String bucket, NotificationInfo notificationInfo) {
        return this.storage.createNotification(bucket, notificationInfo);
    }

    public Notification getNotification(String bucket, String notificationId) {
        return this.storage.getNotification(bucket, notificationId);
    }

    public List<Notification> listNotifications(String bucket) {
        return this.storage.listNotifications(bucket);
    }

    public boolean deleteNotification(String bucket, String notificationId) {
        return this.storage.deleteNotification(bucket, notificationId);
    }

    @BetaApi
    public BlobWriteSession blobWriteSession(BlobInfo blobInfo, Storage.BlobWriteOption ... options) {
        return this.storage.blobWriteSession(blobInfo, options);
    }

    public Blob moveBlob(Storage.MoveBlobRequest request) {
        return this.storage.moveBlob(request);
    }

    public StorageOptions getOptions() {
        return (StorageOptions)this.storage.getOptions();
    }
}

