/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.auto.value.AutoValue;
import com.google.cloud.hadoop.gcsio.AutoValue_GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.util.AsyncWriteChannelOptions;
import com.google.cloud.hadoop.util.RedactedString;
import com.google.cloud.hadoop.util.RequesterPaysOptions;
import com.google.cloud.hadoop.util.RetryHttpInitializerOptions;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.time.Duration;
import java.util.Map;
import javax.annotation.Nullable;

@AutoValue
public abstract class GoogleCloudStorageOptions {
    public static final GoogleCloudStorageOptions DEFAULT = GoogleCloudStorageOptions.builder().build();

    public static Builder builder() {
        return new AutoValue_GoogleCloudStorageOptions.Builder().setAutoRepairImplicitDirectoriesEnabled(true).setBatchThreads(15).setCopyWithRewriteEnabled(true).setDirectPathPreferred(true).setGrpcEnabled(false).setGrpcMessageTimeoutCheckInterval(Duration.ofSeconds(1L)).setHttpRequestConnectTimeout(Duration.ofSeconds(5L)).setHttpRequestHeaders((Map<String, String>)ImmutableMap.of()).setHttpRequestReadTimeout(Duration.ofSeconds(5L)).setMaxHttpRequestRetries(10).setMaxListItemsPerCall(5000).setMaxRequestsPerBatch(15).setMaxRewriteChunkSize(0x20000000L).setMaxWaitTimeForEmptyObjectCreation(Duration.ofSeconds(3L)).setMetricsSink(MetricsSink.NONE).setReadChannelOptions(GoogleCloudStorageReadOptions.DEFAULT).setRequesterPaysOptions(RequesterPaysOptions.DEFAULT).setStorageRootUrl("https://storage.googleapis.com/").setStorageServicePath("storage/v1/").setTraceLogEnabled(false).setOperationTraceLogEnabled(false).setTrafficDirectorEnabled(true).setWriteChannelOptions(AsyncWriteChannelOptions.DEFAULT).setHnBucketRenameEnabled(false).setGrpcWriteEnabled(false).setMoveOperationEnabled(true).setStorageClientCachingEnabled(false);
    }

    public abstract Builder toBuilder();

    public abstract boolean isStorageClientCachingEnabled();

    public abstract boolean isGrpcEnabled();

    public abstract boolean isHnBucketRenameEnabled();

    public abstract boolean isTrafficDirectorEnabled();

    public abstract boolean isDirectPathPreferred();

    public abstract String getStorageRootUrl();

    public abstract String getStorageServicePath();

    public abstract boolean isGrpcWriteEnabled();

    @Nullable
    public abstract String getProjectId();

    @Nullable
    public abstract String getAppName();

    public abstract boolean isAutoRepairImplicitDirectoriesEnabled();

    public abstract Duration getMaxWaitTimeForEmptyObjectCreation();

    public abstract int getMaxListItemsPerCall();

    public abstract int getMaxRequestsPerBatch();

    public abstract int getBatchThreads();

    public abstract int getMaxHttpRequestRetries();

    public abstract Duration getHttpRequestConnectTimeout();

    public abstract Duration getHttpRequestReadTimeout();

    @Nullable
    public abstract String getProxyAddress();

    @Nullable
    public abstract RedactedString getProxyUsername();

    @Nullable
    public abstract RedactedString getProxyPassword();

    public abstract boolean isCopyWithRewriteEnabled();

    public abstract long getMaxRewriteChunkSize();

    public abstract GoogleCloudStorageReadOptions getReadChannelOptions();

    public abstract AsyncWriteChannelOptions getWriteChannelOptions();

    public abstract RequesterPaysOptions getRequesterPaysOptions();

    public abstract ImmutableMap<String, String> getHttpRequestHeaders();

    @Nullable
    public abstract String getEncryptionAlgorithm();

    @Nullable
    public abstract RedactedString getEncryptionKey();

    @Nullable
    public abstract RedactedString getEncryptionKeyHash();

    public abstract Duration getGrpcMessageTimeoutCheckInterval();

    public abstract MetricsSink getMetricsSink();

    public abstract boolean isTraceLogEnabled();

    public abstract boolean isOperationTraceLogEnabled();

    public abstract boolean isMoveOperationEnabled();

    public RetryHttpInitializerOptions toRetryHttpInitializerOptions() {
        return RetryHttpInitializerOptions.builder().setDefaultUserAgent(this.getAppName()).setHttpHeaders(this.getHttpRequestHeaders()).setMaxRequestRetries(this.getMaxHttpRequestRetries()).setConnectTimeout(this.getHttpRequestConnectTimeout()).setReadTimeout(this.getHttpRequestReadTimeout()).build();
    }

    public void throwIfNotValid() {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.getAppName()) ? 1 : 0) != 0, (Object)"appName must not be null or empty");
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setGrpcEnabled(boolean var1);

        public abstract Builder setTrafficDirectorEnabled(boolean var1);

        public abstract Builder setDirectPathPreferred(boolean var1);

        public abstract Builder setStorageRootUrl(String var1);

        public abstract Builder setStorageServicePath(String var1);

        public abstract Builder setProjectId(String var1);

        public abstract Builder setAppName(String var1);

        public abstract Builder setAutoRepairImplicitDirectoriesEnabled(boolean var1);

        public abstract Builder setMaxWaitTimeForEmptyObjectCreation(Duration var1);

        public abstract Builder setMaxListItemsPerCall(int var1);

        public abstract Builder setMaxRequestsPerBatch(int var1);

        public abstract Builder setBatchThreads(int var1);

        public abstract Builder setMaxHttpRequestRetries(int var1);

        public abstract Builder setHttpRequestConnectTimeout(Duration var1);

        public abstract Builder setHttpRequestReadTimeout(Duration var1);

        public abstract Builder setProxyAddress(String var1);

        public abstract Builder setProxyUsername(RedactedString var1);

        public abstract Builder setProxyPassword(RedactedString var1);

        public abstract Builder setCopyWithRewriteEnabled(boolean var1);

        public abstract Builder setMaxRewriteChunkSize(long var1);

        public abstract Builder setReadChannelOptions(GoogleCloudStorageReadOptions var1);

        public abstract Builder setWriteChannelOptions(AsyncWriteChannelOptions var1);

        public abstract Builder setRequesterPaysOptions(RequesterPaysOptions var1);

        public abstract Builder setHttpRequestHeaders(Map<String, String> var1);

        public abstract Builder setEncryptionAlgorithm(String var1);

        public abstract Builder setEncryptionKey(RedactedString var1);

        public abstract Builder setEncryptionKeyHash(RedactedString var1);

        public abstract Builder setGrpcMessageTimeoutCheckInterval(Duration var1);

        public abstract Builder setMetricsSink(MetricsSink var1);

        public abstract Builder setTraceLogEnabled(Boolean var1);

        public abstract Builder setOperationTraceLogEnabled(Boolean var1);

        public abstract Builder setHnBucketRenameEnabled(boolean var1);

        public abstract Builder setGrpcWriteEnabled(boolean var1);

        public abstract Builder setMoveOperationEnabled(boolean var1);

        public abstract Builder setStorageClientCachingEnabled(boolean var1);

        abstract GoogleCloudStorageOptions autoBuild();

        public GoogleCloudStorageOptions build() {
            GoogleCloudStorageOptions instance = this.autoBuild();
            Preconditions.checkArgument((instance.getMaxRewriteChunkSize() <= 0L || instance.getMaxRewriteChunkSize() % 0x100000L == 0L ? 1 : 0) != 0, (String)"maxRewriteChunkSize must be an integral multiple of 1 MiB (1048576), but was: %s", (long)instance.getMaxRewriteChunkSize());
            Preconditions.checkArgument((instance.getProxyAddress() != null || instance.getProxyUsername() == null && instance.getProxyPassword() == null ? 1 : 0) != 0, (Object)"if proxyAddress is null then proxyUsername and proxyPassword should be null too");
            Preconditions.checkArgument((instance.getProxyUsername() == null == (instance.getProxyPassword() == null) ? 1 : 0) != 0, (Object)"both proxyUsername and proxyPassword should be null or not null together");
            Preconditions.checkArgument((boolean)this.isAllEncryptionOptionsSetOrUnset(instance), (Object)"encryptionAlgorithm, encryptionKey and encryptionKeyHash should be null or not null together");
            return instance;
        }

        private boolean isAllEncryptionOptionsSetOrUnset(GoogleCloudStorageOptions instance) {
            return instance.getEncryptionAlgorithm() != null && instance.getEncryptionKey() != null && instance.getEncryptionKeyHash() != null || instance.getEncryptionAlgorithm() == null && instance.getEncryptionKey() == null && instance.getEncryptionKeyHash() == null;
        }
    }

    public static enum MetricsSink {
        NONE,
        CLOUD_MONITORING;

    }
}

