/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.ExponentialBackOff;
import com.google.api.gax.paging.Page;
import com.google.auth.Credentials;
import com.google.auto.value.AutoBuilder;
import com.google.cloud.hadoop.gcsio.AutoBuilder_GoogleCloudStorageClientImpl_Builder;
import com.google.cloud.hadoop.gcsio.BatchExecutor;
import com.google.cloud.hadoop.gcsio.CreateBucketOptions;
import com.google.cloud.hadoop.gcsio.CreateObjectOptions;
import com.google.cloud.hadoop.gcsio.ForwardingGoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageClientReadChannel;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageClientWriteChannel;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageExceptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageImpl;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.gcsio.StorageClientProvider;
import com.google.cloud.hadoop.gcsio.StorageClientWrapper;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.gcsio.StringPaths;
import com.google.cloud.hadoop.gcsio.UpdatableItemInfo;
import com.google.cloud.hadoop.gcsio.VerificationAttributes;
import com.google.cloud.hadoop.util.AccessBoundary;
import com.google.cloud.hadoop.util.AsyncWriteChannelOptions;
import com.google.cloud.hadoop.util.ErrorTypeExtractor;
import com.google.cloud.hadoop.util.GoogleCloudStorageEventBus;
import com.google.cloud.hadoop.util.GrpcErrorTypeExtractor;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.BlobWriteSessionConfig;
import com.google.cloud.storage.BlobWriteSessionConfigs;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.BucketInfo;
import com.google.cloud.storage.CopyWriter;
import com.google.cloud.storage.ParallelCompositeUploadBlobWriteSessionConfig;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageClass;
import com.google.cloud.storage.StorageException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.flogger.GoogleLogger;
import com.google.common.io.BaseEncoding;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.grpc.ClientInterceptor;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@VisibleForTesting
public class GoogleCloudStorageClientImpl
extends ForwardingGoogleCloudStorage {
    private static final String USER_AGENT = "user-agent";
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private static final int MAXIMUM_PRECONDITION_FAILURES_IN_DELETE = 4;
    private final GoogleCloudStorageOptions storageOptions;
    @VisibleForTesting
    final StorageClientWrapper storageWrapper;
    private static final StorageClientProvider storageClientProvider = new StorageClientProvider();
    private static final ErrorTypeExtractor errorExtractor = GrpcErrorTypeExtractor.INSTANCE;
    static final List<Storage.BlobField> BLOB_FIELDS = ImmutableList.of((Object)Storage.BlobField.BUCKET, (Object)Storage.BlobField.CONTENT_ENCODING, (Object)Storage.BlobField.CONTENT_TYPE, (Object)Storage.BlobField.CRC32C, (Object)Storage.BlobField.GENERATION, (Object)Storage.BlobField.METADATA, (Object)Storage.BlobField.MD5HASH, (Object)Storage.BlobField.METAGENERATION, (Object)Storage.BlobField.NAME, (Object)Storage.BlobField.SIZE, (Object)Storage.BlobField.TIME_CREATED, (Object)Storage.BlobField.UPDATED, (Object[])new Storage.BlobField[0]);
    private ExecutorService backgroundTasksThreadPool = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("gcsio-storage-client-write-channel-pool-%d").setDaemon(true).build());

    private static String encodeMetadataValues(byte[] bytes) {
        return bytes == null ? null : BaseEncoding.base64().encode(bytes);
    }

    GoogleCloudStorageClientImpl(GoogleCloudStorageOptions options, @Nullable Storage clientLibraryStorage, @Nullable Credentials credentials, @Nullable HttpTransport httpTransport, @Nullable HttpRequestInitializer httpRequestInitializer, @Nullable ImmutableList<ClientInterceptor> gRPCInterceptors, @Nullable Function<List<AccessBoundary>, String> downscopedAccessTokenFn, @Nullable ExecutorService pCUExecutorService) throws IOException {
        super(GoogleCloudStorageImpl.builder().setOptions(options).setCredentials(credentials).setHttpTransport(httpTransport).setHttpRequestInitializer(httpRequestInitializer).setDownscopedAccessTokenFn(downscopedAccessTokenFn).build());
        this.storageOptions = options;
        this.storageWrapper = clientLibraryStorage == null ? storageClientProvider.getStorage(credentials, this.storageOptions, (List<ClientInterceptor>)gRPCInterceptors, pCUExecutorService, downscopedAccessTokenFn) : new StorageClientWrapper(clientLibraryStorage, storageClientProvider);
    }

    @Override
    public WritableByteChannel create(StorageResourceId resourceId, CreateObjectOptions options) throws IOException {
        if (!this.storageOptions.isGrpcWriteEnabled()) {
            return super.create(resourceId, options);
        }
        ((GoogleLogger.Api)logger.atFiner()).log("create(%s)", (Object)resourceId);
        Preconditions.checkArgument((boolean)resourceId.isStorageObject(), (String)"Expected full StorageObject id, got %s", (Object)resourceId);
        StorageResourceId resourceIdWithGeneration = resourceId;
        if (!resourceId.hasGenerationId()) {
            resourceIdWithGeneration = new StorageResourceId(resourceId.getBucketName(), resourceId.getObjectName(), this.getWriteGeneration(resourceId, options.isOverwriteExisting()));
        }
        return new GoogleCloudStorageClientWriteChannel(this.storageWrapper.getStorage(), this.storageOptions, resourceIdWithGeneration, options);
    }

    @Override
    public void createBucket(String bucketName, CreateBucketOptions options) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("createBucket(%s)", (Object)bucketName);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)bucketName) ? 1 : 0) != 0, (Object)"bucketName must not be null or empty");
        Preconditions.checkNotNull((Object)options, (Object)"options must not be null");
        Preconditions.checkNotNull((Object)this.storageOptions.getProjectId(), (Object)"projectId must not be null");
        BucketInfo.Builder bucketInfoBuilder = BucketInfo.newBuilder((String)bucketName).setLocation(options.getLocation());
        if (options.getStorageClass() != null) {
            bucketInfoBuilder.setStorageClass(StorageClass.valueOfStrict((String)options.getStorageClass().toUpperCase()));
        }
        if (options.getTtl() != null) {
            bucketInfoBuilder.setLifecycleRules(Collections.singletonList(new BucketInfo.LifecycleRule((BucketInfo.LifecycleRule.LifecycleAction)BucketInfo.LifecycleRule.LifecycleAction.newDeleteAction(), BucketInfo.LifecycleRule.LifecycleCondition.newBuilder().setAge(Integer.valueOf(Math.toIntExact(options.getTtl().toDays()))).build())));
        }
        try {
            this.storageWrapper.create(bucketInfoBuilder.build(), new Storage.BucketTargetOption[0]);
        }
        catch (StorageException e) {
            GoogleCloudStorageEventBus.postOnException();
            if (errorExtractor.bucketAlreadyExists((Exception)((Object)e))) {
                throw (FileAlreadyExistsException)new FileAlreadyExistsException(String.format("Bucket '%s' already exists.", bucketName)).initCause(e);
            }
            throw new IOException(e);
        }
    }

    @Override
    public void createEmptyObject(StorageResourceId resourceId) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("createEmptyObject(%s)", (Object)resourceId);
        Preconditions.checkArgument((boolean)resourceId.isStorageObject(), (String)"Expected full StorageObject id, got %s", (Object)resourceId);
        this.createEmptyObject(resourceId, GoogleCloudStorageImpl.EMPTY_OBJECT_CREATE_OPTIONS);
    }

    @Override
    public void createEmptyObject(StorageResourceId resourceId, CreateObjectOptions options) throws IOException {
        Preconditions.checkArgument((boolean)resourceId.isStorageObject(), (String)"Expected full StorageObject id, got %s", (Object)resourceId);
        try {
            this.createEmptyObjectInternal(resourceId, options);
        }
        catch (StorageException e) {
            if (this.canIgnoreExceptionForEmptyObject(e, resourceId, options)) {
                ((GoogleLogger.Api)logger.atInfo()).log("Ignoring exception of type %s; verified object already exists with desired state.", (Object)((Object)((Object)e)).getClass().getSimpleName());
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withCause((Throwable)e)).log("Ignored exception while creating empty object");
            }
            if (errorExtractor.getErrorType((Exception)((Object)e)) == ErrorTypeExtractor.ErrorType.ALREADY_EXISTS) {
                GoogleCloudStorageEventBus.postOnException();
                throw (FileAlreadyExistsException)new FileAlreadyExistsException(String.format("Object '%s' already exists.", resourceId)).initCause(e);
            }
            throw new IOException(e);
        }
    }

    @Override
    public void createEmptyObjects(List<StorageResourceId> resourceIds) throws IOException {
        this.createEmptyObjects(resourceIds, GoogleCloudStorageImpl.EMPTY_OBJECT_CREATE_OPTIONS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createEmptyObjects(List<StorageResourceId> resourceIds, CreateObjectOptions options) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("createEmptyObjects(%s)", resourceIds);
        if (resourceIds.isEmpty()) {
            return;
        }
        if (resourceIds.size() == 1) {
            this.createEmptyObject((StorageResourceId)Iterables.getOnlyElement(resourceIds), options);
            return;
        }
        for (StorageResourceId resourceId : resourceIds) {
            Preconditions.checkArgument((boolean)resourceId.isStorageObject(), (String)"Expected full StorageObject names only, got: '%s'", (Object)resourceId);
        }
        Set innerExceptions = Sets.newConcurrentHashSet();
        BatchExecutor executor = new BatchExecutor(this.storageOptions.getBatchThreads());
        try {
            for (StorageResourceId resourceId : resourceIds) {
                executor.queue(() -> {
                    try {
                        this.createEmptyObjectInternal(resourceId, options);
                        ((GoogleLogger.Api)logger.atFiner()).log("Successfully inserted %s", (Object)resourceId);
                    }
                    catch (StorageException se) {
                        boolean canIgnoreException = false;
                        try {
                            canIgnoreException = this.canIgnoreExceptionForEmptyObject(se, resourceId, options);
                        }
                        catch (Exception e) {
                            innerExceptions.add(new IOException("Error re-fetching after rate-limit error: " + String.valueOf(resourceId), e));
                        }
                        if (canIgnoreException) {
                            ((GoogleLogger.Api)logger.atInfo()).log("Ignoring exception of type %s; verified object already exists with desired state.", (Object)((Object)((Object)se)).getClass().getSimpleName());
                            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withCause((Throwable)se)).log("Ignored exception while creating empty object");
                        } else {
                            innerExceptions.add(new IOException("Error inserting " + String.valueOf(resourceId), se));
                        }
                    }
                    catch (Exception e) {
                        innerExceptions.add(new IOException("Error inserting " + String.valueOf(resourceId), e));
                    }
                    return null;
                }, null);
            }
        }
        finally {
            executor.shutdown();
        }
        if (!innerExceptions.isEmpty()) {
            GoogleCloudStorageEventBus.postOnException();
            throw GoogleCloudStorageExceptions.createCompositeException(innerExceptions);
        }
    }

    private void createEmptyObjectInternal(StorageResourceId resourceId, CreateObjectOptions createObjectOptions) {
        Map<String, String> rewrittenMetadata = GoogleCloudStorageClientImpl.encodeMetadata(createObjectOptions.getMetadata());
        ArrayList<Storage.BlobTargetOption> blobTargetOptions = new ArrayList<Storage.BlobTargetOption>();
        blobTargetOptions.add(Storage.BlobTargetOption.disableGzipContent());
        if (resourceId.hasGenerationId()) {
            blobTargetOptions.add(Storage.BlobTargetOption.generationMatch((long)resourceId.getGenerationId()));
        } else if (resourceId.isDirectory() || !createObjectOptions.isOverwriteExisting()) {
            blobTargetOptions.add(Storage.BlobTargetOption.doesNotExist());
        }
        if (this.storageOptions.getEncryptionKey() != null) {
            blobTargetOptions.add(Storage.BlobTargetOption.encryptionKey((String)this.storageOptions.getEncryptionKey().value()));
        }
        this.storageWrapper.create(BlobInfo.newBuilder((BlobId)BlobId.of((String)resourceId.getBucketName(), (String)resourceId.getObjectName())).setMetadata(rewrittenMetadata).setContentEncoding(createObjectOptions.getContentEncoding()).setContentType(createObjectOptions.getContentType()).build(), (Storage.BlobTargetOption[])blobTargetOptions.toArray(Storage.BlobTargetOption[]::new));
    }

    private boolean canIgnoreExceptionForEmptyObject(StorageException exceptionOnCreate, StorageResourceId resourceId, CreateObjectOptions options) throws IOException {
        ErrorTypeExtractor.ErrorType errorType = errorExtractor.getErrorType((Exception)((Object)exceptionOnCreate));
        if (errorType == ErrorTypeExtractor.ErrorType.RESOURCE_EXHAUSTED || errorType == ErrorTypeExtractor.ErrorType.INTERNAL || resourceId.isDirectory() && errorType == ErrorTypeExtractor.ErrorType.FAILED_PRECONDITION) {
            GoogleCloudStorageItemInfo existingInfo;
            Duration maxWaitTime = this.storageOptions.getMaxWaitTimeForEmptyObjectCreation();
            BackOff backOff = !maxWaitTime.isZero() && !maxWaitTime.isNegative() ? new ExponentialBackOff.Builder().setMaxElapsedTimeMillis(Math.toIntExact(maxWaitTime.toMillis())).setMaxIntervalMillis(500).setInitialIntervalMillis(100).setMultiplier(1.5).setRandomizationFactor(0.15).build() : BackOff.STOP_BACKOFF;
            long nextSleep = 0L;
            do {
                if (nextSleep > 0L) {
                    try {
                        GoogleCloudStorageImpl.sleeper.sleep(nextSleep);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        nextSleep = -1L;
                    }
                }
                existingInfo = this.getItemInfo(resourceId);
                long l = nextSleep = nextSleep == -1L ? -1L : backOff.nextBackOffMillis();
            } while (!existingInfo.exists() && nextSleep != -1L);
            if (existingInfo.exists() && existingInfo.getSize() == 0L) {
                if (options.isEnsureEmptyObjectsMetadataMatch()) {
                    return existingInfo.metadataEquals((Map<String, byte[]>)options.getMetadata());
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void copy(String srcBucketName, List<String> srcObjectNames, String dstBucketName, List<String> dstObjectNames) throws IOException {
        Preconditions.checkArgument((srcObjectNames != null ? 1 : 0) != 0, (Object)"srcObjectNames must not be null");
        Preconditions.checkArgument((dstObjectNames != null ? 1 : 0) != 0, (Object)"dstObjectNames must not be null");
        Preconditions.checkArgument((srcObjectNames.size() == dstObjectNames.size() ? 1 : 0) != 0, (Object)"Must supply same number of elements in srcObjects and dstObjects");
        HashMap<StorageResourceId, StorageResourceId> sourceToDestinationObjectsMap = new HashMap<StorageResourceId, StorageResourceId>(srcObjectNames.size());
        for (int i = 0; i < srcObjectNames.size(); ++i) {
            sourceToDestinationObjectsMap.put(new StorageResourceId(srcBucketName, srcObjectNames.get(i)), new StorageResourceId(dstBucketName, dstObjectNames.get(i)));
        }
        this.copy(sourceToDestinationObjectsMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void move(Map<StorageResourceId, StorageResourceId> sourceToDestinationObjectsMap) throws IOException {
        GoogleCloudStorageImpl.validateMoveArguments(sourceToDestinationObjectsMap);
        if (sourceToDestinationObjectsMap.isEmpty()) {
            return;
        }
        ConcurrentHashMap.KeySetView<IOException, Boolean> innerExceptions = ConcurrentHashMap.newKeySet();
        BatchExecutor executor = new BatchExecutor(this.storageOptions.getBatchThreads());
        try {
            for (Map.Entry<StorageResourceId, StorageResourceId> entry : sourceToDestinationObjectsMap.entrySet()) {
                StorageResourceId srcObject = entry.getKey();
                StorageResourceId dstObject = entry.getValue();
                this.moveInternal(executor, innerExceptions, srcObject.getBucketName(), srcObject.getGenerationId(), srcObject.getObjectName(), dstObject.getGenerationId(), dstObject.getObjectName());
            }
        }
        finally {
            executor.shutdown();
        }
        if (!innerExceptions.isEmpty()) {
            GoogleCloudStorageEventBus.postOnException();
            throw GoogleCloudStorageExceptions.createCompositeException(innerExceptions);
        }
    }

    private void moveInternal(BatchExecutor executor, ConcurrentHashMap.KeySetView<IOException, Boolean> innerExceptions, String srcBucketName, long srcContentGeneration, String srcObjectName, long dstContentGeneration, String dstObjectName) {
        Storage.MoveBlobRequest.Builder moveRequestBuilder = this.createMoveRequestBuilder(srcBucketName, srcObjectName, dstObjectName, srcContentGeneration, dstContentGeneration);
        executor.queue(() -> {
            try {
                String srcString = StringPaths.fromComponents(srcBucketName, srcObjectName);
                String dstString = StringPaths.fromComponents(srcBucketName, dstObjectName);
                Blob movedBlob = this.storageWrapper.moveBlob(moveRequestBuilder.build());
                if (movedBlob != null) {
                    ((GoogleLogger.Api)logger.atFiner()).log("Successfully moved %s to %s", (Object)srcString, (Object)dstString);
                }
            }
            catch (StorageException e) {
                GoogleCloudStorageEventBus.postOnException();
                if (errorExtractor.getErrorType((Exception)((Object)e)) == ErrorTypeExtractor.ErrorType.NOT_FOUND) {
                    innerExceptions.add(GoogleCloudStorageExceptions.createFileNotFoundException(srcBucketName, srcObjectName, new IOException(e)));
                }
                innerExceptions.add(new IOException(String.format("Error moving '%s'", StringPaths.fromComponents(srcBucketName, srcObjectName)), e));
            }
            return null;
        }, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copy(Map<StorageResourceId, StorageResourceId> sourceToDestinationObjectsMap) throws IOException {
        GoogleCloudStorageImpl.validateCopyArguments(sourceToDestinationObjectsMap, this);
        if (sourceToDestinationObjectsMap.isEmpty()) {
            return;
        }
        ConcurrentHashMap.KeySetView<IOException, Boolean> innerExceptions = ConcurrentHashMap.newKeySet();
        BatchExecutor executor = new BatchExecutor(this.storageOptions.getBatchThreads());
        try {
            for (Map.Entry<StorageResourceId, StorageResourceId> entry : sourceToDestinationObjectsMap.entrySet()) {
                StorageResourceId srcObject = entry.getKey();
                StorageResourceId dstObject = entry.getValue();
                this.copyInternal(executor, innerExceptions, srcObject.getBucketName(), srcObject.getObjectName(), dstObject.getGenerationId(), dstObject.getBucketName(), dstObject.getObjectName());
            }
        }
        finally {
            executor.shutdown();
        }
        if (!innerExceptions.isEmpty()) {
            GoogleCloudStorageEventBus.postOnException();
            throw GoogleCloudStorageExceptions.createCompositeException(innerExceptions);
        }
    }

    private void copyInternal(BatchExecutor executor, ConcurrentHashMap.KeySetView<IOException, Boolean> innerExceptions, String srcBucketName, String srcObjectName, long dstContentGeneration, String dstBucketName, String dstObjectName) {
        Storage.CopyRequest.Builder copyRequestBuilder = Storage.CopyRequest.newBuilder().setSource(BlobId.of((String)srcBucketName, (String)srcObjectName));
        if (dstContentGeneration != -1L) {
            copyRequestBuilder.setTarget(BlobId.of((String)dstBucketName, (String)dstObjectName), new Storage.BlobTargetOption[]{Storage.BlobTargetOption.generationMatch((long)dstContentGeneration)});
        } else {
            copyRequestBuilder.setTarget(BlobId.of((String)dstBucketName, (String)dstObjectName));
        }
        if (this.storageOptions.getEncryptionKey() != null) {
            copyRequestBuilder.setSourceOptions(new Storage.BlobSourceOption[]{Storage.BlobSourceOption.decryptionKey((String)this.storageOptions.getEncryptionKey().value())});
            copyRequestBuilder.setTarget(copyRequestBuilder.build().getTarget().getBlobId(), new Storage.BlobTargetOption[]{Storage.BlobTargetOption.encryptionKey((String)this.storageOptions.getEncryptionKey().value())});
        }
        if (this.storageOptions.getMaxRewriteChunkSize() > 0L) {
            copyRequestBuilder.setMegabytesCopiedPerChunk(Long.valueOf(this.storageOptions.getMaxRewriteChunkSize() / 0x100000L));
        }
        executor.queue(() -> {
            try {
                String srcString = StringPaths.fromComponents(srcBucketName, srcObjectName);
                String dstString = StringPaths.fromComponents(dstBucketName, dstObjectName);
                CopyWriter copyWriter = this.storageWrapper.copy(copyRequestBuilder.build());
                while (!copyWriter.isDone()) {
                    copyWriter.copyChunk();
                    ((GoogleLogger.Api)logger.atFinest()).log("Copy (%s to %s) did not complete. Resuming...", (Object)srcString, (Object)dstString);
                }
                ((GoogleLogger.Api)logger.atFiner()).log("Successfully copied %s to %s", (Object)srcString, (Object)dstString);
            }
            catch (StorageException e) {
                GoogleCloudStorageEventBus.postOnException();
                if (errorExtractor.getErrorType((Exception)((Object)e)) == ErrorTypeExtractor.ErrorType.NOT_FOUND) {
                    innerExceptions.add(GoogleCloudStorageExceptions.createFileNotFoundException(srcBucketName, srcObjectName, new IOException(e)));
                }
                innerExceptions.add(new IOException(String.format("Error copying '%s'", StringPaths.fromComponents(srcBucketName, srcObjectName)), e));
            }
            return null;
        }, null);
    }

    @Override
    public List<String> listBucketNames() throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("listBucketNames()");
        List<Bucket> allBuckets = this.listBucketsInternal();
        ArrayList<String> bucketNames = new ArrayList<String>(allBuckets.size());
        for (Bucket bucket : allBuckets) {
            bucketNames.add(bucket.getName());
        }
        return bucketNames;
    }

    @Override
    public List<GoogleCloudStorageItemInfo> listBucketInfo() throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("listBucketInfo()");
        List<Bucket> allBuckets = this.listBucketsInternal();
        ArrayList<GoogleCloudStorageItemInfo> bucketInfos = new ArrayList<GoogleCloudStorageItemInfo>(allBuckets.size());
        for (Bucket bucket : allBuckets) {
            bucketInfos.add(GoogleCloudStorageClientImpl.createItemInfoForBucket(new StorageResourceId(bucket.getName()), bucket));
        }
        return bucketInfos;
    }

    private Storage.MoveBlobRequest.Builder createMoveRequestBuilder(String srcBucketName, String srcObjectName, String dstObjectName, long srcContentGeneration, long dstContentGeneration) {
        Storage.MoveBlobRequest.Builder moveRequestBuilder = Storage.MoveBlobRequest.newBuilder().setSource(BlobId.of((String)srcBucketName, (String)srcObjectName));
        moveRequestBuilder.setTarget(BlobId.of((String)srcBucketName, (String)dstObjectName));
        ArrayList<Storage.BlobTargetOption> blobTargetOptions = new ArrayList<Storage.BlobTargetOption>();
        ArrayList<Storage.BlobSourceOption> blobSourceOptions = new ArrayList<Storage.BlobSourceOption>();
        if (srcContentGeneration != -1L) {
            blobSourceOptions.add(Storage.BlobSourceOption.generationMatch((long)srcContentGeneration));
        }
        if (dstContentGeneration != -1L) {
            blobTargetOptions.add(Storage.BlobTargetOption.generationMatch((long)dstContentGeneration));
        }
        if (this.storageOptions.getEncryptionKey() != null) {
            blobSourceOptions.add(Storage.BlobSourceOption.decryptionKey((String)this.storageOptions.getEncryptionKey().value()));
            blobTargetOptions.add(Storage.BlobTargetOption.encryptionKey((String)this.storageOptions.getEncryptionKey().value()));
        }
        moveRequestBuilder.setSourceOptions(blobSourceOptions);
        moveRequestBuilder.setTargetOptions(blobTargetOptions);
        return moveRequestBuilder;
    }

    private List<Bucket> listBucketsInternal() throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("listBucketsInternal()");
        Preconditions.checkNotNull((Object)this.storageOptions.getProjectId(), (Object)"projectId must not be null");
        ArrayList<Bucket> allBuckets = new ArrayList<Bucket>();
        try {
            Page<Bucket> buckets = this.storageWrapper.list(Storage.BucketListOption.pageSize((long)this.storageOptions.getMaxListItemsPerCall()), Storage.BucketListOption.fields((Storage.BucketField[])new Storage.BucketField[]{Storage.BucketField.LOCATION, Storage.BucketField.STORAGE_CLASS, Storage.BucketField.TIME_CREATED, Storage.BucketField.UPDATED}));
            for (Bucket bucket : buckets.iterateAll()) {
                allBuckets.add(bucket);
            }
        }
        catch (StorageException e) {
            GoogleCloudStorageEventBus.postOnException();
            throw new IOException(e);
        }
        return allBuckets;
    }

    private static GoogleCloudStorageItemInfo createItemInfoForBucket(StorageResourceId resourceId, Bucket bucket) {
        Preconditions.checkArgument((resourceId != null ? 1 : 0) != 0, (Object)"resourceId must not be null");
        Preconditions.checkArgument((bucket != null ? 1 : 0) != 0, (Object)"bucket must not be null");
        Preconditions.checkArgument((boolean)resourceId.isBucket(), (String)"resourceId must be a Bucket. resourceId: %s", (Object)resourceId);
        Preconditions.checkArgument((boolean)resourceId.getBucketName().equals(bucket.getName()), (String)"resourceId.getBucketName() must equal bucket.getName(): '%s' vs '%s'", (Object)resourceId.getBucketName(), (Object)bucket.getName());
        return GoogleCloudStorageItemInfo.createBucket(resourceId, bucket.asBucketInfo().getCreateTimeOffsetDateTime().toInstant().toEpochMilli(), bucket.asBucketInfo().getUpdateTimeOffsetDateTime().toInstant().toEpochMilli(), bucket.getLocation(), bucket.getStorageClass() == null ? null : bucket.getStorageClass().name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteObjects(List<StorageResourceId> fullObjectNames) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("deleteObjects(%s)", fullObjectNames);
        if (fullObjectNames.isEmpty()) {
            return;
        }
        for (StorageResourceId fullObjectName : fullObjectNames) {
            Preconditions.checkArgument((boolean)fullObjectName.isStorageObject(), (String)"Expected full StorageObject names only, got: %s", (Object)fullObjectName);
        }
        ConcurrentHashMap.KeySetView<IOException, Boolean> innerExceptions = ConcurrentHashMap.newKeySet();
        BatchExecutor executor = new BatchExecutor(this.storageOptions.getBatchThreads());
        try {
            for (StorageResourceId object : fullObjectNames) {
                this.queueSingleObjectDelete(object, innerExceptions, executor, 0);
            }
        }
        finally {
            executor.shutdown();
        }
        if (!innerExceptions.isEmpty()) {
            GoogleCloudStorageEventBus.postOnException();
            throw GoogleCloudStorageExceptions.createCompositeException(innerExceptions);
        }
    }

    private void queueSingleObjectDelete(final StorageResourceId resourceId, final ConcurrentHashMap.KeySetView<IOException, Boolean> innerExceptions, final BatchExecutor batchExecutor, final int attempt) {
        final String bucketName = resourceId.getBucketName();
        final String objectName = resourceId.getObjectName();
        if (resourceId.hasGenerationId()) {
            batchExecutor.queue(() -> this.storageWrapper.delete(BlobId.of((String)bucketName, (String)objectName), Storage.BlobSourceOption.generationMatch((long)resourceId.getGenerationId())), this.getObjectDeletionCallback(resourceId, innerExceptions, batchExecutor, attempt, resourceId.getGenerationId()));
        } else {
            batchExecutor.queue(() -> this.storageWrapper.get(BlobId.of((String)bucketName, (String)objectName), Storage.BlobGetOption.fields((Storage.BlobField[])new Storage.BlobField[]{Storage.BlobField.GENERATION})), new FutureCallback<Blob>(){

                public void onSuccess(Blob blob) {
                    if (blob == null) {
                        ((GoogleLogger.Api)logger.atFiner()).log("deleteObjects(%s): get not found.", (Object)resourceId);
                        return;
                    }
                    long generation = (Long)Preconditions.checkNotNull((Object)blob.getGeneration(), (Object)"generation can not be null");
                    batchExecutor.queue(() -> GoogleCloudStorageClientImpl.this.storageWrapper.delete(BlobId.of((String)bucketName, (String)objectName), Storage.BlobSourceOption.generationMatch((long)generation)), GoogleCloudStorageClientImpl.this.getObjectDeletionCallback(resourceId, innerExceptions, batchExecutor, attempt, generation));
                }

                public void onFailure(Throwable throwable) {
                    GoogleCloudStorageEventBus.postOnException();
                    innerExceptions.add(new IOException(String.format("Error deleting %s, stage 1", resourceId), throwable));
                }
            });
        }
    }

    private FutureCallback<Boolean> getObjectDeletionCallback(final StorageResourceId resourceId, final ConcurrentHashMap.KeySetView<IOException, Boolean> innerExceptions, final BatchExecutor batchExecutor, final int attempt, final long generation) {
        return new FutureCallback<Boolean>(){

            public void onSuccess(Boolean result) {
                if (!result.booleanValue()) {
                    ((GoogleLogger.Api)logger.atFiner()).log("Delete object %s not found.", (Object)resourceId);
                } else {
                    ((GoogleLogger.Api)logger.atFiner()).log("Successfully deleted %s at generation %s", (Object)resourceId, generation);
                }
            }

            public void onFailure(Throwable throwable) {
                if (throwable instanceof Exception && errorExtractor.getErrorType((Exception)throwable) == ErrorTypeExtractor.ErrorType.FAILED_PRECONDITION && attempt <= 4) {
                    ((GoogleLogger.Api)logger.atInfo()).log("Precondition not met while deleting '%s' at generation %s. Attempt %s. Retrying:%s", (Object)resourceId, (Object)generation, (Object)attempt, (Object)throwable);
                    GoogleCloudStorageClientImpl.this.queueSingleObjectDelete(resourceId, innerExceptions, batchExecutor, attempt + 1);
                } else {
                    GoogleCloudStorageEventBus.postOnException();
                    innerExceptions.add(new IOException(String.format("Error deleting '%s', stage 2 with generation %s", resourceId, generation), throwable));
                }
            }
        };
    }

    @Override
    public void deleteBuckets(List<String> bucketNames) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("deleteBuckets(%s)", bucketNames);
        for (String bucketName : bucketNames) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)bucketName) ? 1 : 0) != 0, (Object)"bucketName must not be null or empty");
        }
        ArrayList<IOException> innerExceptions = new ArrayList<IOException>();
        for (String bucketName : bucketNames) {
            try {
                boolean isDeleted = this.storageWrapper.delete(bucketName, new Storage.BucketSourceOption[0]);
                if (isDeleted) continue;
                innerExceptions.add(GoogleCloudStorageExceptions.createFileNotFoundException(bucketName, null, null));
            }
            catch (StorageException e) {
                GoogleCloudStorageEventBus.postOnException();
                innerExceptions.add(new IOException(String.format("Error deleting '%s' bucket", bucketName), e));
            }
        }
        if (!innerExceptions.isEmpty()) {
            throw GoogleCloudStorageExceptions.createCompositeException(innerExceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<GoogleCloudStorageItemInfo> getItemInfos(List<StorageResourceId> resourceIds) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("getItemInfos(%s)", resourceIds);
        if (resourceIds.isEmpty()) {
            return new ArrayList<GoogleCloudStorageItemInfo>();
        }
        ConcurrentHashMap<StorageResourceId, GoogleCloudStorageItemInfo> itemInfos = new ConcurrentHashMap<StorageResourceId, GoogleCloudStorageItemInfo>(resourceIds.size());
        Set innerExceptions = Sets.newConcurrentHashSet();
        BatchExecutor executor = new BatchExecutor(this.storageOptions.getBatchThreads());
        try {
            for (StorageResourceId resourceId : resourceIds) {
                if (resourceId.isRoot()) {
                    itemInfos.put(resourceId, GoogleCloudStorageItemInfo.ROOT_INFO);
                    continue;
                }
                if (resourceId.isBucket()) {
                    executor.queue(() -> this.getBucket(resourceId.getBucketName()), this.getBucketCallback(resourceId, innerExceptions, itemInfos));
                    continue;
                }
                if (!resourceId.isStorageObject()) continue;
                executor.queue(() -> this.getBlob(resourceId), this.getBlobCallback(resourceId, innerExceptions, itemInfos));
            }
        }
        finally {
            executor.shutdown();
        }
        if (!innerExceptions.isEmpty()) {
            GoogleCloudStorageEventBus.postOnException();
            throw GoogleCloudStorageExceptions.createCompositeException(innerExceptions);
        }
        ArrayList<GoogleCloudStorageItemInfo> sortedItemInfos = new ArrayList<GoogleCloudStorageItemInfo>();
        for (StorageResourceId resourceId : resourceIds) {
            Preconditions.checkState((boolean)itemInfos.containsKey(resourceId), (String)"Somehow missing resourceId '%s' from map: %s", (Object)resourceId, itemInfos);
            sortedItemInfos.add((GoogleCloudStorageItemInfo)itemInfos.get(resourceId));
        }
        Preconditions.checkState((sortedItemInfos.size() == resourceIds.size() ? 1 : 0) != 0, (String)"sortedItemInfos.size() (%s) != resourceIds.size() (%s). infos: %s, ids: %s", (Object)sortedItemInfos.size(), (Object)resourceIds.size(), sortedItemInfos, resourceIds);
        return sortedItemInfos;
    }

    private FutureCallback<Bucket> getBucketCallback(final StorageResourceId resourceId, final Set<IOException> innerExceptions, final Map<StorageResourceId, GoogleCloudStorageItemInfo> itemInfos) {
        return new FutureCallback<Bucket>(){

            public void onSuccess(@Nullable Bucket bucket) {
                if (bucket != null) {
                    ((GoogleLogger.Api)logger.atFiner()).log("getItemInfos: Successfully fetched bucket: %s for resourceId: %s", (Object)bucket, (Object)resourceId);
                    itemInfos.put(resourceId, GoogleCloudStorageClientImpl.createItemInfoForBucket(resourceId, bucket));
                } else {
                    ((GoogleLogger.Api)logger.atFiner()).log("getItemInfos: bucket '%s' not found", (Object)resourceId.getBucketName());
                    itemInfos.put(resourceId, GoogleCloudStorageItemInfo.createNotFound(resourceId));
                }
            }

            public void onFailure(Throwable throwable) {
                GoogleCloudStorageEventBus.postOnException();
                innerExceptions.add(new IOException(String.format("Error getting %s bucket", resourceId.getBucketName()), throwable));
            }
        };
    }

    private FutureCallback<Blob> getBlobCallback(final StorageResourceId resourceId, final Set<IOException> innerExceptions, final Map<StorageResourceId, GoogleCloudStorageItemInfo> itemInfos) {
        return new FutureCallback<Blob>(){

            public void onSuccess(@Nullable Blob blob) {
                if (blob != null) {
                    ((GoogleLogger.Api)logger.atFiner()).log("getItemInfos: Successfully fetched object '%s' for resourceId '%s'", (Object)blob, (Object)resourceId);
                    itemInfos.put(resourceId, GoogleCloudStorageClientImpl.createItemInfoForBlob(resourceId, blob));
                } else {
                    ((GoogleLogger.Api)logger.atFiner()).log("getItemInfos: object '%s' not found", (Object)resourceId);
                    itemInfos.put(resourceId, GoogleCloudStorageItemInfo.createNotFound(resourceId));
                }
            }

            public void onFailure(Throwable throwable) {
                GoogleCloudStorageEventBus.postOnException();
                innerExceptions.add(new IOException(String.format("Error getting %s object", resourceId), throwable));
            }
        };
    }

    @Override
    public GoogleCloudStorageItemInfo getItemInfo(StorageResourceId resourceId) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("getItemInfo(%s)", (Object)resourceId);
        if (resourceId.isRoot()) {
            return GoogleCloudStorageItemInfo.ROOT_INFO;
        }
        GoogleCloudStorageItemInfo itemInfo = null;
        if (resourceId.isBucket()) {
            Bucket bucket = this.getBucket(resourceId.getBucketName());
            if (bucket != null) {
                itemInfo = GoogleCloudStorageClientImpl.createItemInfoForBucket(resourceId, bucket);
            } else {
                ((GoogleLogger.Api)logger.atFiner()).log("getBucket(%s): not found", (Object)resourceId.getBucketName());
            }
        } else {
            Blob blob = this.getBlob(resourceId);
            if (blob != null) {
                itemInfo = GoogleCloudStorageClientImpl.createItemInfoForBlob(resourceId, blob);
            } else {
                ((GoogleLogger.Api)logger.atFiner()).log("getObject(%s): not found", (Object)resourceId);
            }
        }
        if (itemInfo == null) {
            itemInfo = GoogleCloudStorageItemInfo.createNotFound(resourceId);
        }
        ((GoogleLogger.Api)logger.atFiner()).log("getItemInfo: %s", (Object)itemInfo);
        return itemInfo;
    }

    @Nullable
    private Bucket getBucket(String bucketName) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("getBucket(%s)", (Object)bucketName);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)bucketName) ? 1 : 0) != 0, (Object)"bucketName must not be null or empty");
        try {
            return this.storageWrapper.get(bucketName, new Storage.BucketGetOption[0]);
        }
        catch (StorageException e) {
            GoogleCloudStorageEventBus.postOnException();
            if (errorExtractor.getErrorType((Exception)((Object)e)) == ErrorTypeExtractor.ErrorType.NOT_FOUND) {
                return null;
            }
            throw new IOException("Error accessing Bucket " + bucketName, e);
        }
    }

    @Nullable
    Blob getBlob(StorageResourceId resourceId) throws IOException {
        Blob blob;
        Preconditions.checkArgument((boolean)resourceId.isStorageObject(), (String)"Expected full StorageObject id, got %s", (Object)resourceId);
        String bucketName = resourceId.getBucketName();
        String objectName = resourceId.getObjectName();
        try {
            blob = this.storageWrapper.get(BlobId.of((String)bucketName, (String)objectName), Storage.BlobGetOption.fields((Storage.BlobField[])BLOB_FIELDS.toArray(new Storage.BlobField[0])));
        }
        catch (StorageException e) {
            GoogleCloudStorageEventBus.postOnException();
            throw new IOException("Error accessing " + String.valueOf(resourceId), e);
        }
        return blob;
    }

    @Override
    public SeekableByteChannel open(StorageResourceId resourceId, GoogleCloudStorageReadOptions readOptions) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("open(%s, %s)", (Object)resourceId, (Object)readOptions);
        return this.open(resourceId, null, readOptions);
    }

    @Override
    public SeekableByteChannel open(GoogleCloudStorageItemInfo itemInfo, GoogleCloudStorageReadOptions readOptions) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("open(%s, %s)", (Object)itemInfo, (Object)readOptions);
        Preconditions.checkNotNull((Object)itemInfo, (Object)"itemInfo should not be null");
        StorageResourceId resourceId = itemInfo.getResourceId();
        Preconditions.checkArgument((boolean)resourceId.isStorageObject(), (String)"Expected full StorageObject id, got %s", (Object)resourceId);
        return this.open(resourceId, itemInfo, readOptions);
    }

    private SeekableByteChannel open(StorageResourceId resourceId, GoogleCloudStorageItemInfo itemInfo, GoogleCloudStorageReadOptions readOptions) throws IOException {
        return new GoogleCloudStorageClientReadChannel(this.storageWrapper.getStorage(), itemInfo == null ? this.getItemInfo(resourceId) : itemInfo, readOptions, errorExtractor, this.storageOptions);
    }

    @Override
    public void close() {
        try {
            try {
                this.storageWrapper.close();
            }
            catch (Exception e) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause((Throwable)e)).log("Error occurred while closing the storage client");
            }
            try {
                super.close();
            }
            finally {
                this.backgroundTasksThreadPool.shutdown();
            }
        }
        finally {
            this.backgroundTasksThreadPool = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<GoogleCloudStorageItemInfo> updateItems(List<UpdatableItemInfo> itemInfoList) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("updateItems(%s)", itemInfoList);
        if (itemInfoList.isEmpty()) {
            return new ArrayList<GoogleCloudStorageItemInfo>();
        }
        for (UpdatableItemInfo itemInfo : itemInfoList) {
            Preconditions.checkArgument((!itemInfo.getStorageResourceId().isBucket() && !itemInfo.getStorageResourceId().isRoot() ? 1 : 0) != 0, (Object)"Buckets and GCS Root resources are not supported for updateItems");
        }
        final ConcurrentHashMap resultItemInfos = new ConcurrentHashMap();
        final Set innerExceptions = Sets.newConcurrentHashSet();
        BatchExecutor executor = new BatchExecutor(this.storageOptions.getBatchThreads());
        try {
            for (UpdatableItemInfo itemInfo : itemInfoList) {
                final StorageResourceId resourceId = itemInfo.getStorageResourceId();
                String bucketName = resourceId.getBucketName();
                String blobName = resourceId.getObjectName();
                Map<String, byte[]> originalMetadata = itemInfo.getMetadata();
                Map<String, String> rewrittenMetadata = GoogleCloudStorageClientImpl.encodeMetadata(originalMetadata);
                BlobInfo blobUpdate = BlobInfo.newBuilder((String)bucketName, (String)blobName).setMetadata(rewrittenMetadata).build();
                executor.queue(() -> this.storageWrapper.update(blobUpdate), new FutureCallback<Blob>(){

                    public void onSuccess(Blob blob) {
                        if (blob == null) {
                            ((GoogleLogger.Api)logger.atFiner()).log("updateItems: object not found %s", (Object)resourceId);
                            resultItemInfos.put(resourceId, GoogleCloudStorageItemInfo.createNotFound(resourceId));
                        } else {
                            ((GoogleLogger.Api)logger.atFiner()).log("updateItems: Successfully updated object '%s' for resourceId '%s'", (Object)blob, (Object)resourceId);
                            resultItemInfos.put(resourceId, GoogleCloudStorageClientImpl.createItemInfoForBlob(resourceId, blob));
                        }
                    }

                    public void onFailure(Throwable throwable) {
                        GoogleCloudStorageEventBus.postOnException();
                        innerExceptions.add(new IOException(String.format("Error updating '%s' object", resourceId), throwable));
                    }
                });
            }
        }
        finally {
            executor.shutdown();
        }
        if (!innerExceptions.isEmpty()) {
            GoogleCloudStorageEventBus.postOnException();
            throw GoogleCloudStorageExceptions.createCompositeException(innerExceptions);
        }
        ArrayList<GoogleCloudStorageItemInfo> sortedItemInfos = new ArrayList<GoogleCloudStorageItemInfo>();
        for (UpdatableItemInfo itemInfo : itemInfoList) {
            Preconditions.checkState((boolean)resultItemInfos.containsKey(itemInfo.getStorageResourceId()), (String)"Missing resourceId '%s' from map: %s", (Object)itemInfo.getStorageResourceId(), resultItemInfos);
            sortedItemInfos.add((GoogleCloudStorageItemInfo)resultItemInfos.get(itemInfo.getStorageResourceId()));
        }
        Preconditions.checkState((sortedItemInfos.size() == itemInfoList.size() ? 1 : 0) != 0, (String)"sortedItemInfos.size() (%s) != resourceIds.size() (%s). infos: %s, updateItemInfos: %s", (Object)sortedItemInfos.size(), (Object)itemInfoList.size(), sortedItemInfos, itemInfoList);
        return sortedItemInfos;
    }

    private static Map<String, String> encodeMetadata(Map<String, byte[]> metadata) {
        return Maps.transformValues(metadata, GoogleCloudStorageClientImpl::encodeMetadataValues);
    }

    @Override
    public void compose(String bucketName, List<String> sources, String destination, String contentType) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("compose(%s, %s, %s, %s)", (Object)bucketName, sources, (Object)destination, (Object)contentType);
        List<StorageResourceId> sourceIds = sources.stream().map(objectName -> new StorageResourceId(bucketName, (String)objectName)).collect(Collectors.toList());
        StorageResourceId destinationId = new StorageResourceId(bucketName, destination);
        CreateObjectOptions options = CreateObjectOptions.DEFAULT_OVERWRITE.toBuilder().setContentType(contentType).setEnsureEmptyObjectsMetadataMatch(false).build();
        this.composeObjects(sourceIds, destinationId, options);
    }

    @Override
    public GoogleCloudStorageItemInfo composeObjects(List<StorageResourceId> sources, StorageResourceId destination, CreateObjectOptions options) throws IOException {
        Blob composedBlob;
        ((GoogleLogger.Api)logger.atFiner()).log("composeObjects(%s, %s, %s)", sources, (Object)destination, (Object)options);
        for (StorageResourceId inputId : sources) {
            if (destination.getBucketName().equals(inputId.getBucketName())) continue;
            GoogleCloudStorageEventBus.postOnException();
            throw new IOException(String.format("Bucket doesn't match for source '%s' and destination '%s'!", inputId, destination));
        }
        Storage.ComposeRequest request = Storage.ComposeRequest.newBuilder().addSource((Iterable)sources.stream().map(StorageResourceId::getObjectName).collect(Collectors.toList())).setTarget(BlobInfo.newBuilder((String)destination.getBucketName(), (String)destination.getObjectName()).setContentType(options.getContentType()).setContentEncoding(options.getContentEncoding()).setMetadata(GoogleCloudStorageClientImpl.encodeMetadata(options.getMetadata())).build()).setTargetOptions(new Storage.BlobTargetOption[]{Storage.BlobTargetOption.generationMatch((long)(destination.hasGenerationId() ? destination.getGenerationId() : this.getWriteGeneration(destination, true)))}).build();
        try {
            composedBlob = this.storageWrapper.compose(request);
        }
        catch (StorageException e) {
            GoogleCloudStorageEventBus.postOnException();
            throw new IOException(e);
        }
        GoogleCloudStorageItemInfo compositeInfo = GoogleCloudStorageClientImpl.createItemInfoForBlob(destination, composedBlob);
        ((GoogleLogger.Api)logger.atFiner()).log("composeObjects() done, returning: %s", (Object)compositeInfo);
        return compositeInfo;
    }

    private long getWriteGeneration(StorageResourceId resourceId, boolean overwrite) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("getWriteGeneration(%s, %s)", (Object)resourceId, overwrite);
        GoogleCloudStorageItemInfo info = this.getItemInfo(resourceId);
        if (!info.exists()) {
            return 0L;
        }
        if (info.exists() && overwrite) {
            long generation = info.getContentGeneration();
            Preconditions.checkState((generation != 0L ? 1 : 0) != 0, (Object)"Generation should not be 0 for an existing item");
            return generation;
        }
        GoogleCloudStorageEventBus.postOnException();
        throw new FileAlreadyExistsException(String.format("Object %s already exists.", resourceId));
    }

    static ImmutableMap<String, String> getUpdatedHeadersWithUserAgent(GoogleCloudStorageOptions storageOptions) {
        ImmutableMap httpRequestHeaders = (ImmutableMap)MoreObjects.firstNonNull(storageOptions.getHttpRequestHeaders(), (Object)ImmutableMap.of());
        String appName = storageOptions.getAppName();
        if (!httpRequestHeaders.containsKey((Object)USER_AGENT) && !Strings.isNullOrEmpty((String)appName)) {
            ((GoogleLogger.Api)logger.atFiner()).log("Setting useragent %s", (Object)appName);
            return ImmutableMap.builder().putAll((Map)httpRequestHeaders).put((Object)USER_AGENT, (Object)appName).build();
        }
        return httpRequestHeaders;
    }

    static BlobWriteSessionConfig getSessionConfig(AsyncWriteChannelOptions writeOptions, ExecutorService pCUExecutorService) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("Upload strategy in use: %s", (Object)writeOptions.getUploadType());
        switch (writeOptions.getUploadType()) {
            case CHUNK_UPLOAD: {
                return BlobWriteSessionConfigs.getDefault().withChunkSize(writeOptions.getUploadChunkSize());
            }
            case WRITE_TO_DISK_THEN_UPLOAD: {
                if (writeOptions.getTemporaryPaths() == null || writeOptions.getTemporaryPaths().isEmpty()) {
                    return BlobWriteSessionConfigs.bufferToTempDirThenUpload();
                }
                return BlobWriteSessionConfigs.bufferToDiskThenUpload((Collection)((Collection)writeOptions.getTemporaryPaths().stream().map(x -> Paths.get(x, new String[0])).collect(ImmutableSet.toImmutableSet())));
            }
            case JOURNALING: {
                if (writeOptions.getTemporaryPaths() == null || writeOptions.getTemporaryPaths().isEmpty()) {
                    GoogleCloudStorageEventBus.postOnException();
                    throw new IllegalArgumentException("Upload using `Journaling` requires the property:fs.gs.write.temporary.dirs to be set.");
                }
                return BlobWriteSessionConfigs.journaling((Collection)((Collection)writeOptions.getTemporaryPaths().stream().map(x -> Paths.get(x, new String[0])).collect(ImmutableSet.toImmutableSet())));
            }
            case PARALLEL_COMPOSITE_UPLOAD: {
                return BlobWriteSessionConfigs.parallelCompositeUpload().withBufferAllocationStrategy(ParallelCompositeUploadBlobWriteSessionConfig.BufferAllocationStrategy.fixedPool((int)writeOptions.getPCUBufferCount(), (int)writeOptions.getPCUBufferCapacity())).withPartCleanupStrategy(GoogleCloudStorageClientImpl.getPartCleanupStrategy(writeOptions.getPartFileCleanupType())).withExecutorSupplier(GoogleCloudStorageClientImpl.getPCUExecutorSupplier(pCUExecutorService)).withPartNamingStrategy(GoogleCloudStorageClientImpl.getPartNamingStrategy(writeOptions.getPartFileNamePrefix()));
            }
        }
        GoogleCloudStorageEventBus.postOnException();
        throw new IllegalArgumentException(String.format("Upload type:%s is not supported.", writeOptions.getUploadType()));
    }

    private static ParallelCompositeUploadBlobWriteSessionConfig.PartCleanupStrategy getPartCleanupStrategy(AsyncWriteChannelOptions.PartFileCleanupType cleanupType) {
        switch (cleanupType) {
            case NEVER: {
                return ParallelCompositeUploadBlobWriteSessionConfig.PartCleanupStrategy.never();
            }
            case ON_SUCCESS: {
                return ParallelCompositeUploadBlobWriteSessionConfig.PartCleanupStrategy.onlyOnSuccess();
            }
            case ALWAYS: {
                return ParallelCompositeUploadBlobWriteSessionConfig.PartCleanupStrategy.always();
            }
        }
        GoogleCloudStorageEventBus.postOnException();
        throw new IllegalArgumentException(String.format("Cleanup type:%s is not handled.", cleanupType));
    }

    private static ParallelCompositeUploadBlobWriteSessionConfig.PartNamingStrategy getPartNamingStrategy(String partFilePrefix) {
        if (Strings.isNullOrEmpty((String)partFilePrefix)) {
            return ParallelCompositeUploadBlobWriteSessionConfig.PartNamingStrategy.useObjectNameAsPrefix();
        }
        return ParallelCompositeUploadBlobWriteSessionConfig.PartNamingStrategy.prefix((String)partFilePrefix);
    }

    private static ParallelCompositeUploadBlobWriteSessionConfig.ExecutorSupplier getPCUExecutorSupplier(ExecutorService pCUExecutorService) {
        return pCUExecutorService == null ? ParallelCompositeUploadBlobWriteSessionConfig.ExecutorSupplier.cachedPool() : ParallelCompositeUploadBlobWriteSessionConfig.ExecutorSupplier.useExecutor((Executor)pCUExecutorService);
    }

    private static GoogleCloudStorageItemInfo createItemInfoForBlob(StorageResourceId resourceId, Blob blob) {
        Preconditions.checkArgument((resourceId != null ? 1 : 0) != 0, (Object)"resourceId must not be null");
        Preconditions.checkArgument((blob != null ? 1 : 0) != 0, (Object)"object must not be null");
        Preconditions.checkArgument((boolean)resourceId.isStorageObject(), (String)"resourceId must be a StorageObject. resourceId: %s", (Object)resourceId);
        Preconditions.checkArgument((boolean)resourceId.getBucketName().equals(blob.getBucket()), (String)"resourceId.getBucketName() must equal object.getBucket(): '%s' vs '%s'", (Object)resourceId.getBucketName(), (Object)blob.getBucket());
        Preconditions.checkArgument((boolean)resourceId.getObjectName().equals(blob.getName()), (String)"resourceId.getObjectName() must equal object.getName(): '%s' vs '%s'", (Object)resourceId.getObjectName(), (Object)blob.getName());
        Map<String, byte[]> decodedMetadata = blob.getMetadata() == null ? null : GoogleCloudStorageImpl.decodeMetadata(blob.getMetadata());
        byte[] md5Hash = null;
        byte[] crc32c = null;
        if (!Strings.isNullOrEmpty((String)blob.getCrc32c())) {
            crc32c = BaseEncoding.base64().decode((CharSequence)blob.getCrc32c());
        }
        if (!Strings.isNullOrEmpty((String)blob.getMd5())) {
            md5Hash = BaseEncoding.base64().decode((CharSequence)blob.getMd5());
        }
        return GoogleCloudStorageItemInfo.createObject(resourceId, blob.getCreateTimeOffsetDateTime() == null ? 0L : blob.getCreateTimeOffsetDateTime().toInstant().toEpochMilli(), blob.getUpdateTimeOffsetDateTime() == null ? 0L : blob.getUpdateTimeOffsetDateTime().toInstant().toEpochMilli(), blob.getSize() == null ? 0L : blob.getSize(), blob.getContentType(), blob.getContentEncoding(), decodedMetadata, blob.getGeneration() == null ? 0L : blob.getGeneration(), blob.getMetageneration() == null ? 0L : blob.getMetageneration(), new VerificationAttributes(md5Hash, crc32c));
    }

    public static Builder builder() {
        return new AutoBuilder_GoogleCloudStorageClientImpl_Builder();
    }

    @AutoBuilder(ofClass=GoogleCloudStorageClientImpl.class)
    public static abstract class Builder {
        public abstract Builder setOptions(GoogleCloudStorageOptions var1);

        public abstract Builder setHttpTransport(@Nullable HttpTransport var1);

        public abstract Builder setCredentials(@Nullable Credentials var1);

        @VisibleForTesting
        public abstract Builder setHttpRequestInitializer(@Nullable HttpRequestInitializer var1);

        public abstract Builder setDownscopedAccessTokenFn(@Nullable Function<List<AccessBoundary>, String> var1);

        public abstract Builder setGRPCInterceptors(@Nullable ImmutableList<ClientInterceptor> var1);

        @VisibleForTesting
        public abstract Builder setClientLibraryStorage(@Nullable Storage var1);

        @VisibleForTesting
        public abstract Builder setPCUExecutorService(@Nullable ExecutorService var1);

        public abstract GoogleCloudStorageClientImpl build() throws IOException;
    }
}

