/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.gcsio.CreateBucketOptions;
import com.google.cloud.hadoop.gcsio.CreateObjectOptions;
import com.google.cloud.hadoop.gcsio.FolderInfo;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.gcsio.ListFolderOptions;
import com.google.cloud.hadoop.gcsio.ListObjectOptions;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.gcsio.UpdatableItemInfo;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public interface GoogleCloudStorage {
    public static final String PATH_DELIMITER = "/";
    public static final long MAX_RESULTS_UNLIMITED = -1L;
    public static final long LIST_MAX_RESULTS = 5000L;
    public static final int MAX_COMPOSE_OBJECTS = 32;

    public GoogleCloudStorageOptions getOptions();

    default public WritableByteChannel create(StorageResourceId resourceId) throws IOException {
        return this.create(resourceId, CreateObjectOptions.DEFAULT_OVERWRITE);
    }

    public WritableByteChannel create(StorageResourceId var1, CreateObjectOptions var2) throws IOException;

    default public void createBucket(String bucketName) throws IOException {
        this.createBucket(bucketName, CreateBucketOptions.DEFAULT);
    }

    public void createBucket(String var1, CreateBucketOptions var2) throws IOException;

    public void createEmptyObject(StorageResourceId var1) throws IOException;

    public void createEmptyObject(StorageResourceId var1, CreateObjectOptions var2) throws IOException;

    public void createEmptyObjects(List<StorageResourceId> var1) throws IOException;

    public void createEmptyObjects(List<StorageResourceId> var1, CreateObjectOptions var2) throws IOException;

    default public SeekableByteChannel open(StorageResourceId resourceId) throws IOException {
        return this.open(resourceId, GoogleCloudStorageReadOptions.DEFAULT);
    }

    public SeekableByteChannel open(StorageResourceId var1, GoogleCloudStorageReadOptions var2) throws IOException;

    default public SeekableByteChannel open(GoogleCloudStorageItemInfo itemInfo) throws IOException {
        return this.open(itemInfo, GoogleCloudStorageReadOptions.DEFAULT);
    }

    public SeekableByteChannel open(GoogleCloudStorageItemInfo var1, GoogleCloudStorageReadOptions var2) throws IOException;

    public void deleteBuckets(List<String> var1) throws IOException;

    public void deleteObjects(List<StorageResourceId> var1) throws IOException;

    public void deleteFolders(List<FolderInfo> var1) throws IOException;

    public void copy(String var1, List<String> var2, String var3, List<String> var4) throws IOException;

    default public void copy(Map<StorageResourceId, StorageResourceId> sourceToDestinationObjectsMap) throws IOException {
        Preconditions.checkArgument((sourceToDestinationObjectsMap != null ? 1 : 0) != 0, (Object)"sourceToDestinationObjectsMap must not be null");
        if (sourceToDestinationObjectsMap.isEmpty()) {
            return;
        }
        ArrayList<String> srcObjectNames = new ArrayList<String>(sourceToDestinationObjectsMap.size());
        ArrayList<String> dstObjectNames = new ArrayList<String>(sourceToDestinationObjectsMap.size());
        Optional first = sourceToDestinationObjectsMap.entrySet().stream().findFirst();
        String srcBucketName = ((StorageResourceId)((Map.Entry)first.get()).getKey()).getBucketName();
        String dstBucketName = ((StorageResourceId)((Map.Entry)first.get()).getValue()).getBucketName();
        sourceToDestinationObjectsMap.forEach((source, destination) -> {
            if (!srcBucketName.equals(source.getBucketName())) {
                throw new UnsupportedOperationException("This operation is not supported across multiple source buckets");
            }
            if (!dstBucketName.equals(destination.getBucketName())) {
                throw new UnsupportedOperationException("This operation is not supported across multiple destination buckets");
            }
            srcObjectNames.add(source.getObjectName());
            dstObjectNames.add(destination.getObjectName());
        });
        this.copy(srcBucketName, srcObjectNames, dstBucketName, dstObjectNames);
    }

    public void move(Map<StorageResourceId, StorageResourceId> var1) throws IOException;

    public boolean isHnBucket(URI var1) throws IOException;

    public List<String> listBucketNames() throws IOException;

    public void renameHnFolder(URI var1, URI var2) throws IOException;

    public List<GoogleCloudStorageItemInfo> listBucketInfo() throws IOException;

    default public List<GoogleCloudStorageItemInfo> listObjectInfo(String bucketName, String objectNamePrefix) throws IOException {
        return this.listObjectInfo(bucketName, objectNamePrefix, ListObjectOptions.DEFAULT);
    }

    default public List<GoogleCloudStorageItemInfo> listObjectInfoStartingFrom(String bucketName, String startOffset) throws IOException {
        return this.listObjectInfoStartingFrom(bucketName, startOffset, ListObjectOptions.DEFAULT_USING_START_OFFSET);
    }

    public List<GoogleCloudStorageItemInfo> listObjectInfo(String var1, String var2, ListObjectOptions var3) throws IOException;

    public List<GoogleCloudStorageItemInfo> listObjectInfoStartingFrom(String var1, String var2, ListObjectOptions var3) throws IOException;

    default public ListPage<GoogleCloudStorageItemInfo> listObjectInfoPage(String bucketName, String objectNamePrefix, String pageToken) throws IOException {
        return this.listObjectInfoPage(bucketName, objectNamePrefix, ListObjectOptions.DEFAULT, pageToken);
    }

    public ListPage<GoogleCloudStorageItemInfo> listObjectInfoPage(String var1, String var2, ListObjectOptions var3, String var4) throws IOException;

    public ListPage<FolderInfo> listFolderInfoForPrefixPage(String var1, String var2, ListFolderOptions var3, String var4) throws IOException;

    public GoogleCloudStorageItemInfo getItemInfo(StorageResourceId var1) throws IOException;

    public List<GoogleCloudStorageItemInfo> getItemInfos(List<StorageResourceId> var1) throws IOException;

    public List<GoogleCloudStorageItemInfo> updateItems(List<UpdatableItemInfo> var1) throws IOException;

    public void compose(String var1, List<String> var2, String var3, String var4) throws IOException;

    public GoogleCloudStorageItemInfo composeObjects(List<StorageResourceId> var1, StorageResourceId var2, CreateObjectOptions var3) throws IOException;

    public Map<String, Long> getStatistics();

    public void close();

    public static class ListPage<T> {
        private final List<T> items;
        private final String nextPageToken;

        public ListPage(List<T> items, String nextPageToken) {
            this.items = items;
            this.nextPageToken = nextPageToken;
        }

        public List<T> getItems() {
            return this.items;
        }

        public String getNextPageToken() {
            return this.nextPageToken;
        }
    }
}

