/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio.integration;

import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.util.DateTime;
import com.google.api.services.storage.model.StorageObject;
import com.google.auth.Credentials;
import com.google.auth.oauth2.ComputeEngineCredentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageClientImpl;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageImpl;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.gcsio.ListObjectOptions;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.gcsio.TrackingGrpcRequestInterceptor;
import com.google.cloud.hadoop.gcsio.TrackingHttpRequestInitializer;
import com.google.cloud.hadoop.gcsio.testing.TestConfiguration;
import com.google.cloud.hadoop.util.RetryHttpInitializer;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.flogger.GoogleLogger;
import com.google.common.io.BaseEncoding;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import org.junit.Assert;

public class GoogleCloudStorageTestHelper {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    public static final String APP_NAME = "GHFS/test";
    private static final int BUFFER_SIZE_MAX_BYTES = 0x2000000;

    public static GoogleCloudStorage createGoogleCloudStorage() {
        try {
            return GoogleCloudStorageImpl.builder().setOptions(GoogleCloudStorageTestHelper.getStandardOptionBuilder().build()).setCredentials(GoogleCloudStorageTestHelper.getCredentials()).build();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create GoogleCloudStorage instance", e);
        }
    }

    public static GoogleCloudStorage createGcsClientImpl() {
        try {
            return GoogleCloudStorageClientImpl.builder().setOptions(GoogleCloudStorageTestHelper.getStandardOptionBuilder().build()).setCredentials(GoogleCloudStorageTestHelper.getCredentials()).build();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create GoogleCloudStorage instance", e);
        }
    }

    public static Credentials getCredentials() throws IOException {
        String serviceAccountJsonKeyFile = TestConfiguration.getInstance().getServiceAccountJsonKeyFile();
        if (serviceAccountJsonKeyFile == null) {
            Boolean isApplicationDefaultModeEnabled = TestConfiguration.getInstance().isApplicationDefaultModeEnabled();
            return isApplicationDefaultModeEnabled != false ? GoogleCredentials.getApplicationDefault() : ComputeEngineCredentials.create().createScoped(new String[]{"https://www.googleapis.com/auth/cloud-platform"});
        }
        try (FileInputStream fis = new FileInputStream(serviceAccountJsonKeyFile);){
            GoogleCredentials googleCredentials = ServiceAccountCredentials.fromStream((InputStream)fis).createScoped(new String[]{"https://www.googleapis.com/auth/cloud-platform"});
            return googleCredentials;
        }
    }

    public static GoogleCloudStorageOptions.Builder getStandardOptionBuilder() {
        return GoogleCloudStorageOptions.builder().setAppName(APP_NAME).setDirectPathPreferred(TestConfiguration.getInstance().isDirectPathPreferred()).setGrpcWriteEnabled(true).setProjectId((String)Preconditions.checkNotNull((Object)TestConfiguration.getInstance().getProjectId()));
    }

    public static void assertByteArrayEquals(byte[] expected, byte[] actual) {
        if (expected == null ^ actual == null) {
            Assert.fail((String)String.format("Expected was '%s', actual was '%s'", expected, actual));
        } else if (expected == null && actual == null) {
            return;
        }
        if (expected.length != actual.length) {
            Assert.fail((String)String.format("Length mismatch: expected: %d, actual: %d", expected.length, actual.length));
        }
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == actual[i]) continue;
            Assert.fail((String)String.format("Mismatch at index %d. expected: 0x%02x, actual: 0x%02x", i, expected[i], actual[i]));
        }
    }

    public static void assertObjectContent(GoogleCloudStorage gcs, StorageResourceId resourceId, byte[] expectedBytes) throws IOException {
        GoogleCloudStorageTestHelper.assertObjectContent(gcs, resourceId, expectedBytes, 1);
    }

    public static void assertObjectContent(GoogleCloudStorage gcs, StorageResourceId resourceId, GoogleCloudStorageReadOptions readOptions, byte[] expectedBytes) throws IOException {
        GoogleCloudStorageTestHelper.assertObjectContent(gcs, resourceId, readOptions, expectedBytes, 1);
    }

    public static void assertObjectContent(GoogleCloudStorage gcs, StorageResourceId id, GoogleCloudStorageReadOptions readOptions, byte[] expectedBytes, int expectedBytesCount, int offset) throws IOException {
        Preconditions.checkArgument((expectedBytesCount > 0 ? 1 : 0) != 0, (Object)"expectedBytesCount should be greater than 0");
        int expectedBytesLength = expectedBytes.length;
        long expectedBytesTotalLength = (long)expectedBytesLength * (long)expectedBytesCount;
        ByteBuffer buffer = ByteBuffer.allocate(Math.min(0x2000000, expectedBytesLength));
        long totalRead = 0L;
        try (SeekableByteChannel channel = gcs.open(id, readOptions);){
            if (offset > 0) {
                channel.position(offset);
            }
            int read = channel.read(buffer);
            while (read > 0) {
                Truth.assertWithMessage((String)"Bytes read mismatch").that(Long.valueOf(totalRead += (long)read)).isAtMost((Comparable)Long.valueOf(expectedBytesTotalLength));
                buffer.flip();
                byte[] bytesRead = Arrays.copyOf(buffer.array(), buffer.limit());
                byte[] expectedBytesRead = GoogleCloudStorageTestHelper.getExpectedBytesRead(expectedBytes, totalRead, read);
                GoogleCloudStorageTestHelper.assertByteArrayEquals(expectedBytesRead, bytesRead);
                buffer.clear();
                read = channel.read(buffer);
            }
        }
        Truth.assertWithMessage((String)"Bytes read mismatch").that(Long.valueOf(totalRead)).isEqualTo((Object)expectedBytesTotalLength);
    }

    public static void assertObjectContent(GoogleCloudStorage gcs, StorageResourceId id, GoogleCloudStorageReadOptions readOptions, byte[] expectedBytes, int expectedBytesCount) throws IOException {
        GoogleCloudStorageTestHelper.assertObjectContent(gcs, id, readOptions, expectedBytes, expectedBytesCount, 0);
    }

    public static void assertObjectContent(GoogleCloudStorage gcs, StorageResourceId id, byte[] expectedBytes, int expectedBytesCount) throws IOException {
        GoogleCloudStorageTestHelper.assertObjectContent(gcs, id, GoogleCloudStorageReadOptions.DEFAULT, expectedBytes, expectedBytesCount);
    }

    private static byte[] getExpectedBytesRead(byte[] expectedBytes, long totalRead, int read) {
        int expectedBytesLength = expectedBytes.length;
        int expectedBytesStart = (int)((totalRead - (long)read) % (long)expectedBytesLength);
        int expectedBytesEnd = (int)(totalRead % (long)expectedBytesLength);
        if (expectedBytesStart < expectedBytesEnd) {
            return Arrays.copyOfRange(expectedBytes, expectedBytesStart, expectedBytesEnd);
        }
        byte[] expectedBytesRead = new byte[read];
        int firstPartSize = expectedBytesLength - expectedBytesStart;
        System.arraycopy(expectedBytes, expectedBytesStart, expectedBytesRead, 0, firstPartSize);
        System.arraycopy(expectedBytes, 0, expectedBytesRead, firstPartSize, expectedBytesEnd);
        return expectedBytesRead;
    }

    public static void fillBytes(byte[] bytes) {
        new Random().nextBytes(bytes);
    }

    public static byte[] writeObject(GoogleCloudStorage gcs, StorageResourceId resourceId, int objectSize) throws IOException {
        return GoogleCloudStorageTestHelper.writeObject(gcs, resourceId, objectSize, 1);
    }

    public static byte[] writeObject(GoogleCloudStorage gcs, StorageResourceId resourceId, int partitionSize, int partitionsCount) throws IOException {
        return GoogleCloudStorageTestHelper.writeObject(gcs.create(resourceId), partitionSize, partitionsCount);
    }

    public static byte[] writeObject(WritableByteChannel channel, int partitionSize, int partitionsCount) throws IOException {
        Preconditions.checkArgument((partitionsCount > 0 ? 1 : 0) != 0, (Object)"partitionsCount should be greater than 0");
        byte[] partition = new byte[partitionSize];
        GoogleCloudStorageTestHelper.fillBytes(partition);
        long startTime = System.currentTimeMillis();
        try (WritableByteChannel ignore = channel;){
            for (int i = 0; i < partitionsCount; ++i) {
                channel.write(ByteBuffer.wrap(partition));
            }
        }
        long endTime = System.currentTimeMillis();
        ((GoogleLogger.Api)logger.atFine()).log("Took %sms to write %sB", endTime - startTime, (long)partitionsCount * (long)partitionSize);
        return partition;
    }

    public static Map<String, byte[]> getDecodedMetadata(Map<String, String> metadata) {
        return metadata.entrySet().stream().collect(Collectors.toMap(entity -> (String)entity.getKey(), entity -> GoogleCloudStorageTestHelper.decodeMetadataValues((String)entity.getValue())));
    }

    public static byte[] decodeMetadataValues(String value) {
        return BaseEncoding.base64().decode((CharSequence)value);
    }

    public static ByteString createTestData(int numBytes) {
        byte[] result = new byte[numBytes];
        for (int i = 0; i < numBytes; ++i) {
            result[i] = (byte)(i % 257);
        }
        return ByteString.copyFrom((byte[])result);
    }

    public static StorageObject newStorageObject(String bucketName, String objectName) {
        Random r = new Random();
        return new StorageObject().setBucket(bucketName).setName(objectName).setSize(BigInteger.valueOf(r.nextInt(Integer.MAX_VALUE))).setStorageClass("standard").setGeneration(Long.valueOf(r.nextInt(Integer.MAX_VALUE))).setMetageneration(Long.valueOf(r.nextInt(Integer.MAX_VALUE))).setTimeCreated(new DateTime(new Date())).setUpdated(new DateTime(new Date()));
    }

    public static class TrackingStorageWrapper<T> {
        public final TrackingGrpcRequestInterceptor grpcRequestInterceptor;
        public final TrackingHttpRequestInitializer requestsTracker;
        public final T delegate;

        public TrackingStorageWrapper(GoogleCloudStorageOptions options, CheckedFunction2<TrackingHttpRequestInitializer, ImmutableList, T, IOException> delegateStorageFn, Credentials credentials) throws IOException {
            this.requestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)new RetryHttpInitializer(credentials, options.toRetryHttpInitializerOptions()));
            this.grpcRequestInterceptor = new TrackingGrpcRequestInterceptor();
            this.delegate = delegateStorageFn.apply(this.requestsTracker, ImmutableList.of((Object)this.grpcRequestInterceptor));
        }

        public ImmutableList getAllRequestStrings() {
            return ImmutableList.builder().addAll(this.requestsTracker.getAllRequestStrings()).addAll(this.grpcRequestInterceptor.getAllRequestStrings()).build();
        }
    }

    @FunctionalInterface
    public static interface CheckedFunction2<T, T2, R, E extends Throwable> {
        public R apply(T var1, T2 var2) throws E;
    }

    public static class TestBucketHelper {
        private static final int MAX_CLEANUP_BUCKETS = 250;
        private static final String DELIMITER = "_";
        private static final long LEAKED_BUCKETS_CUTOFF_TIME = Instant.now().minus(Duration.ofHours(6L)).toEpochMilli();
        private final String bucketPrefix;
        private final String uniqueBucketPrefix;

        public TestBucketHelper(String bucketPrefix) {
            this.bucketPrefix = bucketPrefix + DELIMITER;
            this.uniqueBucketPrefix = TestBucketHelper.makeUniqueBucketNamePrefix(bucketPrefix);
            Preconditions.checkState((boolean)this.uniqueBucketPrefix.startsWith(this.bucketPrefix), (Object)"uniqueBucketPrefix should start with bucketPrefix");
        }

        private static String makeUniqueBucketNamePrefix(String prefix) {
            String username = System.getProperty("user.name", "unknown").replaceAll("[-.]", "");
            int usernamePrefixLen = Math.min(username.length(), 8);
            username = username.substring(0, usernamePrefixLen);
            String uuidSuffix = UUID.randomUUID().toString().replaceAll("-", "").substring(0, 12 - usernamePrefixLen);
            return prefix + DELIMITER + username + DELIMITER + uuidSuffix;
        }

        public String getUniqueBucketName(String suffix) {
            Preconditions.checkArgument((this.bucketPrefix.length() + suffix.length() <= 48 ? 1 : 0) != 0, (Object)"bucketPrefix and suffix can have cumulative length upto 48 chars to limit bucket name to 63 chars");
            return this.uniqueBucketPrefix + DELIMITER + suffix;
        }

        public String getUniqueBucketPrefix() {
            return this.uniqueBucketPrefix;
        }

        public void cleanup(GoogleCloudStorage storage) throws IOException {
            Stopwatch storageStopwatch = Stopwatch.createStarted();
            ((GoogleLogger.Api)logger.atInfo()).log("Cleaning up GCS buckets that start with %s prefix or leaked", (Object)this.uniqueBucketPrefix);
            List<String> bucketsToDelete = new ArrayList<String>();
            for (GoogleCloudStorageItemInfo bucketInfo : storage.listBucketInfo()) {
                String bucketName = bucketInfo.getBucketName();
                if (!bucketName.startsWith(this.bucketPrefix) || !bucketName.startsWith(this.uniqueBucketPrefix) && bucketInfo.getCreationTime() >= LEAKED_BUCKETS_CUTOFF_TIME) continue;
                bucketsToDelete.add(bucketName);
            }
            Collections.shuffle(bucketsToDelete);
            if (bucketsToDelete.size() > 250) {
                ((GoogleLogger.Api)logger.atInfo()).log("GCS has %s buckets to cleanup. It's too many, will cleanup only %s buckets: %s", (Object)bucketsToDelete.size(), (Object)250, bucketsToDelete);
                bucketsToDelete = bucketsToDelete.subList(0, 250);
            } else if (bucketsToDelete.size() > 0) {
                ((GoogleLogger.Api)logger.atInfo()).log("GCS has %s buckets to cleanup: %s", bucketsToDelete.size(), bucketsToDelete);
            }
            List objectsToDelete = (List)bucketsToDelete.parallelStream().flatMap(bucket -> {
                try {
                    return storage.listObjectInfo(bucket, null, ListObjectOptions.DEFAULT_FLAT_LIST).stream();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }).collect(ImmutableList.toImmutableList());
            ((GoogleLogger.Api)logger.atInfo()).log("GCS has %s objects to cleanup: %s", objectsToDelete.size(), (Object)objectsToDelete);
            try {
                storage.deleteObjects(Lists.transform((List)objectsToDelete, GoogleCloudStorageItemInfo::getResourceId));
                storage.deleteBuckets(bucketsToDelete);
            }
            catch (IOException ioe) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause((Throwable)ioe)).log("Caught exception during GCS (%s) buckets cleanup", (Object)storage);
            }
            ((GoogleLogger.Api)logger.atInfo()).log("GCS cleaned up in %s seconds", storageStopwatch.elapsed().getSeconds());
        }
    }
}

