/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio.integration;

import com.google.cloud.hadoop.gcsio.AssertingLogHandler;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageClientGrpcTracingInterceptor;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageClientImpl;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageTracingFields;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.gcsio.integration.GoogleCloudStorageTestHelper;
import com.google.cloud.hadoop.util.AsyncWriteChannelOptions;
import com.google.common.truth.Truth;
import com.google.gson.Gson;
import com.google.storage.v2.BucketName;
import io.grpc.Status;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GoogleCloudStorageClientInterceptorIntegrationTest {
    private static final GoogleCloudStorageOptions GCS_TRACE_OPTIONS = GoogleCloudStorageTestHelper.getStandardOptionBuilder().setTraceLogEnabled(Boolean.valueOf(true)).build();
    private static final Logger LOGGER = Logger.getLogger(GoogleCloudStorageClientGrpcTracingInterceptor.class.getName());
    private static final GoogleCloudStorageTestHelper.TestBucketHelper BUCKET_HELPER = new GoogleCloudStorageTestHelper.TestBucketHelper("dataproc-grpc-interceptor");
    private static final String TEST_BUCKET = BUCKET_HELPER.getUniqueBucketPrefix();
    private static GoogleCloudStorage helperGcs = GoogleCloudStorageTestHelper.createGcsClientImpl();
    private AssertingLogHandler assertingHandler;
    private final Gson gson = new Gson();
    @Rule
    public TestName name = new TestName(){

        public String getMethodName() {
            return super.getMethodName();
        }
    };

    @BeforeClass
    public static void setup() throws IOException {
        helperGcs.createBucket(TEST_BUCKET);
    }

    @AfterClass
    public static void after() throws IOException {
        try {
            BUCKET_HELPER.cleanup(helperGcs);
        }
        finally {
            helperGcs.close();
        }
    }

    @Before
    public void setUpHandlers() throws IOException {
        this.assertingHandler = new AssertingLogHandler();
        LOGGER.setUseParentHandlers(false);
        LOGGER.addHandler(this.assertingHandler);
        LOGGER.setLevel(Level.INFO);
    }

    @After
    public void verifyAndRemoveAssertingHandler() {
        LOGGER.removeHandler(this.assertingHandler);
    }

    @Test
    public void testWriteLogs() throws IOException {
        StorageResourceId resourceId = new StorageResourceId(TEST_BUCKET, this.name.getMethodName());
        int uploadChunkSize = 0x200000;
        GoogleCloudStorageOptions storageOption = GCS_TRACE_OPTIONS.toBuilder().setWriteChannelOptions(AsyncWriteChannelOptions.builder().setUploadChunkSize(uploadChunkSize).build()).build();
        GoogleCloudStorage gcsImpl = GoogleCloudStorageClientInterceptorIntegrationTest.getGCSClientImpl(storageOption);
        gcsImpl.create(resourceId).close();
        this.assertingHandler.assertLogCount(7);
        this.verifyChannelCreation(this.assertingHandler.getSubListOfRecords(1, 3), resourceId);
        Map<String, Object> writeObjectRequestRecord = this.assertingHandler.getLogRecordAtIndex(4);
        Truth.assertThat((Object)writeObjectRequestRecord.get(GoogleCloudStorageTracingFields.WRITE_OFFSET.name)).isEqualTo((Object)0);
        Truth.assertThat((Object)writeObjectRequestRecord.get(GoogleCloudStorageTracingFields.CONTENT_LENGTH.name)).isEqualTo((Object)0);
        Truth.assertThat((Object)writeObjectRequestRecord.get(GoogleCloudStorageTracingFields.UPLOAD_ID.name)).isNotNull();
        String uploadId = (String)writeObjectRequestRecord.get(GoogleCloudStorageTracingFields.UPLOAD_ID.name);
        Truth.assertThat((Object)writeObjectRequestRecord.get(GoogleCloudStorageTracingFields.FINALIZE_WRITE.name)).isEqualTo((Object)true);
        Map<String, Object> writeObjectResponseRecord = this.assertingHandler.getLogRecordAtIndex(5);
        Truth.assertThat((Object)writeObjectResponseRecord.get(GoogleCloudStorageTracingFields.UPLOAD_ID.name)).isEqualTo((Object)uploadId);
        Truth.assertThat((Object)writeObjectResponseRecord.get(GoogleCloudStorageTracingFields.PERSISTED_SIZE.name)).isEqualTo((Object)0);
        Map<String, Object> writeObjectCloseStatusRecord = this.assertingHandler.getLogRecordAtIndex(6);
        this.verifyCloseStatus(writeObjectCloseStatusRecord, "WriteObject", Status.OK);
    }

    @Test
    public void testReadLogs() throws IOException {
        StorageResourceId resourceId = new StorageResourceId(TEST_BUCKET, this.name.getMethodName());
        int uploadChunkSize = 0x200000;
        GoogleCloudStorageOptions storageOption = GCS_TRACE_OPTIONS.toBuilder().setWriteChannelOptions(AsyncWriteChannelOptions.builder().setUploadChunkSize(uploadChunkSize).build()).build();
        GoogleCloudStorage gcsImpl = GoogleCloudStorageClientInterceptorIntegrationTest.getGCSClientImpl(storageOption);
        int partitionsCount = 1;
        byte[] partition = GoogleCloudStorageTestHelper.writeObject(gcsImpl, resourceId, 0x200000, partitionsCount);
        this.assertingHandler.assertLogCount(10);
        this.assertingHandler.flush();
        GoogleCloudStorageTestHelper.assertObjectContent(gcsImpl, resourceId, partition, partitionsCount);
        this.assertingHandler.assertLogCount(4);
        StorageResourceId derivedResourceId = this.derivedResourceId(resourceId);
        Map<String, Object> readObjectRequestRecord = this.assertingHandler.getLogRecordAtIndex(1);
        Truth.assertThat((String)readObjectRequestRecord.get(GoogleCloudStorageTracingFields.RESOURCE.name).toString()).contains((CharSequence)derivedResourceId.toString());
        Truth.assertThat((Object)readObjectRequestRecord.get(GoogleCloudStorageTracingFields.READ_OFFSET.name)).isEqualTo((Object)0);
        Truth.assertThat((Object)readObjectRequestRecord.get(GoogleCloudStorageTracingFields.READ_LIMIT.name)).isEqualTo((Object)partition.length);
        Map<String, Object> readObjectResponseRecord = this.assertingHandler.getLogRecordAtIndex(2);
        Truth.assertThat((String)readObjectResponseRecord.get(GoogleCloudStorageTracingFields.RESOURCE.name).toString()).contains((CharSequence)derivedResourceId.toString());
        Truth.assertThat((Object)readObjectResponseRecord.get(GoogleCloudStorageTracingFields.READ_OFFSET.name)).isEqualTo((Object)0);
        Truth.assertThat((Object)readObjectResponseRecord.get(GoogleCloudStorageTracingFields.READ_LIMIT.name)).isEqualTo((Object)partition.length);
        Truth.assertThat((Object)readObjectResponseRecord.get(GoogleCloudStorageTracingFields.BYTES_READ.name)).isEqualTo((Object)partition.length);
        Map<String, Object> writeObjectCloseStatusRecord = this.assertingHandler.getLogRecordAtIndex(3);
        this.verifyCloseStatus(writeObjectCloseStatusRecord, "ReadObject", Status.OK);
    }

    public static GoogleCloudStorage getGCSClientImpl(GoogleCloudStorageOptions options) {
        try {
            return GoogleCloudStorageClientImpl.builder().setOptions(options).setCredentials(GoogleCloudStorageTestHelper.getCredentials()).build();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create GoogleCloudStorage instance", e);
        }
    }

    private void verifyCommonFields(Map<String, Object> logRecord, String rpcMethod) {
        Truth.assertThat((Object)logRecord.get(GoogleCloudStorageTracingFields.IDEMPOTENCY_TOKEN.name)).isNotNull();
        Truth.assertThat((Object)logRecord.get(GoogleCloudStorageTracingFields.RPC_METHOD.name)).isEqualTo((Object)rpcMethod);
    }

    private void verifyCloseStatus(Map<String, Object> logRecord, String rpcMethod, Status status) {
        this.verifyCommonFields(logRecord, rpcMethod);
        Truth.assertThat((String)logRecord.get(GoogleCloudStorageTracingFields.STATUS.name).toString()).contains((CharSequence)status.getCode().toString());
    }

    private StorageResourceId derivedResourceId(StorageResourceId resourceId) {
        String bucketName = BucketName.newBuilder().setBucket(resourceId.getBucketName()).setProject("_").build().toString();
        return new StorageResourceId(bucketName, resourceId.getObjectName(), resourceId.getGenerationId());
    }

    private void verifyChannelCreation(List<Map<String, Object>> logRecord, StorageResourceId resourceId) {
        Truth.assertThat((Integer)logRecord.size()).isEqualTo((Object)3);
        String rpcMethod = "StartResumableWrite";
        StorageResourceId derivedResourceId = this.derivedResourceId(resourceId);
        this.verifyCommonFields(logRecord.get(0), rpcMethod);
        Truth.assertThat((String)logRecord.get(0).get(GoogleCloudStorageTracingFields.RESOURCE.name).toString()).contains((CharSequence)derivedResourceId.toString());
        Truth.assertThat((Object)logRecord.get(0).get(GoogleCloudStorageTracingFields.REQUEST_COUNTER.name)).isEqualTo((Object)0);
        this.verifyCommonFields(logRecord.get(1), rpcMethod);
        Truth.assertThat((String)logRecord.get(1).get(GoogleCloudStorageTracingFields.RESOURCE.name).toString()).contains((CharSequence)derivedResourceId.toString());
        Truth.assertThat((Object)logRecord.get(1).get(GoogleCloudStorageTracingFields.RESPONSE_COUNTER.name)).isEqualTo((Object)0);
        Truth.assertThat((Object)logRecord.get(1).get(GoogleCloudStorageTracingFields.UPLOAD_ID.name)).isNotNull();
        this.verifyCloseStatus(logRecord.get(2), rpcMethod, Status.OK);
    }
}

