/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.gcsio.GrpcStreamType;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.MessageLite;
import com.google.storage.v2.BucketName;
import com.google.storage.v2.StartResumableWriteRequest;
import com.google.storage.v2.WriteObjectRequest;
import io.grpc.Attributes;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ClientStreamTracer;
import io.grpc.ForwardingClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;

public class TrackingGrpcRequestInterceptor
implements ClientInterceptor {
    public static final String REQUEST_PREFIX_FORMAT = "rpcMethod:%s";
    private static final String RESUMABLE_UPLOAD_REQUEST_FORMAT = "StartResumableUpload:{bucket:%s;object:%s;ifGenerationMatch:generationId_%d;}";
    private static final String RESUMABLE_UPLOAD_CHUNK_REQUEST_FORMAT = "WriteObjectRequest:{writeOffset:%d;finalRequest:%b;uploadId:upload_%s;ifGenerationMatch:generationId_%d;contentLength:%d;}";
    private static final String UPLOAD_ID_PARAM_PATTERN = "uploadId:[^};]+";
    private static final String GENERATION_MATCH_TOKEN_PARAM_PATTERN = "ifGenerationMatch:[^};]+";
    public List<TrackingStreamTracer> streamTracerList = new ArrayList<TrackingStreamTracer>();

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        String rpcMethodName = method.getBareMethodName();
        final TrackingStreamTracer streamTracer = this.getStreamTracer(GrpcStreamType.getTypeFromName((String)rpcMethodName), rpcMethodName);
        this.streamTracerList.add(streamTracer);
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions.withStreamTracerFactory(new ClientStreamTracer.Factory(){

            public ClientStreamTracer newClientStreamTracer(ClientStreamTracer.StreamInfo info, Metadata headers) {
                return streamTracer;
            }
        }))){

            public void sendMessage(ReqT message) {
                streamTracer.traceMessage((MessageLite)message);
                super.sendMessage(message);
            }
        };
    }

    private TrackingStreamTracer getStreamTracer(GrpcStreamType type, String rpcMethodName) {
        switch (type) {
            case START_RESUMABLE_WRITE: {
                return new StartResumableUploadStreamTracer(type, rpcMethodName);
            }
            case WRITE_OBJECT: {
                return new WriteObjectStreamTracer(type, rpcMethodName);
            }
        }
        return new TrackingStreamTracer(type, rpcMethodName);
    }

    public ImmutableList<String> getAllRequestStrings() {
        AtomicLong resumableUploadId = new AtomicLong();
        AtomicLong generationMatchId = new AtomicLong();
        return (ImmutableList)this.streamTracerList.stream().map(r -> r.requestStringList()).collect(Collectors.toList()).stream().flatMap(Collection::stream).map(r -> TrackingGrpcRequestInterceptor.replaceResumableUploadIdWithId(r, resumableUploadId)).map(r -> TrackingGrpcRequestInterceptor.replaceGenerationMatchWithId(r, generationMatchId)).collect(ImmutableList.toImmutableList());
    }

    private static String replaceResumableUploadIdWithId(String request, AtomicLong uploadId) {
        return TrackingGrpcRequestInterceptor.replaceWithId(request, UPLOAD_ID_PARAM_PATTERN, "uploadId:upload_", uploadId);
    }

    private static String replaceGenerationMatchWithId(String request, AtomicLong generationId) {
        return TrackingGrpcRequestInterceptor.replaceWithId(request, GENERATION_MATCH_TOKEN_PARAM_PATTERN, "ifGenerationMatch:generationId_", generationId);
    }

    private static String replaceWithId(String request, String pattern, String idPrefix, AtomicLong id) {
        long nextId = id.get() + 1L;
        String replacedRequest = request.replaceAll(pattern, idPrefix + nextId);
        if (!request.equals(replacedRequest)) {
            id.incrementAndGet();
        }
        return replacedRequest;
    }

    private static String resumableUploadRequestToString(StartResumableWriteRequest request) {
        return String.format(RESUMABLE_UPLOAD_REQUEST_FORMAT, request.getWriteObjectSpec().getResource().getBucket(), request.getWriteObjectSpec().getResource().getName(), request.getWriteObjectSpec().getIfGenerationMatch());
    }

    private static String writeObjectRequestToString(WriteObjectRequest request) {
        return String.format(RESUMABLE_UPLOAD_CHUNK_REQUEST_FORMAT, request.getWriteOffset(), request.getFinishWrite(), request.getUploadId(), request.getWriteObjectSpec().getIfGenerationMatch(), request.getChecksummedData().getContent().size());
    }

    private static String requestPrefixString(String rpcMethodName) {
        return String.format(REQUEST_PREFIX_FORMAT, rpcMethodName);
    }

    private static String requestString(String requestPrefix, String value) {
        return String.format("%s;%s", requestPrefix, value);
    }

    public static String resumableUploadRequestString(String bucketName, String object, Integer generationId) {
        String requestPrefixString = TrackingGrpcRequestInterceptor.requestPrefixString(GrpcStreamType.START_RESUMABLE_WRITE.name);
        String requestString = String.format(RESUMABLE_UPLOAD_REQUEST_FORMAT, BucketName.newBuilder().setBucket(bucketName).setProject("_").build().toString(), object, generationId);
        return TrackingGrpcRequestInterceptor.requestString(requestPrefixString, requestString);
    }

    public static String resumableUploadChunkRequestString(Integer generationId, Integer uploadId, long contentLength, long writeOffset, boolean finishWrite) {
        String requestPrefixString = TrackingGrpcRequestInterceptor.requestPrefixString(GrpcStreamType.WRITE_OBJECT.name);
        String requestString = String.format(RESUMABLE_UPLOAD_CHUNK_REQUEST_FORMAT, writeOffset, finishWrite, uploadId, generationId, contentLength);
        return TrackingGrpcRequestInterceptor.requestString(requestPrefixString, requestString);
    }

    public static String getObjectRequestString() {
        return TrackingGrpcRequestInterceptor.requestPrefixString("GetObject");
    }

    private class WriteObjectStreamTracer
    extends TrackingStreamTracer {
        WriteObjectStreamTracer(GrpcStreamType type, String rpcMethod) {
            super(type, rpcMethod);
        }

        @Override
        protected String messageToString(MessageLite message) {
            WriteObjectRequest request = (WriteObjectRequest)message;
            return String.format("%s;%s", super.messageToString(message), TrackingGrpcRequestInterceptor.writeObjectRequestToString(request));
        }
    }

    private class StartResumableUploadStreamTracer
    extends TrackingStreamTracer {
        StartResumableUploadStreamTracer(GrpcStreamType type, String rpcMethod) {
            super(type, rpcMethod);
        }

        @Override
        protected String messageToString(MessageLite message) {
            StartResumableWriteRequest request = (StartResumableWriteRequest)message;
            return String.format("%s;%s", super.messageToString(message), TrackingGrpcRequestInterceptor.resumableUploadRequestToString(request));
        }
    }

    private class TrackingStreamTracer
    extends ClientStreamTracer {
        private final GrpcStreamType type;
        private final String rpcMethod;
        protected List<MessageLite> streamMessages = new ArrayList<MessageLite>();
        private Metadata headers;

        TrackingStreamTracer(GrpcStreamType type, String rpcMethod) {
            this.type = type;
            this.rpcMethod = rpcMethod;
        }

        public void traceMessage(MessageLite message) {
            this.streamMessages.add(message);
        }

        protected String messageToString(MessageLite message) {
            return String.format(TrackingGrpcRequestInterceptor.REQUEST_PREFIX_FORMAT, this.rpcMethod);
        }

        public List<String> requestStringList() {
            ArrayList<String> stringList = new ArrayList<String>();
            for (MessageLite message : this.streamMessages) {
                String requestString = this.messageToString(message);
                stringList.add(requestString);
            }
            return stringList;
        }

        public void streamCreated(Attributes transportAttrs, Metadata headers) {
            this.headers = headers;
            super.streamCreated(transportAttrs, headers);
        }
    }
}

