/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.auth.Credentials;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.StorageClientProvider;
import com.google.cloud.hadoop.gcsio.StorageClientWrapper;
import com.google.cloud.hadoop.util.AccessBoundary;
import com.google.cloud.hadoop.util.AsyncWriteChannelOptions;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class StorageClientProviderTest {
    private static final Credentials TEST_CREDENTIALS = null;
    private static final GoogleCloudStorageOptions TEST_STORAGE_OPTIONS = GoogleCloudStorageOptions.builder().setHttpRequestHeaders((Map)ImmutableMap.of((Object)"header-key", (Object)"header-value")).setTraceLogEnabled(Boolean.valueOf(true)).setDirectPathPreferred(true).setWriteChannelOptions(AsyncWriteChannelOptions.DEFAULT).setStorageClientCachingEnabled(true).build();
    private static final Function<List<AccessBoundary>, String> TEST_DOWNSCOPED_ACCESS_TOKEN_FUNC = accessBoundaries -> "token";
    private static final String TEST_PROJECT_PREFIX = "test-project";
    private static final String PROJECT_ENV_VARIABLE = "GOOGLE_CLOUD_PROJECT";
    private StorageClientProvider storageClientProvider;
    private static String testProject = null;

    private int getReferences(StorageClientWrapper storage) {
        return this.storageClientProvider.storageClientToReferenceMap.getOrDefault(storage, 0);
    }

    @BeforeClass
    public static void beforeClass() {
        if (System.getProperty(PROJECT_ENV_VARIABLE) == null) {
            testProject = TEST_PROJECT_PREFIX + String.valueOf(UUID.randomUUID());
            System.setProperty(PROJECT_ENV_VARIABLE, testProject);
        }
    }

    @AfterClass
    public static void afterCLass() {
        if (Objects.equals(System.getProperty(PROJECT_ENV_VARIABLE), testProject)) {
            System.clearProperty(PROJECT_ENV_VARIABLE);
        }
    }

    @Before
    public void setUp() {
        this.storageClientProvider = new StorageClientProvider();
    }

    @Test
    public void getStorage_returnsAndCachesNewStorageObject() throws IOException {
        StorageClientWrapper storage = this.storageClientProvider.getStorage(TEST_CREDENTIALS, TEST_STORAGE_OPTIONS, null, null, TEST_DOWNSCOPED_ACCESS_TOKEN_FUNC);
        Assert.assertNotNull((Object)storage);
        Assert.assertEquals((long)this.storageClientProvider.cache.size(), (long)1L);
        StorageClientWrapper cachedStorage = (StorageClientWrapper)this.storageClientProvider.cache.getIfPresent((Object)this.storageClientProvider.computeCacheKey(TEST_CREDENTIALS, TEST_STORAGE_OPTIONS, TEST_DOWNSCOPED_ACCESS_TOKEN_FUNC));
        Assert.assertNotNull((Object)cachedStorage);
        Assert.assertEquals((Object)storage, (Object)cachedStorage);
    }

    @Test
    public void getStorage_cacheDisabled_doesNotCache() throws IOException {
        GoogleCloudStorageOptions disableCacheOptions = TEST_STORAGE_OPTIONS.toBuilder().setStorageClientCachingEnabled(false).build();
        StorageClientWrapper storage = this.storageClientProvider.getStorage(TEST_CREDENTIALS, disableCacheOptions, null, null, TEST_DOWNSCOPED_ACCESS_TOKEN_FUNC);
        Assert.assertNotNull((Object)storage);
        Assert.assertEquals((long)this.storageClientProvider.cache.size(), (long)0L);
    }

    @Test
    public void getStorage_returnsCachedStorageObject() throws IOException {
        StorageClientWrapper storage1 = this.storageClientProvider.getStorage(TEST_CREDENTIALS, TEST_STORAGE_OPTIONS, null, null, TEST_DOWNSCOPED_ACCESS_TOKEN_FUNC);
        StorageClientWrapper storage2 = this.storageClientProvider.getStorage(TEST_CREDENTIALS, TEST_STORAGE_OPTIONS, null, null, TEST_DOWNSCOPED_ACCESS_TOKEN_FUNC);
        Assert.assertEquals((long)this.storageClientProvider.cache.size(), (long)1L);
        Assert.assertEquals((long)this.getReferences(storage1), (long)2L);
        Assert.assertEquals((Object)storage1, (Object)storage2);
    }

    @Test
    public void getStorage_cacheMiss_returnsNewObject() throws Exception {
        GoogleCloudStorageOptions testOptions = TEST_STORAGE_OPTIONS.toBuilder().setTraceLogEnabled(Boolean.valueOf(false)).setDirectPathPreferred(false).build();
        StorageClientWrapper storage1 = this.storageClientProvider.getStorage(TEST_CREDENTIALS, TEST_STORAGE_OPTIONS, null, null, TEST_DOWNSCOPED_ACCESS_TOKEN_FUNC);
        StorageClientWrapper storage2 = this.storageClientProvider.getStorage(TEST_CREDENTIALS, testOptions, null, null, TEST_DOWNSCOPED_ACCESS_TOKEN_FUNC);
        Assert.assertNotEquals((Object)storage1, (Object)storage2);
        Assert.assertEquals((long)this.getReferences(storage1), (long)1L);
        Assert.assertEquals((long)this.getReferences(storage2), (long)1L);
    }

    @Test
    public void close_nonZeroReference_doesNotCloseObject() throws Exception {
        StorageClientWrapper storage1 = this.storageClientProvider.getStorage(TEST_CREDENTIALS, TEST_STORAGE_OPTIONS, null, null, TEST_DOWNSCOPED_ACCESS_TOKEN_FUNC);
        StorageClientWrapper storage2 = this.storageClientProvider.getStorage(TEST_CREDENTIALS, TEST_STORAGE_OPTIONS, null, null, TEST_DOWNSCOPED_ACCESS_TOKEN_FUNC);
        Assert.assertEquals((long)this.storageClientProvider.cache.size(), (long)1L);
        Assert.assertEquals((long)this.getReferences(storage1), (long)2L);
        Assert.assertEquals((Object)storage1, (Object)storage2);
        this.storageClientProvider.close(storage1);
        Assert.assertEquals((long)this.storageClientProvider.cache.size(), (long)1L);
        Assert.assertEquals((long)this.getReferences(storage1), (long)1L);
    }

    @Test
    public void close_zeroReference_closesStorageObject() throws Exception {
        StorageClientWrapper storage1 = this.storageClientProvider.getStorage(TEST_CREDENTIALS, TEST_STORAGE_OPTIONS, null, null, TEST_DOWNSCOPED_ACCESS_TOKEN_FUNC);
        Assert.assertEquals((long)this.storageClientProvider.cache.size(), (long)1L);
        Assert.assertEquals((long)this.getReferences(storage1), (long)1L);
        this.storageClientProvider.close(storage1);
        Assert.assertEquals((long)this.storageClientProvider.cache.size(), (long)0L);
        Assert.assertEquals((long)this.getReferences(storage1), (long)0L);
        Assert.assertFalse((boolean)this.storageClientProvider.storageClientToReferenceMap.containsKey(storage1));
    }

    @Test
    public void getStorageConcurrent_returnsStorage() throws Exception {
        int numThreads = 100;
        ExecutorService executorService = Executors.newFixedThreadPool(100);
        CountDownLatch latch = new CountDownLatch(numThreads);
        AtomicInteger failures = new AtomicInteger();
        for (int i = 0; i < numThreads; ++i) {
            executorService.submit(() -> {
                try {
                    this.storageClientProvider.getStorage(TEST_CREDENTIALS, TEST_STORAGE_OPTIONS, null, null, TEST_DOWNSCOPED_ACCESS_TOKEN_FUNC);
                }
                catch (IOException e) {
                    failures.getAndIncrement();
                }
                finally {
                    latch.countDown();
                }
            });
        }
        boolean isComplete = latch.await(5000L, TimeUnit.MILLISECONDS);
        executorService.shutdown();
        if (failures.get() > 0 || !isComplete) {
            Assert.fail((String)"Storage creation failed");
        }
        Assert.assertEquals((long)this.storageClientProvider.cache.size(), (long)1L);
    }
}

