/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.auth.Credentials;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageClientImpl;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageImpl;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.util.RetryHttpInitializer;
import com.google.cloud.hadoop.util.RetryHttpInitializerOptions;
import com.google.cloud.hadoop.util.testing.FakeCredentials;
import com.google.cloud.storage.Storage;
import java.io.IOException;

public class MockGoogleCloudStorageImplFactory {
    public static GoogleCloudStorageImpl mockedGcsImpl(HttpTransport transport) throws IOException {
        return MockGoogleCloudStorageImplFactory.mockedGcsImpl(MockGoogleCloudStorageImplFactory.getDefaultOptions(), transport);
    }

    public static GoogleCloudStorageImpl mockedGcsImpl(GoogleCloudStorageOptions options, HttpTransport transport) throws IOException {
        return MockGoogleCloudStorageImplFactory.mockedGcsImpl(options, transport, null);
    }

    public static GoogleCloudStorageImpl mockedGcsImpl(GoogleCloudStorageOptions options, HttpTransport transport, HttpRequestInitializer httpRequestInitializer) throws IOException {
        return GoogleCloudStorageImpl.builder().setOptions(options).setCredentials((Credentials)new FakeCredentials()).setHttpTransport(transport).setHttpRequestInitializer(httpRequestInitializer).build();
    }

    public static GoogleCloudStorageClientImpl mockedGcsClientImpl(HttpTransport transport, Storage storage) throws IOException {
        return MockGoogleCloudStorageImplFactory.mockedGcsClientImpl(MockGoogleCloudStorageImplFactory.getDefaultOptions(), transport, storage);
    }

    public static GoogleCloudStorageClientImpl mockedGcsClientImpl(GoogleCloudStorageOptions options, HttpTransport transport, Storage storage) throws IOException {
        FakeCredentials fakeCredentials = new FakeCredentials();
        return GoogleCloudStorageClientImpl.builder().setOptions(options).setHttpTransport(transport).setHttpRequestInitializer((HttpRequestInitializer)new RetryHttpInitializer((Credentials)fakeCredentials, RetryHttpInitializerOptions.builder().setDefaultUserAgent("gcsio-unit-test").build())).setClientLibraryStorage(storage).build();
    }

    private static GoogleCloudStorageOptions getDefaultOptions() {
        return GoogleCloudStorageOptions.builder().setAppName("gcsio-unit-test").setProjectId("google.com:foo-project").build();
    }
}

