/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.testing.http.MockHttpTransport;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.DateTime;
import com.google.api.client.util.ExponentialBackOff;
import com.google.api.client.util.NanoClock;
import com.google.api.client.util.Sleeper;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.StorageRequest;
import com.google.api.services.storage.model.Bucket;
import com.google.api.services.storage.model.BucketStorageLayout;
import com.google.api.services.storage.model.Buckets;
import com.google.api.services.storage.model.Objects;
import com.google.api.services.storage.model.StorageObject;
import com.google.auth.Credentials;
import com.google.cloud.hadoop.gcsio.CreateBucketOptions;
import com.google.cloud.hadoop.gcsio.CreateObjectOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageImpl;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadChannel;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageTestUtils;
import com.google.cloud.hadoop.gcsio.ListObjectOptions;
import com.google.cloud.hadoop.gcsio.MockGoogleCloudStorageImplFactory;
import com.google.cloud.hadoop.gcsio.StorageRequestFactory;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.gcsio.TrackingHttpRequestInitializer;
import com.google.cloud.hadoop.util.AsyncWriteChannelOptions;
import com.google.cloud.hadoop.util.RetryHttpInitializer;
import com.google.cloud.hadoop.util.RetryHttpInitializerOptions;
import com.google.cloud.hadoop.util.testing.FakeCredentials;
import com.google.cloud.hadoop.util.testing.MockHttpTransportHelper;
import com.google.cloud.hadoop.util.testing.ThrowingInputStream;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import com.google.common.primitives.Bytes;
import com.google.common.primitives.Ints;
import com.google.common.truth.Truth;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.SSLException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GoogleCloudStorageTest {
    private static final String PROJECT_ID = "test-project";
    private static final String BUCKET_NAME = "foo-bucket";
    private static final String OBJECT_NAME = "bar-object";
    private static final StorageResourceId RESOURCE_ID = new StorageResourceId("foo-bucket", "bar-object");
    private static final int STATUS_CODE_RESUME_INCOMPLETE = 308;
    private static final ImmutableList<String[]> ILLEGAL_OBJECTS = ImmutableList.copyOf((Object[])new String[][]{{null, "bar-object"}, {"foo-bucket", null}, {"", "bar-object"}, {"foo-bucket", ""}});
    private static final ImmutableList<StorageResourceId> ILLEGAL_OBJECT_IDS = ImmutableList.of((Object)StorageResourceId.ROOT, (Object)new StorageResourceId("foo-bucket"));
    private static final GoogleCloudStorageOptions GCS_OPTIONS = GoogleCloudStorageOptions.builder().setAppName("gcsio-unit-test").setProjectId("test-project").setBatchThreads(0).setCopyWithRewriteEnabled(false).build();
    private static final ImmutableMap<String, byte[]> EMPTY_METADATA = ImmutableMap.of();
    private static final ListObjectOptions INCLUDE_PREFIX_LIST_OPTIONS = ListObjectOptions.DEFAULT.toBuilder().setIncludePrefix(true).build();
    private TrackingHttpRequestInitializer trackingRequestInitializerWithRetries;
    private TrackingHttpRequestInitializer trackingRequestInitializerWithoutRetries;

    @Before
    public void setUp() {
        this.trackingRequestInitializerWithRetries = new TrackingHttpRequestInitializer((HttpRequestInitializer)new RetryHttpInitializer((Credentials)new FakeCredentials(), RetryHttpInitializerOptions.builder().setDefaultUserAgent("gcs-io-unit-test").build()), false);
        this.trackingRequestInitializerWithoutRetries = new TrackingHttpRequestInitializer(false);
    }

    private static StorageObject getStorageObjectForEmptyObjectWithMetadata(Map<String, byte[]> metadata) {
        return GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, OBJECT_NAME).setSize(BigInteger.ZERO).setMetadata(metadata == null ? null : GoogleCloudStorageImpl.encodeMetadata(metadata));
    }

    private static GoogleCloudStorageItemInfo getItemInfoForEmptyObjectWithMetadata(Map<String, byte[]> metadata) {
        return GoogleCloudStorageImpl.createItemInfoForStorageObject((StorageResourceId)RESOURCE_ID, (StorageObject)GoogleCloudStorageTest.getStorageObjectForEmptyObjectWithMetadata(metadata));
    }

    @Test
    public void customStorageApiEndpoint() throws Exception {
        GoogleCloudStorageOptions options = GoogleCloudStorageOptions.builder().setAppName("testAppName").setProjectId("testProjectId").setStorageRootUrl("https://unit-test-storage.googleapis.com/").build();
        GoogleCloudStorageImpl gcsImpl = GoogleCloudStorageImpl.builder().setOptions(options).setCredentials((Credentials)new FakeCredentials()).build();
        Truth.assertThat((String)gcsImpl.storage.getRootUrl()).isEqualTo((Object)"https://unit-test-storage.googleapis.com/");
    }

    @Test
    public void testCreateObjectIllegalArguments() throws IOException {
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GoogleCloudStorageTestUtils.HTTP_TRANSPORT);
        ILLEGAL_OBJECT_IDS.forEach(arg_0 -> GoogleCloudStorageTest.lambda$testCreateObjectIllegalArguments$1((GoogleCloudStorage)gcs, arg_0));
    }

    @Test
    public void testCreateObjectNormalOperation() throws Exception {
        byte[] testData = new byte[]{1, 2, 3, 5, 8, 9};
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonErrorResponse((MockHttpTransportHelper.ErrorResponses)MockHttpTransportHelper.ErrorResponses.NOT_FOUND), GoogleCloudStorageTestUtils.resumableUploadResponse(BUCKET_NAME, OBJECT_NAME), MockHttpTransportHelper.jsonDataResponse((Object)GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, OBJECT_NAME).setSize(BigInteger.valueOf(testData.length)).setCrc32c(GoogleCloudStorageTest.calculateCrc32cFromBytes(testData)))});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        try (WritableByteChannel writeChannel = gcs.create(RESOURCE_ID);){
            Truth.assertThat((Boolean)writeChannel.isOpen()).isTrue();
            writeChannel.write(ByteBuffer.wrap(testData));
        }
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(BUCKET_NAME, OBJECT_NAME), TrackingHttpRequestInitializer.resumableUploadRequestString(BUCKET_NAME, OBJECT_NAME, 0, false), TrackingHttpRequestInitializer.resumableUploadChunkRequestString(BUCKET_NAME, OBJECT_NAME, 1)}).inOrder();
        HttpRequest chunkUploadRequest = (HttpRequest)this.trackingRequestInitializerWithRetries.getAllRequests().get(2);
        Truth.assertThat((Long)chunkUploadRequest.getContent().getLength()).isEqualTo((Object)testData.length);
        try (ByteArrayOutputStream writtenData = new ByteArrayOutputStream(testData.length);){
            chunkUploadRequest.getContent().writeTo((OutputStream)writtenData);
            Truth.assertThat((byte[])writtenData.toByteArray()).isEqualTo((Object)testData);
        }
    }

    @Test
    public void testCreateObjectWithGenerationId() throws Exception {
        int generationId = 13;
        byte[] testData = new byte[]{1, 2, 3, 5, 8, 9};
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{GoogleCloudStorageTestUtils.resumableUploadResponse(BUCKET_NAME, OBJECT_NAME), MockHttpTransportHelper.jsonDataResponse((Object)GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, OBJECT_NAME).setSize(BigInteger.valueOf(testData.length)).setCrc32c(GoogleCloudStorageTest.calculateCrc32cFromBytes(testData)))});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        try (WritableByteChannel writeChannel = gcs.create(new StorageResourceId(BUCKET_NAME, OBJECT_NAME, (long)generationId));){
            Truth.assertThat((Boolean)writeChannel.isOpen()).isTrue();
            writeChannel.write(ByteBuffer.wrap(testData));
        }
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.resumableUploadRequestString(BUCKET_NAME, OBJECT_NAME, generationId, false), TrackingHttpRequestInitializer.resumableUploadChunkRequestString(BUCKET_NAME, OBJECT_NAME, 1)}).inOrder();
        HttpRequest chunkUploadRequest = (HttpRequest)this.trackingRequestInitializerWithRetries.getAllRequests().get(1);
        Truth.assertThat((Long)chunkUploadRequest.getContent().getLength()).isEqualTo((Object)testData.length);
        try (ByteArrayOutputStream writtenData = new ByteArrayOutputStream(testData.length);){
            chunkUploadRequest.getContent().writeTo((OutputStream)writtenData);
            Truth.assertThat((byte[])writtenData.toByteArray()).isEqualTo((Object)testData);
        }
    }

    @Test
    public void testCreateObjectWithChecksumMatch() throws Exception {
        byte[] testData = new byte[]{1, 2, 3, 5, 8, 9, 16};
        AsyncWriteChannelOptions writeOptions = AsyncWriteChannelOptions.builder().setRollingChecksumEnabled(true).build();
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{GoogleCloudStorageTestUtils.resumableUploadResponse(BUCKET_NAME, OBJECT_NAME), MockHttpTransportHelper.jsonDataResponse((Object)GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, OBJECT_NAME).setSize(BigInteger.valueOf(testData.length)).setCrc32c(GoogleCloudStorageTest.calculateCrc32cFromBytes(testData)))});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS.toBuilder().setWriteChannelOptions(writeOptions).build(), (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        try (WritableByteChannel writeChannel = gcs.create(new StorageResourceId(BUCKET_NAME, OBJECT_NAME, 1L));){
            Truth.assertThat((Boolean)writeChannel.isOpen()).isTrue();
            int totalBytesWritten = writeChannel.write(ByteBuffer.wrap(testData));
            Truth.assertThat((Integer)totalBytesWritten).isEqualTo((Object)testData.length);
        }
    }

    @Test
    public void testCreateObjectWithChecksumMatchSeekingBuffer() throws Exception {
        byte[] testData = new byte[]{1, 2, 3, 5, 8, 9, 16, 5, 2, 1};
        ByteBuffer buf = ByteBuffer.wrap(testData);
        buf.position(1);
        Hasher testCrc32cHasher = Hashing.crc32c().newHasher();
        testCrc32cHasher.putBytes(buf);
        String testCrc32c = BaseEncoding.base64().encode(Ints.toByteArray((int)testCrc32cHasher.hash().asInt()));
        buf.position(1);
        AsyncWriteChannelOptions writeOptions = AsyncWriteChannelOptions.builder().setRollingChecksumEnabled(true).build();
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{GoogleCloudStorageTestUtils.resumableUploadResponse(BUCKET_NAME, OBJECT_NAME), MockHttpTransportHelper.jsonDataResponse((Object)GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, OBJECT_NAME).setSize(BigInteger.valueOf(testData.length - 1)).setCrc32c(testCrc32c))});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS.toBuilder().setWriteChannelOptions(writeOptions).build(), (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        try (WritableByteChannel writeChannel = gcs.create(new StorageResourceId(BUCKET_NAME, OBJECT_NAME, 1L));){
            Truth.assertThat((Boolean)writeChannel.isOpen()).isTrue();
            int totalBytesWritten = writeChannel.write(buf);
            Truth.assertThat((Integer)totalBytesWritten).isEqualTo((Object)(testData.length - 1));
        }
    }

    @Test
    public void testCreateObjectThrowsExceptionOnChecksumMismatch() throws Exception {
        byte[] testData = new byte[]{1, 2, 3, 5, 8, 9, 16};
        String mockCrc32c = "FFFFFF==";
        AsyncWriteChannelOptions writeOptions = AsyncWriteChannelOptions.builder().setRollingChecksumEnabled(true).build();
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{GoogleCloudStorageTestUtils.resumableUploadResponse(BUCKET_NAME, OBJECT_NAME), MockHttpTransportHelper.jsonDataResponse((Object)GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, OBJECT_NAME).setSize(BigInteger.valueOf(testData.length)).setCrc32c(mockCrc32c))});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS.toBuilder().setWriteChannelOptions(writeOptions).build(), (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        StorageResourceId resourceId = new StorageResourceId(BUCKET_NAME, OBJECT_NAME, 1L);
        try (WritableByteChannel writeChannel = gcs.create(resourceId);){
            Truth.assertThat((Boolean)writeChannel.isOpen()).isTrue();
            writeChannel.write(ByteBuffer.wrap(testData));
            IOException thrown = (IOException)Assert.assertThrows(IOException.class, writeChannel::close);
            Truth.assertThat((Throwable)thrown).hasMessageThat().isEqualTo((Object)String.format("Data integrity check failed for resource '%s'. Client-calculated CRC32C (%s) did not match server-provided CRC32C (%s).", resourceId, GoogleCloudStorageTest.calculateCrc32cFromBytes(testData), mockCrc32c));
        }
    }

    @Test
    public void testCreateObjectWithChecksumMatchAndReuploadFromCache() throws Exception {
        byte[] testData = new byte[]{1, 2, 3, 5, 8, 9, 16};
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.emptyResponse((int)404), GoogleCloudStorageTestUtils.resumableUploadResponse(BUCKET_NAME, OBJECT_NAME), MockHttpTransportHelper.jsonErrorResponse((MockHttpTransportHelper.ErrorResponses)MockHttpTransportHelper.ErrorResponses.GONE), GoogleCloudStorageTestUtils.resumableUploadResponse(BUCKET_NAME, OBJECT_NAME), MockHttpTransportHelper.jsonDataResponse((Object)GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, OBJECT_NAME).setSize(BigInteger.valueOf(testData.length)).setCrc32c(GoogleCloudStorageTest.calculateCrc32cFromBytes(testData)))});
        AsyncWriteChannelOptions writeOptions = AsyncWriteChannelOptions.builder().setUploadChunkSize(524288).setUploadCacheSize(524288).setRollingChecksumEnabled(true).build();
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS.toBuilder().setWriteChannelOptions(writeOptions).build(), (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        try (WritableByteChannel writeChannel = gcs.create(RESOURCE_ID);){
            int totalBytesWritten = writeChannel.write(ByteBuffer.wrap(testData));
            Truth.assertThat((Integer)totalBytesWritten).isEqualTo((Object)testData.length);
        }
    }

    @Test
    public void testCreateObjectApiIOException() throws IOException {
        this.trackingRequestInitializerWithRetries = new TrackingHttpRequestInitializer();
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, OBJECT_NAME)), MockHttpTransportHelper.jsonErrorResponse((MockHttpTransportHelper.ErrorResponses)MockHttpTransportHelper.ErrorResponses.NOT_FOUND)});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        WritableByteChannel writeChannel = gcs.create(RESOURCE_ID);
        Truth.assertThat((Boolean)writeChannel.isOpen()).isTrue();
        IOException thrown = (IOException)Assert.assertThrows(IOException.class, writeChannel::close);
        Truth.assertThat((Throwable)thrown).hasMessageThat().isEqualTo((Object)"Upload failed for 'gs://foo-bucket/bar-object'");
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(BUCKET_NAME, OBJECT_NAME), TrackingHttpRequestInitializer.resumableUploadRequestString(BUCKET_NAME, OBJECT_NAME, 1, true)}).inOrder();
    }

    @Test
    public void reupload_success_singleWrite_singleUploadChunk() throws Exception {
        byte[] testData = new byte[262144];
        new Random().nextBytes(testData);
        int uploadChunkSize = testData.length * 2;
        int uploadCacheSize = testData.length * 2;
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.emptyResponse((int)404), GoogleCloudStorageTestUtils.resumableUploadResponse(BUCKET_NAME, OBJECT_NAME), MockHttpTransportHelper.jsonErrorResponse((MockHttpTransportHelper.ErrorResponses)MockHttpTransportHelper.ErrorResponses.GONE), GoogleCloudStorageTestUtils.resumableUploadResponse(BUCKET_NAME, OBJECT_NAME), MockHttpTransportHelper.jsonDataResponse((Object)GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, OBJECT_NAME).setSize(BigInteger.valueOf(testData.length)).setCrc32c(GoogleCloudStorageTest.calculateCrc32cFromBytes(testData)))});
        AsyncWriteChannelOptions writeOptions = AsyncWriteChannelOptions.builder().setUploadChunkSize(uploadChunkSize).setUploadCacheSize(uploadCacheSize).build();
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS.toBuilder().setWriteChannelOptions(writeOptions).build(), (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        try (WritableByteChannel writeChannel = gcs.create(RESOURCE_ID);){
            writeChannel.write(ByteBuffer.wrap(testData));
        }
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(BUCKET_NAME, OBJECT_NAME), TrackingHttpRequestInitializer.resumableUploadRequestString(BUCKET_NAME, OBJECT_NAME, 0, false), TrackingHttpRequestInitializer.resumableUploadChunkRequestString(BUCKET_NAME, OBJECT_NAME, 1), TrackingHttpRequestInitializer.resumableUploadRequestString(BUCKET_NAME, OBJECT_NAME, 0, false), TrackingHttpRequestInitializer.resumableUploadChunkRequestString(BUCKET_NAME, OBJECT_NAME, 2)}).inOrder();
        HttpRequest writeRequest = (HttpRequest)this.trackingRequestInitializerWithRetries.getAllRequests().get(4);
        Truth.assertThat((Long)writeRequest.getContent().getLength()).isEqualTo((Object)testData.length);
        try (ByteArrayOutputStream writtenData = new ByteArrayOutputStream(testData.length);){
            writeRequest.getContent().writeTo((OutputStream)writtenData);
            Truth.assertThat((byte[])writtenData.toByteArray()).isEqualTo((Object)testData);
        }
    }

    @Test
    public void upload_success_ioException_singleWrite_singleUploadChunk() throws Exception {
        byte[] testData = new byte[262144];
        new Random().nextBytes(testData);
        int uploadChunkSize = testData.length * 2;
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.emptyResponse((int)404), GoogleCloudStorageTestUtils.resumableUploadResponse(BUCKET_NAME, OBJECT_NAME), new IOException("upload IOException"), MockHttpTransportHelper.emptyResponse((int)308), MockHttpTransportHelper.jsonDataResponse((Object)GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, OBJECT_NAME).setSize(BigInteger.valueOf(testData.length)).setCrc32c(GoogleCloudStorageTest.calculateCrc32cFromBytes(testData)))});
        AsyncWriteChannelOptions writeOptions = AsyncWriteChannelOptions.builder().setUploadChunkSize(uploadChunkSize).build();
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS.toBuilder().setWriteChannelOptions(writeOptions).build(), (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        try (WritableByteChannel writeChannel = gcs.create(RESOURCE_ID);){
            writeChannel.write(ByteBuffer.wrap(testData));
        }
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(BUCKET_NAME, OBJECT_NAME), TrackingHttpRequestInitializer.resumableUploadRequestString(BUCKET_NAME, OBJECT_NAME, 0, false), TrackingHttpRequestInitializer.resumableUploadChunkRequestString(BUCKET_NAME, OBJECT_NAME, 1), TrackingHttpRequestInitializer.resumableUploadChunkRequestString(BUCKET_NAME, OBJECT_NAME, 2), TrackingHttpRequestInitializer.resumableUploadChunkRequestString(BUCKET_NAME, OBJECT_NAME, 3)}).inOrder();
        HttpRequest writeRequest = (HttpRequest)this.trackingRequestInitializerWithRetries.getAllRequests().get(4);
        Truth.assertThat((Long)writeRequest.getContent().getLength()).isEqualTo((Object)testData.length);
        try (ByteArrayOutputStream writtenData = new ByteArrayOutputStream(testData.length);){
            writeRequest.getContent().writeTo((OutputStream)writtenData);
            Truth.assertThat((byte[])writtenData.toByteArray()).isEqualTo((Object)testData);
        }
    }

    @Test
    public void upload_failure_runtimeException() throws Exception {
        byte[] testData = new byte[262144];
        new Random().nextBytes(testData);
        RuntimeException uploadException = new RuntimeException("upload RuntimeException");
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.emptyResponse((int)404), GoogleCloudStorageTestUtils.resumableUploadResponse(BUCKET_NAME, OBJECT_NAME), uploadException});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        WritableByteChannel writeChannel = gcs.create(RESOURCE_ID);
        writeChannel.write(ByteBuffer.wrap(testData));
        IOException thrown = (IOException)Assert.assertThrows(IOException.class, writeChannel::close);
        Truth.assertThat((Throwable)thrown).hasCauseThat().isSameInstanceAs((Object)uploadException);
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(BUCKET_NAME, OBJECT_NAME), TrackingHttpRequestInitializer.resumableUploadRequestString(BUCKET_NAME, OBJECT_NAME, 0, false), TrackingHttpRequestInitializer.resumableUploadChunkRequestString(BUCKET_NAME, OBJECT_NAME, 1)}).inOrder();
    }

    @Test
    public void upload_retry_requestTimeout() throws Exception {
        byte[] testData = new byte[262144];
        new Random().nextBytes(testData);
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.emptyResponse((int)404), GoogleCloudStorageTestUtils.resumableUploadResponse(BUCKET_NAME, OBJECT_NAME), MockHttpTransportHelper.emptyResponse((int)408), MockHttpTransportHelper.jsonDataResponse((Object)GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, OBJECT_NAME).setSize(BigInteger.valueOf(testData.length)).setCrc32c(GoogleCloudStorageTest.calculateCrc32cFromBytes(testData)))});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        try (WritableByteChannel writeChannel = gcs.create(RESOURCE_ID);){
            writeChannel.write(ByteBuffer.wrap(testData));
        }
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(BUCKET_NAME, OBJECT_NAME), TrackingHttpRequestInitializer.resumableUploadRequestString(BUCKET_NAME, OBJECT_NAME, 0, false), TrackingHttpRequestInitializer.resumableUploadChunkRequestString(BUCKET_NAME, OBJECT_NAME, 1), TrackingHttpRequestInitializer.resumableUploadChunkRequestString(BUCKET_NAME, OBJECT_NAME, 2)}).inOrder();
    }

    @Test
    public void upload_noRetries_forbidden() throws Exception {
        byte[] testData = new byte[262144];
        new Random().nextBytes(testData);
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.emptyResponse((int)404), GoogleCloudStorageTestUtils.resumableUploadResponse(BUCKET_NAME, OBJECT_NAME), MockHttpTransportHelper.emptyResponse((int)403), MockHttpTransportHelper.jsonDataResponse((Object)GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, OBJECT_NAME).setSize(BigInteger.valueOf(testData.length)))});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        WritableByteChannel writeChannel = gcs.create(RESOURCE_ID);
        writeChannel.write(ByteBuffer.wrap(testData));
        IOException thrown = (IOException)Assert.assertThrows(IOException.class, writeChannel::close);
        Truth.assertThat((Throwable)thrown).hasCauseThat().hasMessageThat().contains((CharSequence)String.valueOf(403));
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(BUCKET_NAME, OBJECT_NAME), TrackingHttpRequestInitializer.resumableUploadRequestString(BUCKET_NAME, OBJECT_NAME, 0, false), TrackingHttpRequestInitializer.resumableUploadChunkRequestString(BUCKET_NAME, OBJECT_NAME, 1)}).inOrder();
    }

    @Test
    public void reupload_success_singleWrite_multipleUploadChunks() throws Exception {
        byte[] testData = new byte[524288];
        new Random().nextBytes(testData);
        int uploadChunkSize = testData.length / 2;
        int uploadCacheSize = testData.length * 2;
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.emptyResponse((int)404), GoogleCloudStorageTestUtils.resumableUploadResponse(BUCKET_NAME, OBJECT_NAME), MockHttpTransportHelper.emptyResponse((int)308).addHeader("Range", "bytes=0-" + (uploadChunkSize - 1)), MockHttpTransportHelper.jsonErrorResponse((MockHttpTransportHelper.ErrorResponses)MockHttpTransportHelper.ErrorResponses.GONE), GoogleCloudStorageTestUtils.resumableUploadResponse(BUCKET_NAME, OBJECT_NAME), MockHttpTransportHelper.emptyResponse((int)308).addHeader("Range", "bytes=0-" + (uploadChunkSize - 1)), MockHttpTransportHelper.jsonDataResponse((Object)GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, OBJECT_NAME).setSize(BigInteger.valueOf(testData.length)).setCrc32c(GoogleCloudStorageTest.calculateCrc32cFromBytes(testData)))});
        AsyncWriteChannelOptions writeOptions = AsyncWriteChannelOptions.builder().setUploadChunkSize(uploadChunkSize).setUploadCacheSize(uploadCacheSize).build();
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS.toBuilder().setWriteChannelOptions(writeOptions).build(), (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        try (WritableByteChannel writeChannel = gcs.create(RESOURCE_ID);){
            writeChannel.write(ByteBuffer.wrap(testData));
        }
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(BUCKET_NAME, OBJECT_NAME), TrackingHttpRequestInitializer.resumableUploadRequestString(BUCKET_NAME, OBJECT_NAME, 0, false), TrackingHttpRequestInitializer.resumableUploadChunkRequestString(BUCKET_NAME, OBJECT_NAME, 1), TrackingHttpRequestInitializer.resumableUploadChunkRequestString(BUCKET_NAME, OBJECT_NAME, 2), TrackingHttpRequestInitializer.resumableUploadRequestString(BUCKET_NAME, OBJECT_NAME, 0, false), TrackingHttpRequestInitializer.resumableUploadChunkRequestString(BUCKET_NAME, OBJECT_NAME, 3), TrackingHttpRequestInitializer.resumableUploadChunkRequestString(BUCKET_NAME, OBJECT_NAME, 4)}).inOrder();
        HttpRequest writeRequestChunk1 = (HttpRequest)this.trackingRequestInitializerWithRetries.getAllRequests().get(5);
        Truth.assertThat((Long)writeRequestChunk1.getContent().getLength()).isEqualTo((Object)(testData.length / 2));
        HttpRequest writeRequestChunk2 = (HttpRequest)this.trackingRequestInitializerWithRetries.getAllRequests().get(6);
        Truth.assertThat((Long)writeRequestChunk2.getContent().getLength()).isEqualTo((Object)(testData.length / 2));
        try (ByteArrayOutputStream writtenData = new ByteArrayOutputStream(testData.length);){
            writeRequestChunk1.getContent().writeTo((OutputStream)writtenData);
            writeRequestChunk2.getContent().writeTo((OutputStream)writtenData);
            Truth.assertThat((byte[])writtenData.toByteArray()).isEqualTo((Object)testData);
        }
    }

    @Test
    public void reupload_success_multipleWrites_singleUploadChunk() throws Exception {
        byte[] testData = new byte[262144];
        new Random().nextBytes(testData);
        int uploadChunkSize = testData.length * 2;
        int uploadCacheSize = testData.length * 2;
        Hasher testCrc32cHasher = Hashing.crc32c().newHasher();
        testCrc32cHasher.putBytes(testData);
        testCrc32cHasher.putBytes(testData);
        String expectedCrc32c = BaseEncoding.base64().encode(Ints.toByteArray((int)testCrc32cHasher.hash().asInt()));
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.emptyResponse((int)404), GoogleCloudStorageTestUtils.resumableUploadResponse(BUCKET_NAME, OBJECT_NAME), MockHttpTransportHelper.jsonErrorResponse((MockHttpTransportHelper.ErrorResponses)MockHttpTransportHelper.ErrorResponses.GONE), GoogleCloudStorageTestUtils.resumableUploadResponse(BUCKET_NAME, OBJECT_NAME), MockHttpTransportHelper.jsonDataResponse((Object)GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, OBJECT_NAME).setSize(BigInteger.valueOf(testData.length)).setCrc32c(expectedCrc32c))});
        AsyncWriteChannelOptions writeOptions = AsyncWriteChannelOptions.builder().setUploadChunkSize(uploadChunkSize).setUploadCacheSize(uploadCacheSize).build();
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS.toBuilder().setWriteChannelOptions(writeOptions).build(), (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        try (WritableByteChannel writeChannel = gcs.create(RESOURCE_ID);){
            writeChannel.write(ByteBuffer.wrap(testData));
            writeChannel.write(ByteBuffer.wrap(testData));
        }
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(BUCKET_NAME, OBJECT_NAME), TrackingHttpRequestInitializer.resumableUploadRequestString(BUCKET_NAME, OBJECT_NAME, 0, false), TrackingHttpRequestInitializer.resumableUploadChunkRequestString(BUCKET_NAME, OBJECT_NAME, 1), TrackingHttpRequestInitializer.resumableUploadRequestString(BUCKET_NAME, OBJECT_NAME, 0, false), TrackingHttpRequestInitializer.resumableUploadChunkRequestString(BUCKET_NAME, OBJECT_NAME, 2)}).inOrder();
        HttpRequest writeRequest = (HttpRequest)this.trackingRequestInitializerWithRetries.getAllRequests().get(4);
        Truth.assertThat((Long)writeRequest.getContent().getLength()).isEqualTo((Object)(2 * testData.length));
        try (ByteArrayOutputStream writtenData = new ByteArrayOutputStream(testData.length);){
            writeRequest.getContent().writeTo((OutputStream)writtenData);
            Truth.assertThat((byte[])writtenData.toByteArray()).isEqualTo((Object)Bytes.concat((byte[][])new byte[][]{testData, testData}));
        }
    }

    @Test
    public void reupload_success_multipleWrites_multipleUploadChunks() throws Exception {
        byte[] testData = new byte[524288];
        new Random().nextBytes(testData);
        int uploadChunkSize = testData.length / 2;
        int uploadCacheSize = testData.length * 2;
        Hasher testCrc32cHasher = Hashing.crc32c().newHasher();
        testCrc32cHasher.putBytes(testData);
        testCrc32cHasher.putBytes(testData);
        String expectedCrc32c = BaseEncoding.base64().encode(Ints.toByteArray((int)testCrc32cHasher.hash().asInt()));
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.emptyResponse((int)404), GoogleCloudStorageTestUtils.resumableUploadResponse(BUCKET_NAME, OBJECT_NAME), MockHttpTransportHelper.emptyResponse((int)308).addHeader("Range", "bytes=0-" + (uploadChunkSize - 1)), MockHttpTransportHelper.jsonErrorResponse((MockHttpTransportHelper.ErrorResponses)MockHttpTransportHelper.ErrorResponses.GONE), GoogleCloudStorageTestUtils.resumableUploadResponse(BUCKET_NAME, OBJECT_NAME), MockHttpTransportHelper.emptyResponse((int)308).addHeader("Range", "bytes=0-" + (uploadChunkSize - 1)), MockHttpTransportHelper.emptyResponse((int)308).addHeader("Range", "bytes=0-" + (2 * uploadChunkSize - 1)), MockHttpTransportHelper.emptyResponse((int)308).addHeader("Range", "bytes=0-" + (3 * uploadChunkSize - 1)), MockHttpTransportHelper.jsonDataResponse((Object)GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, OBJECT_NAME).setCrc32c(expectedCrc32c).setSize(BigInteger.valueOf(2 * testData.length)))});
        AsyncWriteChannelOptions writeOptions = AsyncWriteChannelOptions.builder().setUploadChunkSize(uploadChunkSize).setUploadCacheSize(uploadCacheSize).build();
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS.toBuilder().setWriteChannelOptions(writeOptions).build(), (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        try (WritableByteChannel writeChannel = gcs.create(RESOURCE_ID);){
            writeChannel.write(ByteBuffer.wrap(testData));
            writeChannel.write(ByteBuffer.wrap(testData));
        }
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(BUCKET_NAME, OBJECT_NAME), TrackingHttpRequestInitializer.resumableUploadRequestString(BUCKET_NAME, OBJECT_NAME, 0, false), TrackingHttpRequestInitializer.resumableUploadChunkRequestString(BUCKET_NAME, OBJECT_NAME, 1), TrackingHttpRequestInitializer.resumableUploadChunkRequestString(BUCKET_NAME, OBJECT_NAME, 2), TrackingHttpRequestInitializer.resumableUploadRequestString(BUCKET_NAME, OBJECT_NAME, 0, false), TrackingHttpRequestInitializer.resumableUploadChunkRequestString(BUCKET_NAME, OBJECT_NAME, 3), TrackingHttpRequestInitializer.resumableUploadChunkRequestString(BUCKET_NAME, OBJECT_NAME, 4), TrackingHttpRequestInitializer.resumableUploadChunkRequestString(BUCKET_NAME, OBJECT_NAME, 5), TrackingHttpRequestInitializer.resumableUploadChunkRequestString(BUCKET_NAME, OBJECT_NAME, 6)}).inOrder();
        HttpRequest writeRequestChunk1 = (HttpRequest)this.trackingRequestInitializerWithRetries.getAllRequests().get(5);
        Truth.assertThat((Long)writeRequestChunk1.getContent().getLength()).isEqualTo((Object)(testData.length / 2));
        HttpRequest writeRequestChunk2 = (HttpRequest)this.trackingRequestInitializerWithRetries.getAllRequests().get(6);
        Truth.assertThat((Long)writeRequestChunk2.getContent().getLength()).isEqualTo((Object)(testData.length / 2));
        HttpRequest writeRequestChunk3 = (HttpRequest)this.trackingRequestInitializerWithRetries.getAllRequests().get(7);
        Truth.assertThat((Long)writeRequestChunk3.getContent().getLength()).isEqualTo((Object)(testData.length / 2));
        HttpRequest writeRequestChunk4 = (HttpRequest)this.trackingRequestInitializerWithRetries.getAllRequests().get(8);
        Truth.assertThat((Long)writeRequestChunk4.getContent().getLength()).isEqualTo((Object)(testData.length / 2));
        try (ByteArrayOutputStream writtenData = new ByteArrayOutputStream(testData.length);){
            writeRequestChunk1.getContent().writeTo((OutputStream)writtenData);
            writeRequestChunk2.getContent().writeTo((OutputStream)writtenData);
            writeRequestChunk3.getContent().writeTo((OutputStream)writtenData);
            writeRequestChunk4.getContent().writeTo((OutputStream)writtenData);
            Truth.assertThat((byte[])writtenData.toByteArray()).isEqualTo((Object)Bytes.concat((byte[][])new byte[][]{testData, testData}));
        }
    }

    @Test
    public void reupload_failure_cacheTooSmall_singleWrite_singleChunk() throws Exception {
        byte[] testData = new byte[262144];
        new Random().nextBytes(testData);
        int uploadChunkSize = testData.length;
        int uploadCacheSize = testData.length / 2;
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.emptyResponse((int)404), GoogleCloudStorageTestUtils.resumableUploadResponse(BUCKET_NAME, OBJECT_NAME), MockHttpTransportHelper.jsonErrorResponse((MockHttpTransportHelper.ErrorResponses)MockHttpTransportHelper.ErrorResponses.GONE)});
        AsyncWriteChannelOptions writeOptions = AsyncWriteChannelOptions.builder().setUploadChunkSize(uploadChunkSize).setUploadCacheSize(uploadCacheSize).build();
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS.toBuilder().setWriteChannelOptions(writeOptions).build(), (HttpTransport)transport);
        WritableByteChannel writeChannel = gcs.create(RESOURCE_ID);
        writeChannel.write(ByteBuffer.wrap(testData));
        IOException writeException = (IOException)Assert.assertThrows(IOException.class, writeChannel::close);
        Truth.assertThat((Throwable)writeException).hasCauseThat().isInstanceOf(GoogleJsonResponseException.class);
        Truth.assertThat((Throwable)writeException).hasCauseThat().hasMessageThat().startsWith("410");
    }

    @Test
    public void testCreateEmptyObject() throws IOException {
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, OBJECT_NAME))});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        gcs.createEmptyObject(RESOURCE_ID);
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.uploadRequestString(BUCKET_NAME, OBJECT_NAME, null)}).inOrder();
    }

    @Test
    public void testOpenObjectIllegalArguments() throws IOException {
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GoogleCloudStorageTestUtils.HTTP_TRANSPORT);
        ILLEGAL_OBJECT_IDS.forEach(arg_0 -> GoogleCloudStorageTest.lambda$testOpenObjectIllegalArguments$3((GoogleCloudStorage)gcs, arg_0));
    }

    @Test
    public void testGcsReadChannelCloseIdempotent() throws IOException {
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, OBJECT_NAME))});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        GoogleCloudStorageReadChannel channel = (GoogleCloudStorageReadChannel)gcs.open(RESOURCE_ID);
        Truth.assertThat((Boolean)channel.isOpen()).isTrue();
        channel.close();
        Truth.assertThat((Boolean)channel.isOpen()).isFalse();
        channel.close();
        Truth.assertThat((Boolean)channel.isOpen()).isFalse();
        Assert.assertThrows(ClosedChannelException.class, () -> ((GoogleCloudStorageReadChannel)channel).position());
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(BUCKET_NAME, OBJECT_NAME, "contentEncoding,generation,size")}).inOrder();
    }

    @Test
    public void testOpenWithSomeExceptionsDuringRead() throws Exception {
        ThrowingInputStream timeoutStream = new ThrowingInputStream((Throwable)new SocketTimeoutException("read timeout"));
        ThrowingInputStream sslExceptionStream = new ThrowingInputStream((Throwable)new SSLException("read SSLException"));
        ThrowingInputStream ioExceptionStream = new ThrowingInputStream((Throwable)new IOException("read IOException"));
        byte[] testData = new byte[]{1, 2, 3, 5, 8};
        StorageObject storageObject = GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, OBJECT_NAME);
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)storageObject), MockHttpTransportHelper.inputStreamResponse((String)"Content-Length", (Object)testData.length, (InputStream)timeoutStream), MockHttpTransportHelper.inputStreamResponse((String)"Content-Length", (Object)testData.length, (InputStream)sslExceptionStream), MockHttpTransportHelper.inputStreamResponse((String)"Content-Length", (Object)testData.length, (InputStream)ioExceptionStream), MockHttpTransportHelper.dataResponse((byte[])testData)});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        GoogleCloudStorageReadChannel readChannel = (GoogleCloudStorageReadChannel)gcs.open(RESOURCE_ID);
        readChannel.setSleeper(Sleeper.DEFAULT);
        readChannel.setMaxRetries(3);
        Truth.assertThat((Boolean)readChannel.isOpen()).isTrue();
        Truth.assertThat((Long)readChannel.position()).isEqualTo((Object)0);
        byte[] actualData = new byte[testData.length];
        int bytesRead = readChannel.read(ByteBuffer.wrap(actualData));
        Truth.assertThat((Integer)bytesRead).isEqualTo((Object)testData.length);
        Truth.assertThat((byte[])actualData).isEqualTo((Object)testData);
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(BUCKET_NAME, OBJECT_NAME, "contentEncoding,generation,size"), TrackingHttpRequestInitializer.getMediaRequestString(BUCKET_NAME, OBJECT_NAME, storageObject.getGeneration()), TrackingHttpRequestInitializer.getMediaRequestString(BUCKET_NAME, OBJECT_NAME, storageObject.getGeneration()), TrackingHttpRequestInitializer.getMediaRequestString(BUCKET_NAME, OBJECT_NAME, storageObject.getGeneration()), TrackingHttpRequestInitializer.getMediaRequestString(BUCKET_NAME, OBJECT_NAME, storageObject.getGeneration())}).inOrder();
    }

    @Test
    public void testOpenWithExceptionDuringReadAndCloseForRetry() throws Exception {
        ThrowingInputStream failedStream = new ThrowingInputStream((Throwable)new SSLException("read SSLException"), (Throwable)new SSLException("close SSLException"));
        byte[] testData = new byte[]{1, 2, 3, 5, 8};
        StorageObject storageObject = GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, OBJECT_NAME);
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)storageObject), MockHttpTransportHelper.inputStreamResponse((String)"Content-Length", (Object)testData.length, (InputStream)failedStream), MockHttpTransportHelper.dataResponse((byte[])testData)});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        GoogleCloudStorageReadChannel readChannel = (GoogleCloudStorageReadChannel)gcs.open(RESOURCE_ID);
        readChannel.setMaxRetries(1);
        Truth.assertThat((Boolean)readChannel.isOpen()).isTrue();
        Truth.assertThat((Long)readChannel.position()).isEqualTo((Object)0);
        byte[] actualData = new byte[testData.length];
        int bytesRead = readChannel.read(ByteBuffer.wrap(actualData));
        Truth.assertThat((Integer)bytesRead).isEqualTo((Object)testData.length);
        Truth.assertThat((byte[])actualData).isEqualTo((Object)testData);
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(BUCKET_NAME, OBJECT_NAME, "contentEncoding,generation,size"), TrackingHttpRequestInitializer.getMediaRequestString(BUCKET_NAME, OBJECT_NAME, storageObject.getGeneration()), TrackingHttpRequestInitializer.getMediaRequestString(BUCKET_NAME, OBJECT_NAME, storageObject.getGeneration())}).inOrder();
    }

    @Test
    public void testClosesWithRuntimeExceptionDuringReadAndClose() throws IOException {
        ThrowingInputStream failedStream = new ThrowingInputStream((Throwable)new RuntimeException("read RuntimeException"), (Throwable)new RuntimeException("close RuntimeException"));
        StorageObject storageObject = GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, OBJECT_NAME);
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)storageObject), MockHttpTransportHelper.inputStreamResponse((String)"Content-Length", (Object)1, (InputStream)failedStream)});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        GoogleCloudStorageReadChannel readChannel = (GoogleCloudStorageReadChannel)gcs.open(RESOURCE_ID);
        Truth.assertThat((Boolean)readChannel.isOpen()).isTrue();
        Truth.assertThat((Long)readChannel.position()).isEqualTo((Object)0);
        RuntimeException thrown = (RuntimeException)Assert.assertThrows(RuntimeException.class, () -> readChannel.read(ByteBuffer.allocate(1)));
        Truth.assertThat((Throwable)thrown).hasMessageThat().contains((CharSequence)"read RuntimeException");
        Truth.assertThat((Object)readChannel.contentChannel).isNull();
        Truth.assertThat((Long)readChannel.contentChannelPosition).isEqualTo((Object)-1);
        Truth.assertThat((Boolean)readChannel.isOpen()).isTrue();
        readChannel.close();
        Truth.assertThat((Boolean)readChannel.isOpen()).isFalse();
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(BUCKET_NAME, OBJECT_NAME, "contentEncoding,generation,size"), TrackingHttpRequestInitializer.getMediaRequestString(BUCKET_NAME, OBJECT_NAME, storageObject.getGeneration())}).inOrder();
    }

    @Test
    public void testCloseWithExceptionDuringClose() throws IOException {
        ThrowingInputStream failedStream = new ThrowingInputStream(null, (Throwable)new SSLException("close SSLException"));
        StorageObject storageObject = GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, OBJECT_NAME);
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)storageObject), MockHttpTransportHelper.inputStreamResponse((String)"Content-Length", (Object)1, (InputStream)failedStream)});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        GoogleCloudStorageReadChannel readChannel = (GoogleCloudStorageReadChannel)gcs.open(RESOURCE_ID);
        Truth.assertThat((Boolean)readChannel.isOpen()).isTrue();
        Truth.assertThat((Long)readChannel.position()).isEqualTo((Object)0);
        readChannel.performLazySeek(1L);
        Truth.assertThat((Object)readChannel.contentChannel).isNotNull();
        readChannel.close();
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(BUCKET_NAME, OBJECT_NAME, "contentEncoding,generation,size"), TrackingHttpRequestInitializer.getMediaRequestString(BUCKET_NAME, OBJECT_NAME, storageObject.getGeneration())}).inOrder();
    }

    @Test
    public void testOpenAndReadWithPrematureEndOfStreamRetriesFail() throws Exception {
        int testLength = 5;
        byte[] truncatedData = new byte[]{1, 2, 3};
        byte[] truncatedRetryData = new byte[]{17};
        StorageObject storageObject = GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, OBJECT_NAME);
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)storageObject), MockHttpTransportHelper.inputStreamResponse((String)"Content-Length", (Object)testLength, (InputStream)new ByteArrayInputStream(truncatedData)), MockHttpTransportHelper.inputStreamResponse((String)"Content-Length", (Object)2, (InputStream)new ByteArrayInputStream(truncatedRetryData)), MockHttpTransportHelper.inputStreamResponse((String)"Content-Length", (Object)1, (InputStream)new ByteArrayInputStream(new byte[0]))});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        GoogleCloudStorageReadChannel readChannel = (GoogleCloudStorageReadChannel)gcs.open(RESOURCE_ID);
        readChannel.setMaxRetries(1);
        Truth.assertThat((Boolean)readChannel.isOpen()).isTrue();
        Truth.assertThat((Long)readChannel.position()).isEqualTo((Object)0);
        byte[] actualData = new byte[testLength];
        Assert.assertThrows(IOException.class, () -> readChannel.read(ByteBuffer.wrap(actualData)));
        Truth.assertThat((byte[])actualData).isEqualTo((Object)new byte[]{1, 2, 3, 17, 0});
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(BUCKET_NAME, OBJECT_NAME, "contentEncoding,generation,size"), TrackingHttpRequestInitializer.getMediaRequestString(BUCKET_NAME, OBJECT_NAME, storageObject.getGeneration()), TrackingHttpRequestInitializer.getMediaRequestString(BUCKET_NAME, OBJECT_NAME, storageObject.getGeneration()), TrackingHttpRequestInitializer.getMediaRequestString(BUCKET_NAME, OBJECT_NAME, storageObject.getGeneration())}).inOrder();
    }

    @Test
    public void testOpenAndReadWithPrematureEndOfStreamRetriesSucceed() throws Exception {
        byte[] testData = new byte[]{1, 2, 3, 17, 33};
        byte[] firstReadData = new byte[]{1, 2, 3};
        byte[] secondReadData = new byte[]{17};
        byte[] thirdReadData = new byte[]{33};
        StorageObject storageObject = GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, OBJECT_NAME);
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)storageObject), MockHttpTransportHelper.inputStreamResponse((String)"Content-Length", (Object)testData.length, (InputStream)new ByteArrayInputStream(firstReadData)), MockHttpTransportHelper.inputStreamResponse((String)"Content-Length", (Object)2, (InputStream)new ByteArrayInputStream(secondReadData)), MockHttpTransportHelper.inputStreamResponse((String)"Content-Length", (Object)1, (InputStream)new ByteArrayInputStream(thirdReadData))});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        GoogleCloudStorageReadChannel readChannel = (GoogleCloudStorageReadChannel)gcs.open(RESOURCE_ID);
        Truth.assertThat((Boolean)readChannel.isOpen()).isTrue();
        Truth.assertThat((Long)readChannel.position()).isEqualTo((Object)0);
        byte[] actualData = new byte[testData.length];
        int bytesRead = readChannel.read(ByteBuffer.wrap(actualData));
        Truth.assertThat((Integer)bytesRead).isEqualTo((Object)testData.length);
        Truth.assertThat((byte[])actualData).isEqualTo((Object)testData);
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(BUCKET_NAME, OBJECT_NAME, "contentEncoding,generation,size"), TrackingHttpRequestInitializer.getMediaRequestString(BUCKET_NAME, OBJECT_NAME, storageObject.getGeneration()), TrackingHttpRequestInitializer.getMediaRequestString(BUCKET_NAME, OBJECT_NAME, storageObject.getGeneration()), TrackingHttpRequestInitializer.getMediaRequestString(BUCKET_NAME, OBJECT_NAME, storageObject.getGeneration())}).inOrder();
    }

    @Test
    public void open_exceptionsDuringRead_totalElapsedTimeTooGreat() throws Exception {
        IOException readException1 = new IOException("read IOException #1");
        IOException readException2 = new IOException("read IOException #2");
        NanoClock fakeNanoClock = new NanoClock(){
            private final ImmutableList<Duration> fakeValues = ImmutableList.of((Object)Duration.ofMillis(1L), (Object)Duration.ofMillis(2L), (Object)Duration.ofMillis(3L), (Object)Duration.ofMillis(3L).plus(GoogleCloudStorageReadOptions.DEFAULT.getBackoffMaxElapsedTime()));
            private final AtomicInteger fakeValueIndex = new AtomicInteger(0);

            public long nanoTime() {
                return ((Duration)this.fakeValues.get(this.fakeValueIndex.getAndIncrement())).toNanos();
            }
        };
        StorageObject storageObject = GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, OBJECT_NAME);
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)storageObject), MockHttpTransportHelper.inputStreamResponse((String)"Content-Length", (Object)1, (InputStream)new ThrowingInputStream((Throwable)readException1)), MockHttpTransportHelper.inputStreamResponse((String)"Content-Length", (Object)1, (InputStream)new ThrowingInputStream((Throwable)readException2))});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        GoogleCloudStorageReadChannel readChannel = (GoogleCloudStorageReadChannel)gcs.open(RESOURCE_ID);
        readChannel.setReadBackOff((BackOff)new ExponentialBackOff.Builder().setMaxElapsedTimeMillis(Math.toIntExact(GoogleCloudStorageReadOptions.DEFAULT.getBackoffMaxElapsedTime().toMillis())).setNanoClock(fakeNanoClock).build());
        Truth.assertThat((Boolean)readChannel.isOpen()).isTrue();
        Truth.assertThat((Long)readChannel.position()).isEqualTo((Object)0);
        IOException thrown = (IOException)Assert.assertThrows(IOException.class, () -> readChannel.read(ByteBuffer.allocate(1)));
        Truth.assertThat((Throwable)thrown).isSameInstanceAs((Object)readException2);
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(BUCKET_NAME, OBJECT_NAME, "contentEncoding,generation,size"), TrackingHttpRequestInitializer.getMediaRequestString(BUCKET_NAME, OBJECT_NAME, storageObject.getGeneration()), TrackingHttpRequestInitializer.getMediaRequestString(BUCKET_NAME, OBJECT_NAME, storageObject.getGeneration())}).inOrder();
    }

    @Test
    public void open_exceptionsDuringRead_interruptedDuringSleep() throws Exception {
        InterruptedException sleepException = new InterruptedException("sleep InterruptedException");
        Sleeper throwingSleeper = millis -> {
            throw sleepException;
        };
        StorageObject storageObject = GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, OBJECT_NAME);
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)storageObject), MockHttpTransportHelper.inputStreamResponse((String)"Content-Length", (Object)1, (InputStream)new ThrowingInputStream((Throwable)new IOException("read IOException")))});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        GoogleCloudStorageReadChannel readChannel = (GoogleCloudStorageReadChannel)gcs.open(RESOURCE_ID);
        readChannel.setSleeper(throwingSleeper);
        Truth.assertThat((Boolean)readChannel.isOpen()).isTrue();
        Truth.assertThat((Long)readChannel.position()).isEqualTo((Object)0);
        IOException thrown = (IOException)Assert.assertThrows(IOException.class, () -> readChannel.read(ByteBuffer.allocate(1)));
        Truth.assertThat((Throwable)thrown).hasMessageThat().isEqualTo((Object)"read IOException");
        Truth.assertThat((Object[])thrown.getSuppressed()).isEqualTo((Object)new Throwable[]{sleepException});
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(BUCKET_NAME, OBJECT_NAME, "contentEncoding,generation,size"), TrackingHttpRequestInitializer.getMediaRequestString(BUCKET_NAME, OBJECT_NAME, storageObject.getGeneration())}).inOrder();
    }

    @Test
    public void testOpenTooManyExceptionsDuringRead() throws Exception {
        ThrowingInputStream timeoutStream = new ThrowingInputStream((Throwable)new SocketTimeoutException("read timeout"));
        ThrowingInputStream sslExceptionStream = new ThrowingInputStream((Throwable)new SSLException("read SSLException"));
        IOException readIOException = new IOException("read IOException");
        StorageObject storageObject = GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, OBJECT_NAME);
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)storageObject), MockHttpTransportHelper.inputStreamResponse((String)"Content-Length", (Object)1, (InputStream)timeoutStream), MockHttpTransportHelper.inputStreamResponse((String)"Content-Length", (Object)1, (InputStream)sslExceptionStream), MockHttpTransportHelper.inputStreamResponse((String)"Content-Length", (Object)1, (InputStream)new ThrowingInputStream((Throwable)readIOException))});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        GoogleCloudStorageReadChannel readChannel = (GoogleCloudStorageReadChannel)gcs.open(RESOURCE_ID);
        readChannel.setMaxRetries(2);
        Truth.assertThat((Boolean)readChannel.isOpen()).isTrue();
        Truth.assertThat((Long)readChannel.position()).isEqualTo((Object)0);
        IOException thrown = (IOException)Assert.assertThrows(IOException.class, () -> readChannel.read(ByteBuffer.allocate(1)));
        Truth.assertThat((Throwable)thrown).isSameInstanceAs((Object)readIOException);
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(BUCKET_NAME, OBJECT_NAME, "contentEncoding,generation,size"), TrackingHttpRequestInitializer.getMediaRequestString(BUCKET_NAME, OBJECT_NAME, storageObject.getGeneration()), TrackingHttpRequestInitializer.getMediaRequestString(BUCKET_NAME, OBJECT_NAME, storageObject.getGeneration()), TrackingHttpRequestInitializer.getMediaRequestString(BUCKET_NAME, OBJECT_NAME, storageObject.getGeneration())}).inOrder();
    }

    @Test
    public void testOpenTwoTimeoutsWithIntermittentProgress() throws Exception {
        final byte[] testData = new byte[]{1, 2, 3, 5, 8};
        byte[] testData2 = new byte[]{5, 8};
        ThrowingInputStream timeoutStream = new ThrowingInputStream((Throwable)new SocketTimeoutException("read timeout #1"));
        InputStream intermittentProgressTimeoutStream = new InputStream(){
            final int[] readData;
            int readDataIndex;
            {
                this.readData = new int[]{testData[0], testData[1], -1, testData[2], -1, -1};
                this.readDataIndex = 0;
            }

            @Override
            public int available() {
                return 1;
            }

            @Override
            public int read() throws IOException {
                Truth.assertThat((Integer)this.readDataIndex).isAtMost((Comparable)Integer.valueOf(this.readData.length));
                if (this.readData.length == this.readDataIndex) {
                    ++this.readDataIndex;
                    throw new SocketTimeoutException("read timeout #2");
                }
                return this.readData[this.readDataIndex++];
            }
        };
        StorageObject storageObject = GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, OBJECT_NAME);
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)storageObject), MockHttpTransportHelper.inputStreamResponse((String)"Content-Length", (Object)testData.length, (InputStream)timeoutStream), MockHttpTransportHelper.inputStreamResponse((String)"Content-Length", (Object)testData.length, (InputStream)intermittentProgressTimeoutStream), MockHttpTransportHelper.inputStreamResponse((String)"Content-Length", (Object)testData.length, (InputStream)new ByteArrayInputStream(testData2))});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        GoogleCloudStorageReadChannel readChannel = (GoogleCloudStorageReadChannel)gcs.open(RESOURCE_ID);
        readChannel.setMaxRetries(1);
        Truth.assertThat((Boolean)readChannel.isOpen()).isTrue();
        Truth.assertThat((Long)readChannel.position()).isEqualTo((Object)0);
        byte[] actualData = new byte[testData.length];
        int bytesRead = readChannel.read(ByteBuffer.wrap(actualData));
        Truth.assertThat((Long)readChannel.position()).isEqualTo((Object)5);
        Truth.assertThat((Integer)bytesRead).isEqualTo((Object)testData.length);
        Truth.assertThat((byte[])actualData).isEqualTo((Object)testData);
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(BUCKET_NAME, OBJECT_NAME, "contentEncoding,generation,size"), TrackingHttpRequestInitializer.getMediaRequestString(BUCKET_NAME, OBJECT_NAME, storageObject.getGeneration()), TrackingHttpRequestInitializer.getMediaRequestString(BUCKET_NAME, OBJECT_NAME, storageObject.getGeneration()), TrackingHttpRequestInitializer.getMediaRequestString(BUCKET_NAME, OBJECT_NAME, storageObject.getGeneration())}).inOrder();
    }

    @Test
    public void testOpenGzippedObjectNormalOperation() throws IOException {
        byte[] testData = new byte[1024];
        new Random().nextBytes(testData);
        byte[] compressedData = GoogleCloudStorageTest.gzip(testData);
        ImmutableMap responseHeaders = ImmutableMap.of((Object)"Content-Length", (Object)compressedData.length, (Object)"Content-Encoding", (Object)"gzip");
        StorageObject storageObject = GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, OBJECT_NAME).setSize(BigInteger.valueOf(compressedData.length)).setContentEncoding("gzip");
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)storageObject), MockHttpTransportHelper.dataResponse((Map)responseHeaders, (byte[])compressedData), MockHttpTransportHelper.dataResponse((Map)responseHeaders, (byte[])compressedData), MockHttpTransportHelper.dataResponse((Map)responseHeaders, (byte[])compressedData)});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        GoogleCloudStorageReadOptions readOptions = GoogleCloudStorageReadOptions.builder().setGzipEncodingSupportEnabled(true).build();
        GoogleCloudStorageReadChannel readChannel = (GoogleCloudStorageReadChannel)gcs.open(RESOURCE_ID, readOptions);
        Truth.assertThat((Boolean)readChannel.isOpen()).isTrue();
        Truth.assertThat((Long)readChannel.position()).isEqualTo((Object)0);
        Truth.assertThat((Long)readChannel.size()).isEqualTo((Object)Long.MAX_VALUE);
        byte[] actualData = new byte[testData.length];
        int bytesRead = readChannel.read(ByteBuffer.wrap(actualData));
        Truth.assertThat((Integer)bytesRead).isEqualTo((Object)testData.length);
        Truth.assertThat((Long)readChannel.size()).isEqualTo((Object)Long.MAX_VALUE);
        Truth.assertThat((Object)readChannel.contentChannel).isNotNull();
        Truth.assertThat((byte[])actualData).isEqualTo((Object)testData);
        Truth.assertThat((Long)readChannel.position()).isEqualTo((Object)testData.length);
        Assert.assertThrows(EOFException.class, () -> readChannel.position(-1L));
        readChannel.position(2L);
        Truth.assertThat((Boolean)readChannel.isOpen()).isTrue();
        Truth.assertThat((Long)readChannel.position()).isEqualTo((Object)2);
        byte[] partialData = Arrays.copyOfRange(testData, 2, testData.length);
        actualData = new byte[partialData.length];
        bytesRead = readChannel.read(ByteBuffer.wrap(actualData));
        Truth.assertThat((Integer)bytesRead).isEqualTo((Object)partialData.length);
        Truth.assertThat((Long)readChannel.size()).isEqualTo((Object)Long.MAX_VALUE);
        Truth.assertThat((byte[])actualData).isEqualTo((Object)partialData);
        Truth.assertThat((Long)readChannel.position()).isEqualTo((Object)testData.length);
        readChannel.position((long)(testData.length / 2));
        Truth.assertThat((Boolean)readChannel.isOpen()).isTrue();
        Truth.assertThat((Long)readChannel.position()).isEqualTo((Object)(testData.length / 2));
        partialData = Arrays.copyOfRange(testData, testData.length / 2, testData.length);
        actualData = new byte[partialData.length];
        bytesRead = readChannel.read(ByteBuffer.wrap(actualData));
        Truth.assertThat((Integer)bytesRead).isEqualTo((Object)partialData.length);
        Truth.assertThat((Long)readChannel.size()).isEqualTo((Object)Long.MAX_VALUE);
        Truth.assertThat((byte[])actualData).isEqualTo((Object)partialData);
        Truth.assertThat((Long)readChannel.position()).isEqualTo((Object)testData.length);
        partialData = new byte[1];
        actualData = new byte[partialData.length];
        bytesRead = readChannel.read(ByteBuffer.wrap(actualData));
        Truth.assertThat((Integer)bytesRead).isEqualTo((Object)-1);
        Truth.assertThat((Long)readChannel.size()).isEqualTo((Object)testData.length);
        Truth.assertThat((byte[])actualData).isEqualTo((Object)partialData);
        Truth.assertThat((Long)readChannel.position()).isEqualTo((Object)testData.length);
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(BUCKET_NAME, OBJECT_NAME, "contentEncoding,generation,size"), TrackingHttpRequestInitializer.getMediaRequestString(BUCKET_NAME, OBJECT_NAME, storageObject.getGeneration()), TrackingHttpRequestInitializer.getMediaRequestString(BUCKET_NAME, OBJECT_NAME, storageObject.getGeneration()), TrackingHttpRequestInitializer.getMediaRequestString(BUCKET_NAME, OBJECT_NAME, storageObject.getGeneration())}).inOrder();
    }

    @Test
    public void testOpenNoSupportGzipEncodingAndNoFailFastOnNotFound() throws Exception {
        byte[] testData = new byte[]{1, 2, 3, 5, 8};
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.dataResponse((byte[])testData)});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        GoogleCloudStorageReadOptions readOptions = GoogleCloudStorageReadOptions.builder().setGzipEncodingSupportEnabled(false).setFastFailOnNotFoundEnabled(false).build();
        GoogleCloudStorageReadChannel readChannel = (GoogleCloudStorageReadChannel)gcs.open(RESOURCE_ID, readOptions);
        byte[] actualData = new byte[testData.length];
        int bytesRead = readChannel.read(ByteBuffer.wrap(actualData));
        Truth.assertThat((Integer)bytesRead).isEqualTo((Object)testData.length);
        Truth.assertThat((byte[])actualData).isEqualTo((Object)testData);
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getMediaRequestString(BUCKET_NAME, OBJECT_NAME)}).inOrder();
    }

    @Test
    public void testOpenItemInfoNoSupportGzipEncodingAndNoFailFastOnNotFound() throws Exception {
        byte[] testData = new byte[]{1, 2, 3, 5, 8};
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.dataResponse((byte[])testData)});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        GoogleCloudStorageReadOptions readOptions = GoogleCloudStorageReadOptions.builder().setGzipEncodingSupportEnabled(false).setFastFailOnNotFoundEnabled(false).build();
        StorageObject storageObject = GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, OBJECT_NAME);
        GoogleCloudStorageItemInfo itemInfo = GoogleCloudStorageImpl.createItemInfoForStorageObject((StorageResourceId)RESOURCE_ID, (StorageObject)storageObject);
        GoogleCloudStorageReadChannel readChannel = (GoogleCloudStorageReadChannel)gcs.open(itemInfo, readOptions);
        byte[] actualData = new byte[testData.length];
        int bytesRead = readChannel.read(ByteBuffer.wrap(actualData));
        Truth.assertThat((Integer)bytesRead).isEqualTo((Object)testData.length);
        Truth.assertThat((byte[])actualData).isEqualTo((Object)testData);
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).contains((Object)TrackingHttpRequestInitializer.getMediaRequestString(BUCKET_NAME, OBJECT_NAME, itemInfo.getContentGeneration()));
    }

    @Test
    public void testInplaceSeekSmallerThanSeekLimit() throws Exception {
        byte[] testData = new byte[]{1, 2, 3, 5, 8};
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.dataResponse((byte[])testData)});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        GoogleCloudStorageReadChannel readChannel = (GoogleCloudStorageReadChannel)gcs.open(RESOURCE_ID, GoogleCloudStorageReadOptions.builder().setFastFailOnNotFoundEnabled(false).setInplaceSeekLimit(2L).build());
        byte[] actualData = new byte[1];
        int bytesRead = readChannel.read(ByteBuffer.wrap(actualData));
        Truth.assertThat((Integer)bytesRead).isEqualTo((Object)1);
        Truth.assertThat((byte[])actualData).isEqualTo((Object)new byte[]{1});
        readChannel.position(3L);
        Truth.assertThat((Long)readChannel.position()).isEqualTo((Object)3);
        actualData = new byte[2];
        bytesRead = readChannel.read(ByteBuffer.wrap(actualData));
        Truth.assertThat((Integer)bytesRead).isEqualTo((Object)2);
        Truth.assertThat((byte[])actualData).isEqualTo((Object)new byte[]{5, 8});
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getMediaRequestString(BUCKET_NAME, OBJECT_NAME)}).inOrder();
    }

    @Test
    public void testInplaceSeekLargerThanSeekBuffer() throws Exception {
        byte[] testData = new byte[16384];
        new Random().nextBytes(testData);
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.dataResponse((byte[])testData)});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        GoogleCloudStorageReadOptions readOptions = GoogleCloudStorageReadOptions.builder().setFastFailOnNotFoundEnabled(false).setInplaceSeekLimit((long)testData.length).build();
        SeekableByteChannel readChannel = gcs.open(RESOURCE_ID, readOptions);
        byte[] actualData = new byte[1];
        int bytesRead = readChannel.read(ByteBuffer.wrap(actualData));
        Truth.assertThat((Integer)bytesRead).isEqualTo((Object)1);
        Truth.assertThat((byte[])actualData).isEqualTo((Object)new byte[]{testData[0]});
        int jumpPosition = 8195;
        readChannel.position(jumpPosition);
        Truth.assertThat((Long)readChannel.position()).isEqualTo((Object)jumpPosition);
        actualData = new byte[2];
        bytesRead = readChannel.read(ByteBuffer.wrap(actualData));
        Truth.assertThat((Integer)bytesRead).isEqualTo((Object)2);
        Truth.assertThat((byte[])actualData).isEqualTo((Object)new byte[]{testData[jumpPosition], testData[jumpPosition + 1]});
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getMediaRequestString(BUCKET_NAME, OBJECT_NAME)}).inOrder();
    }

    @Test
    public void testUnusedBackwardSeekIgnored() throws Exception {
        byte[] testData = new byte[]{1, 2, 3, 5, 8};
        StorageObject storageObject = GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, OBJECT_NAME);
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)storageObject), MockHttpTransportHelper.dataResponse((byte[])testData), MockHttpTransportHelper.dataResponse((byte[])testData)});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        GoogleCloudStorageReadChannel readChannel = (GoogleCloudStorageReadChannel)gcs.open(RESOURCE_ID, GoogleCloudStorageReadOptions.builder().setInplaceSeekLimit(2L).build());
        byte[] actualData = new byte[1];
        int bytesRead = readChannel.read(ByteBuffer.wrap(actualData));
        Truth.assertThat((Long)readChannel.position()).isEqualTo((Object)1);
        Truth.assertThat((Integer)bytesRead).isEqualTo((Object)1);
        Truth.assertThat((byte[])actualData).isEqualTo((Object)new byte[]{1});
        readChannel.position(0L);
        Truth.assertThat((Long)readChannel.position()).isEqualTo((Object)0);
        readChannel.position(3L);
        Truth.assertThat((Long)readChannel.position()).isEqualTo((Object)3);
        actualData = new byte[2];
        bytesRead = readChannel.read(ByteBuffer.wrap(actualData));
        Truth.assertThat((Long)readChannel.position()).isEqualTo((Object)5);
        Truth.assertThat((Integer)bytesRead).isEqualTo((Object)2);
        Truth.assertThat((byte[])actualData).isEqualTo((Object)new byte[]{5, 8});
        readChannel.position(0L);
        actualData = new byte[2];
        bytesRead = readChannel.read(ByteBuffer.wrap(actualData));
        Truth.assertThat((Long)readChannel.position()).isEqualTo((Object)2);
        Truth.assertThat((Integer)bytesRead).isEqualTo((Object)2);
        Truth.assertThat((byte[])actualData).isEqualTo((Object)new byte[]{1, 2});
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(BUCKET_NAME, OBJECT_NAME, "contentEncoding,generation,size"), TrackingHttpRequestInitializer.getMediaRequestString(BUCKET_NAME, OBJECT_NAME, storageObject.getGeneration()), TrackingHttpRequestInitializer.getMediaRequestString(BUCKET_NAME, OBJECT_NAME, storageObject.getGeneration())}).inOrder();
    }

    @Test
    public void testOpenGzippedObjectExceptionsDuringRead() throws Exception {
        byte[] testData = new byte[1024];
        new Random().nextBytes(testData);
        byte[] compressedData = GoogleCloudStorageTest.gzip(testData);
        ImmutableMap responseHeaders = ImmutableMap.of((Object)"Content-Length", (Object)compressedData.length, (Object)"Content-Encoding", (Object)"gzip");
        StorageObject storageObject = GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, OBJECT_NAME).setSize(BigInteger.valueOf(compressedData.length)).setContentEncoding("gzip");
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)storageObject), MockHttpTransportHelper.inputStreamResponse((Map)responseHeaders, (InputStream)GoogleCloudStorageTest.partialReadTimeoutStream(compressedData, 0.25, "read timeout #1")), MockHttpTransportHelper.inputStreamResponse((Map)responseHeaders, (InputStream)GoogleCloudStorageTest.partialReadTimeoutStream(compressedData, 0.75, "read timeout #2")), MockHttpTransportHelper.inputStreamResponse((Map)responseHeaders, (InputStream)new ByteArrayInputStream(compressedData))});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        GoogleCloudStorageReadOptions readOptions = GoogleCloudStorageReadOptions.builder().setGzipEncodingSupportEnabled(true).build();
        GoogleCloudStorageReadChannel readChannel = (GoogleCloudStorageReadChannel)gcs.open(RESOURCE_ID, readOptions);
        readChannel.setReadBackOff(BackOff.ZERO_BACKOFF);
        Truth.assertThat((Boolean)readChannel.isOpen()).isTrue();
        Truth.assertThat((Long)readChannel.position()).isEqualTo((Object)0);
        byte[] actualData = new byte[testData.length];
        int bytesRead = readChannel.read(ByteBuffer.wrap(actualData));
        Truth.assertThat((Long)readChannel.position()).isEqualTo((Object)testData.length);
        Truth.assertThat((Integer)bytesRead).isEqualTo((Object)testData.length);
        Truth.assertThat((byte[])actualData).isEqualTo((Object)testData);
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(BUCKET_NAME, OBJECT_NAME, "contentEncoding,generation,size"), TrackingHttpRequestInitializer.getMediaRequestString(BUCKET_NAME, OBJECT_NAME, storageObject.getGeneration()), TrackingHttpRequestInitializer.getMediaRequestString(BUCKET_NAME, OBJECT_NAME, storageObject.getGeneration()), TrackingHttpRequestInitializer.getMediaRequestString(BUCKET_NAME, OBJECT_NAME, storageObject.getGeneration())}).inOrder();
    }

    @Test
    public void testOpenObjectNormalOperation() throws IOException {
        byte[] testData = new byte[]{1, 2, 17, 18, 19};
        byte[] testData2 = new byte[]{17, 18, 19};
        StorageObject storageObject = GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, OBJECT_NAME).setSize(BigInteger.valueOf(testData.length));
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)storageObject), MockHttpTransportHelper.dataResponse((byte[])testData), MockHttpTransportHelper.dataResponse((byte[])testData2)});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        GoogleCloudStorageReadChannel readChannel = (GoogleCloudStorageReadChannel)gcs.open(RESOURCE_ID);
        Truth.assertThat((Boolean)readChannel.isOpen()).isTrue();
        Truth.assertThat((Long)readChannel.position()).isEqualTo((Object)0);
        byte[] actualData = new byte[testData.length];
        int bytesRead = readChannel.read(ByteBuffer.wrap(actualData));
        Truth.assertThat((Integer)bytesRead).isEqualTo((Object)testData.length);
        Truth.assertThat((byte[])actualData).isEqualTo((Object)testData);
        Truth.assertThat((Object)readChannel.contentChannel).isNotNull();
        Truth.assertThat((Long)readChannel.position()).isEqualTo((Object)testData.length);
        readChannel.position(2L);
        Truth.assertThat((Boolean)readChannel.isOpen()).isTrue();
        Truth.assertThat((Long)readChannel.position()).isEqualTo((Object)2);
        Assert.assertThrows(EOFException.class, () -> readChannel.position(-1L));
        Assert.assertThrows(EOFException.class, () -> readChannel.position((long)testData.length));
        readChannel.position(2L);
        Truth.assertThat((Boolean)readChannel.isOpen()).isTrue();
        Truth.assertThat((Long)readChannel.position()).isEqualTo((Object)2);
        Truth.assertThat((Integer)readChannel.read(ByteBuffer.wrap(new byte[0]))).isEqualTo((Object)0);
        Truth.assertThat((Boolean)readChannel.isOpen()).isTrue();
        Truth.assertThat((Long)readChannel.position()).isEqualTo((Object)2);
        actualData = new byte[testData2.length];
        bytesRead = readChannel.read(ByteBuffer.wrap(actualData));
        Truth.assertThat((Integer)bytesRead).isEqualTo((Object)testData2.length);
        Truth.assertThat((byte[])actualData).isEqualTo((Object)testData2);
        Truth.assertThat((Long)readChannel.position()).isEqualTo((Object)testData.length);
        readChannel.close();
        Truth.assertThat((Boolean)readChannel.isOpen()).isFalse();
        Assert.assertThrows(ClosedChannelException.class, () -> readChannel.read(ByteBuffer.allocate(1)));
        Assert.assertThrows(ClosedChannelException.class, () -> readChannel.position(0L));
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(BUCKET_NAME, OBJECT_NAME, "contentEncoding,generation,size"), TrackingHttpRequestInitializer.getMediaRequestString(BUCKET_NAME, OBJECT_NAME, storageObject.getGeneration())}).inOrder();
    }

    @Test
    public void testOpenObjectApiException() throws IOException {
        StorageObject storageObject1 = GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, OBJECT_NAME);
        StorageObject storageObject2 = GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, OBJECT_NAME);
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonErrorResponse((MockHttpTransportHelper.ErrorResponses)MockHttpTransportHelper.ErrorResponses.NOT_FOUND), MockHttpTransportHelper.jsonDataResponse((Object)storageObject1), MockHttpTransportHelper.jsonErrorResponse((MockHttpTransportHelper.ErrorResponses)MockHttpTransportHelper.ErrorResponses.RANGE_NOT_SATISFIABLE), MockHttpTransportHelper.jsonDataResponse((Object)storageObject2), MockHttpTransportHelper.jsonErrorResponse((MockHttpTransportHelper.ErrorResponses)MockHttpTransportHelper.ErrorResponses.GONE)});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        StorageResourceId objectId = RESOURCE_ID;
        Assert.assertThrows(FileNotFoundException.class, () -> GoogleCloudStorageTest.lambda$testOpenObjectApiException$15((GoogleCloudStorage)gcs, objectId));
        SeekableByteChannel readChannel2 = gcs.open(objectId);
        EOFException thrown2 = (EOFException)Assert.assertThrows(EOFException.class, () -> readChannel2.read(ByteBuffer.allocate(1)));
        String expectedErrorMessage = MockHttpTransportHelper.ErrorResponses.RANGE_NOT_SATISFIABLE.getErrorMessage();
        Truth.assertThat((Throwable)thrown2).hasCauseThat().hasMessageThat().contains((CharSequence)expectedErrorMessage);
        SeekableByteChannel readChannel3 = gcs.open(objectId);
        IOException thrown3 = (IOException)Assert.assertThrows(IOException.class, () -> readChannel3.read(ByteBuffer.allocate(1)));
        Truth.assertThat((Throwable)thrown3).hasMessageThat().isEqualTo((Object)String.format("Error reading 'gs://%s/%s' at position 0", BUCKET_NAME, OBJECT_NAME));
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(BUCKET_NAME, OBJECT_NAME, "contentEncoding,generation,size"), TrackingHttpRequestInitializer.getRequestString(BUCKET_NAME, OBJECT_NAME, "contentEncoding,generation,size"), TrackingHttpRequestInitializer.getMediaRequestString(BUCKET_NAME, OBJECT_NAME, storageObject1.getGeneration()), TrackingHttpRequestInitializer.getRequestString(BUCKET_NAME, OBJECT_NAME, "contentEncoding,generation,size"), TrackingHttpRequestInitializer.getMediaRequestString(BUCKET_NAME, OBJECT_NAME, storageObject2.getGeneration())}).inOrder();
    }

    @Test
    public void testCreateBucketIllegalArguments() throws IOException {
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GoogleCloudStorageTestUtils.HTTP_TRANSPORT);
        Assert.assertThrows(IllegalArgumentException.class, () -> GoogleCloudStorageTest.lambda$testCreateBucketIllegalArguments$18((GoogleCloudStorage)gcs));
        Assert.assertThrows(IllegalArgumentException.class, () -> GoogleCloudStorageTest.lambda$testCreateBucketIllegalArguments$19((GoogleCloudStorage)gcs));
    }

    @Test
    public void testCreateBucketNormalOperation() throws IOException {
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)GoogleCloudStorageTest.newBucket(BUCKET_NAME))});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        gcs.createBucket(BUCKET_NAME);
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.createBucketRequestString(PROJECT_ID)}).inOrder();
    }

    @Test
    public void testCreateBucketWithOptionsNormalOperation() throws IOException {
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)GoogleCloudStorageTest.newBucket(BUCKET_NAME))});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        String location = "some-location";
        String storageClass = "storage-class";
        CreateBucketOptions bucketOptions = CreateBucketOptions.builder().setLocation(location).setStorageClass(storageClass).build();
        gcs.createBucket(BUCKET_NAME, bucketOptions);
        Truth.assertThat((String)bucketOptions.getLocation()).isEqualTo((Object)location);
        Truth.assertThat((String)bucketOptions.getStorageClass()).isEqualTo((Object)storageClass);
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.createBucketRequestString(PROJECT_ID)}).inOrder();
    }

    @Test
    public void testCreateBucketApiException() throws Exception {
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonErrorResponse((MockHttpTransportHelper.ErrorResponses)MockHttpTransportHelper.ErrorResponses.GONE)});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        IOException exception = (IOException)Assert.assertThrows(IOException.class, () -> GoogleCloudStorageTest.lambda$testCreateBucketApiException$20((GoogleCloudStorage)gcs));
        Truth.assertThat((Throwable)exception).hasMessageThat().contains((CharSequence)("\"code\": " + MockHttpTransportHelper.ErrorResponses.GONE.getErrorCode()));
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.createBucketRequestString(PROJECT_ID)}).inOrder();
    }

    @Test
    public void testCreateBucketRateLimited() throws Exception {
        Bucket bucket = GoogleCloudStorageTest.newBucket(BUCKET_NAME);
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonErrorResponse((MockHttpTransportHelper.ErrorResponses)MockHttpTransportHelper.ErrorResponses.RATE_LIMITED), MockHttpTransportHelper.jsonDataResponse((Object)bucket)});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        gcs.createBucket(BUCKET_NAME);
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.createBucketRequestString(PROJECT_ID), TrackingHttpRequestInitializer.createBucketRequestString(PROJECT_ID)}).inOrder();
    }

    @Test
    public void testDeleteBucketIllegalArguments() throws IOException {
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GoogleCloudStorageTestUtils.HTTP_TRANSPORT);
        Assert.assertThrows(IllegalArgumentException.class, () -> GoogleCloudStorageTest.lambda$testDeleteBucketIllegalArguments$21((GoogleCloudStorage)gcs));
        Assert.assertThrows(IllegalArgumentException.class, () -> GoogleCloudStorageTest.lambda$testDeleteBucketIllegalArguments$22((GoogleCloudStorage)gcs));
    }

    @Test
    public void testDeleteBucketNormalOperation() throws IOException {
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.emptyResponse((int)204)});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        gcs.deleteBuckets((List)ImmutableList.of((Object)BUCKET_NAME));
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.deleteBucketRequestString(BUCKET_NAME)}).inOrder();
    }

    @Test
    public void testDeleteBucketApiException() throws Exception {
        String bucket1 = "foo-bucket1";
        String bucket2 = "foo-bucket2";
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.emptyResponse((int)500), MockHttpTransportHelper.jsonErrorResponse((MockHttpTransportHelper.ErrorResponses)MockHttpTransportHelper.ErrorResponses.NOT_FOUND)});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithoutRetries);
        Assert.assertThrows(IOException.class, () -> GoogleCloudStorageTest.lambda$testDeleteBucketApiException$23((GoogleCloudStorage)gcs, bucket1));
        Assert.assertThrows(FileNotFoundException.class, () -> GoogleCloudStorageTest.lambda$testDeleteBucketApiException$24((GoogleCloudStorage)gcs, bucket2));
        Truth.assertThat(this.trackingRequestInitializerWithoutRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.deleteBucketRequestString(bucket1), TrackingHttpRequestInitializer.deleteBucketRequestString(bucket2)}).inOrder();
    }

    @Test
    public void testDeleteBucketRateLimited() throws Exception {
        Bucket bucket = GoogleCloudStorageTest.newBucket(BUCKET_NAME);
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonErrorResponse((MockHttpTransportHelper.ErrorResponses)MockHttpTransportHelper.ErrorResponses.RATE_LIMITED), MockHttpTransportHelper.jsonDataResponse((Object)bucket)});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        gcs.deleteBuckets((List)ImmutableList.of((Object)BUCKET_NAME));
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.deleteBucketRequestString(BUCKET_NAME), TrackingHttpRequestInitializer.deleteBucketRequestString(BUCKET_NAME)}).inOrder();
    }

    @Test
    public void testDeleteObjectIllegalArguments() throws IOException {
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GoogleCloudStorageTestUtils.HTTP_TRANSPORT);
        ILLEGAL_OBJECT_IDS.forEach(arg_0 -> GoogleCloudStorageTest.lambda$testDeleteObjectIllegalArguments$26((GoogleCloudStorage)gcs, arg_0));
    }

    @Test
    public void testDeleteObjectNormalOperation() throws IOException {
        this.trackingRequestInitializerWithRetries = new TrackingHttpRequestInitializer();
        StorageObject storageObject = GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, OBJECT_NAME);
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)storageObject), MockHttpTransportHelper.emptyResponse((int)204)});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        gcs.deleteObjects((List)Lists.newArrayList((Object[])new StorageResourceId[]{RESOURCE_ID}));
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(BUCKET_NAME, OBJECT_NAME, "generation"), TrackingHttpRequestInitializer.deleteRequestString(BUCKET_NAME, OBJECT_NAME, 1L)}).inOrder();
    }

    @Test
    public void testDeleteObjectWithGenerationId() throws IOException {
        int generationId = 65;
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.emptyResponse((int)204)});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        gcs.deleteObjects((List)ImmutableList.of((Object)new StorageResourceId(BUCKET_NAME, OBJECT_NAME, (long)generationId)));
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.deleteRequestString(BUCKET_NAME, OBJECT_NAME, generationId, false)}).inOrder();
    }

    @Test
    public void testCopyObjectsIllegalArguments() throws IOException {
        String b = BUCKET_NAME;
        ImmutableList o = ImmutableList.of((Object)OBJECT_NAME);
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GoogleCloudStorageTestUtils.HTTP_TRANSPORT);
        ILLEGAL_OBJECTS.forEach(arg_0 -> GoogleCloudStorageTest.lambda$testCopyObjectsIllegalArguments$29((GoogleCloudStorage)gcs, b, (List)o, arg_0));
        Assert.assertThrows(IllegalArgumentException.class, () -> GoogleCloudStorageTest.lambda$testCopyObjectsIllegalArguments$30((GoogleCloudStorage)gcs, b, (List)o));
        Assert.assertThrows(IllegalArgumentException.class, () -> GoogleCloudStorageTest.lambda$testCopyObjectsIllegalArguments$31((GoogleCloudStorage)gcs, b, (List)o));
        Assert.assertThrows(IllegalArgumentException.class, () -> GoogleCloudStorageTest.lambda$testCopyObjectsIllegalArguments$32((GoogleCloudStorage)gcs, b, (List)o));
        ImmutableList objects = ImmutableList.of((Object)"bar-object1", (Object)"bar-object2");
        Assert.assertThrows(IllegalArgumentException.class, () -> GoogleCloudStorageTest.lambda$testCopyObjectsIllegalArguments$33((GoogleCloudStorage)gcs, b, (List)o, (List)objects));
    }

    @Test
    public void testCopyObjectsNormalOperationSameBucket() throws IOException {
        String dstObject = "bar-object-copy";
        StorageObject object = GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, dstObject);
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)new Objects().setItems((List)ImmutableList.of((Object)object)))});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        gcs.copy(BUCKET_NAME, (List)ImmutableList.of((Object)OBJECT_NAME), BUCKET_NAME, (List)ImmutableList.of((Object)dstObject));
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.copyRequestString(BUCKET_NAME, OBJECT_NAME, BUCKET_NAME, dstObject, "copyTo")}).inOrder();
    }

    @Test
    public void testMoveObjectsIllegalArguments() throws IOException {
        String b = BUCKET_NAME;
        String o = OBJECT_NAME;
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GoogleCloudStorageTestUtils.HTTP_TRANSPORT);
        HashMap<StorageResourceId, StorageResourceId> sourceToDestinationObjectsMap = new HashMap<StorageResourceId, StorageResourceId>();
        sourceToDestinationObjectsMap.put(new StorageResourceId(b, o), new StorageResourceId(b, o));
        Assert.assertThrows(IllegalArgumentException.class, () -> GoogleCloudStorageTest.lambda$testMoveObjectsIllegalArguments$34((GoogleCloudStorage)gcs, sourceToDestinationObjectsMap));
        sourceToDestinationObjectsMap.clear();
        sourceToDestinationObjectsMap.put(new StorageResourceId(b, o), new StorageResourceId("other-bucket", o));
        Assert.assertThrows(UnsupportedOperationException.class, () -> GoogleCloudStorageTest.lambda$testMoveObjectsIllegalArguments$35((GoogleCloudStorage)gcs, sourceToDestinationObjectsMap));
    }

    @Test
    public void testMoveObjectsOperation() throws IOException {
        String dstObject = "bar-object-move";
        StorageObject object = GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, dstObject);
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)new Objects().setItems((List)ImmutableList.of((Object)object)))});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        HashMap<StorageResourceId, StorageResourceId> sourceToDestinationObjectsMap = new HashMap<StorageResourceId, StorageResourceId>(1);
        sourceToDestinationObjectsMap.put(new StorageResourceId(BUCKET_NAME, OBJECT_NAME), new StorageResourceId(BUCKET_NAME, dstObject));
        gcs.move(sourceToDestinationObjectsMap);
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.moveRequestString(BUCKET_NAME, OBJECT_NAME, dstObject, "moveTo")}).inOrder();
    }

    @Test
    public void testMoveObjectsSourceNotFound() throws IOException {
        String srcObject = "bar-object-src-nonexistent";
        String dstObject = "bar-object-move-dst";
        StorageResourceId srcId = new StorageResourceId(BUCKET_NAME, srcObject);
        StorageResourceId dstId = new StorageResourceId(BUCKET_NAME, dstObject);
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonErrorResponse((MockHttpTransportHelper.ErrorResponses)MockHttpTransportHelper.ErrorResponses.NOT_FOUND)});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithoutRetries);
        HashMap<StorageResourceId, StorageResourceId> sourceToDestinationObjectsMap = new HashMap<StorageResourceId, StorageResourceId>(1);
        sourceToDestinationObjectsMap.put(srcId, dstId);
        Assert.assertThrows(FileNotFoundException.class, () -> GoogleCloudStorageTest.lambda$testMoveObjectsSourceNotFound$36((GoogleCloudStorage)gcs, sourceToDestinationObjectsMap));
    }

    @Test
    public void testCopyObjectsNormalOperationDifferentBucket() throws IOException {
        String dstBucket = "foo-bucket-copy";
        String dstObject = "bar-object-copy";
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)GoogleCloudStorageTest.newBucket(BUCKET_NAME)), MockHttpTransportHelper.jsonDataResponse((Object)GoogleCloudStorageTest.newBucket(dstBucket)), MockHttpTransportHelper.dataResponse((byte[])"{\"done\": true}".getBytes(StandardCharsets.UTF_8))});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        gcs.copy(BUCKET_NAME, (List)ImmutableList.of((Object)OBJECT_NAME), dstBucket, (List)ImmutableList.of((Object)dstObject));
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getBucketRequestString(BUCKET_NAME), TrackingHttpRequestInitializer.getBucketRequestString(dstBucket), TrackingHttpRequestInitializer.copyRequestString(BUCKET_NAME, OBJECT_NAME, dstBucket, dstObject, "copyTo")}).inOrder();
    }

    @Test
    public void testCopyObjectsApiExceptionDifferentBucket() throws IOException {
        String dstObjectName = "bar-object-copy";
        String dstBucketName = "foo-bucket-copy";
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonErrorResponse((MockHttpTransportHelper.ErrorResponses)MockHttpTransportHelper.ErrorResponses.NOT_FOUND), MockHttpTransportHelper.jsonErrorResponse((MockHttpTransportHelper.ErrorResponses)MockHttpTransportHelper.ErrorResponses.GONE), MockHttpTransportHelper.jsonDataResponse((Object)GoogleCloudStorageTest.newBucket(BUCKET_NAME)), MockHttpTransportHelper.jsonErrorResponse((MockHttpTransportHelper.ErrorResponses)MockHttpTransportHelper.ErrorResponses.NOT_FOUND), MockHttpTransportHelper.jsonDataResponse((Object)GoogleCloudStorageTest.newBucket(BUCKET_NAME)), MockHttpTransportHelper.jsonErrorResponse((MockHttpTransportHelper.ErrorResponses)MockHttpTransportHelper.ErrorResponses.GONE)});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        ImmutableList srcObjectNames = ImmutableList.of((Object)OBJECT_NAME);
        ImmutableList dstObjectNames = ImmutableList.of((Object)dstObjectName);
        FileNotFoundException thrownSrcFileNotFoundException = (FileNotFoundException)Assert.assertThrows(FileNotFoundException.class, () -> GoogleCloudStorageTest.lambda$testCopyObjectsApiExceptionDifferentBucket$37((GoogleCloudStorage)gcs, srcObjectNames, dstBucketName, dstObjectNames));
        Truth.assertThat((Throwable)thrownSrcFileNotFoundException).hasMessageThat().contains((CharSequence)BUCKET_NAME);
        IOException srcIOException = (IOException)Assert.assertThrows(IOException.class, () -> GoogleCloudStorageTest.lambda$testCopyObjectsApiExceptionDifferentBucket$38((GoogleCloudStorage)gcs, srcObjectNames, dstBucketName, dstObjectNames));
        Truth.assertThat((Throwable)srcIOException).hasMessageThat().isEqualTo((Object)"Error accessing Bucket foo-bucket");
        FileNotFoundException dstFileNotFoundException = (FileNotFoundException)Assert.assertThrows(FileNotFoundException.class, () -> GoogleCloudStorageTest.lambda$testCopyObjectsApiExceptionDifferentBucket$39((GoogleCloudStorage)gcs, srcObjectNames, dstBucketName, dstObjectNames));
        Truth.assertThat((Throwable)dstFileNotFoundException).hasMessageThat().contains((CharSequence)dstBucketName);
        IOException dstIOException = (IOException)Assert.assertThrows(IOException.class, () -> GoogleCloudStorageTest.lambda$testCopyObjectsApiExceptionDifferentBucket$40((GoogleCloudStorage)gcs, srcObjectNames, dstBucketName, dstObjectNames));
        Truth.assertThat((Throwable)dstIOException).hasMessageThat().isEqualTo((Object)("Error accessing Bucket " + dstBucketName));
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getBucketRequestString(BUCKET_NAME), TrackingHttpRequestInitializer.getBucketRequestString(BUCKET_NAME), TrackingHttpRequestInitializer.getBucketRequestString(BUCKET_NAME), TrackingHttpRequestInitializer.getBucketRequestString(dstBucketName), TrackingHttpRequestInitializer.getBucketRequestString(BUCKET_NAME), TrackingHttpRequestInitializer.getBucketRequestString(dstBucketName)}).inOrder();
    }

    @Test
    public void testCopyObjectsIncompatibleBuckets() throws IOException {
        ImmutableList srcObject = ImmutableList.of((Object)OBJECT_NAME);
        String dstBucket = "foo-bucket-copy";
        ImmutableList dstObject = ImmutableList.of((Object)"bar-object-copy");
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)GoogleCloudStorageTest.newBucket(BUCKET_NAME).setLocation("us-east-incomp")), MockHttpTransportHelper.jsonDataResponse((Object)GoogleCloudStorageTest.newBucket(dstBucket)), MockHttpTransportHelper.jsonDataResponse((Object)GoogleCloudStorageTest.newBucket(BUCKET_NAME).setStorageClass("class-be2-incomp")), MockHttpTransportHelper.jsonDataResponse((Object)GoogleCloudStorageTest.newBucket(dstBucket))});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        UnsupportedOperationException locationException = (UnsupportedOperationException)Assert.assertThrows(UnsupportedOperationException.class, () -> GoogleCloudStorageTest.lambda$testCopyObjectsIncompatibleBuckets$41((GoogleCloudStorage)gcs, (List)srcObject, dstBucket, (List)dstObject));
        Truth.assertThat((Throwable)locationException).hasMessageThat().contains((CharSequence)"not supported");
        Truth.assertThat((Throwable)locationException).hasMessageThat().contains((CharSequence)"storage location");
        UnsupportedOperationException storageClassException = (UnsupportedOperationException)Assert.assertThrows(UnsupportedOperationException.class, () -> GoogleCloudStorageTest.lambda$testCopyObjectsIncompatibleBuckets$42((GoogleCloudStorage)gcs, (List)srcObject, dstBucket, (List)dstObject));
        Truth.assertThat((Throwable)storageClassException).hasMessageThat().contains((CharSequence)"not supported");
        Truth.assertThat((Throwable)storageClassException).hasMessageThat().contains((CharSequence)"storage class");
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getBucketRequestString(BUCKET_NAME), TrackingHttpRequestInitializer.getBucketRequestString(dstBucket), TrackingHttpRequestInitializer.getBucketRequestString(BUCKET_NAME), TrackingHttpRequestInitializer.getBucketRequestString(dstBucket)}).inOrder();
    }

    @Test
    public void testListBucketNames() throws IOException {
        ImmutableList buckets = ImmutableList.of((Object)GoogleCloudStorageTest.newBucket("bucket0"), (Object)GoogleCloudStorageTest.newBucket("bucket1"), (Object)GoogleCloudStorageTest.newBucket("bucket2"));
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)new Buckets().setItems((List)buckets))});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        List bucketNames = gcs.listBucketNames();
        Truth.assertThat((Iterable)bucketNames).containsExactly(new Object[]{"bucket0", "bucket1", "bucket2"}).inOrder();
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listBucketsRequestString(PROJECT_ID)}).inOrder();
    }

    @Test
    public void testListBucketInfo() throws IOException {
        ImmutableList buckets = ImmutableList.of((Object)GoogleCloudStorageTest.newBucket("bucket0"), (Object)GoogleCloudStorageTest.newBucket("bucket1"), (Object)GoogleCloudStorageTest.newBucket("bucket2"));
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)new Buckets().setItems((List)buckets))});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        List bucketInfos = gcs.listBucketInfo();
        Truth.assertThat((Iterable)bucketInfos).containsExactlyElementsIn(buckets.stream().map(b -> GoogleCloudStorageImpl.createItemInfoForBucket((StorageResourceId)new StorageResourceId(b.getName()), (Bucket)b)).toArray()).inOrder();
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listBucketsRequestString(PROJECT_ID)}).inOrder();
    }

    @Test
    public void testIsHnBucket_enabled() throws Exception {
        BucketStorageLayout layout = new BucketStorageLayout().setHierarchicalNamespace(new BucketStorageLayout.HierarchicalNamespace().setEnabled(Boolean.valueOf(true)));
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)layout)});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        String testHnsBucket = "hns-bucket-enabled";
        URI bucketUri = new URI("gs://" + testHnsBucket);
        boolean result = gcs.isHnBucket(bucketUri);
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getBucketStorageLayoutRequestString(testHnsBucket)}).inOrder();
        Truth.assertThat((Boolean)result).isTrue();
    }

    @Test
    public void testIsHnBucket_disabled() throws Exception {
        BucketStorageLayout layout = new BucketStorageLayout().setHierarchicalNamespace(new BucketStorageLayout.HierarchicalNamespace().setEnabled(Boolean.valueOf(false)));
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)layout)});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        String testHnsBucket = "hns-bucket-disabled";
        URI bucketUri = new URI("gs://" + testHnsBucket);
        boolean result = gcs.isHnBucket(bucketUri);
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getBucketStorageLayoutRequestString(testHnsBucket)}).inOrder();
        Truth.assertThat((Boolean)result).isFalse();
    }

    @Test
    public void listObjectInfo_objects() throws IOException {
        String prefix = "foo/bar/baz/";
        StorageObject object1 = GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, "foo/bar/baz/obj0");
        StorageObject object2 = GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, "foo/bar/baz/obj1");
        ImmutableList objects = ImmutableList.of((Object)GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, "foo/bar/baz/"), (Object)object1, (Object)object2);
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)new Objects().setItems((List)objects).setNextPageToken(null))});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        List objectInfos = gcs.listObjectInfo(BUCKET_NAME, prefix);
        Truth.assertThat((Iterable)objectInfos).containsExactly(new Object[]{GoogleCloudStorageImpl.createItemInfoForStorageObject((StorageResourceId)new StorageResourceId(BUCKET_NAME, object1.getName()), (StorageObject)object1), GoogleCloudStorageImpl.createItemInfoForStorageObject((StorageResourceId)new StorageResourceId(BUCKET_NAME, object2.getName()), (StorageObject)object2)}).inOrder();
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(BUCKET_NAME, prefix, null)}).inOrder();
    }

    @Test
    public void listObjectInfo_prefixesAndPrefixObjects() throws IOException {
        String objectPrefix = "foo/bar/baz/";
        StorageObject dir0 = GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, "foo/bar/baz/dir0/");
        StorageObject dir1 = GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, "foo/bar/baz/dir1/");
        ImmutableList objects = ImmutableList.of((Object)GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, objectPrefix), (Object)dir0, (Object)dir1);
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)new Objects().setPrefixes((List)ImmutableList.of((Object)dir0.getName(), (Object)dir1.getName())).setItems((List)objects).setNextPageToken(null))});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        List objectInfos = gcs.listObjectInfo(BUCKET_NAME, objectPrefix);
        this.trackingRequestInitializerWithRetries.getAllRequestStrings();
        Truth.assertThat((Iterable)objectInfos).containsExactly(new Object[]{GoogleCloudStorageImpl.createItemInfoForStorageObject((StorageObject)dir0), GoogleCloudStorageImpl.createItemInfoForStorageObject((StorageObject)dir1)}).inOrder();
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(BUCKET_NAME, objectPrefix, null)}).inOrder();
    }

    @Test
    public void listObjectInfo_prefixesAndObjects() throws IOException {
        String prefix = "foo/bar/baz/";
        String pageToken = "pageToken_0";
        StorageObject obj1 = GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, "foo/bar/baz/obj0");
        StorageObject obj2 = GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, "foo/bar/baz/obj1");
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)new Objects().setPrefixes((List)ImmutableList.of((Object)"foo/bar/baz/dir0/", (Object)"foo/bar/baz/dir1/")).setNextPageToken(pageToken)), MockHttpTransportHelper.jsonDataResponse((Object)new Objects().setItems((List)ImmutableList.of((Object)GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, "foo/bar/baz/"), (Object)obj1, (Object)obj2)).setNextPageToken(null))});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        List objects = gcs.listObjectInfo(BUCKET_NAME, prefix);
        Truth.assertThat((Iterable)objects).containsExactly(new Object[]{GoogleCloudStorageItemInfo.createInferredDirectory((StorageResourceId)new StorageResourceId(BUCKET_NAME, "foo/bar/baz/dir0/")), GoogleCloudStorageItemInfo.createInferredDirectory((StorageResourceId)new StorageResourceId(BUCKET_NAME, "foo/bar/baz/dir1/")), GoogleCloudStorageImpl.createItemInfoForStorageObject((StorageObject)obj1), GoogleCloudStorageImpl.createItemInfoForStorageObject((StorageObject)obj2)}).inOrder();
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(BUCKET_NAME, prefix, null), TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(BUCKET_NAME, prefix, pageToken)}).inOrder();
    }

    @Test
    public void listObjectInfo_includePrefix_emptyBucket() throws IOException {
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)new Objects())});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        List objects = gcs.listObjectInfo(BUCKET_NAME, null, INCLUDE_PREFIX_LIST_OPTIONS);
        Truth.assertThat((Iterable)objects).isEmpty();
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(BUCKET_NAME, null, null)}).inOrder();
    }

    @Test
    public void listObjectInfo_includePrefix_objectInBucket() throws IOException {
        StorageObject obj = GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, "obj");
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)new Objects().setItems((List)ImmutableList.of((Object)obj)))});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        List objects = gcs.listObjectInfo(BUCKET_NAME, null, INCLUDE_PREFIX_LIST_OPTIONS);
        Truth.assertThat((Iterable)objects).containsExactly(new Object[]{GoogleCloudStorageImpl.createItemInfoForStorageObject((StorageObject)obj)});
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(BUCKET_NAME, null, null)}).inOrder();
    }

    @Test
    public void listObjectInfo_includePrefix_implicitDirInBucket() throws IOException {
        String dirName = "dir/";
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)new Objects().setPrefixes((List)ImmutableList.of((Object)dirName)))});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        List objects = gcs.listObjectInfo(BUCKET_NAME, null, INCLUDE_PREFIX_LIST_OPTIONS);
        Truth.assertThat((Iterable)objects).containsExactly(new Object[]{GoogleCloudStorageItemInfo.createInferredDirectory((StorageResourceId)new StorageResourceId(BUCKET_NAME, dirName))});
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(BUCKET_NAME, null, null)}).inOrder();
    }

    @Test
    public void listObjectInfo_includePrefix_dirInBucket() throws IOException {
        String dirName = "dir/";
        StorageObject dir = GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, dirName);
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)new Objects().setItems((List)ImmutableList.of((Object)dir)).setPrefixes((List)ImmutableList.of((Object)dirName)))});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        List objects = gcs.listObjectInfo(BUCKET_NAME, null, INCLUDE_PREFIX_LIST_OPTIONS);
        Truth.assertThat((Iterable)objects).containsExactly(new Object[]{GoogleCloudStorageImpl.createItemInfoForStorageObject((StorageObject)dir)});
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(BUCKET_NAME, null, null)}).inOrder();
    }

    @Test
    public void listObjectInfo_includePrefix_prefixObjectDoesNotExist() throws IOException {
        String prefix = "foo/bar/baz/";
        String pageToken = "pageToken_0";
        StorageObject obj0 = GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, "foo/bar/baz/obj0");
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)new Objects().setPrefixes((List)ImmutableList.of((Object)"foo/bar/baz/dir0/")).setNextPageToken(pageToken)), MockHttpTransportHelper.jsonDataResponse((Object)new Objects().setItems((List)ImmutableList.of((Object)obj0)).setNextPageToken(null))});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        List objects = gcs.listObjectInfo(BUCKET_NAME, prefix, INCLUDE_PREFIX_LIST_OPTIONS);
        Truth.assertThat((Iterable)objects).containsExactly(new Object[]{GoogleCloudStorageItemInfo.createInferredDirectory((StorageResourceId)new StorageResourceId(BUCKET_NAME, "foo/bar/baz/")), GoogleCloudStorageItemInfo.createInferredDirectory((StorageResourceId)new StorageResourceId(BUCKET_NAME, "foo/bar/baz/dir0/")), GoogleCloudStorageImpl.createItemInfoForStorageObject((StorageObject)obj0)}).inOrder();
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(BUCKET_NAME, prefix, null), TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(BUCKET_NAME, prefix, pageToken)}).inOrder();
    }

    @Test
    public void listObjectInfo_includePrefix_prefixObjectDoesNotExist_objects() throws IOException {
        String prefix = "foo/bar/baz/";
        String pageToken = "pageToken_0";
        StorageObject obj0 = GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, "foo/bar/baz/obj0");
        StorageObject obj1 = GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, "foo/bar/baz/obj1");
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)new Objects().setItems((List)ImmutableList.of((Object)obj0)).setNextPageToken(pageToken)), MockHttpTransportHelper.jsonDataResponse((Object)new Objects().setItems((List)ImmutableList.of((Object)obj1)).setNextPageToken(null))});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        List objects = gcs.listObjectInfo(BUCKET_NAME, prefix, INCLUDE_PREFIX_LIST_OPTIONS);
        Truth.assertThat((Iterable)objects).containsExactly(new Object[]{GoogleCloudStorageItemInfo.createInferredDirectory((StorageResourceId)new StorageResourceId(BUCKET_NAME, "foo/bar/baz/")), GoogleCloudStorageImpl.createItemInfoForStorageObject((StorageObject)obj0), GoogleCloudStorageImpl.createItemInfoForStorageObject((StorageObject)obj1)}).inOrder();
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(BUCKET_NAME, prefix, null), TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(BUCKET_NAME, prefix, pageToken)}).inOrder();
    }

    @Test
    public void listObjectInfo_includePrefix_prefixObjectDoesNotExist_prefixes() throws IOException {
        String prefix = "foo/bar/baz/";
        String pageToken = "pageToken_0";
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)new Objects().setPrefixes((List)ImmutableList.of((Object)"foo/bar/baz/dir0/")).setNextPageToken(pageToken)), MockHttpTransportHelper.jsonDataResponse((Object)new Objects().setPrefixes((List)ImmutableList.of((Object)"foo/bar/baz/dir1/")).setNextPageToken(null))});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        List objects = gcs.listObjectInfo(BUCKET_NAME, prefix, INCLUDE_PREFIX_LIST_OPTIONS);
        Truth.assertThat((Iterable)objects).containsExactly(new Object[]{GoogleCloudStorageItemInfo.createInferredDirectory((StorageResourceId)new StorageResourceId(BUCKET_NAME, "foo/bar/baz/")), GoogleCloudStorageItemInfo.createInferredDirectory((StorageResourceId)new StorageResourceId(BUCKET_NAME, "foo/bar/baz/dir0/")), GoogleCloudStorageItemInfo.createInferredDirectory((StorageResourceId)new StorageResourceId(BUCKET_NAME, "foo/bar/baz/dir1/"))}).inOrder();
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(BUCKET_NAME, prefix, null), TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(BUCKET_NAME, prefix, pageToken)}).inOrder();
    }

    @Test
    public void listObjectInfo_includePrefix_prefixObjectExists() throws IOException {
        String prefix = "foo/bar/baz/";
        String pageToken = "pageToken_0";
        StorageObject prefixObj = GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, "foo/bar/baz/");
        StorageObject obj0 = GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, "foo/bar/baz/obj0");
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)new Objects().setPrefixes((List)ImmutableList.of((Object)"foo/bar/baz/dir0/")).setNextPageToken(pageToken)), MockHttpTransportHelper.jsonDataResponse((Object)new Objects().setItems((List)ImmutableList.of((Object)prefixObj, (Object)obj0)).setNextPageToken(null))});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        List objects = gcs.listObjectInfo(BUCKET_NAME, prefix, INCLUDE_PREFIX_LIST_OPTIONS);
        Truth.assertThat((Iterable)objects).containsExactly(new Object[]{GoogleCloudStorageImpl.createItemInfoForStorageObject((StorageObject)prefixObj), GoogleCloudStorageItemInfo.createInferredDirectory((StorageResourceId)new StorageResourceId(BUCKET_NAME, "foo/bar/baz/dir0/")), GoogleCloudStorageImpl.createItemInfoForStorageObject((StorageObject)obj0)}).inOrder();
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(BUCKET_NAME, prefix, null), TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(BUCKET_NAME, prefix, pageToken)}).inOrder();
    }

    @Test
    public void listObjectInfo_includePrefix_onlyPrefixObjectExists() throws IOException {
        String prefix = "foo/bar/baz/";
        StorageObject prefixObj = GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, "foo/bar/baz/");
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)new Objects().setItems((List)ImmutableList.of((Object)prefixObj)).setNextPageToken(null))});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        List objects = gcs.listObjectInfo(BUCKET_NAME, prefix, INCLUDE_PREFIX_LIST_OPTIONS);
        Truth.assertThat((Iterable)objects).containsExactly(new Object[]{GoogleCloudStorageImpl.createItemInfoForStorageObject((StorageObject)prefixObj)}).inOrder();
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(BUCKET_NAME, prefix, null)}).inOrder();
    }

    @Test
    public void listObjectInfo_includePrefix_prefixDoesNotExist() throws IOException {
        String prefix = "foo/bar/baz/";
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)new Objects())});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        List objects = gcs.listObjectInfo(BUCKET_NAME, prefix, INCLUDE_PREFIX_LIST_OPTIONS);
        Truth.assertThat((Iterable)objects).isEmpty();
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(BUCKET_NAME, prefix, null)}).inOrder();
    }

    @Test
    public void listObjectInfo_inferImplicit() throws IOException {
        String objectPrefix = "foo/bar/baz/";
        String dir0Name = "foo/bar/baz/dir0/";
        String dir1Name = "foo/bar/baz/dir1/";
        String dir2Name = "foo/bar/baz/dir2/";
        StorageObject dir1 = GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, dir1Name);
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)new Objects().setPrefixes((List)ImmutableList.of((Object)dir0Name, (Object)dir1Name, (Object)dir2Name)).setItems((List)ImmutableList.of((Object)dir1)).setNextPageToken(null))});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        List objectInfos = gcs.listObjectInfo(BUCKET_NAME, objectPrefix);
        Truth.assertThat((Iterable)objectInfos).containsExactly(new Object[]{GoogleCloudStorageItemInfo.createInferredDirectory((StorageResourceId)new StorageResourceId(BUCKET_NAME, dir0Name)), GoogleCloudStorageImpl.createItemInfoForStorageObject((StorageResourceId)new StorageResourceId(BUCKET_NAME, dir1Name), (StorageObject)dir1), GoogleCloudStorageItemInfo.createInferredDirectory((StorageResourceId)new StorageResourceId(BUCKET_NAME, dir2Name))}).inOrder();
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(BUCKET_NAME, objectPrefix, null)}).inOrder();
    }

    @Test
    public void listObjectInfoPage_objects() throws IOException {
        String prefix = "foo/bar/baz/";
        StorageObject object1 = GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, "foo/bar/baz/obj0");
        StorageObject object2 = GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, "foo/bar/baz/obj1");
        ImmutableList objects = ImmutableList.of((Object)GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, "foo/bar/baz/"), (Object)object1, (Object)object2);
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)new Objects().setItems((List)objects).setNextPageToken(null))});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        GoogleCloudStorage.ListPage objectsPage = gcs.listObjectInfoPage(BUCKET_NAME, prefix, null);
        Truth.assertThat((String)objectsPage.getNextPageToken()).isNull();
        Truth.assertThat((Iterable)objectsPage.getItems()).containsExactly(new Object[]{GoogleCloudStorageImpl.createItemInfoForStorageObject((StorageResourceId)new StorageResourceId(BUCKET_NAME, object1.getName()), (StorageObject)object1), GoogleCloudStorageImpl.createItemInfoForStorageObject((StorageResourceId)new StorageResourceId(BUCKET_NAME, object2.getName()), (StorageObject)object2)}).inOrder();
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(BUCKET_NAME, prefix, null)}).inOrder();
    }

    @Test
    public void listObjectInfoPage_prefixesAndPrefixObjects() throws IOException {
        String objectPrefix = "foo/bar/baz/";
        StorageObject dir0 = GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, "foo/bar/baz/dir0/");
        StorageObject dir1 = GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, "foo/bar/baz/dir1/");
        ImmutableList objects = ImmutableList.of((Object)GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, objectPrefix), (Object)dir0, (Object)dir1);
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)new Objects().setPrefixes((List)ImmutableList.of((Object)dir0.getName(), (Object)dir1.getName())).setItems((List)objects).setNextPageToken(null))});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        GoogleCloudStorage.ListPage objectsPage = gcs.listObjectInfoPage(BUCKET_NAME, objectPrefix, null);
        this.trackingRequestInitializerWithRetries.getAllRequestStrings();
        Truth.assertThat((String)objectsPage.getNextPageToken()).isNull();
        Truth.assertThat((Iterable)objectsPage.getItems()).containsExactly(new Object[]{GoogleCloudStorageImpl.createItemInfoForStorageObject((StorageObject)dir0), GoogleCloudStorageImpl.createItemInfoForStorageObject((StorageObject)dir1)}).inOrder();
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(BUCKET_NAME, objectPrefix, null)}).inOrder();
    }

    @Test
    public void listObjectInfoPage_prefixesAndObjects() throws IOException {
        String prefix = "foo/bar/baz/";
        StorageObject obj1 = GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, "foo/bar/baz/obj0");
        StorageObject obj2 = GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, "foo/bar/baz/obj1");
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)new Objects().setPrefixes((List)ImmutableList.of((Object)"foo/bar/baz/dir0/", (Object)"foo/bar/baz/dir1/")).setItems((List)ImmutableList.of((Object)GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, "foo/bar/baz/"), (Object)obj1, (Object)obj2)).setNextPageToken(null))});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        GoogleCloudStorage.ListPage objectsPage = gcs.listObjectInfoPage(BUCKET_NAME, prefix, null);
        Truth.assertThat((String)objectsPage.getNextPageToken()).isNull();
        Truth.assertThat((Iterable)objectsPage.getItems()).containsExactly(new Object[]{GoogleCloudStorageItemInfo.createInferredDirectory((StorageResourceId)new StorageResourceId(BUCKET_NAME, "foo/bar/baz/dir0/")), GoogleCloudStorageItemInfo.createInferredDirectory((StorageResourceId)new StorageResourceId(BUCKET_NAME, "foo/bar/baz/dir1/")), GoogleCloudStorageImpl.createItemInfoForStorageObject((StorageObject)obj1), GoogleCloudStorageImpl.createItemInfoForStorageObject((StorageObject)obj2)}).inOrder();
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(BUCKET_NAME, prefix, null)}).inOrder();
    }

    @Test
    public void listObjectInfoPage_includePrefix_emptyBucket() throws IOException {
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)new Objects())});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        GoogleCloudStorage.ListPage objectsPage = gcs.listObjectInfoPage(BUCKET_NAME, null, INCLUDE_PREFIX_LIST_OPTIONS, null);
        Truth.assertThat((String)objectsPage.getNextPageToken()).isNull();
        Truth.assertThat((Iterable)objectsPage.getItems()).isEmpty();
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(BUCKET_NAME, null, null)}).inOrder();
    }

    @Test
    public void listObjectInfoPage_includePrefix_objectInBucket() throws IOException {
        StorageObject obj = GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, "obj");
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)new Objects().setItems((List)ImmutableList.of((Object)obj)))});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        GoogleCloudStorage.ListPage objectsPage = gcs.listObjectInfoPage(BUCKET_NAME, null, INCLUDE_PREFIX_LIST_OPTIONS, null);
        Truth.assertThat((String)objectsPage.getNextPageToken()).isNull();
        Truth.assertThat((Iterable)objectsPage.getItems()).containsExactly(new Object[]{GoogleCloudStorageImpl.createItemInfoForStorageObject((StorageObject)obj)});
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(BUCKET_NAME, null, null)}).inOrder();
    }

    @Test
    public void listObjectInfoPage_includePrefix_implicitDirInBucket() throws IOException {
        String dirName = "dir/";
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)new Objects().setPrefixes((List)ImmutableList.of((Object)dirName)))});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        GoogleCloudStorage.ListPage objectsPage = gcs.listObjectInfoPage(BUCKET_NAME, null, INCLUDE_PREFIX_LIST_OPTIONS, null);
        Truth.assertThat((String)objectsPage.getNextPageToken()).isNull();
        Truth.assertThat((Iterable)objectsPage.getItems()).containsExactly(new Object[]{GoogleCloudStorageItemInfo.createInferredDirectory((StorageResourceId)new StorageResourceId(BUCKET_NAME, dirName))});
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(BUCKET_NAME, null, null)}).inOrder();
    }

    @Test
    public void listObjectInfoPage_includePrefix_dirInBucket() throws IOException {
        String dirName = "dir/";
        StorageObject dir = GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, dirName);
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)new Objects().setItems((List)ImmutableList.of((Object)dir)).setPrefixes((List)ImmutableList.of((Object)dirName)))});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        GoogleCloudStorage.ListPage objectsPage = gcs.listObjectInfoPage(BUCKET_NAME, null, INCLUDE_PREFIX_LIST_OPTIONS, null);
        Truth.assertThat((String)objectsPage.getNextPageToken()).isNull();
        Truth.assertThat((Iterable)objectsPage.getItems()).containsExactly(new Object[]{GoogleCloudStorageImpl.createItemInfoForStorageObject((StorageObject)dir)});
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(BUCKET_NAME, null, null)}).inOrder();
    }

    @Test
    public void listObjectInfoPage_includePrefix_prefixObjectDoesNotExist() throws IOException {
        String prefix = "foo/bar/baz/";
        StorageObject obj0 = GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, "foo/bar/baz/obj0");
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)new Objects().setPrefixes((List)ImmutableList.of((Object)"foo/bar/baz/dir0/")).setItems((List)ImmutableList.of((Object)obj0)).setNextPageToken(null))});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        GoogleCloudStorage.ListPage objectsPage = gcs.listObjectInfoPage(BUCKET_NAME, prefix, INCLUDE_PREFIX_LIST_OPTIONS, null);
        Truth.assertThat((String)objectsPage.getNextPageToken()).isNull();
        Truth.assertThat((Iterable)objectsPage.getItems()).containsExactly(new Object[]{GoogleCloudStorageItemInfo.createInferredDirectory((StorageResourceId)new StorageResourceId(BUCKET_NAME, "foo/bar/baz/")), GoogleCloudStorageItemInfo.createInferredDirectory((StorageResourceId)new StorageResourceId(BUCKET_NAME, "foo/bar/baz/dir0/")), GoogleCloudStorageImpl.createItemInfoForStorageObject((StorageObject)obj0)}).inOrder();
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(BUCKET_NAME, prefix, null)}).inOrder();
    }

    @Test
    public void listObjectInfoPage_includePrefix_prefixObjectDoesNotExist_objects() throws IOException {
        String prefix = "foo/bar/baz/";
        StorageObject obj0 = GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, "foo/bar/baz/obj0");
        StorageObject obj1 = GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, "foo/bar/baz/obj1");
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)new Objects().setItems((List)ImmutableList.of((Object)obj0, (Object)obj1)).setNextPageToken(null))});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        GoogleCloudStorage.ListPage objectsPage = gcs.listObjectInfoPage(BUCKET_NAME, prefix, INCLUDE_PREFIX_LIST_OPTIONS, null);
        Truth.assertThat((String)objectsPage.getNextPageToken()).isNull();
        Truth.assertThat((Iterable)objectsPage.getItems()).containsExactly(new Object[]{GoogleCloudStorageItemInfo.createInferredDirectory((StorageResourceId)new StorageResourceId(BUCKET_NAME, "foo/bar/baz/")), GoogleCloudStorageImpl.createItemInfoForStorageObject((StorageObject)obj0), GoogleCloudStorageImpl.createItemInfoForStorageObject((StorageObject)obj1)}).inOrder();
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(BUCKET_NAME, prefix, null)}).inOrder();
    }

    @Test
    public void listObjectInfoPage_includePrefix_prefixObjectDoesNotExist_prefixes() throws IOException {
        String prefix = "foo/bar/baz/";
        String pageToken = "pageToken_0";
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)new Objects().setPrefixes((List)ImmutableList.of((Object)"foo/bar/baz/dir0/", (Object)"foo/bar/baz/dir1/")).setNextPageToken(pageToken))});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        GoogleCloudStorage.ListPage objects = gcs.listObjectInfoPage(BUCKET_NAME, prefix, INCLUDE_PREFIX_LIST_OPTIONS, null);
        Truth.assertThat((String)objects.getNextPageToken()).isEqualTo((Object)pageToken);
        Truth.assertThat((Iterable)objects.getItems()).containsExactly(new Object[]{GoogleCloudStorageItemInfo.createInferredDirectory((StorageResourceId)new StorageResourceId(BUCKET_NAME, "foo/bar/baz/")), GoogleCloudStorageItemInfo.createInferredDirectory((StorageResourceId)new StorageResourceId(BUCKET_NAME, "foo/bar/baz/dir0/")), GoogleCloudStorageItemInfo.createInferredDirectory((StorageResourceId)new StorageResourceId(BUCKET_NAME, "foo/bar/baz/dir1/"))}).inOrder();
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(BUCKET_NAME, prefix, null)}).inOrder();
    }

    @Test
    public void listObjectInfoPage_includePrefix_prefixObjectExists() throws IOException {
        String prefix = "foo/bar/baz/";
        String pageToken = "pageToken_0";
        StorageObject prefixObj = GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, "foo/bar/baz/");
        StorageObject obj0 = GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, "foo/bar/baz/obj0");
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)new Objects().setPrefixes((List)ImmutableList.of((Object)"foo/bar/baz/dir0/")).setItems((List)ImmutableList.of((Object)prefixObj, (Object)obj0)).setNextPageToken(pageToken))});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        GoogleCloudStorage.ListPage objectsPage = gcs.listObjectInfoPage(BUCKET_NAME, prefix, INCLUDE_PREFIX_LIST_OPTIONS, null);
        Truth.assertThat((String)objectsPage.getNextPageToken()).isEqualTo((Object)pageToken);
        Truth.assertThat((Iterable)objectsPage.getItems()).containsExactly(new Object[]{GoogleCloudStorageImpl.createItemInfoForStorageObject((StorageObject)prefixObj), GoogleCloudStorageItemInfo.createInferredDirectory((StorageResourceId)new StorageResourceId(BUCKET_NAME, "foo/bar/baz/dir0/")), GoogleCloudStorageImpl.createItemInfoForStorageObject((StorageObject)obj0)}).inOrder();
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(BUCKET_NAME, prefix, null)}).inOrder();
    }

    @Test
    public void listObjectInfoPage_includePrefix_onlyPrefixObjectExists() throws IOException {
        String prefix = "foo/bar/baz/";
        StorageObject prefixObj = GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, "foo/bar/baz/");
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)new Objects().setItems((List)ImmutableList.of((Object)prefixObj)).setNextPageToken(null))});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        GoogleCloudStorage.ListPage objectsPage = gcs.listObjectInfoPage(BUCKET_NAME, prefix, INCLUDE_PREFIX_LIST_OPTIONS, null);
        Truth.assertThat((String)objectsPage.getNextPageToken()).isNull();
        Truth.assertThat((Iterable)objectsPage.getItems()).containsExactly(new Object[]{GoogleCloudStorageImpl.createItemInfoForStorageObject((StorageObject)prefixObj)}).inOrder();
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(BUCKET_NAME, prefix, null)}).inOrder();
    }

    @Test
    public void listObjectInfoPage_includePrefix_prefixDoesNotExist() throws IOException {
        String prefix = "foo/bar/baz/";
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)new Objects())});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        GoogleCloudStorage.ListPage objectsPage = gcs.listObjectInfoPage(BUCKET_NAME, prefix, INCLUDE_PREFIX_LIST_OPTIONS, null);
        Truth.assertThat((String)objectsPage.getNextPageToken()).isNull();
        Truth.assertThat((Iterable)objectsPage.getItems()).isEmpty();
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(BUCKET_NAME, prefix, null)}).inOrder();
    }

    @Test
    public void listObjectInfoPage_inferImplicit() throws IOException {
        String objectPrefix = "foo/bar/baz/";
        String dir0Name = "foo/bar/baz/dir0/";
        String dir1Name = "foo/bar/baz/dir1/";
        String dir2Name = "foo/bar/baz/dir2/";
        StorageObject dir1 = GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, dir1Name);
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)new Objects().setPrefixes((List)ImmutableList.of((Object)dir0Name, (Object)dir1Name, (Object)dir2Name)).setItems((List)ImmutableList.of((Object)dir1)).setNextPageToken(null))});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        GoogleCloudStorage.ListPage objectInfos = gcs.listObjectInfoPage(BUCKET_NAME, objectPrefix, null);
        Truth.assertThat((String)objectInfos.getNextPageToken()).isNull();
        Truth.assertThat((Iterable)objectInfos.getItems()).containsExactly(new Object[]{GoogleCloudStorageItemInfo.createInferredDirectory((StorageResourceId)new StorageResourceId(BUCKET_NAME, dir0Name)), GoogleCloudStorageImpl.createItemInfoForStorageObject((StorageResourceId)new StorageResourceId(BUCKET_NAME, dir1Name), (StorageObject)dir1), GoogleCloudStorageItemInfo.createInferredDirectory((StorageResourceId)new StorageResourceId(BUCKET_NAME, dir2Name))}).inOrder();
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(BUCKET_NAME, objectPrefix, null)}).inOrder();
    }

    @Test
    public void testGetItemInfoRoot() throws IOException {
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GoogleCloudStorageTestUtils.HTTP_TRANSPORT);
        GoogleCloudStorageItemInfo info = gcs.getItemInfo(StorageResourceId.ROOT);
        Truth.assertThat((Object)info).isEqualTo((Object)GoogleCloudStorageItemInfo.ROOT_INFO);
    }

    @Test
    public void testGetItemInfoBucket() throws IOException {
        Bucket bucket = GoogleCloudStorageTest.newBucket(BUCKET_NAME);
        StorageResourceId bucketId = new StorageResourceId(bucket.getName());
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)bucket)});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        GoogleCloudStorageItemInfo info = gcs.getItemInfo(bucketId);
        Truth.assertThat((Object)info).isEqualTo((Object)GoogleCloudStorageImpl.createItemInfoForBucket((StorageResourceId)bucketId, (Bucket)bucket));
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getBucketRequestString(BUCKET_NAME)}).inOrder();
    }

    @Test
    public void testGetItemInfoBucketReturnMismatchedName() throws IOException {
        Bucket bucket = GoogleCloudStorageTest.newBucket("wrong-bucket-name");
        StorageResourceId bucketId = new StorageResourceId(BUCKET_NAME);
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)bucket)});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        IllegalArgumentException thrown = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> GoogleCloudStorageTest.lambda$testGetItemInfoBucketReturnMismatchedName$44((GoogleCloudStorage)gcs, bucketId));
        String expectedMsg = String.format("resourceId.getBucketName() must equal bucket.getName(): '%s' vs '%s'", BUCKET_NAME, bucket.getName());
        Truth.assertThat((Throwable)thrown).hasMessageThat().isEqualTo((Object)expectedMsg);
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getBucketRequestString(BUCKET_NAME)}).inOrder();
    }

    @Test
    public void testGetItemInfoBucketApiException() throws IOException {
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonErrorResponse((MockHttpTransportHelper.ErrorResponses)MockHttpTransportHelper.ErrorResponses.NOT_FOUND), MockHttpTransportHelper.jsonErrorResponse((MockHttpTransportHelper.ErrorResponses)MockHttpTransportHelper.ErrorResponses.GONE)});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        GoogleCloudStorageItemInfo info = gcs.getItemInfo(new StorageResourceId(BUCKET_NAME));
        GoogleCloudStorageItemInfo expected = GoogleCloudStorageItemInfo.createNotFound((StorageResourceId)new StorageResourceId(BUCKET_NAME));
        Truth.assertThat((Object)info).isEqualTo((Object)expected);
        Assert.assertThrows(IOException.class, () -> GoogleCloudStorageTest.lambda$testGetItemInfoBucketApiException$45((GoogleCloudStorage)gcs));
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getBucketRequestString(BUCKET_NAME), TrackingHttpRequestInitializer.getBucketRequestString(BUCKET_NAME)}).inOrder();
    }

    @Test
    public void testGetItemInfoObject() throws IOException {
        StorageObject storageObject = GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, OBJECT_NAME);
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)storageObject)});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        GoogleCloudStorageItemInfo info = gcs.getItemInfo(RESOURCE_ID);
        GoogleCloudStorageItemInfo expected = GoogleCloudStorageImpl.createItemInfoForStorageObject((StorageResourceId)RESOURCE_ID, (StorageObject)storageObject);
        Truth.assertThat((Object)info).isEqualTo((Object)expected);
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(BUCKET_NAME, OBJECT_NAME)}).inOrder();
    }

    @Test
    public void testGetItemInfoObjectReturnMismatchedName() throws IOException {
        StorageObject wrongObjectName = GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, "wrong-object-name");
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)wrongObjectName)});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        IllegalArgumentException thrown = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> GoogleCloudStorageTest.lambda$testGetItemInfoObjectReturnMismatchedName$46((GoogleCloudStorage)gcs));
        String expectedMsg = String.format("resourceId.getObjectName() must equal object.getName(): '%s' vs '%s'", OBJECT_NAME, wrongObjectName.getName());
        Truth.assertThat((Throwable)thrown).hasMessageThat().isEqualTo((Object)expectedMsg);
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(BUCKET_NAME, OBJECT_NAME)}).inOrder();
    }

    @Test
    public void testGetItemInfoObjectApiException() throws IOException {
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonErrorResponse((MockHttpTransportHelper.ErrorResponses)MockHttpTransportHelper.ErrorResponses.NOT_FOUND), MockHttpTransportHelper.jsonErrorResponse((MockHttpTransportHelper.ErrorResponses)MockHttpTransportHelper.ErrorResponses.GONE)});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        GoogleCloudStorageItemInfo info = gcs.getItemInfo(RESOURCE_ID);
        GoogleCloudStorageItemInfo expected = GoogleCloudStorageItemInfo.createNotFound((StorageResourceId)RESOURCE_ID);
        Truth.assertThat((Object)info).isEqualTo((Object)expected);
        Assert.assertThrows(IOException.class, () -> GoogleCloudStorageTest.lambda$testGetItemInfoObjectApiException$47((GoogleCloudStorage)gcs));
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(BUCKET_NAME, OBJECT_NAME), TrackingHttpRequestInitializer.getRequestString(BUCKET_NAME, OBJECT_NAME)}).inOrder();
    }

    @Test
    public void testGetItemInfos() throws IOException {
        Bucket bucket = GoogleCloudStorageTest.newBucket(BUCKET_NAME);
        StorageObject storageObject = GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, OBJECT_NAME);
        MockHttpTransport transport = MockHttpTransportHelper.mockBatchTransport((int)2, (LowLevelHttpResponse[])new LowLevelHttpResponse[]{MockHttpTransportHelper.jsonDataResponse((Object)storageObject), MockHttpTransportHelper.jsonDataResponse((Object)bucket)});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        List itemInfos = gcs.getItemInfos((List)ImmutableList.of((Object)RESOURCE_ID, (Object)new StorageResourceId(BUCKET_NAME)));
        Truth.assertThat((Iterable)itemInfos).containsExactly(new Object[]{GoogleCloudStorageImpl.createItemInfoForStorageObject((StorageResourceId)RESOURCE_ID, (StorageObject)storageObject), GoogleCloudStorageImpl.createItemInfoForBucket((StorageResourceId)new StorageResourceId(BUCKET_NAME), (Bucket)bucket)}).inOrder();
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.batchRequestString(), TrackingHttpRequestInitializer.getRequestString(BUCKET_NAME, OBJECT_NAME), TrackingHttpRequestInitializer.getBucketRequestString(BUCKET_NAME)}).inOrder();
    }

    @Test
    public void testGetItemInfosWithRetries() throws IOException {
        Bucket bucket = GoogleCloudStorageTest.newBucket(BUCKET_NAME);
        StorageObject storageObject = GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, OBJECT_NAME);
        MockHttpTransport transport = MockHttpTransportHelper.mockBatchTransport((int)2, (LowLevelHttpResponse[])new LowLevelHttpResponse[]{MockHttpTransportHelper.jsonDataResponse((Object)storageObject), MockHttpTransportHelper.jsonErrorResponse((MockHttpTransportHelper.ErrorResponses)MockHttpTransportHelper.ErrorResponses.RATE_LIMITED), MockHttpTransportHelper.jsonDataResponse((Object)bucket)});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        List itemInfos = gcs.getItemInfos((List)ImmutableList.of((Object)RESOURCE_ID, (Object)new StorageResourceId(BUCKET_NAME)));
        Truth.assertThat((Iterable)itemInfos).containsExactly(new Object[]{GoogleCloudStorageImpl.createItemInfoForStorageObject((StorageResourceId)RESOURCE_ID, (StorageObject)storageObject), GoogleCloudStorageImpl.createItemInfoForBucket((StorageResourceId)new StorageResourceId(BUCKET_NAME), (Bucket)bucket)}).inOrder();
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.batchRequestString(), TrackingHttpRequestInitializer.getRequestString(BUCKET_NAME, OBJECT_NAME), TrackingHttpRequestInitializer.getBucketRequestString(BUCKET_NAME), TrackingHttpRequestInitializer.batchRequestString(), TrackingHttpRequestInitializer.getBucketRequestString(BUCKET_NAME)}).inOrder();
    }

    @Test
    public void testGetItemInfosNotFound() throws IOException {
        MockHttpTransport transport = MockHttpTransportHelper.mockBatchTransport((int)2, (LowLevelHttpResponse[])new LowLevelHttpResponse[]{MockHttpTransportHelper.jsonErrorResponse((MockHttpTransportHelper.ErrorResponses)MockHttpTransportHelper.ErrorResponses.NOT_FOUND), MockHttpTransportHelper.jsonErrorResponse((MockHttpTransportHelper.ErrorResponses)MockHttpTransportHelper.ErrorResponses.NOT_FOUND)});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        List itemInfos = gcs.getItemInfos((List)ImmutableList.of((Object)RESOURCE_ID, (Object)StorageResourceId.ROOT, (Object)new StorageResourceId(BUCKET_NAME)));
        GoogleCloudStorageItemInfo expectedObject = GoogleCloudStorageItemInfo.createNotFound((StorageResourceId)RESOURCE_ID);
        GoogleCloudStorageItemInfo expectedRoot = GoogleCloudStorageItemInfo.ROOT_INFO;
        GoogleCloudStorageItemInfo expectedBucket = GoogleCloudStorageItemInfo.createNotFound((StorageResourceId)new StorageResourceId(BUCKET_NAME));
        Truth.assertThat((Iterable)itemInfos).containsExactly(new Object[]{expectedObject, expectedRoot, expectedBucket}).inOrder();
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.batchRequestString(), TrackingHttpRequestInitializer.getRequestString(BUCKET_NAME, OBJECT_NAME), TrackingHttpRequestInitializer.getBucketRequestString(BUCKET_NAME)}).inOrder();
    }

    @Test
    public void testClose() throws IOException {
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GoogleCloudStorageTestUtils.HTTP_TRANSPORT);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        gcs.setBackgroundTasksThreadPool(executorService);
        gcs.close();
        Truth.assertThat((Boolean)executorService.isShutdown()).isTrue();
    }

    @Test
    public void testComposeSuccess() throws Exception {
        this.trackingRequestInitializerWithRetries = new TrackingHttpRequestInitializer();
        ImmutableList sources = ImmutableList.of((Object)"object1", (Object)"object2");
        StorageObject storageObject = GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, OBJECT_NAME);
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)storageObject), MockHttpTransportHelper.jsonDataResponse((Object)storageObject)});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        gcs.compose(BUCKET_NAME, (List)sources, OBJECT_NAME, "application/octet-stream");
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(BUCKET_NAME, OBJECT_NAME), TrackingHttpRequestInitializer.composeRequestString(BUCKET_NAME, OBJECT_NAME, 1)}).inOrder();
    }

    @Test
    public void testComposeObjectsWithGenerationId() throws Exception {
        String destination = "composedObject";
        int generationId = 35;
        StorageResourceId destinationId = new StorageResourceId(BUCKET_NAME, destination, (long)generationId);
        StorageObject destinationObject = GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, destination);
        StorageObject object1 = GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, "object1");
        StorageObject object2 = GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, "object2");
        ImmutableList sources = ImmutableList.of((Object)new StorageResourceId(BUCKET_NAME, "object1"), (Object)new StorageResourceId(BUCKET_NAME, "object2"));
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)destinationObject), MockHttpTransportHelper.jsonDataResponse((Object)object1), MockHttpTransportHelper.jsonDataResponse((Object)object2)});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        ImmutableMap rawMetadata = ImmutableMap.of((Object)"foo", (Object)new byte[]{1}, (Object)"bar", (Object)new byte[]{2});
        GoogleCloudStorageItemInfo composedInfo = gcs.composeObjects((List)sources, destinationId, CreateObjectOptions.builder().setMetadata((Map)rawMetadata).build());
        Truth.assertThat((Object)composedInfo).isEqualTo((Object)GoogleCloudStorageImpl.createItemInfoForStorageObject((StorageResourceId)new StorageResourceId(BUCKET_NAME, destination), (StorageObject)destinationObject));
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.composeRequestString(BUCKET_NAME, destination, generationId, false)}).inOrder();
    }

    @Test
    public void testItemInfoMetadataEquals() {
        Truth.assertThat((Boolean)GoogleCloudStorageTest.getItemInfoForEmptyObjectWithMetadata(EMPTY_METADATA).metadataEquals(EMPTY_METADATA)).isTrue();
        Truth.assertThat((Boolean)GoogleCloudStorageTest.getItemInfoForEmptyObjectWithMetadata(null).metadataEquals(EMPTY_METADATA)).isTrue();
        Truth.assertThat((Boolean)GoogleCloudStorageTest.getItemInfoForEmptyObjectWithMetadata(null).metadataEquals(null)).isFalse();
        Truth.assertThat((Boolean)GoogleCloudStorageTest.getItemInfoForEmptyObjectWithMetadata((Map<String, byte[]>)ImmutableMap.of((Object)"foo", (Object)new byte[]{1}, (Object)"bar", (Object)new byte[]{2})).metadataEquals((Map)ImmutableMap.of((Object)"foo", (Object)new byte[]{1}, (Object)"bar", (Object)new byte[]{2}))).isTrue();
        Truth.assertThat((Boolean)GoogleCloudStorageTest.getItemInfoForEmptyObjectWithMetadata(new HashMap<String, byte[]>((Map<String, byte[]>)ImmutableMap.of((Object)"foo", (Object)new byte[]{1}, (Object)"bar", (Object)new byte[]{2}))).metadataEquals(new TreeMap(ImmutableMap.of((Object)"foo", (Object)new byte[]{1}, (Object)"bar", (Object)new byte[]{2})))).isTrue();
        Truth.assertThat((Boolean)GoogleCloudStorageTest.getItemInfoForEmptyObjectWithMetadata((Map<String, byte[]>)ImmutableMap.of((Object)"foo", (Object)new byte[]{1}, (Object)"bar", (Object)new byte[]{2})).metadataEquals((Map)ImmutableMap.of((Object)"foo", (Object)new byte[]{2}, (Object)"bar", (Object)new byte[]{1}))).isFalse();
        Truth.assertThat((Boolean)GoogleCloudStorageTest.getItemInfoForEmptyObjectWithMetadata((Map<String, byte[]>)ImmutableMap.of((Object)"foo", (Object)new byte[]{1}, (Object)"bar", (Object)new byte[]{2})).metadataEquals((Map)ImmutableMap.of((Object)"foo", (Object)new byte[]{1}))).isFalse();
    }

    @Test
    public void testItemInfoEqualityIncludesMetadata() {
        Truth.assertThat((Object)GoogleCloudStorageTest.getItemInfoForEmptyObjectWithMetadata((Map<String, byte[]>)ImmutableMap.of((Object)"foo", (Object)new byte[]{1}, (Object)"bar", (Object)new byte[]{2}))).isNotEqualTo((Object)GoogleCloudStorageTest.getItemInfoForEmptyObjectWithMetadata(null));
    }

    @Test
    public void testIgnoreExceptionsOnCreateEmptyObject() throws IOException {
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonErrorResponse((MockHttpTransportHelper.ErrorResponses)MockHttpTransportHelper.ErrorResponses.RATE_LIMITED), MockHttpTransportHelper.jsonDataResponse((Object)GoogleCloudStorageTest.getStorageObjectForEmptyObjectWithMetadata((Map<String, byte[]>)ImmutableMap.of((Object)"foo", (Object)new byte[0])))});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithoutRetries);
        gcs.createEmptyObject(RESOURCE_ID, CreateObjectOptions.DEFAULT_OVERWRITE.toBuilder().setMetadata((Map)ImmutableMap.of((Object)"foo", (Object)new byte[0])).build());
        Truth.assertThat(this.trackingRequestInitializerWithoutRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.uploadRequestString(BUCKET_NAME, OBJECT_NAME, null), TrackingHttpRequestInitializer.getRequestString(BUCKET_NAME, OBJECT_NAME)}).inOrder();
    }

    @Test
    public void testIgnoreExceptionsOnCreateEmptyObjectMismatchMetadata() throws IOException {
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonErrorResponse((MockHttpTransportHelper.ErrorResponses)MockHttpTransportHelper.ErrorResponses.RATE_LIMITED), MockHttpTransportHelper.jsonDataResponse((Object)GoogleCloudStorageTest.getStorageObjectForEmptyObjectWithMetadata(EMPTY_METADATA))});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithoutRetries);
        CreateObjectOptions createOptions = CreateObjectOptions.DEFAULT_OVERWRITE.toBuilder().setMetadata((Map)ImmutableMap.of((Object)"foo", (Object)new byte[0])).build();
        IOException thrown = (IOException)Assert.assertThrows(IOException.class, () -> GoogleCloudStorageTest.lambda$testIgnoreExceptionsOnCreateEmptyObjectMismatchMetadata$48((GoogleCloudStorage)gcs, createOptions));
        Truth.assertThat((Throwable)thrown).hasMessageThat().contains((CharSequence)"rateLimitExceeded");
        Truth.assertThat(this.trackingRequestInitializerWithoutRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.uploadRequestString(BUCKET_NAME, OBJECT_NAME, null), TrackingHttpRequestInitializer.getRequestString(BUCKET_NAME, OBJECT_NAME)}).inOrder();
    }

    @Test
    public void testIgnoreExceptionsOnCreateEmptyObjectMismatchMetadataButOptionsHasNoMetadata() throws IOException {
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonErrorResponse((MockHttpTransportHelper.ErrorResponses)MockHttpTransportHelper.ErrorResponses.RATE_LIMITED), MockHttpTransportHelper.jsonDataResponse((Object)GoogleCloudStorageTest.getStorageObjectForEmptyObjectWithMetadata((Map<String, byte[]>)ImmutableMap.of((Object)"foo", (Object)new byte[0])))});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithoutRetries);
        gcs.createEmptyObject(RESOURCE_ID);
        Truth.assertThat(this.trackingRequestInitializerWithoutRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.uploadRequestString(BUCKET_NAME, OBJECT_NAME, null), TrackingHttpRequestInitializer.getRequestString(BUCKET_NAME, OBJECT_NAME)}).inOrder();
    }

    @Test
    public void testIgnoreExceptionsOnCreateEmptyObjects() throws IOException {
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonErrorResponse((MockHttpTransportHelper.ErrorResponses)MockHttpTransportHelper.ErrorResponses.RATE_LIMITED), MockHttpTransportHelper.jsonDataResponse((Object)GoogleCloudStorageTest.getStorageObjectForEmptyObjectWithMetadata(EMPTY_METADATA))});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithoutRetries);
        gcs.createEmptyObjects((List)ImmutableList.of((Object)RESOURCE_ID));
        Truth.assertThat(this.trackingRequestInitializerWithoutRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.uploadRequestString(BUCKET_NAME, OBJECT_NAME, null), TrackingHttpRequestInitializer.getRequestString(BUCKET_NAME, OBJECT_NAME)}).inOrder();
    }

    @Test
    public void testIgnoreExceptionsOnCreateEmptyObjectsNonIgnorableException() throws Exception {
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonErrorResponse((MockHttpTransportHelper.ErrorResponses)MockHttpTransportHelper.ErrorResponses.GONE)});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithRetries);
        Assert.assertThrows(IOException.class, () -> GoogleCloudStorageTest.lambda$testIgnoreExceptionsOnCreateEmptyObjectsNonIgnorableException$49((GoogleCloudStorage)gcs));
        Truth.assertThat(this.trackingRequestInitializerWithRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.uploadRequestString(BUCKET_NAME, OBJECT_NAME, null)}).inOrder();
    }

    @Test
    public void testIgnoreExceptionsOnCreateEmptyObjectsErrorOnRefetch() throws IOException {
        String objectName1 = "bar-object1";
        String objectName2 = "bar-object2";
        ThrowingInputStream failedStream = new ThrowingInputStream((Throwable)new RuntimeException("read RuntimeException"));
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonErrorResponse((MockHttpTransportHelper.ErrorResponses)MockHttpTransportHelper.ErrorResponses.RATE_LIMITED), MockHttpTransportHelper.jsonDataResponse((Object)GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, objectName2)), MockHttpTransportHelper.inputStreamResponse((String)"Content-Length", (Object)1, (InputStream)failedStream)});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithoutRetries);
        ImmutableList resourceIds = ImmutableList.of((Object)new StorageResourceId(BUCKET_NAME, objectName1), (Object)new StorageResourceId(BUCKET_NAME, objectName2));
        IOException thrown = (IOException)Assert.assertThrows(IOException.class, () -> GoogleCloudStorageTest.lambda$testIgnoreExceptionsOnCreateEmptyObjectsErrorOnRefetch$50((GoogleCloudStorage)gcs, (List)resourceIds));
        Truth.assertThat((Throwable)thrown).hasMessageThat().contains((CharSequence)"Multiple IOExceptions");
        ImmutableList<String> allRequestStrings = this.trackingRequestInitializerWithoutRetries.getAllRequestStrings();
        Truth.assertThat(allRequestStrings).hasSize(3);
        Truth.assertThat(allRequestStrings).containsAtLeast((Object)TrackingHttpRequestInitializer.uploadRequestString(BUCKET_NAME, objectName1, null), (Object)TrackingHttpRequestInitializer.uploadRequestString(BUCKET_NAME, objectName2, null), new Object[0]);
        Truth.assertThat(allRequestStrings).containsAnyOf((Object)TrackingHttpRequestInitializer.getRequestString(BUCKET_NAME, objectName1), (Object)TrackingHttpRequestInitializer.getRequestString(BUCKET_NAME, objectName2), new Object[0]);
    }

    @Test
    public void testIgnoreExceptionsOnCreateEmptyObjectsWithMultipleRetries() throws Exception {
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonErrorResponse((MockHttpTransportHelper.ErrorResponses)MockHttpTransportHelper.ErrorResponses.RATE_LIMITED), MockHttpTransportHelper.jsonErrorResponse((MockHttpTransportHelper.ErrorResponses)MockHttpTransportHelper.ErrorResponses.NOT_FOUND), MockHttpTransportHelper.jsonDataResponse((Object)GoogleCloudStorageTest.getStorageObjectForEmptyObjectWithMetadata(EMPTY_METADATA))});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl(GCS_OPTIONS, (HttpTransport)transport, this.trackingRequestInitializerWithoutRetries);
        gcs.createEmptyObjects((List)ImmutableList.of((Object)RESOURCE_ID));
        Truth.assertThat(this.trackingRequestInitializerWithoutRetries.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.uploadRequestString(BUCKET_NAME, OBJECT_NAME, null), TrackingHttpRequestInitializer.getRequestString(BUCKET_NAME, OBJECT_NAME), TrackingHttpRequestInitializer.getRequestString(BUCKET_NAME, OBJECT_NAME)}).inOrder();
    }

    @Test
    public void initializeRequest_withAccessTokenProviderNotUsingNewTokenPerRequest() throws IOException {
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)GoogleCloudStorageTest.newBucket(BUCKET_NAME))});
        GoogleCloudStorageImpl gcs = GoogleCloudStorageImpl.builder().setOptions(GCS_OPTIONS).setCredentials((Credentials)new FakeCredentials()).setHttpTransport((HttpTransport)transport).build();
        Storage.Objects.Get testGetRequest = gcs.storage.objects().get(BUCKET_NAME, OBJECT_NAME);
        gcs.initializeRequest((StorageRequest)testGetRequest, BUCKET_NAME);
        Truth.assertThat((String)testGetRequest.getRequestHeaders().getAuthorization()).isNull();
    }

    @Test
    public void initializeRequest_withDownscopedAccessToken() throws IOException {
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)GoogleCloudStorageTest.newBucket(BUCKET_NAME))});
        GoogleCloudStorageImpl gcs = GoogleCloudStorageImpl.builder().setOptions(GCS_OPTIONS).setCredentials((Credentials)new FakeCredentials()).setHttpTransport((HttpTransport)transport).setDownscopedAccessTokenFn(ignore -> "testDownscopedAccessToken").build();
        StorageRequestFactory.ObjectsGetMetadata testGetRequest = gcs.storageRequestFactory.objectsGetMetadata(BUCKET_NAME, OBJECT_NAME);
        gcs.initializeRequest((StorageRequest)testGetRequest, BUCKET_NAME);
        Truth.assertThat((String)testGetRequest.getRequestHeaders().getAuthorization()).isEqualTo((Object)"Bearer testDownscopedAccessToken");
    }

    static String calculateCrc32cFromBytes(byte[] data) {
        Hasher testCrc32cHasher = Hashing.crc32c().newHasher();
        testCrc32cHasher.putBytes(data);
        return BaseEncoding.base64().encode(Ints.toByteArray((int)testCrc32cHasher.hash().asInt()));
    }

    static Bucket newBucket(String name) {
        return new Bucket().setName(name).setLocation("us-central1-a").setStorageClass("class-af4").setTimeCreated(new DateTime(new Date())).setUpdated(new DateTime(new Date()));
    }

    static StorageObject newStorageObject(String bucketName, String objectName) {
        Random r = new Random();
        return new StorageObject().setBucket(bucketName).setName(objectName).setSize(BigInteger.valueOf(r.nextInt(Integer.MAX_VALUE))).setStorageClass("standard").setGeneration(Long.valueOf(r.nextInt(Integer.MAX_VALUE))).setMetageneration(Long.valueOf(r.nextInt(Integer.MAX_VALUE))).setTimeCreated(new DateTime(new Date())).setUpdated(new DateTime(new Date()));
    }

    private static byte[] gzip(byte[] testData) throws IOException {
        ByteArrayOutputStream outputStream;
        try (ByteArrayOutputStream outputStreamToClose = outputStream = new ByteArrayOutputStream();
             GZIPOutputStream gzipOutputStream = new GZIPOutputStream(outputStreamToClose);){
            gzipOutputStream.write(testData);
        }
        return outputStream.toByteArray();
    }

    private static InputStream partialReadTimeoutStream(final byte[] data, final double readFraction, final String timeoutMessage) {
        return new InputStream(){
            private int position;
            private final int maxPos;
            {
                this.maxPos = (int)((double)data.length * readFraction);
            }

            @Override
            public int read() throws IOException {
                if (this.position == this.maxPos) {
                    ++this.position;
                    throw new SocketTimeoutException(timeoutMessage);
                }
                if (this.position >= this.maxPos) {
                    return -1;
                }
                Truth.assertThat((Integer)this.position).isLessThan((Comparable)Integer.valueOf(this.maxPos));
                return data[this.position++] & 0xFF;
            }
        };
    }

    private static /* synthetic */ void lambda$testIgnoreExceptionsOnCreateEmptyObjectsErrorOnRefetch$50(GoogleCloudStorage gcs, List resourceIds) throws Throwable {
        gcs.createEmptyObjects(resourceIds);
    }

    private static /* synthetic */ void lambda$testIgnoreExceptionsOnCreateEmptyObjectsNonIgnorableException$49(GoogleCloudStorage gcs) throws Throwable {
        gcs.createEmptyObjects((List)ImmutableList.of((Object)RESOURCE_ID));
    }

    private static /* synthetic */ void lambda$testIgnoreExceptionsOnCreateEmptyObjectMismatchMetadata$48(GoogleCloudStorage gcs, CreateObjectOptions createOptions) throws Throwable {
        gcs.createEmptyObject(RESOURCE_ID, createOptions);
    }

    private static /* synthetic */ void lambda$testGetItemInfoObjectApiException$47(GoogleCloudStorage gcs) throws Throwable {
        gcs.getItemInfo(RESOURCE_ID);
    }

    private static /* synthetic */ void lambda$testGetItemInfoObjectReturnMismatchedName$46(GoogleCloudStorage gcs) throws Throwable {
        gcs.getItemInfo(RESOURCE_ID);
    }

    private static /* synthetic */ void lambda$testGetItemInfoBucketApiException$45(GoogleCloudStorage gcs) throws Throwable {
        gcs.getItemInfo(new StorageResourceId(BUCKET_NAME));
    }

    private static /* synthetic */ void lambda$testGetItemInfoBucketReturnMismatchedName$44(GoogleCloudStorage gcs, StorageResourceId bucketId) throws Throwable {
        gcs.getItemInfo(bucketId);
    }

    private static /* synthetic */ void lambda$testCopyObjectsIncompatibleBuckets$42(GoogleCloudStorage gcs, List srcObject, String dstBucket, List dstObject) throws Throwable {
        gcs.copy(BUCKET_NAME, srcObject, dstBucket, dstObject);
    }

    private static /* synthetic */ void lambda$testCopyObjectsIncompatibleBuckets$41(GoogleCloudStorage gcs, List srcObject, String dstBucket, List dstObject) throws Throwable {
        gcs.copy(BUCKET_NAME, srcObject, dstBucket, dstObject);
    }

    private static /* synthetic */ void lambda$testCopyObjectsApiExceptionDifferentBucket$40(GoogleCloudStorage gcs, ImmutableList srcObjectNames, String dstBucketName, ImmutableList dstObjectNames) throws Throwable {
        gcs.copy(BUCKET_NAME, (List)srcObjectNames, dstBucketName, (List)dstObjectNames);
    }

    private static /* synthetic */ void lambda$testCopyObjectsApiExceptionDifferentBucket$39(GoogleCloudStorage gcs, ImmutableList srcObjectNames, String dstBucketName, ImmutableList dstObjectNames) throws Throwable {
        gcs.copy(BUCKET_NAME, (List)srcObjectNames, dstBucketName, (List)dstObjectNames);
    }

    private static /* synthetic */ void lambda$testCopyObjectsApiExceptionDifferentBucket$38(GoogleCloudStorage gcs, ImmutableList srcObjectNames, String dstBucketName, ImmutableList dstObjectNames) throws Throwable {
        gcs.copy(BUCKET_NAME, (List)srcObjectNames, dstBucketName, (List)dstObjectNames);
    }

    private static /* synthetic */ void lambda$testCopyObjectsApiExceptionDifferentBucket$37(GoogleCloudStorage gcs, ImmutableList srcObjectNames, String dstBucketName, ImmutableList dstObjectNames) throws Throwable {
        gcs.copy(BUCKET_NAME, (List)srcObjectNames, dstBucketName, (List)dstObjectNames);
    }

    private static /* synthetic */ void lambda$testMoveObjectsSourceNotFound$36(GoogleCloudStorage gcs, Map sourceToDestinationObjectsMap) throws Throwable {
        gcs.move(sourceToDestinationObjectsMap);
    }

    private static /* synthetic */ void lambda$testMoveObjectsIllegalArguments$35(GoogleCloudStorage gcs, Map sourceToDestinationObjectsMap) throws Throwable {
        gcs.move(sourceToDestinationObjectsMap);
    }

    private static /* synthetic */ void lambda$testMoveObjectsIllegalArguments$34(GoogleCloudStorage gcs, Map sourceToDestinationObjectsMap) throws Throwable {
        gcs.move(sourceToDestinationObjectsMap);
    }

    private static /* synthetic */ void lambda$testCopyObjectsIllegalArguments$33(GoogleCloudStorage gcs, String b, List o, List objects) throws Throwable {
        gcs.copy(b, o, b, objects);
    }

    private static /* synthetic */ void lambda$testCopyObjectsIllegalArguments$32(GoogleCloudStorage gcs, String b, List o) throws Throwable {
        gcs.copy(b, o, b, null);
    }

    private static /* synthetic */ void lambda$testCopyObjectsIllegalArguments$31(GoogleCloudStorage gcs, String b, List o) throws Throwable {
        gcs.copy(b, null, b, o);
    }

    private static /* synthetic */ void lambda$testCopyObjectsIllegalArguments$30(GoogleCloudStorage gcs, String b, List o) throws Throwable {
        gcs.copy(b, o, b, o);
    }

    private static /* synthetic */ void lambda$testCopyObjectsIllegalArguments$29(GoogleCloudStorage gcs, String b, List o, String[] objectPair) {
        String badBucket = objectPair[0];
        List<String> badObject = Collections.singletonList(objectPair[1]);
        Assert.assertThrows(IllegalArgumentException.class, () -> gcs.copy(badBucket, badObject, b, o));
        Assert.assertThrows(IllegalArgumentException.class, () -> gcs.copy(b, o, badBucket, badObject));
    }

    private static /* synthetic */ void lambda$testDeleteObjectIllegalArguments$26(GoogleCloudStorage gcs, StorageResourceId resourceId) {
        Assert.assertThrows(IllegalArgumentException.class, () -> gcs.deleteObjects((List)ImmutableList.of((Object)resourceId)));
    }

    private static /* synthetic */ void lambda$testDeleteBucketApiException$24(GoogleCloudStorage gcs, String bucket2) throws Throwable {
        gcs.deleteBuckets((List)ImmutableList.of((Object)bucket2));
    }

    private static /* synthetic */ void lambda$testDeleteBucketApiException$23(GoogleCloudStorage gcs, String bucket1) throws Throwable {
        gcs.deleteBuckets((List)ImmutableList.of((Object)bucket1));
    }

    private static /* synthetic */ void lambda$testDeleteBucketIllegalArguments$22(GoogleCloudStorage gcs) throws Throwable {
        gcs.deleteBuckets((List)Lists.newArrayList((Object[])new String[]{""}));
    }

    private static /* synthetic */ void lambda$testDeleteBucketIllegalArguments$21(GoogleCloudStorage gcs) throws Throwable {
        gcs.deleteBuckets((List)Lists.newArrayList((Object[])new String[]{null}));
    }

    private static /* synthetic */ void lambda$testCreateBucketApiException$20(GoogleCloudStorage gcs) throws Throwable {
        gcs.createBucket(BUCKET_NAME);
    }

    private static /* synthetic */ void lambda$testCreateBucketIllegalArguments$19(GoogleCloudStorage gcs) throws Throwable {
        gcs.createBucket("");
    }

    private static /* synthetic */ void lambda$testCreateBucketIllegalArguments$18(GoogleCloudStorage gcs) throws Throwable {
        gcs.createBucket(null);
    }

    private static /* synthetic */ void lambda$testOpenObjectApiException$15(GoogleCloudStorage gcs, StorageResourceId objectId) throws Throwable {
        gcs.open(objectId);
    }

    private static /* synthetic */ void lambda$testOpenObjectIllegalArguments$3(GoogleCloudStorage gcs, StorageResourceId resourceId) {
        Assert.assertThrows(IllegalArgumentException.class, () -> gcs.open(resourceId));
    }

    private static /* synthetic */ void lambda$testCreateObjectIllegalArguments$1(GoogleCloudStorage gcs, StorageResourceId resourceId) {
        Assert.assertThrows(IllegalArgumentException.class, () -> gcs.create(resourceId));
    }
}

