/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.testing.http.MockHttpTransport;
import com.google.api.client.testing.http.MockLowLevelHttpResponse;
import com.google.api.client.util.DateTime;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.StorageObject;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageImpl;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadChannel;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageTest;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageTestUtils;
import com.google.cloud.hadoop.gcsio.MockGoogleCloudStorageImplFactory;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.gcsio.TrackingHttpRequestInitializer;
import com.google.cloud.hadoop.util.RetryHttpInitializer;
import com.google.cloud.hadoop.util.RetryHttpInitializerOptions;
import com.google.cloud.hadoop.util.testing.MockHttpTransportHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.truth.Truth;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GoogleCloudStorageReadChannelTest {
    @Test
    public void metadataInitialization_eager() throws IOException {
        StorageObject object = GoogleCloudStorageTest.newStorageObject("foo-bucket", "bar-object");
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)object)});
        ArrayList requests = new ArrayList();
        Storage storage = new Storage((HttpTransport)transport, (JsonFactory)GsonFactory.getDefaultInstance(), requests::add);
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setFastFailOnNotFoundEnabled(true).build();
        GoogleCloudStorageReadChannel readChannel = GoogleCloudStorageTestUtils.createReadChannel(storage, options);
        Truth.assertThat(requests).hasSize(1);
        Truth.assertThat((Long)readChannel.size()).isEqualTo((Object)object.getSize().longValue());
        Truth.assertThat(requests).hasSize(1);
    }

    @Test
    public void metadataInitialization_lazy() throws IOException {
        StorageObject object = GoogleCloudStorageTest.newStorageObject("foo-bucket", "bar-object");
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)object)});
        ArrayList requests = new ArrayList();
        Storage storage = new Storage((HttpTransport)transport, (JsonFactory)GsonFactory.getDefaultInstance(), requests::add);
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setFastFailOnNotFoundEnabled(false).build();
        GoogleCloudStorageReadChannel readChannel = GoogleCloudStorageTestUtils.createReadChannel(storage, options);
        Truth.assertThat(requests).isEmpty();
        Truth.assertThat((Long)readChannel.size()).isEqualTo((Object)object.getSize().longValue());
        Truth.assertThat(requests).hasSize(1);
    }

    @Test
    public void fadviseAuto_onForwardRead_switchesToRandom() throws IOException {
        int seekPosition = 5;
        byte[] testData = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        byte[] testData2 = Arrays.copyOfRange(testData, seekPosition, testData.length);
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.dataRangeResponse((byte[])Arrays.copyOfRange(testData, 1, testData.length), (long)1L, (long)testData.length), MockHttpTransportHelper.dataRangeResponse((byte[])testData2, (long)seekPosition, (long)testData2.length)});
        ArrayList requests = new ArrayList();
        Storage storage = new Storage((HttpTransport)transport, (JsonFactory)GsonFactory.getDefaultInstance(), requests::add);
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadChannelTest.newLazyReadOptionsBuilder().setFadvise(GoogleCloudStorageReadOptions.Fadvise.AUTO).setMinRangeRequestSize(1L).setInplaceSeekLimit(2L).build();
        GoogleCloudStorageReadChannel readChannel = GoogleCloudStorageTestUtils.createReadChannel(storage, options);
        byte[] readBytes = new byte[1];
        readChannel.position(1L);
        Truth.assertThat((Integer)readChannel.read(ByteBuffer.wrap(readBytes))).isEqualTo((Object)1);
        Truth.assertThat((byte[])readBytes).isEqualTo((Object)new byte[]{testData[1]});
        readChannel.position((long)seekPosition);
        Truth.assertThat((Boolean)readChannel.randomAccessStatus()).isFalse();
        Truth.assertThat((Integer)readChannel.read(ByteBuffer.wrap(readBytes))).isEqualTo((Object)1);
        Truth.assertThat((byte[])readBytes).isEqualTo((Object)new byte[]{testData[seekPosition]});
        Truth.assertThat((Boolean)readChannel.randomAccessStatus()).isTrue();
        List rangeHeaders = requests.stream().map(r -> r.getHeaders().getRange()).collect(Collectors.toList());
        Truth.assertThat(rangeHeaders).containsExactly(new Object[]{"bytes=1-", "bytes=5-5"}).inOrder();
    }

    @Test
    public void fadviseAuto_onBackwardRead_switchesToRandom() throws IOException {
        int seekPosition = 5;
        byte[] testData = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        byte[] testData2 = Arrays.copyOfRange(testData, seekPosition, testData.length);
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.dataRangeResponse((byte[])testData2, (long)seekPosition, (long)testData2.length), MockHttpTransportHelper.dataRangeResponse((byte[])testData, (long)0L, (long)testData.length)});
        ArrayList requests = new ArrayList();
        Storage storage = new Storage((HttpTransport)transport, (JsonFactory)GsonFactory.getDefaultInstance(), requests::add);
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadChannelTest.newLazyReadOptionsBuilder().setFadvise(GoogleCloudStorageReadOptions.Fadvise.AUTO).setMinRangeRequestSize(1L).build();
        GoogleCloudStorageReadChannel readChannel = GoogleCloudStorageTestUtils.createReadChannel(storage, options);
        byte[] readBytes = new byte[1];
        readChannel.position((long)seekPosition);
        Truth.assertThat((Integer)readChannel.read(ByteBuffer.wrap(readBytes))).isEqualTo((Object)1);
        Truth.assertThat((byte[])readBytes).isEqualTo((Object)new byte[]{testData[seekPosition]});
        readChannel.position(0L);
        Truth.assertThat((Boolean)readChannel.randomAccessStatus()).isFalse();
        Truth.assertThat((Integer)readChannel.read(ByteBuffer.wrap(readBytes))).isEqualTo((Object)1);
        Truth.assertThat((byte[])readBytes).isEqualTo((Object)new byte[]{testData[0]});
        Truth.assertThat((Boolean)readChannel.randomAccessStatus()).isTrue();
        List rangeHeaders = requests.stream().map(r -> r.getHeaders().getRange()).collect(Collectors.toList());
        Truth.assertThat(rangeHeaders).containsExactly(new Object[]{"bytes=5-", "bytes=0-0"}).inOrder();
    }

    @Test
    public void fadviseAutoRandom_onSequentialRead_switchToSequential() throws IOException {
        int blockSize = 3;
        byte[] testData = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        ArrayList<MockLowLevelHttpResponse> lowLevelHttpResponses = new ArrayList<MockLowLevelHttpResponse>();
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadChannelTest.newLazyReadOptionsBuilder().setFadvise(GoogleCloudStorageReadOptions.Fadvise.AUTO_RANDOM).setMinRangeRequestSize(1L).setBlockSize((long)blockSize).build();
        int requestLength = (int)options.getMinRangeRequestSize();
        int rangeStartIndex = 0;
        for (int i = 0; i <= options.getFadviseRequestTrackCount(); ++i) {
            int rangeEndIndex = rangeStartIndex + requestLength;
            if (i == options.getFadviseRequestTrackCount()) {
                rangeEndIndex = rangeStartIndex + blockSize;
            }
            MockLowLevelHttpResponse request = MockHttpTransportHelper.dataRangeResponse((byte[])Arrays.copyOfRange(testData, rangeStartIndex, rangeEndIndex), (long)rangeStartIndex, (long)testData.length);
            lowLevelHttpResponses.add(request);
            rangeStartIndex = rangeEndIndex;
        }
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])lowLevelHttpResponses.toArray(new MockLowLevelHttpResponse[lowLevelHttpResponses.size()]));
        ArrayList requests = new ArrayList();
        Storage storage = new Storage((HttpTransport)transport, (JsonFactory)GsonFactory.getDefaultInstance(), requests::add);
        GoogleCloudStorageReadChannel readChannel = GoogleCloudStorageTestUtils.createReadChannel(storage, options);
        byte[] readBytes = new byte[requestLength];
        rangeStartIndex = 0;
        for (int i = 0; i <= options.getFadviseRequestTrackCount(); ++i) {
            readChannel.position((long)rangeStartIndex);
            Truth.assertThat((Integer)readChannel.read(ByteBuffer.wrap(readBytes))).isEqualTo((Object)requestLength);
            Truth.assertThat((byte[])readBytes).isEqualTo((Object)new byte[]{testData[rangeStartIndex]});
            if (i == options.getFadviseRequestTrackCount()) {
                Truth.assertThat((Boolean)readChannel.randomAccessStatus()).isFalse();
            } else {
                Truth.assertThat((Boolean)readChannel.randomAccessStatus()).isTrue();
            }
            rangeStartIndex += requestLength;
        }
        List rangeHeaders = requests.stream().map(r -> r.getHeaders().getRange()).collect(Collectors.toList());
        Truth.assertThat(rangeHeaders).containsExactly(new Object[]{"bytes=0-0", "bytes=1-1", "bytes=2-2", "bytes=3-5"}).inOrder();
    }

    @Test
    public void footerPrefetch_reused() throws IOException {
        int footerSize = 2;
        byte[] testData = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        int footerStart = testData.length - footerSize;
        byte[] footer = Arrays.copyOfRange(testData, footerStart, testData.length);
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.dataRangeResponse((byte[])footer, (long)footerStart, (long)testData.length), MockHttpTransportHelper.dataResponse((byte[])new byte[]{testData[footerStart - 1]})});
        ArrayList requests = new ArrayList();
        Storage storage = new Storage((HttpTransport)transport, (JsonFactory)GsonFactory.getDefaultInstance(), requests::add);
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadChannelTest.newLazyReadOptionsBuilder().setFadvise(GoogleCloudStorageReadOptions.Fadvise.RANDOM).setMinRangeRequestSize((long)footerSize).build();
        GoogleCloudStorageReadChannel readChannel = GoogleCloudStorageTestUtils.createReadChannel(storage, options);
        Truth.assertThat(requests).isEmpty();
        byte[] readBytes = new byte[2];
        readChannel.position((long)footerStart);
        Truth.assertThat((Integer)readChannel.read(ByteBuffer.wrap(readBytes))).isEqualTo((Object)2);
        Truth.assertThat((Long)readChannel.size()).isEqualTo((Object)testData.length);
        Truth.assertThat((byte[])readBytes).isEqualTo((Object)Arrays.copyOfRange(testData, footerStart, testData.length));
        readChannel.position((long)(footerStart - 1));
        Truth.assertThat((Integer)readChannel.read(ByteBuffer.wrap(readBytes))).isEqualTo((Object)2);
        Truth.assertThat((byte[])readBytes).isEqualTo((Object)Arrays.copyOfRange(testData, footerStart - 1, testData.length - 1));
        List rangeHeaders = requests.stream().map(r -> r.getHeaders().getRange()).collect(Collectors.toList());
        Truth.assertThat(rangeHeaders).containsExactly(new Object[]{"bytes=8-9", "bytes=7-7"}).inOrder();
    }

    @Test
    public void read_onlyRequestedRange() throws IOException {
        int rangeSize = 2;
        int seekPosition = 0;
        byte[] testData = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        byte[] requestedContent = Arrays.copyOfRange(testData, seekPosition, seekPosition + rangeSize);
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.dataRangeResponse((byte[])requestedContent, (long)0L, (long)testData.length)});
        ArrayList requests = new ArrayList();
        Storage storage = new Storage((HttpTransport)transport, (JsonFactory)GsonFactory.getDefaultInstance(), requests::add);
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadChannelTest.newLazyReadOptionsBuilder().setFadvise(GoogleCloudStorageReadOptions.Fadvise.SEQUENTIAL).setMinRangeRequestSize(4L).setReadExactRequestedBytesEnabled(true).build();
        GoogleCloudStorageReadChannel readChannel = GoogleCloudStorageTestUtils.createReadChannel(storage, options);
        Truth.assertThat(requests).isEmpty();
        byte[] readBytes = new byte[rangeSize];
        Truth.assertThat((Integer)readChannel.read(ByteBuffer.wrap(readBytes))).isEqualTo((Object)readBytes.length);
        Truth.assertThat((Long)readChannel.size()).isEqualTo((Object)testData.length);
        Truth.assertThat((byte[])readBytes).isEqualTo((Object)requestedContent);
        List rangeHeaders = requests.stream().map(r -> r.getHeaders().getRange()).collect(Collectors.toList());
        Truth.assertThat(rangeHeaders).containsExactly(new Object[]{"bytes=0-1"}).inOrder();
    }

    @Test
    public void read_whenBufferIsEmpty() throws IOException {
        ByteBuffer emptyBuffer = ByteBuffer.wrap(new byte[0]);
        Storage storage = new Storage(GoogleCloudStorageTestUtils.HTTP_TRANSPORT, (JsonFactory)GsonFactory.getDefaultInstance(), r -> {});
        GoogleCloudStorageReadChannel readChannel = GoogleCloudStorageTestUtils.createReadChannel(storage, GoogleCloudStorageReadChannelTest.newLazyReadOptionsBuilder().build());
        Truth.assertThat((Integer)readChannel.read(emptyBuffer)).isEqualTo((Object)0);
    }

    @Test
    public void read_whenPositionIsEqualToSize() throws IOException {
        ByteBuffer readBuffer = ByteBuffer.wrap(new byte[1]);
        StorageObject object = GoogleCloudStorageTest.newStorageObject("foo-bucket", "bar-object");
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)object.setSize(BigInteger.ZERO))});
        Storage storage = new Storage((HttpTransport)transport, (JsonFactory)GsonFactory.getDefaultInstance(), r -> {});
        GoogleCloudStorageReadChannel readChannel = GoogleCloudStorageTestUtils.createReadChannel(storage, GoogleCloudStorageReadOptions.DEFAULT);
        Truth.assertThat((Long)readChannel.position()).isEqualTo((Object)readChannel.size());
        Truth.assertThat((Integer)readChannel.read(readBuffer)).isEqualTo((Object)-1);
    }

    @Test
    public void size_whenObjectIsGzipEncoded_shouldBeSetToMaxLongValue() throws IOException {
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)GoogleCloudStorageTest.newStorageObject("foo-bucket", "bar-object").setContentEncoding("gzip"))});
        Storage storage = new Storage((HttpTransport)transport, (JsonFactory)GsonFactory.getDefaultInstance(), r -> {});
        GoogleCloudStorageReadOptions readOptions = GoogleCloudStorageReadOptions.builder().setGzipEncodingSupportEnabled(true).build();
        GoogleCloudStorageReadChannel readChannel = GoogleCloudStorageTestUtils.createReadChannel(storage, readOptions);
        Truth.assertThat((Long)readChannel.size()).isEqualTo((Object)Long.MAX_VALUE);
    }

    @Test
    public void initMetadata_throwsException_whenReadConsistencyEnabledAndGenerationIsNull() throws IOException {
        Storage storage = new Storage(GoogleCloudStorageTestUtils.HTTP_TRANSPORT, (JsonFactory)GsonFactory.getDefaultInstance(), r -> {});
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadChannelTest.newLazyReadOptionsBuilder().build();
        GoogleCloudStorageReadChannel readChannel = GoogleCloudStorageTestUtils.createReadChannel(storage, options);
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> readChannel.initMetadata("gzip", 1L, -1L));
        Truth.assertThat((Throwable)e).hasMessageThat().contains((CharSequence)"Generation parameter of -1 is invalid");
    }

    @Test
    public void initMetadata_succeeds_whenReadConsistencyEnabledAndGenerationIsValid() throws IOException {
        Storage storage = new Storage(GoogleCloudStorageTestUtils.HTTP_TRANSPORT, (JsonFactory)GsonFactory.getDefaultInstance(), r -> {});
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadChannelTest.newLazyReadOptionsBuilder().setGzipEncodingSupportEnabled(true).build();
        GoogleCloudStorageReadChannel readChannel = GoogleCloudStorageTestUtils.createReadChannel(storage, options);
        readChannel.initMetadata("gzip", 1L, 1234L);
    }

    @Test
    public void initGeneration_hasGenerationId() throws IOException {
        StorageObject storageObject = GoogleCloudStorageTest.newStorageObject("foo-bucket", "bar-object");
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)storageObject)});
        ArrayList requests = new ArrayList();
        Storage storage = new Storage((HttpTransport)transport, (JsonFactory)GsonFactory.getDefaultInstance(), requests::add);
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setFastFailOnNotFoundEnabled(false).build();
        GoogleCloudStorageReadChannel readChannel = GoogleCloudStorageTestUtils.createReadChannel(storage, options);
        readChannel.size();
        Truth.assertThat((Long)readChannel.generation()).isEqualTo((Object)storageObject.getGeneration());
    }

    @Test
    public void lazyInitGeneration_succeeds_whenReadConsistencyStrict() throws IOException {
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)GoogleCloudStorageTest.newStorageObject("foo-bucket", "bar-object").setGeneration(Long.valueOf(5L)))});
        ArrayList requests = new ArrayList();
        Storage storage = new Storage((HttpTransport)transport, (JsonFactory)GsonFactory.getDefaultInstance(), requests::add);
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setFastFailOnNotFoundEnabled(false).build();
        GoogleCloudStorageReadChannel readChannel = GoogleCloudStorageTestUtils.createReadChannel(storage, options);
        readChannel.size();
        Truth.assertThat((Long)readChannel.generation()).isEqualTo((Object)5L);
    }

    @Test
    public void lazyReadFileAtSpecificGeneration_fails_ifGenerationChanged() throws IOException {
        long requestedGeneration = 5L;
        long actualGeneration = 342L;
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)GoogleCloudStorageTest.newStorageObject("foo-bucket", "bar-object").setGeneration(Long.valueOf(actualGeneration)))});
        Storage storage = new Storage((HttpTransport)transport, (JsonFactory)GsonFactory.getDefaultInstance(), new ArrayList()::add);
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setFastFailOnNotFoundEnabled(false).build();
        GoogleCloudStorageReadChannel readChannel = GoogleCloudStorageTestUtils.createReadChannel(storage, options, requestedGeneration);
        IllegalStateException exception = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ((GoogleCloudStorageReadChannel)readChannel).size());
        Truth.assertThat((Throwable)exception).hasMessageThat().contains((CharSequence)String.format("Provided generation (%d) should be equal to fetched generation (%d)", requestedGeneration, actualGeneration));
    }

    @Test
    public void eagerReadFileAtSpecificGeneration_fails_ifGenerationChanged() throws IOException {
        long requestedGeneration = 5L;
        long actualGeneration = 342L;
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)GoogleCloudStorageTest.newStorageObject("foo-bucket", "bar-object").setGeneration(Long.valueOf(actualGeneration)))});
        Storage storage = new Storage((HttpTransport)transport, (JsonFactory)GsonFactory.getDefaultInstance(), new ArrayList()::add);
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setFastFailOnNotFoundEnabled(true).build();
        IllegalStateException exception = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> GoogleCloudStorageTestUtils.createReadChannel(storage, options, requestedGeneration));
        Truth.assertThat((Throwable)exception).hasMessageThat().contains((CharSequence)String.format("Provided generation (%d) should be equal to fetched generation (%d)", requestedGeneration, actualGeneration));
    }

    @Test
    public void lazyReadFileAtSpecificGeneration_succeeds_whenReadConsistencyStrict() throws IOException {
        long generation = 5L;
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)GoogleCloudStorageTest.newStorageObject("foo-bucket", "bar-object").setGeneration(Long.valueOf(generation)))});
        ArrayList requests = new ArrayList();
        Storage storage = new Storage((HttpTransport)transport, (JsonFactory)GsonFactory.getDefaultInstance(), requests::add);
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setFastFailOnNotFoundEnabled(false).build();
        GoogleCloudStorageReadChannel readChannel = GoogleCloudStorageTestUtils.createReadChannel(storage, options, generation);
        readChannel.size();
        Truth.assertThat((Long)readChannel.generation()).isEqualTo((Object)generation);
    }

    @Test
    public void eagerReadFileAtSpecificGeneration_succeeds_whenReadConsistencyStrict() throws IOException {
        long generation = 5L;
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)GoogleCloudStorageTest.newStorageObject("foo-bucket", "bar-object").setGeneration(Long.valueOf(generation)))});
        ArrayList requests = new ArrayList();
        Storage storage = new Storage((HttpTransport)transport, (JsonFactory)GsonFactory.getDefaultInstance(), requests::add);
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setFastFailOnNotFoundEnabled(true).build();
        GoogleCloudStorageReadChannel readChannel = GoogleCloudStorageTestUtils.createReadChannel(storage, options, generation);
        Truth.assertThat((Long)readChannel.generation()).isEqualTo((Object)generation);
    }

    @Test
    public void lazyReadFileAtSpecificGeneration_fails_whenReadConsistencyStrict() throws IOException {
        long generation = 5L;
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonErrorResponse((MockHttpTransportHelper.ErrorResponses)MockHttpTransportHelper.ErrorResponses.NOT_FOUND)});
        ArrayList requests = new ArrayList();
        Storage storage = new Storage((HttpTransport)transport, (JsonFactory)GsonFactory.getDefaultInstance(), requests::add);
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setFastFailOnNotFoundEnabled(false).build();
        GoogleCloudStorageReadChannel readChannel = GoogleCloudStorageTestUtils.createReadChannel(storage, options, generation);
        Assert.assertThrows(FileNotFoundException.class, () -> ((GoogleCloudStorageReadChannel)readChannel).size());
    }

    @Test
    public void eagerReadFileAtSpecificGeneration_fails_whenReadConsistencyStrict() throws IOException {
        long generation = 5L;
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonErrorResponse((MockHttpTransportHelper.ErrorResponses)MockHttpTransportHelper.ErrorResponses.NOT_FOUND)});
        ArrayList requests = new ArrayList();
        Storage storage = new Storage((HttpTransport)transport, (JsonFactory)GsonFactory.getDefaultInstance(), requests::add);
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setFastFailOnNotFoundEnabled(true).build();
        Assert.assertThrows(FileNotFoundException.class, () -> GoogleCloudStorageTestUtils.createReadChannel(storage, options, generation));
    }

    @Test
    public void afterRetry_subsequentReads_succeed() throws IOException {
        long generation = 5L;
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonErrorResponse((MockHttpTransportHelper.ErrorResponses)MockHttpTransportHelper.ErrorResponses.NOT_FOUND), MockHttpTransportHelper.jsonDataResponse((Object)GoogleCloudStorageTest.newStorageObject("foo-bucket", "bar-object").setGeneration(Long.valueOf(generation)))});
        Storage storage = new Storage((HttpTransport)transport, (JsonFactory)GsonFactory.getDefaultInstance(), new ArrayList()::add);
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setFastFailOnNotFoundEnabled(false).build();
        GoogleCloudStorageReadChannel readChannel = GoogleCloudStorageTestUtils.createReadChannel(storage, options, generation);
        Assert.assertThrows(FileNotFoundException.class, () -> ((GoogleCloudStorageReadChannel)readChannel).size());
        Truth.assertThat((Long)readChannel.size()).isNotEqualTo((Object)0);
        Truth.assertThat((Long)readChannel.generation()).isEqualTo((Object)generation);
    }

    @Test
    public void retired_request_same_invocationId() throws IOException {
        long generation = 5L;
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonErrorResponse((MockHttpTransportHelper.ErrorResponses)MockHttpTransportHelper.ErrorResponses.RATE_LIMITED), MockHttpTransportHelper.jsonDataResponse((Object)GoogleCloudStorageTest.newStorageObject("foo-bucket", "bar-object").setGeneration(Long.valueOf(generation)))});
        TrackingHttpRequestInitializer requestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)new RetryHttpInitializer(null, RetryHttpInitializerOptions.builder().build()));
        Storage storage = new Storage((HttpTransport)transport, (JsonFactory)GsonFactory.getDefaultInstance(), (HttpRequestInitializer)requestsTracker);
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setFastFailOnNotFoundEnabled(false).build();
        GoogleCloudStorageReadChannel readChannel = GoogleCloudStorageTestUtils.createReadChannel(storage, options, generation);
        Truth.assertThat((Long)readChannel.size()).isNotEqualTo((Object)0);
        ImmutableList<String> invocationIds = requestsTracker.getAllRequestInvocationIds();
        Truth.assertThat((Integer)invocationIds.size()).isEqualTo((Object)2);
        Set<String> uniqueInvocationIds = Set.copyOf(invocationIds);
        Truth.assertThat((Integer)uniqueInvocationIds.size()).isEqualTo((Object)1);
    }

    @Test
    public void read_gzipEncoded_shouldReadAllBytes() throws IOException {
        byte[] testData = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)GoogleCloudStorageTest.newStorageObject("foo-bucket", "bar-object").setContentEncoding("gzip")), MockHttpTransportHelper.dataRangeResponse((byte[])testData, (long)0L, (long)testData.length)});
        Storage storage = new Storage((HttpTransport)transport, (JsonFactory)GsonFactory.getDefaultInstance(), r -> {});
        GoogleCloudStorageReadOptions readOptions = GoogleCloudStorageReadOptions.builder().setGzipEncodingSupportEnabled(true).build();
        GoogleCloudStorageReadChannel readChannel = GoogleCloudStorageTestUtils.createReadChannel(storage, readOptions);
        Truth.assertThat((Long)readChannel.size()).isEqualTo((Object)Long.MAX_VALUE);
        Truth.assertThat((Integer)readChannel.read(ByteBuffer.wrap(new byte[testData.length + 1]))).isEqualTo((Object)testData.length);
        Truth.assertThat((Long)readChannel.size()).isEqualTo((Object)testData.length);
    }

    @Test
    public void read_withPositiveGeneration_usesGenerationMatchPrecondition() throws IOException {
        long generation = 12345L;
        byte[] testData = new byte[]{1, 2, 3};
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)GoogleCloudStorageTest.newStorageObject("foo-bucket", "bar-object").setGeneration(Long.valueOf(generation))), MockHttpTransportHelper.dataResponse((byte[])testData)});
        ArrayList requests = new ArrayList();
        Storage storage = new Storage((HttpTransport)transport, (JsonFactory)GsonFactory.getDefaultInstance(), requests::add);
        GoogleCloudStorageReadChannel readChannel = GoogleCloudStorageTestUtils.createReadChannel(storage, GoogleCloudStorageReadOptions.builder().build(), generation);
        readChannel.read(ByteBuffer.allocate(testData.length));
        String mediaRequestUrl = TrackingHttpRequestInitializer.getMediaRequestString("foo-bucket", "bar-object", generation);
        Truth.assertThat((String)("GET:" + ((HttpRequest)requests.get(1)).getUrl().toString())).isEqualTo((Object)mediaRequestUrl);
    }

    @Test
    public void read_withZeroGeneration_doesNotUseGenerationMatchPrecondition() throws IOException {
        long requestedGeneration = 0L;
        long actualGeneration = 54321L;
        byte[] testData = new byte[]{4, 5, 6};
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)GoogleCloudStorageTest.newStorageObject("foo-bucket", "bar-object").setGeneration(Long.valueOf(actualGeneration))), MockHttpTransportHelper.dataResponse((byte[])testData)});
        ArrayList requests = new ArrayList();
        Storage storage = new Storage((HttpTransport)transport, (JsonFactory)GsonFactory.getDefaultInstance(), requests::add);
        GoogleCloudStorageReadChannel readChannel = GoogleCloudStorageTestUtils.createReadChannel(storage, GoogleCloudStorageReadOptions.builder().setFastFailOnNotFoundEnabled(false).build(), requestedGeneration);
        readChannel.read(ByteBuffer.allocate(testData.length));
        String mediaRequestUrl = TrackingHttpRequestInitializer.getMediaRequestString("foo-bucket", "bar-object");
        Truth.assertThat((String)("GET:" + ((HttpRequest)requests.get(0)).getUrl().toString())).isEqualTo((Object)mediaRequestUrl);
    }

    @Test
    public void open_gzipContentEncoding_succeeds_whenContentEncodingSupported() throws Exception {
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)GoogleCloudStorageTest.newStorageObject("foo-bucket", "bar-object").setContentEncoding("gzip"))});
        Storage storage = new Storage((HttpTransport)transport, (JsonFactory)GsonFactory.getDefaultInstance(), r -> {});
        GoogleCloudStorageReadOptions readOptions = GoogleCloudStorageReadOptions.builder().setGzipEncodingSupportEnabled(true).build();
        try (GoogleCloudStorageReadChannel channel = GoogleCloudStorageTestUtils.createReadChannel(storage, readOptions);){
            channel.position();
        }
    }

    @Test
    public void open_gzipContentEncoding_throwsIOException_ifContentEncodingNotSupported() throws Exception {
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)GoogleCloudStorageTest.newStorageObject("foo-bucket", "bar-object").setContentEncoding("gzip"))});
        Storage storage = new Storage((HttpTransport)transport, (JsonFactory)GsonFactory.getDefaultInstance(), r -> {});
        GoogleCloudStorageReadOptions readOptions = GoogleCloudStorageReadOptions.builder().setGzipEncodingSupportEnabled(false).build();
        IOException e = (IOException)Assert.assertThrows(IOException.class, () -> GoogleCloudStorageTestUtils.createReadChannel(storage, readOptions));
        Truth.assertThat((Throwable)e).hasMessageThat().isEqualTo((Object)"Cannot read GZIP encoded files - content encoding support is disabled.");
    }

    private void setUpAndValidateReadChannelMocksAndSetMaxRetries(GoogleCloudStorageReadChannel readChannel, int maxRetries) throws IOException {
        readChannel.setMaxRetries(maxRetries);
        Truth.assertThat((Boolean)readChannel.isOpen()).isTrue();
        Truth.assertThat((Long)readChannel.position()).isEqualTo((Object)0);
    }

    @Test
    public void testReadWithFailedInplaceSeekSucceeds() throws IOException {
        byte[] testData = new byte[]{1, 2, 3, 5, 8};
        byte[] testData2 = Arrays.copyOfRange(testData, 3, testData.length);
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)new StorageObject().setBucket("foo-bucket").setName("bar-object").setTimeCreated(new DateTime(11L)).setUpdated(new DateTime(12L)).setSize(BigInteger.valueOf(testData.length)).setContentEncoding(null).setGeneration(Long.valueOf(1L)).setMetageneration(Long.valueOf(1L))), MockHttpTransportHelper.inputStreamResponse((String)"Content-Length", (Object)testData.length, (InputStream)new InputStream(){
            private int current = 0;

            @Override
            public synchronized int read() throws IOException {
                if (this.current == 0) {
                    ++this.current;
                    return 1;
                }
                throw new IOException("In-place seek IOException");
            }
        }), MockHttpTransportHelper.dataResponse((Map)ImmutableMap.of((Object)"Content-Length", (Object)testData2.length), (byte[])testData2)});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsImpl((HttpTransport)transport);
        GoogleCloudStorageReadChannel readChannel = (GoogleCloudStorageReadChannel)gcs.open(new StorageResourceId("foo-bucket", "bar-object"), GoogleCloudStorageReadOptions.builder().setInplaceSeekLimit(3L).setFadvise(GoogleCloudStorageReadOptions.Fadvise.SEQUENTIAL).build());
        this.setUpAndValidateReadChannelMocksAndSetMaxRetries(readChannel, 3);
        Truth.assertThat((Integer)readChannel.read(ByteBuffer.wrap(new byte[1]))).isEqualTo((Object)1);
        readChannel.position(3L);
        byte[] byte3 = new byte[1];
        Truth.assertThat((Integer)readChannel.read(ByteBuffer.wrap(byte3))).isEqualTo((Object)1);
        Truth.assertThat((byte[])byte3).isEqualTo((Object)new byte[]{testData[3]});
    }

    @Test
    public void read_gzipped_withExceptionThrownDuringRead() throws IOException {
        long bytesRead;
        final byte[] testDataBatch = new byte[1024];
        new Random().nextBytes(testDataBatch);
        final long exceptionByte = 0x80000000L + (long)testDataBatch.length;
        final long maxLength = exceptionByte + (long)testDataBatch.length;
        long generation = 3419L;
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)GoogleCloudStorageTest.newStorageObject("foo-bucket", "bar-object").setContentEncoding("gzip").setSize(BigInteger.valueOf(maxLength / 2L)).setGeneration(Long.valueOf(generation))), MockHttpTransportHelper.inputStreamResponse((InputStream)new InputStream(){
            long bytesRead = 0L;
            boolean streamFailed;

            @Override
            public int read() throws IOException {
                if (this.streamFailed) {
                    return -1;
                }
                if (this.bytesRead == exceptionByte) {
                    throw new IOException(String.format("Read exception at %d byte", exceptionByte));
                }
                return testDataBatch[(int)(this.bytesRead++ % (long)testDataBatch.length)] & 0xFF;
            }
        }).addHeader("Content-Encoding", "gzip").addHeader("Content-Length", String.valueOf(maxLength / 2L)), MockHttpTransportHelper.inputStreamResponse((InputStream)new InputStream(){
            long bytesRead = 0L;

            @Override
            public int read() {
                return this.bytesRead < maxLength ? testDataBatch[(int)(this.bytesRead++ % (long)testDataBatch.length)] & 0xFF : -1;
            }
        }).addHeader("Content-Encoding", "gzip").addHeader("Content-Length", String.valueOf(maxLength / 2L))});
        ArrayList requests = new ArrayList();
        Storage storage = new Storage((HttpTransport)transport, (JsonFactory)GsonFactory.getDefaultInstance(), requests::add);
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setFadvise(GoogleCloudStorageReadOptions.Fadvise.SEQUENTIAL).setGzipEncodingSupportEnabled(true).build();
        GoogleCloudStorageReadChannel readChannel = GoogleCloudStorageTestUtils.createReadChannel(storage, options);
        Truth.assertThat((Long)readChannel.size()).isEqualTo((Object)Long.MAX_VALUE);
        byte[] readBytes = new byte[testDataBatch.length];
        long totalBytesRead = 0L;
        while ((bytesRead = (long)readChannel.read(ByteBuffer.wrap(readBytes))) > 0L) {
            totalBytesRead += bytesRead;
            Truth.assertThat((Long)bytesRead).isEqualTo((Object)testDataBatch.length);
            Truth.assertThat((byte[])readBytes).isEqualTo((Object)testDataBatch);
            readBytes = new byte[testDataBatch.length];
        }
        Truth.assertThat((Long)totalBytesRead).isEqualTo((Object)maxLength);
        List rangeHeaders = requests.stream().map(r -> r.getHeaders().getRange()).collect(Collectors.toList());
        Truth.assertThat(rangeHeaders).containsExactly(new Object[]{null, null, null}).inOrder();
        List requestStrings = requests.stream().map(r -> r.getRequestMethod() + ":" + String.valueOf(r.getUrl())).collect(Collectors.toList());
        Truth.assertThat(requestStrings).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString("foo-bucket", "bar-object", "contentEncoding,generation,size"), TrackingHttpRequestInitializer.getMediaRequestString("foo-bucket", "bar-object", generation), TrackingHttpRequestInitializer.getMediaRequestString("foo-bucket", "bar-object", generation)}).inOrder();
    }

    @Test
    public void openStream_gzipped_onPrematureEofInSkip_throwsEofException() throws IOException {
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)GoogleCloudStorageTest.newStorageObject("foo-bucket", "bar-object").setContentEncoding("gzip").setSize(BigInteger.valueOf(100L))), MockHttpTransportHelper.inputStreamResponse((InputStream)new InputStream(){

            @Override
            public int read() {
                return -1;
            }
        })});
        Storage storage = new Storage((HttpTransport)transport, (JsonFactory)new GsonFactory(), r -> {});
        GoogleCloudStorageReadOptions readOptions = GoogleCloudStorageReadOptions.builder().setGzipEncodingSupportEnabled(true).build();
        GoogleCloudStorageReadChannel readChannel = GoogleCloudStorageTestUtils.createReadChannel(storage, readOptions);
        readChannel.position(10L);
        EOFException e = (EOFException)Assert.assertThrows(EOFException.class, () -> readChannel.read(ByteBuffer.allocate(1)));
        Truth.assertThat((Throwable)e).hasMessageThat().isEqualTo((Object)"Unexpected end of stream trying to skip 10 bytes to seek to position 10, size: 9223372036854775807 for 'gs://foo-bucket/bar-object'");
    }

    private static GoogleCloudStorageReadOptions.Builder newLazyReadOptionsBuilder() {
        return GoogleCloudStorageReadOptions.builder().setFastFailOnNotFoundEnabled(false);
    }
}

