/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.client.http.HttpRequestInitializer;
import com.google.cloud.hadoop.gcsio.CreateObjectOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystemIntegrationHelper;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.gcsio.ListObjectOptions;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.gcsio.TrackingHttpRequestInitializer;
import com.google.cloud.hadoop.gcsio.UpdatableItemInfo;
import com.google.cloud.hadoop.util.RetryHttpInitializer;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.truth.Truth;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.zip.GZIPOutputStream;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public abstract class GoogleCloudStorageNewIntegrationTestBase {
    protected static final CreateObjectOptions GZIP_CREATE_OPTIONS = CreateObjectOptions.DEFAULT_NO_OVERWRITE.toBuilder().setContentEncoding("gzip").build();
    private static final ListObjectOptions INCLUDE_PREFIX_LIST_OPTIONS = ListObjectOptions.DEFAULT.toBuilder().setIncludePrefix(true).build();
    protected static GoogleCloudStorageOptions gcsOptions;
    protected static RetryHttpInitializer httpRequestsInitializer;
    protected static GoogleCloudStorageFileSystemIntegrationHelper gcsfsIHelper;
    @Rule
    public TestName name = new TestName();
    protected TrackingHttpRequestInitializer gcsRequestsTracker;
    protected boolean isTracingSupported = true;
    private GoogleCloudStorage gcs;

    @Before
    public void before() {
        this.gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
    }

    @After
    public void after() {
        if (this.gcs != null) {
            this.gcs.close();
            this.gcs = null;
        }
    }

    @Test
    public void listObjectInfo_nonExistentBucket_nullPrefix() throws Exception {
        this.list_nonExistentBucket_nullPrefix((gcs, bucket, prefix) -> GoogleCloudStorageNewIntegrationTestBase.getObjectNames(gcs.listObjectInfo(bucket, prefix)), (bucket, prefix) -> TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucket, prefix, null));
    }

    @Test
    public void listObjectInfoPage_nonExistentBucket_nullPrefix() throws Exception {
        this.list_nonExistentBucket_nullPrefix((gcs, bucket, prefix) -> GoogleCloudStorageNewIntegrationTestBase.getObjectNames(gcs.listObjectInfoPage(bucket, prefix, null).getItems()), (bucket, prefix) -> TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucket, prefix, null));
    }

    private void list_nonExistentBucket_nullPrefix(TriFunction<GoogleCloudStorage, String, String, List<String>> listFn, BiFunction<String, String, String> requestFn) throws Exception {
        this.gcs = this.createGoogleCloudStorage(gcsOptions);
        String testBucket = "list-neb-np_" + String.valueOf(UUID.randomUUID());
        List<String> listResult = listFn.apply(this.gcs, testBucket, null);
        Truth.assertThat(listResult).isEmpty();
        Truth.assertThat(this.gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{requestFn.apply(testBucket, null)});
    }

    @Test
    public void listObjectInfo_emptyBucket_nullPrefix() throws Exception {
        this.list_emptyBucket_nullPrefix((gcs, bucket, prefix) -> GoogleCloudStorageNewIntegrationTestBase.getObjectNames(gcs.listObjectInfo(bucket, prefix)), (bucket, prefix) -> TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucket, prefix, null));
    }

    @Test
    public void listObjectInfoPage_emptyBucket_nullPrefix() throws Exception {
        this.list_emptyBucket_nullPrefix((gcs, bucket, prefix) -> GoogleCloudStorageNewIntegrationTestBase.getObjectNames(gcs.listObjectInfoPage(bucket, prefix, null).getItems()), (bucket, prefix) -> TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucket, prefix, null));
    }

    private void list_emptyBucket_nullPrefix(TriFunction<GoogleCloudStorage, String, String, List<String>> listFn, BiFunction<String, String, String> requestFn) throws Exception {
        this.gcs = this.createGoogleCloudStorage(gcsOptions);
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.createUniqueBucket("list-eb-np");
        List<String> listResult = listFn.apply(this.gcs, testBucket, null);
        Truth.assertThat(listResult).isEmpty();
        Truth.assertThat(this.gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{requestFn.apply(testBucket, null)});
    }

    @Test
    public void listObjectInfo_nonEmptyBucket_nullPrefix_object() throws Exception {
        this.list_nonEmptyBucket_nullPrefix_object((gcs, bucket, prefix) -> GoogleCloudStorageNewIntegrationTestBase.getObjectNames(gcs.listObjectInfo(bucket, prefix)), (bucket, prefix) -> TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucket, prefix, null));
    }

    @Test
    public void listObjectInfoPage_nonEmptyBucket_nullPrefix_object() throws Exception {
        this.list_nonEmptyBucket_nullPrefix_object((gcs, bucket, prefix) -> GoogleCloudStorageNewIntegrationTestBase.getObjectNames(gcs.listObjectInfoPage(bucket, prefix, null).getItems()), (bucket, prefix) -> TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucket, prefix, null));
    }

    private void list_nonEmptyBucket_nullPrefix_object(TriFunction<GoogleCloudStorage, String, String, List<String>> listFn, BiFunction<String, String, String> requestFn) throws Exception {
        this.gcs = this.createGoogleCloudStorage(gcsOptions);
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.createUniqueBucket("list-neb-np-o");
        gcsfsIHelper.createObjects(testBucket, "obj");
        List<String> listResult = listFn.apply(this.gcs, testBucket, null);
        Truth.assertThat(listResult).containsExactly(new Object[]{"obj"});
        Truth.assertThat(this.gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{requestFn.apply(testBucket, null)});
    }

    @Test
    public void listObjectInfo_nonEmptyBucket_nullPrefix_emptyDir() throws Exception {
        this.list_nonEmptyBucket_nullPrefix_emptyDir((gcs, bucket, prefix) -> GoogleCloudStorageNewIntegrationTestBase.getObjectNames(gcs.listObjectInfo(bucket, prefix)), (bucket, prefix) -> TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucket, prefix, null));
    }

    @Test
    public void listObjectInfoPage_nonEmptyBucket_nullPrefix_emptyDir() throws Exception {
        this.list_nonEmptyBucket_nullPrefix_emptyDir((gcs, bucket, prefix) -> GoogleCloudStorageNewIntegrationTestBase.getObjectNames(gcs.listObjectInfoPage(bucket, prefix, null).getItems()), (bucket, prefix) -> TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucket, prefix, null));
    }

    private void list_nonEmptyBucket_nullPrefix_emptyDir(TriFunction<GoogleCloudStorage, String, String, List<String>> listFn, BiFunction<String, String, String> requestFn) throws Exception {
        this.gcs = this.createGoogleCloudStorage(gcsOptions);
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.createUniqueBucket("list-neb-np-ed_");
        gcsfsIHelper.createObjects(testBucket, "dir/");
        List<String> listResult = listFn.apply(this.gcs, testBucket, null);
        Truth.assertThat(listResult).containsExactly(new Object[]{"dir/"});
        Truth.assertThat(this.gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{requestFn.apply(testBucket, null)});
    }

    @Test
    public void listObjectInfo_nonEmptyBucket_nullPrefix_subDir() throws Exception {
        this.list_nonEmptyBucket_nullPrefix_subDir((gcs, bucket, prefix) -> GoogleCloudStorageNewIntegrationTestBase.getObjectNames(gcs.listObjectInfo(bucket, prefix)), (bucket, prefix) -> TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucket, prefix, null));
    }

    @Test
    public void listObjectInfoPage_nonEmptyBucket_nullPrefix_subDir() throws Exception {
        this.list_nonEmptyBucket_nullPrefix_subDir((gcs, bucket, prefix) -> GoogleCloudStorageNewIntegrationTestBase.getObjectNames(gcs.listObjectInfoPage(bucket, prefix, null).getItems()), (bucket, prefix) -> TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucket, prefix, null));
    }

    private void list_nonEmptyBucket_nullPrefix_subDir(TriFunction<GoogleCloudStorage, String, String, List<String>> listFn, BiFunction<String, String, String> requestFn) throws Exception {
        this.gcs = this.createGoogleCloudStorage(gcsOptions);
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.createUniqueBucket("list-neb-np-sd");
        gcsfsIHelper.createObjects(testBucket, "subdir/", "subdir/obj");
        List<String> listResult = listFn.apply(this.gcs, testBucket, null);
        Truth.assertThat(listResult).containsExactly(new Object[]{"subdir/"});
        Truth.assertThat(this.gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{requestFn.apply(testBucket, null)});
    }

    @Test
    public void listObjectInfo_nonEmptyBucket_nullPrefix_implicitSubDir() throws Exception {
        this.list_nonEmptyBucket_nullPrefix_implicitSubDir((gcs, bucket, prefix) -> GoogleCloudStorageNewIntegrationTestBase.getObjectNames(gcs.listObjectInfo(bucket, prefix)), (bucket, prefix) -> TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucket, prefix, null));
    }

    @Test
    public void listObjectInfoPage_nonEmptyBucket_nullPrefix_implicitSubDir() throws Exception {
        this.list_nonEmptyBucket_nullPrefix_implicitSubDir((gcs, bucket, prefix) -> GoogleCloudStorageNewIntegrationTestBase.getObjectNames(gcs.listObjectInfoPage(bucket, prefix, null).getItems()), (bucket, prefix) -> TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucket, prefix, null));
    }

    private void list_nonEmptyBucket_nullPrefix_implicitSubDir(TriFunction<GoogleCloudStorage, String, String, List<String>> listFn, BiFunction<String, String, String> requestFn) throws Exception {
        this.gcs = this.createGoogleCloudStorage(gcsOptions);
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.createUniqueBucket("list-neb-np-isd");
        gcsfsIHelper.createObjects(testBucket, "subdir/obj");
        List<String> listResult = listFn.apply(this.gcs, testBucket, null);
        Truth.assertThat(listResult).containsExactly(new Object[]{"subdir/"});
        Truth.assertThat(this.gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{requestFn.apply(testBucket, null)});
    }

    @Test
    public void listObjectInfo_prefix_doesNotExist() throws Exception {
        this.list_prefix_doesNotExist((gcs, bucket, prefix) -> GoogleCloudStorageNewIntegrationTestBase.getObjectNames(gcs.listObjectInfo(bucket, prefix)), (bucket, prefix) -> TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucket, prefix, null));
    }

    @Test
    public void listObjectInfoPage_prefix_doesNotExist() throws Exception {
        this.list_prefix_doesNotExist((gcs, bucket, prefix) -> GoogleCloudStorageNewIntegrationTestBase.getObjectNames(gcs.listObjectInfoPage(bucket, prefix, null).getItems()), (bucket, prefix) -> TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucket, prefix, null));
    }

    private void list_prefix_doesNotExist(TriFunction<GoogleCloudStorage, String, String, List<String>> listFn, BiFunction<String, String, String> requestFn) throws Exception {
        this.gcs = this.createGoogleCloudStorage(gcsOptions);
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        String testDir = String.format("list_prefix_doesNotExist_%s/", UUID.randomUUID());
        List<String> listResult = listFn.apply(this.gcs, testBucket, testDir);
        Truth.assertThat(listResult).isEmpty();
        Truth.assertThat(this.gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{requestFn.apply(testBucket, testDir)});
    }

    @Test
    public void listObjectInfo_prefixObject_empty() throws Exception {
        this.list_prefixObject_empty((gcs, bucket, prefix) -> GoogleCloudStorageNewIntegrationTestBase.getObjectNames(gcs.listObjectInfo(bucket, prefix)), (bucket, prefix) -> TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucket, prefix, null));
    }

    @Test
    public void listObjectInfoPage_prefixObject_empty() throws Exception {
        this.list_prefixObject_empty((gcs, bucket, prefix) -> GoogleCloudStorageNewIntegrationTestBase.getObjectNames(gcs.listObjectInfoPage(bucket, prefix, null).getItems()), (bucket, prefix) -> TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucket, prefix, null));
    }

    private void list_prefixObject_empty(TriFunction<GoogleCloudStorage, String, String, List<String>> listFn, BiFunction<String, String, String> requestFn) throws Exception {
        this.gcs = this.createGoogleCloudStorage(gcsOptions);
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        String testDir = this.getTestResource() + "/";
        gcsfsIHelper.createObjects(testBucket, testDir);
        List<String> listResult = listFn.apply(this.gcs, testBucket, testDir);
        Truth.assertThat(listResult).isEmpty();
        Truth.assertThat(this.gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{requestFn.apply(testBucket, testDir)});
    }

    @Test
    public void listObjectInfo_prefixObject_withObject() throws Exception {
        this.list_prefixObject_withObject((gcs, bucket, prefix) -> GoogleCloudStorageNewIntegrationTestBase.getObjectNames(gcs.listObjectInfo(bucket, prefix)), (bucket, prefix) -> TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucket, prefix, null));
    }

    @Test
    public void listObjectInfoPage_prefixObject_withObject() throws Exception {
        this.list_prefixObject_withObject((gcs, bucket, prefix) -> GoogleCloudStorageNewIntegrationTestBase.getObjectNames(gcs.listObjectInfoPage(bucket, prefix, null).getItems()), (bucket, prefix) -> TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucket, prefix, null));
    }

    private void list_prefixObject_withObject(TriFunction<GoogleCloudStorage, String, String, List<String>> listFn, BiFunction<String, String, String> requestFn) throws Exception {
        this.gcs = this.createGoogleCloudStorage(gcsOptions);
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        String testDir = this.createObjectsInTestDir(testBucket, "obj");
        List<String> listResult = listFn.apply(this.gcs, testBucket, testDir);
        Truth.assertThat(listResult).containsExactly(new Object[]{testDir + "obj"});
        Truth.assertThat(this.gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{requestFn.apply(testBucket, testDir)});
    }

    @Test
    public void listObjectInfo_prefixObject_withSubdir() throws Exception {
        this.list_prefixObject_withSubdir((gcs, bucket, prefix) -> GoogleCloudStorageNewIntegrationTestBase.getObjectNames(gcs.listObjectInfo(bucket, prefix)), (bucket, prefix) -> TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucket, prefix, null));
    }

    @Test
    public void listObjectInfoPage_prefixObject_withSubdir() throws Exception {
        this.list_prefixObject_withSubdir((gcs, bucket, prefix) -> GoogleCloudStorageNewIntegrationTestBase.getObjectNames(gcs.listObjectInfoPage(bucket, prefix, null).getItems()), (bucket, prefix) -> TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucket, prefix, null));
    }

    private void list_prefixObject_withSubdir(TriFunction<GoogleCloudStorage, String, String, List<String>> listFn, BiFunction<String, String, String> requestFn) throws Exception {
        this.gcs = this.createGoogleCloudStorage(gcsOptions);
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        String testDir = this.createObjectsInTestDir(testBucket, "sub/");
        List<String> listResult = listFn.apply(this.gcs, testBucket, testDir);
        Truth.assertThat(listResult).containsExactly(new Object[]{testDir + "sub/"});
        Truth.assertThat(this.gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{requestFn.apply(testBucket, testDir)});
    }

    @Test
    public void listObjectInfo_prefixObject_withImplicitSubdir() throws Exception {
        this.list_prefixObject_withImplicitSubdir((gcs, bucket, prefix) -> GoogleCloudStorageNewIntegrationTestBase.getObjectNames(gcs.listObjectInfo(bucket, prefix)), (bucket, prefix) -> TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucket, prefix, null));
    }

    @Test
    public void listObjectInfoPage_prefixObject_withImplicitSubdir() throws Exception {
        this.list_prefixObject_withImplicitSubdir((gcs, bucket, prefix) -> GoogleCloudStorageNewIntegrationTestBase.getObjectNames(gcs.listObjectInfoPage(bucket, prefix, null).getItems()), (bucket, prefix) -> TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucket, prefix, null));
    }

    private void list_prefixObject_withImplicitSubdir(TriFunction<GoogleCloudStorage, String, String, List<String>> listFn, BiFunction<String, String, String> requestFn) throws Exception {
        this.gcs = this.createGoogleCloudStorage(gcsOptions);
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        String testDir = this.createObjectsInTestDirWithoutSubdirs(testBucket, "sub/obj");
        gcsfsIHelper.createObjects(testBucket, testDir);
        List<String> listResult = listFn.apply(this.gcs, testBucket, testDir);
        Truth.assertThat(listResult).containsExactly(new Object[]{testDir + "sub/"});
        Truth.assertThat(this.gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{requestFn.apply(testBucket, testDir)});
    }

    @Test
    public void listObjectInfo_implicitPrefix_withObject() throws Exception {
        this.list_implicitPrefix_withObject((gcs, bucket, prefix) -> GoogleCloudStorageNewIntegrationTestBase.getObjectNames(gcs.listObjectInfo(bucket, prefix)), (bucket, prefix) -> TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucket, prefix, null));
    }

    @Test
    public void listObjectInfoPage_implicitPrefix_withObject() throws Exception {
        this.list_implicitPrefix_withObject((gcs, bucket, prefix) -> GoogleCloudStorageNewIntegrationTestBase.getObjectNames(gcs.listObjectInfoPage(bucket, prefix, null).getItems()), (bucket, prefix) -> TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucket, prefix, null));
    }

    private void list_implicitPrefix_withObject(TriFunction<GoogleCloudStorage, String, String, List<String>> listFn, BiFunction<String, String, String> requestFn) throws Exception {
        this.gcs = this.createGoogleCloudStorage(gcsOptions);
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        String testDir = this.createObjectsInTestDirWithoutSubdirs(testBucket, "obj");
        List<String> listResult = listFn.apply(this.gcs, testBucket, testDir);
        Truth.assertThat(listResult).containsExactly(new Object[]{testDir + "obj"});
        Truth.assertThat(this.gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{requestFn.apply(testBucket, testDir)});
    }

    @Test
    public void listObjectInfo_implicitPrefix_withSubdir() throws Exception {
        this.list_implicitPrefix_withSubdir((gcs, bucket, prefix) -> GoogleCloudStorageNewIntegrationTestBase.getObjectNames(gcs.listObjectInfo(bucket, prefix)), (bucket, prefix) -> TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucket, prefix, null));
    }

    @Test
    public void listObjectInfoPage_implicitPrefix_withSubdir() throws Exception {
        this.list_implicitPrefix_withSubdir((gcs, bucket, prefix) -> GoogleCloudStorageNewIntegrationTestBase.getObjectNames(gcs.listObjectInfoPage(bucket, prefix, null).getItems()), (bucket, prefix) -> TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucket, prefix, null));
    }

    private void list_implicitPrefix_withSubdir(TriFunction<GoogleCloudStorage, String, String, List<String>> listFn, BiFunction<String, String, String> requestFn) throws Exception {
        this.gcs = this.createGoogleCloudStorage(gcsOptions);
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        String testDir = this.createObjectsInTestDirWithoutSubdirs(testBucket, "sub/");
        List<String> listResult = listFn.apply(this.gcs, testBucket, testDir);
        Truth.assertThat(listResult).containsExactly(new Object[]{testDir + "sub/"});
        Truth.assertThat(this.gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{requestFn.apply(testBucket, testDir)});
    }

    @Test
    public void listObjectInfo_implicitPrefix_withImplicitSubdir() throws Exception {
        this.list_implicitPrefix_withImplicitSubdir((gcs, bucket, prefix) -> GoogleCloudStorageNewIntegrationTestBase.getObjectNames(gcs.listObjectInfo(bucket, prefix)), (bucket, prefix) -> TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucket, prefix, null));
    }

    @Test
    public void listObjectInfoPage_implicitPrefix_withImplicitSubdir() throws Exception {
        this.list_implicitPrefix_withImplicitSubdir((gcs, bucket, prefix) -> GoogleCloudStorageNewIntegrationTestBase.getObjectNames(gcs.listObjectInfoPage(bucket, prefix, null).getItems()), (bucket, prefix) -> TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucket, prefix, null));
    }

    private void list_implicitPrefix_withImplicitSubdir(TriFunction<GoogleCloudStorage, String, String, List<String>> listFn, BiFunction<String, String, String> requestFn) throws Exception {
        this.gcs = this.createGoogleCloudStorage(gcsOptions);
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        String testDir = this.createObjectsInTestDirWithoutSubdirs(testBucket, "sub/obj");
        List<String> listResult = listFn.apply(this.gcs, testBucket, testDir);
        Truth.assertThat(listResult).containsExactly(new Object[]{testDir + "sub/"});
        Truth.assertThat(this.gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{requestFn.apply(testBucket, testDir)});
    }

    @Test
    public void listObjectInfo_withLimit_oneGcsRequest() throws Exception {
        this.gcs = this.createGoogleCloudStorage(gcsOptions);
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        String testDir = this.createObjectsInTestDir(testBucket, "f1", "f2", "f3");
        List listedObjects = this.gcs.listObjectInfo(testBucket, testDir, ListObjectOptions.DEFAULT.toBuilder().setMaxResults(1L).build());
        Truth.assertThat(GoogleCloudStorageNewIntegrationTestBase.getObjectNames(listedObjects)).containsExactly(new Object[]{testDir + "f1"});
        Truth.assertThat(this.gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestString(testBucket, true, testDir, 2, null)});
    }

    @Test
    public void listObjectInfo_withLimit_multipleGcsRequests() throws Exception {
        int maxResultsPerRequest = 1;
        this.gcs = this.createGoogleCloudStorage(gcsOptions.toBuilder().setMaxListItemsPerCall(maxResultsPerRequest).build());
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        String testDir = this.createObjectsInTestDir(testBucket, "f1", "f2", "f3", "f4");
        List listedObjects = this.gcs.listObjectInfo(testBucket, testDir, ListObjectOptions.DEFAULT.toBuilder().setMaxResults(2L).build());
        Truth.assertThat(GoogleCloudStorageNewIntegrationTestBase.getObjectNames(listedObjects)).containsExactly(new Object[]{testDir + "f1", testDir + "f2"});
        Truth.assertThat(this.gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestString(testBucket, true, testDir, maxResultsPerRequest, null), TrackingHttpRequestInitializer.listRequestString(testBucket, true, testDir, maxResultsPerRequest, "token_1"), TrackingHttpRequestInitializer.listRequestString(testBucket, true, testDir, maxResultsPerRequest, "token_2")});
    }

    @Test
    public void listObjectInfo_withoutLimits() throws Exception {
        int maxResultsPerRequest = 1;
        GoogleCloudStorageOptions options = gcsOptions.toBuilder().setMaxListItemsPerCall(maxResultsPerRequest).build();
        this.gcs = this.createGoogleCloudStorage(options);
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        String testDir = this.createObjectsInTestDir(testBucket, "f1", "f2", "f3");
        List listedObjects = this.gcs.listObjectInfo(testBucket, testDir);
        Truth.assertThat(GoogleCloudStorageNewIntegrationTestBase.getObjectNames(listedObjects)).containsExactly(new Object[]{testDir + "f1", testDir + "f2", testDir + "f3"});
        Truth.assertThat(this.gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestString(testBucket, true, testDir, maxResultsPerRequest, null), TrackingHttpRequestInitializer.listRequestString(testBucket, true, testDir, maxResultsPerRequest, "token_1"), TrackingHttpRequestInitializer.listRequestString(testBucket, true, testDir, maxResultsPerRequest, "token_2"), TrackingHttpRequestInitializer.listRequestString(testBucket, true, testDir, maxResultsPerRequest, "token_3")});
    }

    @Test
    public void listObjectInfo_includePrefix_emptyBucket() throws Exception {
        this.gcs = this.createGoogleCloudStorage(gcsOptions);
        String testBucket = gcsfsIHelper.createUniqueBucket("lst-objs_incl-pfx_empty-bckt");
        List listedObjects = this.gcs.listObjectInfo(testBucket, null, INCLUDE_PREFIX_LIST_OPTIONS);
        Truth.assertThat(GoogleCloudStorageNewIntegrationTestBase.getObjectNames(listedObjects)).isEmpty();
        Truth.assertThat(this.gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(testBucket, null, null)});
    }

    @Test
    public void listObjectInfo_includePrefix_objectInBucket() throws Exception {
        this.gcs = this.createGoogleCloudStorage(gcsOptions);
        String testBucket = gcsfsIHelper.createUniqueBucket("lst-objs_incl-pfx_obj-in-bckt");
        gcsfsIHelper.createObjects(testBucket, "obj");
        List listedObjects = this.gcs.listObjectInfo(testBucket, null, INCLUDE_PREFIX_LIST_OPTIONS);
        Truth.assertThat(GoogleCloudStorageNewIntegrationTestBase.getObjectNames(listedObjects)).containsExactly(new Object[]{"obj"});
        Truth.assertThat(this.gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(testBucket, null, null)});
    }

    @Test
    public void listObjectInfo_includePrefix_implicitDirInBucket() throws Exception {
        this.gcs = this.createGoogleCloudStorage(gcsOptions);
        String testBucket = gcsfsIHelper.createUniqueBucket(UUID.randomUUID().toString().replaceAll("-", "").substring(0, 10));
        gcsfsIHelper.createObjects(testBucket, "implDir/obj");
        List listedObjects = this.gcs.listObjectInfo(testBucket, null, INCLUDE_PREFIX_LIST_OPTIONS);
        Truth.assertThat(GoogleCloudStorageNewIntegrationTestBase.getObjectNames(listedObjects)).containsExactly(new Object[]{"implDir/"});
        Truth.assertThat(this.gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(testBucket, null, null)});
    }

    @Test
    public void listObjectInfo_includePrefix_onlyPrefixObject() throws Exception {
        this.gcs = this.createGoogleCloudStorage(gcsOptions);
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        String testDir = this.createObjectsInTestDir(testBucket, "dir/") + "dir/";
        List listedObjects = this.gcs.listObjectInfo(testBucket, testDir, INCLUDE_PREFIX_LIST_OPTIONS);
        Truth.assertThat(GoogleCloudStorageNewIntegrationTestBase.getObjectNames(listedObjects)).containsExactly(new Object[]{testDir});
        Truth.assertThat(this.gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(testBucket, testDir, null)});
    }

    @Test
    public void listObjectInfo_includePrefix_object() throws Exception {
        this.gcs = this.createGoogleCloudStorage(gcsOptions);
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        String testDir = this.createObjectsInTestDir(testBucket, "obj");
        List listedObjects = this.gcs.listObjectInfo(testBucket, testDir, INCLUDE_PREFIX_LIST_OPTIONS);
        Truth.assertThat(GoogleCloudStorageNewIntegrationTestBase.getObjectNames(listedObjects)).containsExactly(new Object[]{testDir, testDir + "obj"});
        Truth.assertThat(this.gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(testBucket, testDir, null)});
    }

    @Test
    public void listObjectInfo_includePrefix_subdir() throws Exception {
        this.gcs = this.createGoogleCloudStorage(gcsOptions);
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        String testDir = this.createObjectsInTestDir(testBucket, "dir/");
        List listedObjects = this.gcs.listObjectInfo(testBucket, testDir, INCLUDE_PREFIX_LIST_OPTIONS);
        Truth.assertThat(GoogleCloudStorageNewIntegrationTestBase.getObjectNames(listedObjects)).containsExactly(new Object[]{testDir, testDir + "dir/"});
        Truth.assertThat(this.gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(testBucket, testDir, null)});
    }

    @Test
    public void listObjectInfo_includePrefix_implicitPrefixObject() throws Exception {
        this.gcs = this.createGoogleCloudStorage(gcsOptions);
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        String testDir = this.createObjectsInTestDirWithoutSubdirs(testBucket, "obj");
        List listedObjects = this.gcs.listObjectInfo(testBucket, testDir, INCLUDE_PREFIX_LIST_OPTIONS);
        Truth.assertThat(GoogleCloudStorageNewIntegrationTestBase.getObjectNames(listedObjects)).containsExactly(new Object[]{testDir, testDir + "obj"});
        Truth.assertThat(this.gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(testBucket, testDir, null)});
    }

    @Test
    public void listObjectInfo_includePrefix_implicitSubdir() throws Exception {
        this.gcs = this.createGoogleCloudStorage(gcsOptions);
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        String testDir = this.createObjectsInTestDirWithoutSubdirs(testBucket, "dir/obj");
        List listedObjects = this.gcs.listObjectInfo(testBucket, testDir, INCLUDE_PREFIX_LIST_OPTIONS);
        Truth.assertThat(GoogleCloudStorageNewIntegrationTestBase.getObjectNames(listedObjects)).containsExactly(new Object[]{testDir, testDir + "dir/"});
        Truth.assertThat(this.gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(testBucket, testDir, null)});
    }

    @Test
    public void listObjectInfo_allMetadataFieldsCorrect() throws Exception {
        this.gcs = this.createGoogleCloudStorage(gcsOptions);
        String testDirName = this.name.getMethodName() + "/";
        StorageResourceId objectId = new StorageResourceId(GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1, testDirName + "object");
        CreateObjectOptions createOptions = GZIP_CREATE_OPTIONS.toBuilder().setMetadata((Map)ImmutableMap.of((Object)"test-key", (Object)"val".getBytes(StandardCharsets.UTF_8))).build();
        try (GZIPOutputStream os = new GZIPOutputStream(Channels.newOutputStream(GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.gcs.create(objectId, createOptions)));){
            ((OutputStream)os).write((String.valueOf(objectId) + "-content").getBytes(StandardCharsets.UTF_8));
        }
        List listedObjects = this.gcs.listObjectInfo(objectId.getBucketName(), testDirName);
        Truth.assertThat(GoogleCloudStorageNewIntegrationTestBase.getObjectNames(listedObjects)).containsExactly(new Object[]{objectId.getObjectName()});
        GoogleCloudStorageNewIntegrationTestBase.assertObjectFields(objectId, (GoogleCloudStorageItemInfo)listedObjects.get(0));
        Truth.assertThat(this.gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(objectId.getBucketName(), testDirName, null)});
    }

    @Test
    public void listObjectInfoStartingFrom_negativeMaxResult() throws Exception {
        this.gcs = this.createGoogleCloudStorage(gcsOptions);
        String bucketName = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        String testDirName = this.name.getMethodName() + "/";
        String fileName = testDirName + "I_am_file";
        StorageResourceId fileResource = new StorageResourceId(bucketName, fileName);
        GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.gcs.createEmptyObject(fileResource);
        int maxResults = -1;
        ListObjectOptions listOptionsLimitResults = ListObjectOptions.DEFAULT_USING_START_OFFSET.toBuilder().setMaxResults((long)maxResults).build();
        this.gcs.listObjectInfoStartingFrom(bucketName, testDirName, listOptionsLimitResults);
        Truth.assertThat(this.gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestWithStartOffset(bucketName, testDirName, null, 5000)});
    }

    @Test
    public void listObjectInfoStartingFrom_startOffsetNotObject() throws Exception {
        this.gcs = this.createGoogleCloudStorage(gcsOptions);
        String bucketName = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        String testDirName = this.name.getMethodName() + "/";
        String fileName = testDirName + "I_am_file";
        StorageResourceId fileResource = new StorageResourceId(bucketName, fileName);
        GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.gcs.createEmptyObject(fileResource);
        String startOffset = testDirName.substring(5, testDirName.length() - 1);
        List listedObjects = this.gcs.listObjectInfoStartingFrom(bucketName, startOffset);
        this.verifyListedFilesOrder(listedObjects, startOffset);
        Truth.assertThat(this.gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestWithStartOffset(bucketName, startOffset, null)});
    }

    @Test
    public void listObjectInfoStartingFrom_sortedListFiles() throws Exception {
        this.gcs = this.createGoogleCloudStorage(gcsOptions);
        String bucketName = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        String testDirName = this.name.getMethodName() + "/";
        ArrayList<StorageResourceId> resources = new ArrayList<StorageResourceId>();
        int filesCount = 50;
        for (int i = 0; i < filesCount; ++i) {
            String uniqueFilename = UUID.randomUUID().toString().replaceAll("-", "").substring(0, 12);
            StorageResourceId file = new StorageResourceId(bucketName, testDirName + uniqueFilename);
            GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.gcs.createEmptyObject(file);
            resources.add(file);
        }
        List sortedResources = resources.stream().sorted(Comparator.comparing(StorageResourceId::getObjectName)).collect(Collectors.toList());
        Assert.assertTrue((sortedResources.size() == resources.size() ? 1 : 0) != 0);
        List listedObjects = this.gcs.listObjectInfoStartingFrom(bucketName, testDirName);
        this.verifyListedFilesOrder(listedObjects, testDirName);
        for (int i = 0; i < filesCount; ++i) {
            Truth.assertThat((String)GoogleCloudStorageNewIntegrationTestBase.getObjectNames(listedObjects).get(i)).isEqualTo((Object)((StorageResourceId)sortedResources.get(i)).getObjectName());
        }
        Truth.assertThat(this.gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestWithStartOffset(bucketName, testDirName, null)});
    }

    @Test
    public void listObjectInfoStartingFrom_invalidListOptions() throws Exception {
        String bucketName = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        this.gcs = this.createGoogleCloudStorage(gcsOptions);
        String dir = this.name.getMethodName() + "2/";
        String fileName = dir + "I_am_file";
        StorageResourceId fileResource = new StorageResourceId(bucketName, fileName);
        GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.gcs.createEmptyObject(fileResource);
        Assert.assertThrows(IOException.class, () -> this.gcs.listObjectInfoStartingFrom(GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1, dir, ListObjectOptions.DEFAULT));
    }

    @Test
    public void listObjectInfoStartingFrom_multipleListCalls() throws Exception {
        String bucketName = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        this.gcs = this.createGoogleCloudStorage(gcsOptions);
        String dir1 = this.name.getMethodName() + "1/";
        StorageResourceId dirResource1 = new StorageResourceId(bucketName, dir1);
        String dir2 = this.name.getMethodName() + "2/";
        StorageResourceId dirResource2 = new StorageResourceId(bucketName, dir2);
        String fileName = dir2 + "I_am_file";
        StorageResourceId fileResource = new StorageResourceId(bucketName, fileName);
        GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.gcs.createEmptyObject(dirResource1);
        GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.gcs.createEmptyObject(dirResource2);
        GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.gcs.createEmptyObject(fileResource);
        int maxResults = 2;
        ListObjectOptions listOptionsLimitResults = ListObjectOptions.DEFAULT_USING_START_OFFSET.toBuilder().setMaxResults((long)maxResults).build();
        List listedObjects = this.gcs.listObjectInfoStartingFrom(GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1, dir1, listOptionsLimitResults);
        Truth.assertThat(GoogleCloudStorageNewIntegrationTestBase.getObjectNames(listedObjects)).doesNotContain((Object)dirResource1);
        Truth.assertThat(GoogleCloudStorageNewIntegrationTestBase.getObjectNames(listedObjects)).doesNotContain((Object)dirResource2);
        Truth.assertThat((String)GoogleCloudStorageNewIntegrationTestBase.getObjectNames(listedObjects).get(0)).isEqualTo((Object)fileResource.getObjectName());
        Truth.assertThat(this.gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestWithStartOffset(bucketName, dir1, null, maxResults), TrackingHttpRequestInitializer.listRequestWithStartOffset(bucketName, dir1, "token_1", maxResults)});
    }

    @Test
    public void listObjectInfoStartingFrom_filterDirObjects() throws Exception {
        this.gcs = this.createGoogleCloudStorage(gcsOptions);
        String testDirName = this.name.getMethodName() + "/";
        StorageResourceId objectId1 = new StorageResourceId(GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1, testDirName + "object1");
        String subDirName = testDirName + "subDir/";
        StorageResourceId directoryResource = new StorageResourceId(GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1, subDirName);
        StorageResourceId objectId2 = new StorageResourceId(GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1, subDirName + "subObject1");
        GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.gcs.createEmptyObject(objectId1);
        GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.gcs.createEmptyObject(directoryResource);
        GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.gcs.createEmptyObject(objectId2);
        List listedObjects = this.gcs.listObjectInfoStartingFrom(GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1, testDirName);
        this.verifyListedFilesOrder(listedObjects, testDirName);
        Truth.assertThat(GoogleCloudStorageNewIntegrationTestBase.getObjectNames(listedObjects)).doesNotContain((Object)directoryResource);
        Truth.assertThat((String)GoogleCloudStorageNewIntegrationTestBase.getObjectNames(listedObjects).get(0)).isEqualTo((Object)objectId1.getObjectName());
        Truth.assertThat((String)GoogleCloudStorageNewIntegrationTestBase.getObjectNames(listedObjects).get(1)).isEqualTo((Object)objectId2.getObjectName());
        Truth.assertThat(this.gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestWithStartOffset(objectId1.getBucketName(), testDirName, null)});
    }

    @Test
    public void listObjectInfoStartingFrom_listSubDirFiles() throws Exception {
        this.gcs = this.createGoogleCloudStorage(gcsOptions);
        String testDirName = this.name.getMethodName() + "/";
        StorageResourceId objectId1 = new StorageResourceId(GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1, testDirName + "object1");
        String subDirName = testDirName + "subDir/";
        StorageResourceId objectId2 = new StorageResourceId(GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1, subDirName + "subObject1");
        GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.gcs.createEmptyObject(objectId2);
        GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.gcs.createEmptyObject(objectId1);
        List listedObjects = this.gcs.listObjectInfoStartingFrom(GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1, testDirName);
        this.verifyListedFilesOrder(listedObjects, testDirName);
        Truth.assertThat((String)GoogleCloudStorageNewIntegrationTestBase.getObjectNames(listedObjects).get(0)).isEqualTo((Object)objectId1.getObjectName());
        Truth.assertThat((String)GoogleCloudStorageNewIntegrationTestBase.getObjectNames(listedObjects).get(1)).isEqualTo((Object)objectId2.getObjectName());
        Truth.assertThat(this.gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestWithStartOffset(objectId1.getBucketName(), testDirName, null)});
    }

    @Test
    public void listObjectInfoStartingFrom_allMetadataFieldsCorrect() throws Exception {
        this.gcs = this.createGoogleCloudStorage(gcsOptions);
        String testDirName = this.name.getMethodName() + "/";
        StorageResourceId objectId2 = new StorageResourceId(GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1, testDirName + "object2");
        StorageResourceId objectId1 = new StorageResourceId(GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1, testDirName + "object1");
        CreateObjectOptions createOptions = GZIP_CREATE_OPTIONS.toBuilder().setMetadata((Map)ImmutableMap.of((Object)"test-key", (Object)"val".getBytes(StandardCharsets.UTF_8))).build();
        GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.gcs.createEmptyObject(objectId2, createOptions);
        GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.gcs.createEmptyObject(objectId1, createOptions);
        List listedObjects = this.gcs.listObjectInfoStartingFrom(GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1, testDirName);
        this.verifyListedFilesOrder(listedObjects, testDirName);
        Truth.assertThat((String)GoogleCloudStorageNewIntegrationTestBase.getObjectNames(listedObjects).get(0)).isEqualTo((Object)objectId1.getObjectName());
        Truth.assertThat((String)GoogleCloudStorageNewIntegrationTestBase.getObjectNames(listedObjects).get(1)).isEqualTo((Object)objectId2.getObjectName());
        GoogleCloudStorageNewIntegrationTestBase.assertObjectFields(objectId1, (GoogleCloudStorageItemInfo)listedObjects.get(0));
        Truth.assertThat(this.gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestWithStartOffset(objectId1.getBucketName(), testDirName, null)});
    }

    @Test
    public void getItemInfo_allMetadataFieldsCorrect() throws Exception {
        this.gcs = this.createGoogleCloudStorage(gcsOptions);
        StorageResourceId objectId = new StorageResourceId(GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1, this.name.getMethodName());
        CreateObjectOptions createOptions = GZIP_CREATE_OPTIONS.toBuilder().setMetadata((Map)ImmutableMap.of((Object)"test-key", (Object)"val".getBytes(StandardCharsets.UTF_8))).build();
        try (GZIPOutputStream os = new GZIPOutputStream(Channels.newOutputStream(GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.gcs.create(objectId, createOptions)));){
            ((OutputStream)os).write((String.valueOf(objectId) + "-content").getBytes(StandardCharsets.UTF_8));
        }
        GoogleCloudStorageItemInfo object = this.gcs.getItemInfo(objectId);
        GoogleCloudStorageNewIntegrationTestBase.assertObjectFields(objectId, object);
        if (this.isTracingSupported) {
            Truth.assertThat(this.gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(objectId.getBucketName(), objectId.getObjectName())});
        }
    }

    @Test
    public void getItemInfo_oneGcsRequest() throws Exception {
        this.gcs = this.createGoogleCloudStorage(gcsOptions);
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        String testDir = this.createObjectsInTestDir(testBucket, "f1");
        GoogleCloudStorageItemInfo object = this.gcs.getItemInfo(new StorageResourceId(testBucket, testDir + "f1"));
        Truth.assertThat((String)object.getObjectName()).isEqualTo((Object)(testDir + "f1"));
        if (this.isTracingSupported) {
            Truth.assertThat(this.gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(testBucket, testDir + "f1")});
        }
    }

    @Test
    public void getItemInfos_withoutLimits() throws Exception {
        this.gcs = this.createGoogleCloudStorage(gcsOptions);
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        String testDir = this.createObjectsInTestDir(testBucket, "f1", "f2", "f3");
        ImmutableList resourceIdsList = ImmutableList.of((Object)new StorageResourceId(testBucket, testDir + "f1"), (Object)new StorageResourceId(testBucket, testDir + "f2"), (Object)new StorageResourceId(testBucket, testDir + "f3"));
        List objects = this.gcs.getItemInfos((List)resourceIdsList);
        Truth.assertThat(GoogleCloudStorageNewIntegrationTestBase.getObjectNames(objects)).containsExactly(new Object[]{testDir + "f1", testDir + "f2", testDir + "f3"});
        if (this.isTracingSupported) {
            Truth.assertThat(this.gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.batchRequestString(), TrackingHttpRequestInitializer.getRequestString(testBucket, testDir + "f1"), TrackingHttpRequestInitializer.getRequestString(testBucket, testDir + "f2"), TrackingHttpRequestInitializer.getRequestString(testBucket, testDir + "f3")});
        }
    }

    @Test
    public void getItemInfos_withLimit_zeroBatchGcsRequest() throws Exception {
        this.gcs = this.createGoogleCloudStorage(gcsOptions.toBuilder().setMaxRequestsPerBatch(1).build());
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        String testDir = this.createObjectsInTestDir(testBucket, "f1", "f2", "f3");
        ImmutableList resourceIdsList = ImmutableList.of((Object)new StorageResourceId(testBucket, testDir + "f1"), (Object)new StorageResourceId(testBucket, testDir + "f2"), (Object)new StorageResourceId(testBucket, testDir + "f3"));
        List objects = this.gcs.getItemInfos((List)resourceIdsList);
        Truth.assertThat(GoogleCloudStorageNewIntegrationTestBase.getObjectNames(objects)).containsExactly(new Object[]{testDir + "f1", testDir + "f2", testDir + "f3"});
        if (this.isTracingSupported) {
            Truth.assertThat(this.gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(testBucket, testDir + "f1"), TrackingHttpRequestInitializer.getRequestString(testBucket, testDir + "f2"), TrackingHttpRequestInitializer.getRequestString(testBucket, testDir + "f3")});
        }
    }

    @Test
    public void getItemInfos_withLimit_multipleBatchGcsRequest() throws Exception {
        this.gcs = this.createGoogleCloudStorage(gcsOptions.toBuilder().setMaxRequestsPerBatch(2).build());
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        String testDir = this.createObjectsInTestDir(testBucket, "f1", "f2", "f3");
        ImmutableList resourceIdsList = ImmutableList.of((Object)new StorageResourceId(testBucket, testDir + "f1"), (Object)new StorageResourceId(testBucket, testDir + "f2"), (Object)new StorageResourceId(testBucket, testDir + "f3"));
        List objects = this.gcs.getItemInfos((List)resourceIdsList);
        Truth.assertThat(GoogleCloudStorageNewIntegrationTestBase.getObjectNames(objects)).containsExactly(new Object[]{testDir + "f1", testDir + "f2", testDir + "f3"});
        if (this.isTracingSupported) {
            Truth.assertThat(this.gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.batchRequestString(), TrackingHttpRequestInitializer.getRequestString(testBucket, testDir + "f1"), TrackingHttpRequestInitializer.getRequestString(testBucket, testDir + "f2"), TrackingHttpRequestInitializer.batchRequestString(), TrackingHttpRequestInitializer.getRequestString(testBucket, testDir + "f3")});
        }
    }

    @Test
    public void updateItems_withoutLimits() throws Exception {
        this.gcs = this.createGoogleCloudStorage(gcsOptions);
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        String testDir = this.createObjectsInTestDir(testBucket, "f1");
        StorageResourceId resourceId = new StorageResourceId(testBucket, testDir + "f1");
        ImmutableMap updatedMetadata = ImmutableMap.of((Object)"test-metadata", (Object)"test-value".getBytes(StandardCharsets.UTF_8));
        List updatedObjects = this.gcs.updateItems((List)ImmutableList.of((Object)new UpdatableItemInfo(resourceId, (Map)updatedMetadata)));
        Truth.assertThat(GoogleCloudStorageNewIntegrationTestBase.getObjectNames(updatedObjects)).containsExactly(new Object[]{testDir + "f1"});
        Truth.assertThat(((GoogleCloudStorageItemInfo)updatedObjects.get(0)).getMetadata().keySet()).isEqualTo(updatedMetadata.keySet());
        if (this.isTracingSupported) {
            Truth.assertThat(this.gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.postRequestString(testBucket, testDir + "f1")});
        }
    }

    @Test
    public void updateItems_withLimits_MultipleBatchGcsRequests() throws Exception {
        this.gcs = this.createGoogleCloudStorage(gcsOptions.toBuilder().setMaxRequestsPerBatch(2).build());
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        String testDir = this.createObjectsInTestDir(testBucket, "f1", "f2", "f3");
        ImmutableMap updatedMetadata = ImmutableMap.of((Object)"test-metadata", (Object)"test-value".getBytes(StandardCharsets.UTF_8));
        List updatedObjects = this.gcs.updateItems((List)ImmutableList.of((Object)new UpdatableItemInfo(new StorageResourceId(testBucket, testDir + "f1"), (Map)updatedMetadata), (Object)new UpdatableItemInfo(new StorageResourceId(testBucket, testDir + "f2"), (Map)updatedMetadata), (Object)new UpdatableItemInfo(new StorageResourceId(testBucket, testDir + "f3"), (Map)updatedMetadata)));
        Truth.assertThat(GoogleCloudStorageNewIntegrationTestBase.getObjectNames(updatedObjects)).containsExactly(new Object[]{testDir + "f1", testDir + "f2", testDir + "f3"});
        Truth.assertThat(((GoogleCloudStorageItemInfo)updatedObjects.get(0)).getMetadata().keySet()).isEqualTo(updatedMetadata.keySet());
        if (this.isTracingSupported) {
            Truth.assertThat(this.gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.batchRequestString(), TrackingHttpRequestInitializer.postRequestString(testBucket, testDir + "f1"), TrackingHttpRequestInitializer.postRequestString(testBucket, testDir + "f2"), TrackingHttpRequestInitializer.batchRequestString(), TrackingHttpRequestInitializer.postRequestString(testBucket, testDir + "f3")});
        }
    }

    @Test
    public void copy_withoutLimits_withDisabledCopyWithRewrites() throws Exception {
        this.gcs = this.createGoogleCloudStorage(gcsOptions);
        String testBucket1 = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        String testBucket2 = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName2;
        String testDir = this.createObjectsInTestDir(testBucket1, "f1", "f2", "f3");
        this.gcs.copy(testBucket1, (List)ImmutableList.of((Object)(testDir + "f1"), (Object)(testDir + "f2")), testBucket2, (List)ImmutableList.of((Object)(testDir + "f4"), (Object)(testDir + "f5")));
        if (this.isTracingSupported) {
            Truth.assertThat(this.gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getBucketRequestString(testBucket1), TrackingHttpRequestInitializer.getBucketRequestString(testBucket2), TrackingHttpRequestInitializer.batchRequestString(), TrackingHttpRequestInitializer.copyRequestString(testBucket1, testDir + "f1", testBucket2, testDir + "f4", "copyTo"), TrackingHttpRequestInitializer.copyRequestString(testBucket1, testDir + "f2", testBucket2, testDir + "f5", "copyTo")});
        }
        List<String> listedObjects = GoogleCloudStorageNewIntegrationTestBase.getObjectNames(this.gcs.listObjectInfo(testBucket2, testDir));
        Truth.assertThat(listedObjects).containsExactly(new Object[]{testDir + "f4", testDir + "f5"});
    }

    @Test
    public void copy_withoutLimits_withEnabledCopyWithRewrites() throws Exception {
        this.gcs = this.createGoogleCloudStorage(gcsOptions.toBuilder().setBatchThreads(0).setCopyWithRewriteEnabled(true).setMaxRewriteChunkSize(0L).build());
        String testBucket1 = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        String testBucket2 = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName2;
        String testDir = this.createObjectsInTestDir(testBucket1, "f1", "f2", "f3");
        this.gcs.copy(testBucket1, (List)ImmutableList.of((Object)(testDir + "f1"), (Object)(testDir + "f2")), testBucket2, (List)ImmutableList.of((Object)(testDir + "f4"), (Object)(testDir + "f5")));
        if (this.isTracingSupported) {
            Truth.assertThat(this.gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getBucketRequestString(testBucket1), TrackingHttpRequestInitializer.getBucketRequestString(testBucket2), TrackingHttpRequestInitializer.batchRequestString(), TrackingHttpRequestInitializer.copyRequestString(testBucket1, testDir + "f1", testBucket2, testDir + "f4", "rewriteTo"), TrackingHttpRequestInitializer.copyRequestString(testBucket1, testDir + "f2", testBucket2, testDir + "f5", "rewriteTo")});
        }
        List<String> listedObjects = GoogleCloudStorageNewIntegrationTestBase.getObjectNames(this.gcs.listObjectInfo(testBucket2, testDir));
        Truth.assertThat(listedObjects).containsExactly(new Object[]{testDir + "f4", testDir + "f5"});
    }

    @Test
    public void deleteObjects_withoutLimit() throws Exception {
        this.gcs = this.createGoogleCloudStorage(gcsOptions);
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        String testDir = this.createObjectsInTestDir(testBucket, "f1", "f2", "f3");
        this.gcs.deleteObjects((List)ImmutableList.of((Object)new StorageResourceId(testBucket, testDir + "f1"), (Object)new StorageResourceId(testBucket, testDir + "f2")));
        if (this.isTracingSupported) {
            Truth.assertThat(this.gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.batchRequestString(), TrackingHttpRequestInitializer.getRequestString(testBucket, testDir + "f1", "generation"), TrackingHttpRequestInitializer.getRequestString(testBucket, testDir + "f2", "generation"), TrackingHttpRequestInitializer.batchRequestString(), TrackingHttpRequestInitializer.deleteRequestString(testBucket, testDir + "f1", 1L), TrackingHttpRequestInitializer.deleteRequestString(testBucket, testDir + "f2", 2L)});
        }
        List<String> listedObjects = GoogleCloudStorageNewIntegrationTestBase.getObjectNames(this.gcs.listObjectInfo(testBucket, testDir));
        Truth.assertThat(listedObjects).containsExactly(new Object[]{testDir + "f3"});
    }

    @Test
    public void deleteObjects_withLimit_zeroBatchGcsRequest() throws Exception {
        this.gcs = this.createGoogleCloudStorage(gcsOptions.toBuilder().setMaxRequestsPerBatch(1).build());
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        String testDir = this.createObjectsInTestDir(testBucket, "f1", "f2", "f3");
        this.gcs.deleteObjects((List)ImmutableList.of((Object)new StorageResourceId(testBucket, testDir + "f1"), (Object)new StorageResourceId(testBucket, testDir + "f2")));
        if (this.isTracingSupported) {
            Truth.assertThat(this.gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(testBucket, testDir + "f1", "generation"), TrackingHttpRequestInitializer.deleteRequestString(testBucket, testDir + "f1", 1L), TrackingHttpRequestInitializer.getRequestString(testBucket, testDir + "f2", "generation"), TrackingHttpRequestInitializer.deleteRequestString(testBucket, testDir + "f2", 2L)});
        }
        List<String> listedObjects = GoogleCloudStorageNewIntegrationTestBase.getObjectNames(this.gcs.listObjectInfo(testBucket, testDir));
        Truth.assertThat(listedObjects).containsExactly(new Object[]{testDir + "f3"});
    }

    @Test
    public void composeObject_withoutLimit() throws Exception {
        this.gcs = this.createGoogleCloudStorage(gcsOptions);
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        String testDir = this.createObjectsInTestDir(testBucket, "f1", "f2");
        this.gcs.compose(testBucket, (List)ImmutableList.of((Object)(testDir + "f1"), (Object)(testDir + "f2")), testDir + "f3", null);
        if (this.isTracingSupported) {
            Truth.assertThat(this.gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(testBucket, testDir + "f3"), TrackingHttpRequestInitializer.composeRequestString(testBucket, testDir + "f3", 1)});
        }
        List<String> listedObjects = GoogleCloudStorageNewIntegrationTestBase.getObjectNames(this.gcs.listObjectInfo(testBucket, testDir));
        Truth.assertThat(listedObjects).containsExactly(new Object[]{testDir + "f1", testDir + "f2", testDir + "f3"});
    }

    @Test
    public void create_gzipEncodedFile() throws Exception {
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        StorageResourceId testFile = new StorageResourceId(testBucket, this.getTestResource());
        this.gcs = this.createGoogleCloudStorage(gcsOptions);
        try (GZIPOutputStream os = new GZIPOutputStream(Channels.newOutputStream(this.gcs.create(testFile, GZIP_CREATE_OPTIONS)));){
            ((OutputStream)os).write("content".getBytes(StandardCharsets.UTF_8));
        }
        if (this.isTracingSupported) {
            Truth.assertThat(this.gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(testBucket, testFile.getObjectName()), TrackingHttpRequestInitializer.resumableUploadRequestString(testBucket, testFile.getObjectName(), 1, true), TrackingHttpRequestInitializer.resumableUploadChunkRequestString(testBucket, testFile.getObjectName(), 2, 1)});
        }
        Truth.assertThat((String)this.gcs.getItemInfo(testFile).getContentEncoding()).isEqualTo((Object)"gzip");
    }

    @Test
    public void open_gzipEncoded_succeeds_ifContentEncodingSupportEnabled() throws Exception {
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        StorageResourceId testFile = new StorageResourceId(testBucket, this.getTestResource());
        try (GZIPOutputStream os = new GZIPOutputStream(Channels.newOutputStream(GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.gcs.create(testFile, GZIP_CREATE_OPTIONS)));){
            ((OutputStream)os).write("content".getBytes(StandardCharsets.UTF_8));
        }
        long generationId = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.gcs.getItemInfo(testFile).getContentGeneration();
        this.gcs = this.createGoogleCloudStorage(gcsOptions);
        byte[] readContent = new byte[7];
        GoogleCloudStorageReadOptions readOptions = GoogleCloudStorageReadOptions.builder().setGzipEncodingSupportEnabled(true).build();
        try (SeekableByteChannel channel = this.gcs.open(testFile, readOptions);){
            channel.read(ByteBuffer.wrap(readContent));
        }
        Truth.assertThat((String)new String(readContent, StandardCharsets.UTF_8)).isEqualTo((Object)"content");
        if (this.isTracingSupported) {
            Truth.assertThat(this.gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(testBucket, testFile.getObjectName(), "contentEncoding,generation,size"), TrackingHttpRequestInitializer.getMediaRequestString(testBucket, testFile.getObjectName(), generationId)}).inOrder();
        }
    }

    @Test
    public void open_gzipEncoded_rangeRead_succeed() throws Exception {
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        StorageResourceId testFile = new StorageResourceId(testBucket, this.getTestResource());
        String data = "content";
        try (GZIPOutputStream os = new GZIPOutputStream(Channels.newOutputStream(GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.gcs.create(testFile, GZIP_CREATE_OPTIONS)));){
            ((OutputStream)os).write(data.getBytes(StandardCharsets.UTF_8));
        }
        long generationId = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.gcs.getItemInfo(testFile).getContentGeneration();
        this.gcs = this.createGoogleCloudStorage(gcsOptions);
        int startIndex = 2;
        int endIndex = 4;
        byte[] readContent = new byte[endIndex - startIndex];
        GoogleCloudStorageReadOptions readOptions = GoogleCloudStorageReadOptions.builder().setGzipEncodingSupportEnabled(true).build();
        try (SeekableByteChannel channel = this.gcs.open(testFile, readOptions);){
            channel.position(startIndex);
            channel.read(ByteBuffer.wrap(readContent));
        }
        Truth.assertThat((String)new String(readContent, StandardCharsets.UTF_8)).isEqualTo((Object)data.substring(startIndex, endIndex));
        if (this.isTracingSupported) {
            Truth.assertThat(this.gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(testBucket, testFile.getObjectName(), "contentEncoding,generation,size"), TrackingHttpRequestInitializer.getMediaRequestString(testBucket, testFile.getObjectName(), generationId)}).inOrder();
        }
    }

    @Test
    public void open_itemInfo_gzipEncoded_succeeds_ifContentEncodingSupportEnabled() throws Exception {
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        StorageResourceId testFile = new StorageResourceId(testBucket, this.getTestResource());
        try (GZIPOutputStream os = new GZIPOutputStream(Channels.newOutputStream(GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.gcs.create(testFile, GZIP_CREATE_OPTIONS)));){
            ((OutputStream)os).write("content".getBytes(StandardCharsets.UTF_8));
        }
        GoogleCloudStorageItemInfo itemInfo = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.gcs.getItemInfo(testFile);
        this.gcs = this.createGoogleCloudStorage(gcsOptions);
        byte[] readContent = new byte[7];
        GoogleCloudStorageReadOptions readOptions = GoogleCloudStorageReadOptions.builder().setGzipEncodingSupportEnabled(true).build();
        try (SeekableByteChannel channel = this.gcs.open(itemInfo, readOptions);){
            channel.read(ByteBuffer.wrap(readContent));
        }
        Truth.assertThat((String)new String(readContent, StandardCharsets.UTF_8)).isEqualTo((Object)"content");
        if (this.isTracingSupported) {
            Truth.assertThat(this.gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getMediaRequestString(testBucket, testFile.getObjectName(), itemInfo.getContentGeneration())});
        }
    }

    @Test
    public void open_gzipEncoded_fails_ifContentEncodingSupportDisabled() throws Exception {
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        StorageResourceId testFile = new StorageResourceId(testBucket, this.getTestResource());
        try (GZIPOutputStream os = new GZIPOutputStream(Channels.newOutputStream(GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.gcs.create(testFile, GZIP_CREATE_OPTIONS)));){
            ((OutputStream)os).write("content".getBytes(StandardCharsets.UTF_8));
        }
        this.gcs = this.createGoogleCloudStorage(gcsOptions);
        GoogleCloudStorageReadOptions readOptions = GoogleCloudStorageReadOptions.builder().setGzipEncodingSupportEnabled(false).build();
        IOException e = (IOException)Assert.assertThrows(IOException.class, () -> this.gcs.open(testFile, readOptions));
        Truth.assertThat((Throwable)e).hasMessageThat().isEqualTo((Object)"Cannot read GZIP encoded files - content encoding support is disabled.");
        if (this.isTracingSupported) {
            Truth.assertThat(this.gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(testBucket, testFile.getObjectName(), "contentEncoding,generation,size")});
        }
    }

    @Test
    public void open_itemInfo_gzipEncoded_fails_ifContentEncodingSupportDisabled() throws Exception {
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        StorageResourceId testFile = new StorageResourceId(testBucket, this.getTestResource());
        try (GZIPOutputStream os = new GZIPOutputStream(Channels.newOutputStream(GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.gcs.create(testFile, GZIP_CREATE_OPTIONS)));){
            ((OutputStream)os).write("content".getBytes(StandardCharsets.UTF_8));
        }
        this.gcs = this.createGoogleCloudStorage(gcsOptions);
        GoogleCloudStorageItemInfo itemInfo = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.gcs.getItemInfo(testFile);
        GoogleCloudStorageReadOptions readOptions = GoogleCloudStorageReadOptions.builder().setGzipEncodingSupportEnabled(false).build();
        IOException e = (IOException)Assert.assertThrows(IOException.class, () -> this.gcs.open(itemInfo, readOptions));
        Truth.assertThat((Throwable)e).hasMessageThat().isEqualTo((Object)"Cannot read GZIP encoded files - content encoding support is disabled.");
        Truth.assertThat(this.gcsRequestsTracker.getAllRequestStrings()).isEmpty();
    }

    @Test
    public void open_itemInfo_fails_ifInvalidItemInfo() throws Exception {
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        StorageResourceId testFile = new StorageResourceId(testBucket, this.getTestResource());
        this.gcs = this.createGoogleCloudStorage(gcsOptions);
        GoogleCloudStorageItemInfo itemInfo = GoogleCloudStorageItemInfo.createNotFound((StorageResourceId)testFile);
        GoogleCloudStorageReadOptions readOptions = GoogleCloudStorageReadOptions.builder().build();
        FileNotFoundException e = (FileNotFoundException)Assert.assertThrows(FileNotFoundException.class, () -> this.gcs.open(itemInfo, readOptions));
        Truth.assertThat((Throwable)e).hasMessageThat().startsWith("Item not found");
        Truth.assertThat(this.gcsRequestsTracker.getAllRequestStrings()).isEmpty();
    }

    protected static List<String> getObjectNames(List<GoogleCloudStorageItemInfo> listedObjects) {
        return listedObjects.stream().map(GoogleCloudStorageItemInfo::getObjectName).collect(Collectors.toList());
    }

    private static String createUniqueBucket(String suffix) throws IOException {
        return gcsfsIHelper.createUniqueBucket(suffix + UUID.randomUUID().toString().substring(0, 8));
    }

    private static void assertObjectFields(StorageResourceId expectedObjectId, GoogleCloudStorageItemInfo object) throws IOException {
        GoogleCloudStorageItemInfo expectedObjectItemInfo = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.gcs.getItemInfo(expectedObjectId);
        Truth.assertThat((Object)object).isEqualTo((Object)expectedObjectItemInfo);
        Truth.assertThat((String)object.getLocation()).isNull();
        Truth.assertThat((String)object.getStorageClass()).isNull();
    }

    private String createObjectsInTestDir(String bucketName, String ... objects) throws Exception {
        String testDir = this.getTestResource() + "/";
        String[] objectPaths = (String[])Arrays.stream(objects).map(o -> testDir + o).toArray(String[]::new);
        gcsfsIHelper.createObjectsWithSubdirs(bucketName, objectPaths);
        return testDir;
    }

    private String createObjectsInTestDirWithoutSubdirs(String bucketName, String ... objects) throws Exception {
        String testDir = this.getTestResource() + "/";
        String[] objectPaths = (String[])Arrays.stream(objects).map(o -> testDir + o).toArray(String[]::new);
        gcsfsIHelper.createObjects(bucketName, objectPaths);
        return testDir;
    }

    private void verifyListedFilesOrder(List<GoogleCloudStorageItemInfo> listedObjects, String startOffset) {
        if (listedObjects.size() > 1) {
            Assert.assertTrue((boolean)IntStream.range(0, listedObjects.size() - 1).allMatch(i -> ((GoogleCloudStorageItemInfo)listedObjects.get(i)).getObjectName().compareTo(((GoogleCloudStorageItemInfo)listedObjects.get(i + 1)).getObjectName()) <= 0));
        }
        Assert.assertTrue((boolean)IntStream.range(0, listedObjects.size() - 1).allMatch(i -> ((GoogleCloudStorageItemInfo)listedObjects.get(i)).getObjectName().compareTo(startOffset) >= 0));
    }

    protected abstract GoogleCloudStorage createGoogleCloudStorage(GoogleCloudStorageOptions var1) throws IOException;

    protected String getTestResource() {
        return this.name.getMethodName() + "_" + String.valueOf(UUID.randomUUID());
    }

    @FunctionalInterface
    private static interface TriFunction<A, B, C, R> {
        public R apply(A var1, B var2, C var3) throws IOException;

        default public <V> TriFunction<A, B, C, V> andThen(Function<? super R, ? extends V> after) {
            return (a, b, c) -> ((Function)Preconditions.checkNotNull((Object)after)).apply(this.apply(a, b, c));
        }
    }
}

