/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.gcsio.GoogleCloudStorageClientImpl;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.integration.GoogleCloudStorageTestHelper;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nullable;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GoogleCloudStorageJavaStorageClientCachingIntegrationTest {
    @Test
    public void reusesCachedStorageClient_cacheEnabled() throws IOException {
        GoogleCloudStorageClientImpl test_gcs1 = this.createGcsClient(null, true);
        GoogleCloudStorageClientImpl test_gcs2 = this.createGcsClient(null, true);
        Assert.assertEquals((Object)test_gcs1.storageWrapper, (Object)test_gcs2.storageWrapper);
    }

    @Test
    public void createsNewClient_cacheEnabled() throws IOException {
        GoogleCloudStorageOptions.Builder testOptionsBuilder = GoogleCloudStorageTestHelper.getStandardOptionBuilder().setTraceLogEnabled(Boolean.valueOf(true)).setHttpRequestHeaders((Map)ImmutableMap.of((Object)"header-key", (Object)"header-value"));
        GoogleCloudStorageClientImpl test_gcs1 = this.createGcsClient(testOptionsBuilder, true);
        GoogleCloudStorageClientImpl test_gcs2 = this.createGcsClient(null, true);
        Assert.assertNotEquals((Object)test_gcs1.storageWrapper, (Object)test_gcs2.storageWrapper);
    }

    @Test
    public void createsNewClient_cacheDisabled() throws IOException {
        GoogleCloudStorageClientImpl test_gcs1 = this.createGcsClient(null, false);
        GoogleCloudStorageClientImpl test_gcs2 = this.createGcsClient(null, false);
        Assert.assertNotEquals((Object)test_gcs1.storageWrapper, (Object)test_gcs2.storageWrapper);
    }

    private GoogleCloudStorageClientImpl createGcsClient(@Nullable GoogleCloudStorageOptions.Builder optionsBuilder, boolean enableCache) throws IOException {
        if (optionsBuilder == null) {
            optionsBuilder = GoogleCloudStorageTestHelper.getStandardOptionBuilder();
        }
        optionsBuilder.setStorageClientCachingEnabled(enableCache);
        return GoogleCloudStorageClientImpl.builder().setOptions(optionsBuilder.build()).setCredentials(null).setDownscopedAccessTokenFn(ignore -> "testDownscopedAccessToken").build();
    }
}

