/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.client.http.HttpRequestInitializer;
import com.google.auth.Credentials;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystem;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystemImpl;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystemIntegrationHelper;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystemOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageImpl;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageNewIntegrationTestBase;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.integration.GoogleCloudStorageTestHelper;
import com.google.cloud.hadoop.util.RetryHttpInitializer;
import com.google.common.base.Preconditions;
import java.io.IOException;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GoogleCloudStorageHttpClientNewIntegrationTest
extends GoogleCloudStorageNewIntegrationTestBase {
    @BeforeClass
    public static void beforeClass() throws Throwable {
        Credentials credentials = (Credentials)Preconditions.checkNotNull((Object)GoogleCloudStorageTestHelper.getCredentials(), (Object)"credentials must not be null");
        gcsOptions = GoogleCloudStorageTestHelper.getStandardOptionBuilder().setBatchThreads(0).setCopyWithRewriteEnabled(false).build();
        httpRequestsInitializer = new RetryHttpInitializer(credentials, gcsOptions.toRetryHttpInitializerOptions());
        GoogleCloudStorageFileSystemImpl gcsfs = new GoogleCloudStorageFileSystemImpl(credentials, GoogleCloudStorageFileSystemOptions.builder().setBucketDeleteEnabled(true).setCloudStorageOptions(gcsOptions).setClientType(GoogleCloudStorageFileSystemOptions.ClientType.HTTP_API_CLIENT).build());
        gcsfsIHelper = new GoogleCloudStorageFileSystemIntegrationHelper((GoogleCloudStorageFileSystem)gcsfs);
        gcsfsIHelper.beforeAllTests();
    }

    @AfterClass
    public static void afterClass() {
        gcsfsIHelper.afterAllTests();
    }

    @Override
    protected GoogleCloudStorage createGoogleCloudStorage(GoogleCloudStorageOptions options) throws IOException {
        return GoogleCloudStorageImpl.builder().setOptions(options).setCredentials(httpRequestsInitializer.getCredentials()).setHttpRequestInitializer((HttpRequestInitializer)this.gcsRequestsTracker).build();
    }
}

