/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.gcsio.GoogleCloudStorageExceptions;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GoogleCloudStorageExceptionsTest {
    @Test
    public void testGetFileNotFoundExceptionThrowsWhenBucketNameIsNull() {
        Assert.assertThrows(IllegalArgumentException.class, () -> GoogleCloudStorageExceptions.createFileNotFoundException(null, (String)"obj", null));
    }

    @Test
    public void testGetFileNotFoundExceptionThrowsWhenBucketNameIsEmpty() {
        Assert.assertThrows(IllegalArgumentException.class, () -> GoogleCloudStorageExceptions.createFileNotFoundException((String)"", (String)"obj", null));
    }

    @Test
    public void testGetFileNotFoundException() {
        Truth.assertThat((Throwable)GoogleCloudStorageExceptions.createFileNotFoundException((String)"bucket", null, null)).hasMessageThat().startsWith("Item not found: 'gs://bucket/'.");
        Truth.assertThat((Throwable)GoogleCloudStorageExceptions.createFileNotFoundException((String)"bucket", (String)"", null)).hasMessageThat().startsWith("Item not found: 'gs://bucket/'.");
        Truth.assertThat((Throwable)GoogleCloudStorageExceptions.createFileNotFoundException((String)"bucket", (String)"obj", null)).hasMessageThat().startsWith("Item not found: 'gs://bucket/obj'.");
    }

    @Test
    public void createFileNotFoundException_withCause() {
        IOException cause = new IOException("cause exception");
        FileNotFoundException e = GoogleCloudStorageExceptions.createFileNotFoundException((String)"bucket", (String)"object", (IOException)cause);
        Truth.assertThat((Throwable)e).hasCauseThat().isSameInstanceAs((Object)cause);
    }

    @Test
    public void testConstructorThrowsWhenInnerExceptionsAreEmpty() {
        ImmutableList emptyList = ImmutableList.of();
        Assert.assertThrows(IllegalArgumentException.class, () -> GoogleCloudStorageExceptionsTest.lambda$testConstructorThrowsWhenInnerExceptionsAreEmpty$2((List)emptyList));
    }

    @Test
    public void testConstructorThrowsWhenInnerExceptionsAreNull() {
        Assert.assertThrows(IllegalArgumentException.class, () -> GoogleCloudStorageExceptions.createCompositeException(null));
    }

    @Test
    public void createCompositeException_withSingleInnerException() {
        IOException inner = new IOException("inner exception");
        IOException compositeException = GoogleCloudStorageExceptions.createCompositeException((Collection)ImmutableList.of((Object)inner));
        Truth.assertThat((Throwable)inner).isSameInstanceAs((Object)compositeException);
    }

    @Test
    public void createCompositeException_withMultipleInnerExceptions() {
        IOException inner1 = new IOException("inner exception 1");
        IOException inner2 = new IOException("inner exception 2");
        IOException compositeException = GoogleCloudStorageExceptions.createCompositeException((Collection)ImmutableList.of((Object)inner1, (Object)inner2));
        Truth.assertThat((Throwable)inner1).isNotSameInstanceAs((Object)compositeException);
        Truth.assertThat((Throwable)inner2).isNotSameInstanceAs((Object)compositeException);
        Truth.assertThat((Throwable)compositeException).hasMessageThat().isEqualTo((Object)"Multiple IOExceptions.");
        Truth.assertThat((Object[])compositeException.getSuppressed()).isEqualTo((Object)new Throwable[]{inner1, inner2});
        Truth.assertThat((Throwable)compositeException.getSuppressed()[0]).isSameInstanceAs((Object)inner1);
        Truth.assertThat((Throwable)compositeException.getSuppressed()[1]).isSameInstanceAs((Object)inner2);
    }

    private static /* synthetic */ void lambda$testConstructorThrowsWhenInnerExceptionsAreEmpty$2(List emptyList) throws Throwable {
        GoogleCloudStorageExceptions.createCompositeException((Collection)emptyList);
    }
}

