/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.testing.http.MockHttpTransport;
import com.google.auth.Credentials;
import com.google.cloud.WriteChannel;
import com.google.cloud.hadoop.gcsio.CreateObjectOptions;
import com.google.cloud.hadoop.gcsio.FakeWriteChannel;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageClientImpl;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageClientWriteChannel;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.gcsio.integration.GoogleCloudStorageTestHelper;
import com.google.cloud.hadoop.util.AsyncWriteChannelOptions;
import com.google.cloud.hadoop.util.RetryHttpInitializer;
import com.google.cloud.hadoop.util.RetryHttpInitializerOptions;
import com.google.cloud.hadoop.util.testing.FakeCredentials;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.BlobWriteSession;
import com.google.cloud.storage.Storage;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import com.google.storage.v2.ServiceConstants;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class GoogleCloudStorageClientWriteChannelTest {
    private static final String BUCKET_NAME = "bucket-name";
    private static final String OBJECT_NAME = "object-name";
    private static final String CONTENT_TYPE = "image/jpeg";
    private static final String CONTENT_ENCODING = "content-encoding";
    private static final String KMS_KEY = "kms-key";
    private static final long GENERATION_ID = 0L;
    private static final Map<String, String> metadata = Map.of("metadata-key-1", "dGVzdC1tZXRhZGF0YQ==");
    private static ExecutorService EXECUTOR_SERVICE = Executors.newCachedThreadPool();
    private final StorageResourceId resourceId = new StorageResourceId("bucket-name", "object-name", 0L);
    private GoogleCloudStorageClientWriteChannel writeChannel;
    private Storage mockedStorage = (Storage)Mockito.mock(Storage.class);
    private WriteChannel fakeWriteChannel;
    private final BlobWriteSession mockBlobWriteSession = (BlobWriteSession)Mockito.mock(BlobWriteSession.class);
    private ArgumentCaptor<BlobInfo> blobInfoCapture = ArgumentCaptor.forClass(BlobInfo.class);
    ArgumentCaptor<Storage.BlobWriteOption> blobWriteOptionsCapture = ArgumentCaptor.forClass(Storage.BlobWriteOption.class);

    @Before
    public void setUp() throws Exception {
        this.fakeWriteChannel = (WriteChannel)Mockito.spy((Object)new FakeWriteChannel());
        Mockito.when((Object)this.mockedStorage.blobWriteSession((BlobInfo)this.blobInfoCapture.capture(), new Storage.BlobWriteOption[]{(Storage.BlobWriteOption)this.blobWriteOptionsCapture.capture()})).thenReturn((Object)this.mockBlobWriteSession);
        Mockito.when((Object)this.mockBlobWriteSession.open()).thenReturn((Object)this.fakeWriteChannel);
        this.writeChannel = this.getJavaStorageChannel();
    }

    @AfterClass
    public static void cleanUp() {
        try {
            EXECUTOR_SERVICE.shutdown();
        }
        finally {
            EXECUTOR_SERVICE = null;
        }
    }

    @Test
    public void writeMultipleChunksSuccess() throws IOException {
        int numberOfChunks = 10;
        ByteString data = GoogleCloudStorageTestHelper.createTestData(ServiceConstants.Values.MAX_WRITE_CHUNK_BYTES.getNumber() * numberOfChunks);
        this.writeChannel.write(data.asReadOnlyByteBuffer());
        this.writeChannel.close();
        ((WriteChannel)Mockito.verify((Object)this.fakeWriteChannel, (VerificationMode)Mockito.times((int)1))).write((ByteBuffer)ArgumentMatchers.any());
        ((WriteChannel)Mockito.verify((Object)this.fakeWriteChannel, (VerificationMode)Mockito.times((int)1))).close();
        GoogleCloudStorageClientWriteChannelTest.verifyBlobInfoProperties(this.blobInfoCapture, this.resourceId);
        GoogleCloudStorageClientWriteChannelTest.verifyBlobWriteOptionProperties(this.blobWriteOptionsCapture);
    }

    @Test
    public void writeSingleChunkSuccess() throws IOException {
        int numberOfChunks = 1;
        ByteString data = GoogleCloudStorageTestHelper.createTestData(ServiceConstants.Values.MAX_WRITE_CHUNK_BYTES.getNumber() * numberOfChunks - 1);
        this.writeChannel.write(data.asReadOnlyByteBuffer());
        this.writeChannel.close();
        ((WriteChannel)Mockito.verify((Object)this.fakeWriteChannel, (VerificationMode)Mockito.times((int)1))).write((ByteBuffer)ArgumentMatchers.any());
        ((WriteChannel)Mockito.verify((Object)this.fakeWriteChannel, (VerificationMode)Mockito.times((int)1))).close();
        GoogleCloudStorageClientWriteChannelTest.verifyBlobInfoProperties(this.blobInfoCapture, this.resourceId);
        GoogleCloudStorageClientWriteChannelTest.verifyBlobWriteOptionProperties(this.blobWriteOptionsCapture);
    }

    private GoogleCloudStorageClientWriteChannel getJavaStorageChannel() throws IOException {
        return new GoogleCloudStorageClientWriteChannel(this.mockedStorage, GoogleCloudStorageOptions.DEFAULT.toBuilder().setWriteChannelOptions(AsyncWriteChannelOptions.DEFAULT.toBuilder().setGrpcChecksumsEnabled(true).build()).build(), this.resourceId, CreateObjectOptions.DEFAULT_NO_OVERWRITE.toBuilder().setContentType(CONTENT_TYPE).setContentEncoding(CONTENT_ENCODING).setMetadata(GoogleCloudStorageTestHelper.getDecodedMetadata(metadata)).setKmsKeyName(KMS_KEY).build());
    }

    private static void verifyBlobInfoProperties(ArgumentCaptor<BlobInfo> blobInfoCapture, StorageResourceId resourceId) {
        BlobInfo blobInfo = (BlobInfo)blobInfoCapture.getValue();
        Truth.assertThat((String)blobInfo.getBucket()).isEqualTo((Object)resourceId.getBucketName());
        Truth.assertThat((String)blobInfo.getName()).isEqualTo((Object)resourceId.getObjectName());
        Truth.assertThat((String)blobInfo.getContentType()).isEqualTo((Object)CONTENT_TYPE);
        Truth.assertThat((String)blobInfo.getContentEncoding()).isEqualTo((Object)CONTENT_ENCODING);
        Truth.assertThat((Map)blobInfo.getMetadata()).isEqualTo(metadata);
    }

    private static void verifyBlobWriteOptionProperties(ArgumentCaptor<Storage.BlobWriteOption> blobWriteOptionsCapture) {
        List optionsList = blobWriteOptionsCapture.getAllValues();
        Truth.assertThat((Iterable)optionsList).containsExactly(new Object[]{Storage.BlobWriteOption.kmsKeyName((String)KMS_KEY), Storage.BlobWriteOption.generationMatch(), Storage.BlobWriteOption.disableGzipContent(), Storage.BlobWriteOption.crc32cMatch()});
    }

    private GoogleCloudStorage mockGcsJavaStorage(MockHttpTransport transport, Storage clientLibraryStorage) throws IOException {
        FakeCredentials fakeCredentials = new FakeCredentials();
        GoogleCloudStorageOptions options = GoogleCloudStorageOptions.builder().setAppName("gcsio-unit-test").setGrpcEnabled(true).build();
        return GoogleCloudStorageClientImpl.builder().setOptions(options).setCredentials((Credentials)fakeCredentials).setHttpTransport((HttpTransport)transport).setHttpRequestInitializer((HttpRequestInitializer)new RetryHttpInitializer((Credentials)fakeCredentials, RetryHttpInitializerOptions.builder().setDefaultUserAgent("gcsio-unit-test").build())).setClientLibraryStorage(clientLibraryStorage).build();
    }
}

