/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.client.http.HttpTransport;
import com.google.api.client.testing.http.MockHttpTransport;
import com.google.cloud.hadoop.gcsio.CreateBucketOptions;
import com.google.cloud.hadoop.gcsio.CreateObjectOptions;
import com.google.cloud.hadoop.gcsio.FakeServer;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageClientImpl;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageImpl;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.gcsio.MockGoogleCloudStorageImplFactory;
import com.google.cloud.hadoop.gcsio.MockStorage;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.gcsio.StringPaths;
import com.google.cloud.hadoop.gcsio.UpdatableItemInfo;
import com.google.cloud.hadoop.gcsio.integration.GoogleCloudStorageTest;
import com.google.cloud.hadoop.util.ErrorTypeExtractor;
import com.google.cloud.hadoop.util.testing.MockHttpTransportHelper;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.truth.Truth;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Empty;
import com.google.protobuf.Timestamp;
import com.google.storage.v2.Bucket;
import com.google.storage.v2.BucketName;
import com.google.storage.v2.ComposeObjectRequest;
import com.google.storage.v2.CreateBucketRequest;
import com.google.storage.v2.DeleteBucketRequest;
import com.google.storage.v2.DeleteObjectRequest;
import com.google.storage.v2.ListBucketsResponse;
import com.google.storage.v2.MoveObjectRequest;
import com.google.storage.v2.RewriteObjectRequest;
import com.google.storage.v2.RewriteResponse;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.time.Duration;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GoogleCloudStorageClientTest {
    private static final String TEST_BUCKET_NAME = "foo-bucket";
    private static final String TEST_OBJECT_NAME = "foo-object";
    private static final String TEST_OBJECT_NAME_2 = "foo-object-2";
    private static final String OTHER_BUCKET_NAME = "other-bucket";
    private static final StorageResourceId TEST_RESOURCE_ID = new StorageResourceId("foo-bucket", "foo-object");
    private static final StorageResourceId TEST_RESOURCE_ID_2 = new StorageResourceId("foo-bucket", "foo-object-2");
    private static final Timestamp CREATE_TIME;
    private static final Timestamp UPDATE_TIME;
    private static final String BUCKET_STORAGE_CLASS = "STANDARD";
    private static final String BUCKET_LOCATION = "some-location";
    private static final int TTL_DAYS = 10;
    private static final int GENERATION = 123456;
    private static final Bucket TEST_BUCKET;
    private static final Bucket TEST_BUCKET_WITH_OPTIONS;
    private static final com.google.storage.v2.Object TEST_OBJECT;
    private static MockHttpTransport transport;
    private static final MockStorage mockStorage;

    @Before
    public void setUp() {
        mockStorage.reset();
    }

    @Test
    public void createBucket_succeeds() throws Exception {
        mockStorage.addResponse((AbstractMessage)TEST_BUCKET);
        try (FakeServer fakeServer = FakeServer.of(mockStorage);){
            GoogleCloudStorageClientImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsClientImpl((HttpTransport)transport, (Storage)fakeServer.getGrpcStorageOptions().getService());
            gcs.createBucket(TEST_BUCKET_NAME);
        }
        Assert.assertEquals((long)mockStorage.getRequests().size(), (long)1L);
        CreateBucketRequest bucketRequest = (CreateBucketRequest)mockStorage.getRequests().get(0);
        Assert.assertEquals((Object)bucketRequest.getBucketId(), (Object)TEST_BUCKET_NAME);
    }

    @Test
    public void createBucket_withOptions_succeeds() throws Exception {
        mockStorage.addResponse((AbstractMessage)TEST_BUCKET_WITH_OPTIONS);
        CreateBucketOptions bucketOptions = CreateBucketOptions.builder().setLocation(BUCKET_LOCATION).setStorageClass(BUCKET_STORAGE_CLASS).setTtl(Duration.ofDays(10L)).build();
        try (FakeServer fakeServer = FakeServer.of(mockStorage);){
            GoogleCloudStorageClientImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsClientImpl((HttpTransport)transport, (Storage)fakeServer.getGrpcStorageOptions().getService());
            gcs.createBucket(TEST_BUCKET_NAME, bucketOptions);
        }
        Assert.assertEquals((long)mockStorage.getRequests().size(), (long)1L);
        CreateBucketRequest bucketRequest = (CreateBucketRequest)mockStorage.getRequests().get(0);
        Assert.assertEquals((Object)bucketRequest.getBucketId(), (Object)TEST_BUCKET_NAME);
        Assert.assertEquals((Object)bucketRequest.getBucket().getLocation(), (Object)BUCKET_LOCATION);
        Assert.assertEquals((Object)bucketRequest.getBucket().getStorageClass(), (Object)BUCKET_STORAGE_CLASS);
        Assert.assertEquals((Object)bucketRequest.getBucket().getLifecycle().getRule(0).getAction().getType(), (Object)"Delete");
        Assert.assertEquals((long)bucketRequest.getBucket().getLifecycle().getRule(0).getCondition().getAgeDays(), (long)10L);
    }

    @Test
    public void createBucket_throwsFileAlreadyExistsException() throws Exception {
        mockStorage.addException((Exception)new StatusRuntimeException(Status.ALREADY_EXISTS));
        try (FakeServer fakeServer = FakeServer.of(mockStorage);){
            GoogleCloudStorageClientImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsClientImpl((HttpTransport)transport, (Storage)fakeServer.getGrpcStorageOptions().getService());
            Assert.assertThrows(FileAlreadyExistsException.class, () -> GoogleCloudStorageClientTest.lambda$createBucket_throwsFileAlreadyExistsException$0((GoogleCloudStorage)gcs));
        }
    }

    @Test
    public void createBucket_throwsIOException() throws Exception {
        mockStorage.addException((Exception)new StorageException(0, "Some exception", (Throwable)new StatusException(Status.INVALID_ARGUMENT)));
        try (FakeServer fakeServer = FakeServer.of(mockStorage);){
            GoogleCloudStorageClientImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsClientImpl((HttpTransport)transport, (Storage)fakeServer.getGrpcStorageOptions().getService());
            Assert.assertThrows(IOException.class, () -> GoogleCloudStorageClientTest.lambda$createBucket_throwsIOException$1((GoogleCloudStorage)gcs));
        }
    }

    @Test
    public void createBucket_illegalArguments() throws Exception {
        try (FakeServer fakeServer = FakeServer.of(mockStorage);){
            GoogleCloudStorageClientImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsClientImpl((HttpTransport)transport, (Storage)fakeServer.getGrpcStorageOptions().getService());
            Assert.assertThrows(IllegalArgumentException.class, () -> GoogleCloudStorageClientTest.lambda$createBucket_illegalArguments$2((GoogleCloudStorage)gcs));
            Assert.assertThrows(IllegalArgumentException.class, () -> GoogleCloudStorageClientTest.lambda$createBucket_illegalArguments$3((GoogleCloudStorage)gcs));
        }
    }

    @Test
    public void createEmptyObject_ignoresException() throws Exception {
        mockStorage.addException((Exception)new StatusRuntimeException(Status.RESOURCE_EXHAUSTED));
        mockStorage.addResponse((AbstractMessage)TEST_OBJECT.toBuilder().setSize(0L).putAllMetadata((Map)ImmutableMap.of()).build());
        try (FakeServer fakeServer = FakeServer.of(mockStorage);){
            GoogleCloudStorageClientImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsClientImpl((HttpTransport)transport, (Storage)fakeServer.getGrpcStorageOptions().getService());
            gcs.createEmptyObject(TEST_RESOURCE_ID);
        }
        Truth.assertThat((Integer)mockStorage.getRequests().size()).isEqualTo((Object)2);
    }

    @Test
    public void createEmptyObject_mismatchedMetadata_doesNotIgnoreException() throws Exception {
        mockStorage.addException((Exception)new StatusRuntimeException(Status.RESOURCE_EXHAUSTED));
        mockStorage.addResponse((AbstractMessage)TEST_OBJECT.toBuilder().setSize(0L).putAllMetadata((Map)ImmutableMap.of()).build());
        CreateObjectOptions createOptions = CreateObjectOptions.DEFAULT_OVERWRITE.toBuilder().setMetadata((Map)ImmutableMap.of((Object)"foo", (Object)new byte[0])).build();
        try (FakeServer fakeServer = FakeServer.of(mockStorage);){
            GoogleCloudStorageClientImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsClientImpl((HttpTransport)transport, (Storage)fakeServer.getGrpcStorageOptions().getService());
            IOException thrown = (IOException)Assert.assertThrows(IOException.class, () -> GoogleCloudStorageClientTest.lambda$createEmptyObject_mismatchedMetadata_doesNotIgnoreException$4((GoogleCloudStorage)gcs, createOptions));
            Truth.assertThat((Throwable)thrown).hasMessageThat().contains((CharSequence)ErrorTypeExtractor.ErrorType.RESOURCE_EXHAUSTED.toString());
        }
    }

    @Test
    public void createEmptyObject_mismatchedMetadata_ignoreException() throws Exception {
        mockStorage.addException((Exception)new StatusRuntimeException(Status.RESOURCE_EXHAUSTED));
        mockStorage.addResponse((AbstractMessage)TEST_OBJECT.toBuilder().setSize(0L).putAllMetadata((Map)ImmutableMap.of((Object)"foo", (Object)"bar")).build());
        try (FakeServer fakeServer = FakeServer.of(mockStorage);){
            GoogleCloudStorageClientImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsClientImpl((HttpTransport)transport, (Storage)fakeServer.getGrpcStorageOptions().getService());
            gcs.createEmptyObject(TEST_RESOURCE_ID);
        }
        Truth.assertThat((Integer)mockStorage.getRequests().size()).isEqualTo((Object)2);
    }

    @Test
    public void createEmptyObject_doesNotIgnoreExceptions() throws Exception {
        mockStorage.addException((Exception)new StatusRuntimeException(Status.UNAVAILABLE));
        mockStorage.addResponse((AbstractMessage)TEST_OBJECT.toBuilder().setSize(0L).putAllMetadata((Map)ImmutableMap.of()).build());
        try (FakeServer fakeServer = FakeServer.of(mockStorage);){
            GoogleCloudStorageClientImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsClientImpl((HttpTransport)transport, (Storage)fakeServer.getGrpcStorageOptions().getService());
            IOException thrown = (IOException)Assert.assertThrows(IOException.class, () -> GoogleCloudStorageClientTest.lambda$createEmptyObject_doesNotIgnoreExceptions$5((GoogleCloudStorage)gcs));
            Truth.assertThat((Throwable)thrown).hasMessageThat().contains((CharSequence)ErrorTypeExtractor.ErrorType.UNAVAILABLE.toString());
        }
    }

    @Test
    public void createEmptyObject_alreadyExists_throwsException() throws Exception {
        mockStorage.addException((Exception)new StatusRuntimeException(Status.ALREADY_EXISTS));
        try (FakeServer fakeServer = FakeServer.of(mockStorage);){
            GoogleCloudStorageClientImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsClientImpl((HttpTransport)transport, (Storage)fakeServer.getGrpcStorageOptions().getService());
            IOException thrown = (IOException)Assert.assertThrows(FileAlreadyExistsException.class, () -> GoogleCloudStorageClientTest.lambda$createEmptyObject_alreadyExists_throwsException$6((GoogleCloudStorage)gcs));
            Truth.assertThat((Throwable)thrown).hasMessageThat().isEqualTo((Object)String.format("Object 'gs://%s/%s' already exists.", TEST_BUCKET_NAME, TEST_OBJECT_NAME));
        }
    }

    @Test
    public void createEmptyObjects_ignoresExceptions() throws Exception {
        mockStorage.addException((Exception)new StatusRuntimeException(Status.RESOURCE_EXHAUSTED));
        mockStorage.addException((Exception)new StatusRuntimeException(Status.RESOURCE_EXHAUSTED));
        mockStorage.addResponse((AbstractMessage)TEST_OBJECT.toBuilder().setSize(0L).putAllMetadata((Map)ImmutableMap.of()).build());
        mockStorage.addResponse((AbstractMessage)TEST_OBJECT.toBuilder().setSize(0L).putAllMetadata((Map)ImmutableMap.of()).build());
        try (FakeServer fakeServer = FakeServer.of(mockStorage);){
            GoogleCloudStorageClientImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsClientImpl((HttpTransport)transport, (Storage)fakeServer.getGrpcStorageOptions().getService());
            gcs.createEmptyObjects((List)ImmutableList.of((Object)TEST_RESOURCE_ID, (Object)TEST_RESOURCE_ID));
        }
        Truth.assertThat((Integer)mockStorage.getRequests().size()).isEqualTo((Object)4);
    }

    @Test
    public void createEmptyObjects_doesNotIgnoreExceptions() throws Exception {
        mockStorage.addException((Exception)new StatusRuntimeException(Status.UNAVAILABLE));
        mockStorage.addException((Exception)new StatusRuntimeException(Status.UNAVAILABLE));
        try (FakeServer fakeServer = FakeServer.of(mockStorage);){
            GoogleCloudStorageClientImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsClientImpl((HttpTransport)transport, (Storage)fakeServer.getGrpcStorageOptions().getService());
            IOException thrown = (IOException)Assert.assertThrows(IOException.class, () -> GoogleCloudStorageClientTest.lambda$createEmptyObjects_doesNotIgnoreExceptions$7((GoogleCloudStorage)gcs));
            Truth.assertThat((Throwable)thrown).hasMessageThat().isEqualTo((Object)"Multiple IOExceptions.");
        }
    }

    @Test
    public void compose_succeeds() throws Exception {
        mockStorage.addResponse((AbstractMessage)TEST_OBJECT);
        mockStorage.addResponse((AbstractMessage)TEST_OBJECT);
        ImmutableList sources = ImmutableList.of((Object)"object1", (Object)"object2");
        try (FakeServer fakeServer = FakeServer.of(mockStorage);){
            GoogleCloudStorageClientImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsClientImpl((HttpTransport)transport, (Storage)fakeServer.getGrpcStorageOptions().getService());
            gcs.compose(TEST_BUCKET_NAME, (List)sources, TEST_OBJECT_NAME, "application/octet-stream");
        }
        Assert.assertEquals((long)mockStorage.getRequests().size(), (long)2L);
        ComposeObjectRequest actualRequest = (ComposeObjectRequest)mockStorage.getRequests().get(1);
        Truth.assertThat((String)actualRequest.getDestination().getName()).contains((CharSequence)TEST_OBJECT_NAME);
        Truth.assertThat((String)actualRequest.getSourceObjects(0).getName()).isEqualTo((Object)"object1");
        Truth.assertThat((String)actualRequest.getSourceObjects(1).getName()).isEqualTo((Object)"object2");
    }

    @Test
    public void compose_throwsException() throws Exception {
        mockStorage.addResponse((AbstractMessage)TEST_OBJECT);
        mockStorage.addException((Exception)new StatusRuntimeException(Status.INVALID_ARGUMENT));
        ImmutableList sources = ImmutableList.of((Object)"object1", (Object)"object2");
        try (FakeServer fakeServer = FakeServer.of(mockStorage);){
            GoogleCloudStorageClientImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsClientImpl((HttpTransport)transport, (Storage)fakeServer.getGrpcStorageOptions().getService());
            Assert.assertThrows(IOException.class, () -> GoogleCloudStorageClientTest.lambda$compose_throwsException$8((GoogleCloudStorage)gcs, (List)sources));
        }
    }

    @Test
    public void copyObjects_sameBucket_succeeds() throws Exception {
        RewriteResponse expectedResponse = RewriteResponse.newBuilder().setTotalBytesRewritten(-1109205579L).setObjectSize(-1277221631L).setDone(true).setRewriteToken("rewriteToken80654285").setResource(com.google.storage.v2.Object.newBuilder().build()).build();
        mockStorage.addResponse((AbstractMessage)expectedResponse);
        String destinationObject = "foo-object-copy";
        try (FakeServer fakeServer = FakeServer.of(mockStorage);){
            GoogleCloudStorageClientImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsClientImpl((HttpTransport)transport, (Storage)fakeServer.getGrpcStorageOptions().getService());
            gcs.copy(TEST_BUCKET_NAME, (List)ImmutableList.of((Object)TEST_OBJECT_NAME), TEST_BUCKET_NAME, (List)ImmutableList.of((Object)destinationObject));
        }
        Assert.assertEquals((long)mockStorage.getRequests().size(), (long)1L);
        RewriteObjectRequest actualResponse = (RewriteObjectRequest)mockStorage.getRequests().get(0);
        Truth.assertThat((String)actualResponse.getDestinationName()).isEqualTo((Object)destinationObject);
        Truth.assertThat((String)actualResponse.getDestinationBucket()).contains((CharSequence)TEST_BUCKET_NAME);
        Truth.assertThat((String)actualResponse.getSourceBucket()).contains((CharSequence)TEST_BUCKET_NAME);
        Truth.assertThat((String)actualResponse.getSourceObject()).isEqualTo((Object)TEST_OBJECT_NAME);
    }

    @Test
    public void copyObjects_differentBuckets_succeeds() throws Exception {
        String destinationBucket = "foo-bucket-copy";
        String destinationObject = "foo-object-copy";
        RewriteResponse expectedRewriteResponse = RewriteResponse.newBuilder().setTotalBytesRewritten(-1109205579L).setObjectSize(-1277221631L).setDone(true).setRewriteToken("rewriteToken80654285").setResource(com.google.storage.v2.Object.newBuilder().build()).build();
        mockStorage.addResponse((AbstractMessage)TEST_BUCKET);
        mockStorage.addResponse((AbstractMessage)Bucket.newBuilder().setName(destinationBucket).setCreateTime(CREATE_TIME).setUpdateTime(UPDATE_TIME).build());
        mockStorage.addResponse((AbstractMessage)expectedRewriteResponse);
        try (FakeServer fakeServer = FakeServer.of(mockStorage);){
            GoogleCloudStorageClientImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsClientImpl((HttpTransport)transport, (Storage)fakeServer.getGrpcStorageOptions().getService());
            gcs.copy(TEST_BUCKET_NAME, (List)ImmutableList.of((Object)TEST_OBJECT_NAME), destinationBucket, (List)ImmutableList.of((Object)destinationObject));
        }
        Assert.assertEquals((long)mockStorage.getRequests().size(), (long)3L);
        RewriteObjectRequest actualResponse = (RewriteObjectRequest)mockStorage.getRequests().get(2);
        Truth.assertThat((String)actualResponse.getDestinationName()).isEqualTo((Object)destinationObject);
        Truth.assertThat((String)actualResponse.getDestinationBucket()).contains((CharSequence)destinationBucket);
        Truth.assertThat((String)actualResponse.getSourceBucket()).contains((CharSequence)TEST_BUCKET_NAME);
        Truth.assertThat((String)actualResponse.getSourceObject()).isEqualTo((Object)TEST_OBJECT_NAME);
    }

    @Test
    public void move_succeedsSingleObject() throws Exception {
        String destinationObjectName = "foo-object-move";
        mockStorage.addResponse((AbstractMessage)TEST_OBJECT.toBuilder().setName(destinationObjectName).setGeneration(123457L).setMetageneration(1L).build());
        ImmutableMap moveMap = ImmutableMap.of((Object)TEST_RESOURCE_ID, (Object)new StorageResourceId(TEST_BUCKET_NAME, destinationObjectName));
        try (FakeServer fakeServer = FakeServer.of(mockStorage);){
            GoogleCloudStorageClientImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsClientImpl((HttpTransport)transport, (Storage)fakeServer.getGrpcStorageOptions().getService());
            gcs.move((Map)moveMap);
        }
        Assert.assertEquals((long)mockStorage.getRequests().size(), (long)1L);
        MoveObjectRequest actualRequest = (MoveObjectRequest)mockStorage.getRequests().get(0);
        Truth.assertThat((String)actualRequest.getDestinationObject()).isEqualTo((Object)destinationObjectName);
        Truth.assertThat((String)actualRequest.getBucket()).contains((CharSequence)TEST_BUCKET_NAME);
        Truth.assertThat((String)actualRequest.getSourceObject()).isEqualTo((Object)TEST_OBJECT_NAME);
        Truth.assertThat((Long)actualRequest.getIfGenerationMatch()).isEqualTo((Object)0);
    }

    @Test
    public void move_succeedsMultipleObjects() throws Exception {
        String destinationObjectName1 = "foo-object-move1";
        String destinationObjectName2 = "foo-object-move2";
        mockStorage.addResponse((AbstractMessage)TEST_OBJECT.toBuilder().setName(destinationObjectName1).setGeneration(123457L).setMetageneration(1L).build());
        mockStorage.addResponse((AbstractMessage)TEST_OBJECT.toBuilder().setName(destinationObjectName2).setGeneration(123457L).setMetageneration(1L).build());
        ImmutableMap moveMap = ImmutableMap.of((Object)TEST_RESOURCE_ID, (Object)new StorageResourceId(TEST_BUCKET_NAME, destinationObjectName1), (Object)new StorageResourceId(TEST_BUCKET_NAME, TEST_OBJECT_NAME_2), (Object)new StorageResourceId(TEST_BUCKET_NAME, destinationObjectName2));
        try (FakeServer fakeServer = FakeServer.of(mockStorage);){
            GoogleCloudStorageClientImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsClientImpl((HttpTransport)transport, (Storage)fakeServer.getGrpcStorageOptions().getService());
            gcs.move((Map)moveMap);
        }
        Assert.assertEquals((long)mockStorage.getRequests().size(), (long)2L);
        List<AbstractMessage> requestList = mockStorage.getRequests();
        requestList.sort(Comparator.comparing(Object::toString));
        MoveObjectRequest actualRequest1 = (MoveObjectRequest)requestList.get(0);
        Truth.assertThat((String)actualRequest1.getSourceObject()).isEqualTo((Object)TEST_OBJECT_NAME);
        Truth.assertThat((String)actualRequest1.getDestinationObject()).isEqualTo((Object)destinationObjectName1);
        MoveObjectRequest actualRequest2 = (MoveObjectRequest)requestList.get(1);
        Truth.assertThat((String)actualRequest2.getSourceObject()).isEqualTo((Object)TEST_OBJECT_NAME_2);
        Truth.assertThat((String)actualRequest2.getDestinationObject()).isEqualTo((Object)destinationObjectName2);
    }

    @Test
    public void move_throwsFileNotFoundExceptionOnSourceMissing() throws Exception {
        mockStorage.addException((Exception)new StatusRuntimeException(Status.NOT_FOUND));
        String destinationObjectName = "foo-object-move";
        ImmutableMap moveMap = ImmutableMap.of((Object)TEST_RESOURCE_ID, (Object)new StorageResourceId(TEST_BUCKET_NAME, destinationObjectName));
        try (FakeServer fakeServer = FakeServer.of(mockStorage);){
            GoogleCloudStorageClientImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsClientImpl((HttpTransport)transport, (Storage)fakeServer.getGrpcStorageOptions().getService());
            FileNotFoundException thrown = (FileNotFoundException)Assert.assertThrows(FileNotFoundException.class, () -> GoogleCloudStorageClientTest.lambda$move_throwsFileNotFoundExceptionOnSourceMissing$9((GoogleCloudStorage)gcs, (Map)moveMap));
            Truth.assertThat((Throwable)thrown).hasMessageThat().contains((CharSequence)String.format("Item not found: '%s'. Note, it is possible that the live version is still available but the requested generation is deleted.", TEST_RESOURCE_ID.toString()));
        }
        Assert.assertEquals((long)mockStorage.getRequests().size(), (long)0L);
    }

    @Test
    public void move_throwsGeneralIOExceptionOnError() throws Exception {
        mockStorage.addException((Exception)new StatusRuntimeException(Status.INVALID_ARGUMENT));
        String destinationObjectName = "foo-object-move";
        ImmutableMap moveMap = ImmutableMap.of((Object)TEST_RESOURCE_ID, (Object)new StorageResourceId(TEST_BUCKET_NAME, destinationObjectName));
        try (FakeServer fakeServer = FakeServer.of(mockStorage);){
            GoogleCloudStorageClientImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsClientImpl((HttpTransport)transport, (Storage)fakeServer.getGrpcStorageOptions().getService());
            IOException thrown = (IOException)Assert.assertThrows(IOException.class, () -> GoogleCloudStorageClientTest.lambda$move_throwsGeneralIOExceptionOnError$10((GoogleCloudStorage)gcs, (Map)moveMap));
            Truth.assertThat((Throwable)thrown).hasMessageThat().contains((CharSequence)String.format("Error moving '%s'", StringPaths.fromComponents((String)TEST_BUCKET_NAME, (String)TEST_OBJECT_NAME)));
        }
        Assert.assertEquals((long)mockStorage.getRequests().size(), (long)0L);
    }

    @Test
    public void move_emptyMap_doesNothing() throws Exception {
        ImmutableMap moveMap = ImmutableMap.of();
        try (FakeServer fakeServer = FakeServer.of(mockStorage);){
            GoogleCloudStorageClientImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsClientImpl((HttpTransport)transport, (Storage)fakeServer.getGrpcStorageOptions().getService());
            gcs.move((Map)moveMap);
        }
        Assert.assertEquals((long)mockStorage.getRequests().size(), (long)0L);
    }

    @Test
    public void move_differentBuckets_throwsIllegalArgumentException() throws Exception {
        String destinationObjectName = "foo-object-move";
        ImmutableMap moveMap = ImmutableMap.of((Object)TEST_RESOURCE_ID, (Object)new StorageResourceId(OTHER_BUCKET_NAME, destinationObjectName));
        try (FakeServer fakeServer = FakeServer.of(mockStorage);){
            GoogleCloudStorageClientImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsClientImpl((HttpTransport)transport, (Storage)fakeServer.getGrpcStorageOptions().getService());
            UnsupportedOperationException thrown = (UnsupportedOperationException)Assert.assertThrows(UnsupportedOperationException.class, () -> GoogleCloudStorageClientTest.lambda$move_differentBuckets_throwsIllegalArgumentException$11((GoogleCloudStorage)gcs, (Map)moveMap));
            Truth.assertThat((Throwable)thrown).hasMessageThat().contains((CharSequence)"This operation is not supported across two different buckets");
        }
        Assert.assertEquals((long)mockStorage.getRequests().size(), (long)0L);
    }

    @Test
    public void move_withDestinationGeneration_succeeds() throws Exception {
        String destinationObjectName = "foo-object-move";
        mockStorage.addResponse((AbstractMessage)TEST_OBJECT.toBuilder().setName(destinationObjectName).setGeneration(9876L).setMetageneration(1L).build());
        StorageResourceId dstResourceIDWithGenID = new StorageResourceId(TEST_BUCKET_NAME, destinationObjectName, 9876L);
        ImmutableMap moveMap = ImmutableMap.of((Object)TEST_RESOURCE_ID, (Object)dstResourceIDWithGenID);
        try (FakeServer fakeServer = FakeServer.of(mockStorage);){
            GoogleCloudStorageClientImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsClientImpl((HttpTransport)transport, (Storage)fakeServer.getGrpcStorageOptions().getService());
            gcs.move((Map)moveMap);
        }
        Assert.assertEquals((long)mockStorage.getRequests().size(), (long)1L);
        MoveObjectRequest actualRequest = (MoveObjectRequest)mockStorage.getRequests().get(0);
        Truth.assertThat((String)actualRequest.getDestinationObject()).isEqualTo((Object)destinationObjectName);
        Truth.assertThat((String)actualRequest.getSourceObject()).contains((CharSequence)TEST_OBJECT_NAME);
        Truth.assertThat((String)actualRequest.getBucket()).contains((CharSequence)TEST_BUCKET_NAME);
        Truth.assertThat((Long)actualRequest.getIfGenerationMatch()).isEqualTo((Object)dstResourceIDWithGenID.getGenerationId());
    }

    @Test
    public void move_withSourceGeneration_succeeds() throws Exception {
        String destinationObjectName = "foo-object-move";
        long sourceGeneration = 999L;
        mockStorage.addResponse((AbstractMessage)TEST_OBJECT.toBuilder().setName(destinationObjectName).setGeneration(123457L).setMetageneration(1L).build());
        StorageResourceId srcResourceIdWithGen = new StorageResourceId(TEST_BUCKET_NAME, TEST_OBJECT_NAME, sourceGeneration);
        StorageResourceId dstResourceId = new StorageResourceId(TEST_BUCKET_NAME, destinationObjectName);
        ImmutableMap moveMap = ImmutableMap.of((Object)srcResourceIdWithGen, (Object)dstResourceId);
        try (FakeServer fakeServer = FakeServer.of(mockStorage);){
            GoogleCloudStorageClientImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsClientImpl((HttpTransport)transport, (Storage)fakeServer.getGrpcStorageOptions().getService());
            gcs.move((Map)moveMap);
        }
        Assert.assertEquals((long)mockStorage.getRequests().size(), (long)1L);
        MoveObjectRequest actualRequest = (MoveObjectRequest)mockStorage.getRequests().get(0);
        Truth.assertThat((String)actualRequest.getDestinationObject()).isEqualTo((Object)destinationObjectName);
        Truth.assertThat((String)actualRequest.getBucket()).contains((CharSequence)TEST_BUCKET_NAME);
        Truth.assertThat((String)actualRequest.getSourceObject()).isEqualTo((Object)TEST_OBJECT_NAME);
        Truth.assertThat((Long)actualRequest.getIfSourceGenerationMatch()).isEqualTo((Object)sourceGeneration);
        Truth.assertThat((Long)actualRequest.getIfGenerationMatch()).isEqualTo((Object)0);
    }

    @Test
    public void deleteBuckets_illegalArguments() throws Exception {
        try (FakeServer fakeServer = FakeServer.of(mockStorage);){
            GoogleCloudStorageClientImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsClientImpl((HttpTransport)transport, (Storage)fakeServer.getGrpcStorageOptions().getService());
            Assert.assertThrows(IllegalArgumentException.class, () -> GoogleCloudStorageClientTest.lambda$deleteBuckets_illegalArguments$12((GoogleCloudStorage)gcs));
            Assert.assertThrows(IllegalArgumentException.class, () -> GoogleCloudStorageClientTest.lambda$deleteBuckets_illegalArguments$13((GoogleCloudStorage)gcs));
        }
    }

    @Test
    public void deleteBuckets_succeeds() throws Exception {
        mockStorage.addResponse((AbstractMessage)Empty.newBuilder().build());
        try (FakeServer fakeServer = FakeServer.of(mockStorage);){
            GoogleCloudStorageClientImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsClientImpl((HttpTransport)transport, (Storage)fakeServer.getGrpcStorageOptions().getService());
            gcs.deleteBuckets((List)ImmutableList.of((Object)TEST_BUCKET_NAME));
        }
        Assert.assertEquals((long)mockStorage.getRequests().size(), (long)1L);
        DeleteBucketRequest deleteBucketRequest = (DeleteBucketRequest)mockStorage.getRequests().get(0);
        Truth.assertThat((String)deleteBucketRequest.getName()).contains((CharSequence)TEST_BUCKET_NAME);
    }

    @Test
    public void deleteBuckets_throwsException() throws Exception {
        mockStorage.addException((Exception)new StatusRuntimeException(Status.INVALID_ARGUMENT));
        try (FakeServer fakeServer = FakeServer.of(mockStorage);){
            GoogleCloudStorageClientImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsClientImpl((HttpTransport)transport, (Storage)fakeServer.getGrpcStorageOptions().getService());
            Assert.assertThrows(IOException.class, () -> GoogleCloudStorageClientTest.lambda$deleteBuckets_throwsException$14((GoogleCloudStorage)gcs));
        }
    }

    @Test
    public void deleteBuckets_throwsFileNotFoundException() throws Exception {
        mockStorage.addException((Exception)new StatusRuntimeException(Status.NOT_FOUND));
        try (FakeServer fakeServer = FakeServer.of(mockStorage);){
            GoogleCloudStorageClientImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsClientImpl((HttpTransport)transport, (Storage)fakeServer.getGrpcStorageOptions().getService());
            Assert.assertThrows(FileNotFoundException.class, () -> GoogleCloudStorageClientTest.lambda$deleteBuckets_throwsFileNotFoundException$15((GoogleCloudStorage)gcs));
        }
    }

    @Test
    public void deleteObjects_illegalArguments() throws Exception {
        try (FakeServer fakeServer = FakeServer.of(mockStorage);){
            GoogleCloudStorageClientImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsClientImpl((HttpTransport)transport, (Storage)fakeServer.getGrpcStorageOptions().getService());
            ImmutableList.of((Object)StorageResourceId.ROOT, (Object)new StorageResourceId(TEST_BUCKET_NAME)).forEach(arg_0 -> GoogleCloudStorageClientTest.lambda$deleteObjects_illegalArguments$17((GoogleCloudStorage)gcs, arg_0));
        }
    }

    @Test
    public void deleteObjects_withoutGeneration_succeeds() throws Exception {
        mockStorage.addResponse((AbstractMessage)TEST_OBJECT);
        mockStorage.addResponse((AbstractMessage)Empty.newBuilder().build());
        try (FakeServer fakeServer = FakeServer.of(mockStorage);){
            GoogleCloudStorageClientImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsClientImpl((HttpTransport)transport, (Storage)fakeServer.getGrpcStorageOptions().getService());
            gcs.deleteObjects((List)ImmutableList.of((Object)new StorageResourceId(TEST_BUCKET_NAME, TEST_OBJECT_NAME)));
        }
        Assert.assertEquals((long)mockStorage.getRequests().size(), (long)2L);
        DeleteObjectRequest actualRequest = (DeleteObjectRequest)mockStorage.getRequests().get(1);
        Truth.assertThat((String)actualRequest.getBucket()).contains((CharSequence)TEST_BUCKET_NAME);
        Assert.assertEquals((Object)actualRequest.getObject(), (Object)TEST_OBJECT_NAME);
    }

    @Test
    public void deleteObjects_withoutGeneration_failsToGetGeneration() throws Exception {
        mockStorage.addException((Exception)new StatusException(Status.INVALID_ARGUMENT));
        mockStorage.addResponse((AbstractMessage)Empty.newBuilder().build());
        try (FakeServer fakeServer = FakeServer.of(mockStorage);){
            GoogleCloudStorageClientImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsClientImpl((HttpTransport)transport, (Storage)fakeServer.getGrpcStorageOptions().getService());
            Assert.assertThrows(IOException.class, () -> GoogleCloudStorageClientTest.lambda$deleteObjects_withoutGeneration_failsToGetGeneration$18((GoogleCloudStorage)gcs));
        }
    }

    @Test
    public void deleteObjects_withoutGeneration_objectDoesntExist() throws Exception {
        mockStorage.addException((Exception)new StatusException(Status.NOT_FOUND));
        mockStorage.addResponse((AbstractMessage)Empty.newBuilder().build());
        try (FakeServer fakeServer = FakeServer.of(mockStorage);){
            GoogleCloudStorageClientImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsClientImpl((HttpTransport)transport, (Storage)fakeServer.getGrpcStorageOptions().getService());
            gcs.deleteObjects((List)ImmutableList.of((Object)new StorageResourceId(TEST_BUCKET_NAME, TEST_OBJECT_NAME)));
            Assert.assertEquals((long)mockStorage.getRequests().size(), (long)0L);
        }
    }

    @Test
    public void deleteObjects_withGeneration_succeeds() throws Exception {
        mockStorage.addResponse((AbstractMessage)Empty.newBuilder().build());
        try (FakeServer fakeServer = FakeServer.of(mockStorage);){
            GoogleCloudStorageClientImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsClientImpl((HttpTransport)transport, (Storage)fakeServer.getGrpcStorageOptions().getService());
            gcs.deleteObjects((List)ImmutableList.of((Object)new StorageResourceId(TEST_BUCKET_NAME, TEST_OBJECT_NAME, 123456L)));
            Assert.assertEquals((long)mockStorage.getRequests().size(), (long)1L);
            DeleteObjectRequest actualRequest = (DeleteObjectRequest)mockStorage.getRequests().get(0);
            Truth.assertThat((String)actualRequest.getBucket()).contains((CharSequence)TEST_BUCKET_NAME);
            Assert.assertEquals((Object)actualRequest.getObject(), (Object)TEST_OBJECT_NAME);
        }
    }

    @Test
    public void deleteObjects_throwsException() throws Exception {
        mockStorage.addException((Exception)new StatusRuntimeException(Status.INVALID_ARGUMENT));
        try (FakeServer fakeServer = FakeServer.of(mockStorage);){
            GoogleCloudStorageClientImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsClientImpl((HttpTransport)transport, (Storage)fakeServer.getGrpcStorageOptions().getService());
            Assert.assertThrows(IOException.class, () -> GoogleCloudStorageClientTest.lambda$deleteObjects_throwsException$19((GoogleCloudStorage)gcs));
        }
    }

    @Test
    public void getItemInfo_bucket_succeeds() throws Exception {
        mockStorage.addResponse((AbstractMessage)TEST_BUCKET);
        try (FakeServer fakeServer = FakeServer.of(mockStorage);){
            GoogleCloudStorageClientImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsClientImpl((HttpTransport)transport, (Storage)fakeServer.getGrpcStorageOptions().getService());
            StorageResourceId bucketId = new StorageResourceId(TEST_BUCKET_NAME);
            GoogleCloudStorageItemInfo info = gcs.getItemInfo(bucketId);
            Truth.assertThat((String)info.getBucketName()).isEqualTo((Object)TEST_BUCKET_NAME);
        }
    }

    @Test
    public void getItemInfo_root_succeeds() throws Exception {
        try (FakeServer fakeServer = FakeServer.of(mockStorage);){
            GoogleCloudStorageClientImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsClientImpl((HttpTransport)transport, (Storage)fakeServer.getGrpcStorageOptions().getService());
            GoogleCloudStorageItemInfo info = gcs.getItemInfo(StorageResourceId.ROOT);
            Truth.assertThat((Object)info).isEqualTo((Object)GoogleCloudStorageItemInfo.ROOT_INFO);
        }
    }

    @Test
    public void getItemInfo_object_succeeds() throws Exception {
        mockStorage.addResponse((AbstractMessage)TEST_OBJECT);
        try (FakeServer fakeServer = FakeServer.of(mockStorage);){
            GoogleCloudStorageClientImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsClientImpl((HttpTransport)transport, (Storage)fakeServer.getGrpcStorageOptions().getService());
            StorageResourceId objectId = new StorageResourceId(TEST_BUCKET_NAME, TEST_OBJECT_NAME);
            GoogleCloudStorageItemInfo info = gcs.getItemInfo(objectId);
            Truth.assertThat((String)info.getBucketName()).isEqualTo((Object)TEST_BUCKET_NAME);
            Truth.assertThat((String)info.getObjectName()).isEqualTo((Object)TEST_OBJECT_NAME);
        }
    }

    @Test
    public void getItemInfo_throwsException() throws Exception {
        mockStorage.addException((Exception)new StatusRuntimeException(Status.INVALID_ARGUMENT));
        try (FakeServer fakeServer = FakeServer.of(mockStorage);){
            GoogleCloudStorageClientImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsClientImpl((HttpTransport)transport, (Storage)fakeServer.getGrpcStorageOptions().getService());
            StorageResourceId objectId = new StorageResourceId(TEST_BUCKET_NAME, TEST_OBJECT_NAME);
            Assert.assertThrows(IOException.class, () -> GoogleCloudStorageClientTest.lambda$getItemInfo_throwsException$20((GoogleCloudStorage)gcs, objectId));
        }
    }

    @Test
    public void getItemInfos_returnsNotFound() throws Exception {
        mockStorage.addException((Exception)new StatusRuntimeException(Status.NOT_FOUND));
        mockStorage.addException((Exception)new StatusRuntimeException(Status.NOT_FOUND));
        try (FakeServer fakeServer = FakeServer.of(mockStorage);){
            GoogleCloudStorageClientImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsClientImpl((HttpTransport)transport, (Storage)fakeServer.getGrpcStorageOptions().getService());
            StorageResourceId objectId = new StorageResourceId(TEST_BUCKET_NAME, TEST_OBJECT_NAME);
            List itemInfos = gcs.getItemInfos((List)ImmutableList.of((Object)objectId, (Object)StorageResourceId.ROOT, (Object)new StorageResourceId(TEST_BUCKET_NAME)));
            Truth.assertThat((Integer)itemInfos.size()).isEqualTo((Object)3);
            GoogleCloudStorageItemInfo expectedObject = GoogleCloudStorageItemInfo.createNotFound((StorageResourceId)objectId);
            GoogleCloudStorageItemInfo expectedRoot = GoogleCloudStorageItemInfo.ROOT_INFO;
            GoogleCloudStorageItemInfo expectedBucket = GoogleCloudStorageItemInfo.createNotFound((StorageResourceId)new StorageResourceId(TEST_BUCKET_NAME));
            Truth.assertThat((Iterable)itemInfos).containsExactly(new Object[]{expectedObject, expectedRoot, expectedBucket}).inOrder();
        }
    }

    @Test
    public void getItemInfos_succeeds() throws Exception {
        mockStorage.addResponse((AbstractMessage)TEST_OBJECT);
        try (FakeServer fakeServer = FakeServer.of(mockStorage);){
            GoogleCloudStorageClientImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsClientImpl((HttpTransport)transport, (Storage)fakeServer.getGrpcStorageOptions().getService());
            List itemInfos = gcs.getItemInfos((List)ImmutableList.of((Object)new StorageResourceId(TEST_BUCKET_NAME, TEST_OBJECT_NAME), (Object)StorageResourceId.ROOT));
            Assert.assertEquals((long)itemInfos.size(), (long)2L);
            GoogleCloudStorageItemInfo objectInfo = (GoogleCloudStorageItemInfo)itemInfos.get(0);
            GoogleCloudStorageItemInfo rootInfo = (GoogleCloudStorageItemInfo)itemInfos.get(1);
            Truth.assertThat((String)objectInfo.getBucketName()).isEqualTo((Object)TEST_BUCKET_NAME);
            Truth.assertThat((String)objectInfo.getObjectName()).isEqualTo((Object)TEST_OBJECT_NAME);
            Truth.assertThat((Boolean)rootInfo.isRoot()).isEqualTo((Object)true);
        }
    }

    @Test
    public void listBucketNames_succeeds() throws Exception {
        mockStorage.addResponse((AbstractMessage)ListBucketsResponse.newBuilder().addBuckets(TEST_BUCKET).addBuckets(TEST_BUCKET_WITH_OPTIONS).build());
        try (FakeServer fakeServer = FakeServer.of(mockStorage);){
            GoogleCloudStorageClientImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsClientImpl((HttpTransport)transport, (Storage)fakeServer.getGrpcStorageOptions().getService());
            List listedBuckets = gcs.listBucketNames();
            Truth.assertThat((Iterable)listedBuckets).containsExactly(new Object[]{TEST_BUCKET.getName(), TEST_BUCKET_WITH_OPTIONS.getName()});
        }
    }

    @Test
    public void listBucketInfo_succeeds() throws Exception {
        mockStorage.addResponse((AbstractMessage)ListBucketsResponse.newBuilder().addBuckets(TEST_BUCKET).addBuckets(TEST_BUCKET_WITH_OPTIONS).build());
        try (FakeServer fakeServer = FakeServer.of(mockStorage);){
            GoogleCloudStorageClientImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsClientImpl((HttpTransport)transport, (Storage)fakeServer.getGrpcStorageOptions().getService());
            List listedBuckets = gcs.listBucketInfo();
            Truth.assertThat((Iterable)listedBuckets).containsExactly(new Object[]{GoogleCloudStorageItemInfo.createBucket((StorageResourceId)new StorageResourceId(TEST_BUCKET.getName()), (long)0L, (long)0L, (String)"", null), GoogleCloudStorageItemInfo.createBucket((StorageResourceId)new StorageResourceId(TEST_BUCKET_WITH_OPTIONS.getName()), (long)0L, (long)0L, (String)BUCKET_LOCATION, (String)BUCKET_STORAGE_CLASS)});
        }
    }

    @Test
    public void updateItems_succeeds() throws Exception {
        ImmutableMap metadata = ImmutableMap.of((Object)"key1", (Object)"value1".getBytes(StandardCharsets.UTF_8), (Object)"key2", (Object)"value2".getBytes(StandardCharsets.UTF_8));
        mockStorage.addResponse((AbstractMessage)TEST_OBJECT.toBuilder().putAllMetadata(GoogleCloudStorageImpl.encodeMetadata((Map)metadata)).build());
        try (FakeServer fakeServer = FakeServer.of(mockStorage);){
            GoogleCloudStorageClientImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsClientImpl((HttpTransport)transport, (Storage)fakeServer.getGrpcStorageOptions().getService());
            List results = gcs.updateItems((List)ImmutableList.of((Object)new UpdatableItemInfo(new StorageResourceId(TEST_BUCKET_NAME, TEST_OBJECT_NAME), (Map)metadata)));
            Assert.assertEquals((long)mockStorage.getRequests().size(), (long)1L);
            Assert.assertEquals((long)results.size(), (long)1L);
            GoogleCloudStorageTest.assertMapsEqual(metadata, ((GoogleCloudStorageItemInfo)results.get(0)).getMetadata(), GoogleCloudStorageTest.BYTE_ARRAY_EQUIVALENCE);
        }
    }

    @Test
    public void updateItems_throwsException() throws Exception {
        mockStorage.addException((Exception)new StatusRuntimeException(Status.INVALID_ARGUMENT));
        try (FakeServer fakeServer = FakeServer.of(mockStorage);){
            GoogleCloudStorageClientImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsClientImpl((HttpTransport)transport, (Storage)fakeServer.getGrpcStorageOptions().getService());
            Assert.assertThrows(IOException.class, () -> GoogleCloudStorageClientTest.lambda$updateItems_throwsException$21((GoogleCloudStorage)gcs));
        }
    }

    @Test
    public void updateItems_returnsNotFound() throws Exception {
        mockStorage.addException((Exception)new StatusRuntimeException(Status.NOT_FOUND));
        try (FakeServer fakeServer = FakeServer.of(mockStorage);){
            GoogleCloudStorageClientImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcsClientImpl((HttpTransport)transport, (Storage)fakeServer.getGrpcStorageOptions().getService());
            List results = gcs.updateItems((List)ImmutableList.of((Object)new UpdatableItemInfo(new StorageResourceId(TEST_BUCKET_NAME, TEST_OBJECT_NAME), (Map)ImmutableMap.of())));
            Assert.assertEquals((long)results.size(), (long)1L);
            Truth.assertThat((Boolean)((GoogleCloudStorageItemInfo)results.get(0)).exists()).isFalse();
        }
    }

    private static /* synthetic */ void lambda$updateItems_throwsException$21(GoogleCloudStorage gcs) throws Throwable {
        gcs.updateItems((List)ImmutableList.of((Object)new UpdatableItemInfo(new StorageResourceId(TEST_BUCKET_NAME, TEST_OBJECT_NAME), (Map)ImmutableMap.of())));
    }

    private static /* synthetic */ void lambda$getItemInfo_throwsException$20(GoogleCloudStorage gcs, StorageResourceId objectId) throws Throwable {
        gcs.getItemInfo(objectId);
    }

    private static /* synthetic */ void lambda$deleteObjects_throwsException$19(GoogleCloudStorage gcs) throws Throwable {
        gcs.deleteObjects((List)ImmutableList.of((Object)new StorageResourceId(TEST_BUCKET_NAME, TEST_OBJECT_NAME, 123456L)));
    }

    private static /* synthetic */ void lambda$deleteObjects_withoutGeneration_failsToGetGeneration$18(GoogleCloudStorage gcs) throws Throwable {
        gcs.deleteObjects((List)ImmutableList.of((Object)new StorageResourceId(TEST_BUCKET_NAME, TEST_OBJECT_NAME)));
    }

    private static /* synthetic */ void lambda$deleteObjects_illegalArguments$17(GoogleCloudStorage gcs, StorageResourceId resourceId) {
        Assert.assertThrows(IllegalArgumentException.class, () -> gcs.deleteObjects((List)ImmutableList.of((Object)resourceId)));
    }

    private static /* synthetic */ void lambda$deleteBuckets_throwsFileNotFoundException$15(GoogleCloudStorage gcs) throws Throwable {
        gcs.deleteBuckets((List)ImmutableList.of((Object)TEST_BUCKET_NAME));
    }

    private static /* synthetic */ void lambda$deleteBuckets_throwsException$14(GoogleCloudStorage gcs) throws Throwable {
        gcs.deleteBuckets((List)ImmutableList.of((Object)TEST_BUCKET_NAME));
    }

    private static /* synthetic */ void lambda$deleteBuckets_illegalArguments$13(GoogleCloudStorage gcs) throws Throwable {
        gcs.deleteBuckets((List)Lists.newArrayList((Object[])new String[]{""}));
    }

    private static /* synthetic */ void lambda$deleteBuckets_illegalArguments$12(GoogleCloudStorage gcs) throws Throwable {
        gcs.deleteBuckets((List)Lists.newArrayList((Object[])new String[]{null}));
    }

    private static /* synthetic */ void lambda$move_differentBuckets_throwsIllegalArgumentException$11(GoogleCloudStorage gcs, Map moveMap) throws Throwable {
        gcs.move(moveMap);
    }

    private static /* synthetic */ void lambda$move_throwsGeneralIOExceptionOnError$10(GoogleCloudStorage gcs, Map moveMap) throws Throwable {
        gcs.move(moveMap);
    }

    private static /* synthetic */ void lambda$move_throwsFileNotFoundExceptionOnSourceMissing$9(GoogleCloudStorage gcs, Map moveMap) throws Throwable {
        gcs.move(moveMap);
    }

    private static /* synthetic */ void lambda$compose_throwsException$8(GoogleCloudStorage gcs, List sources) throws Throwable {
        gcs.compose(TEST_BUCKET_NAME, sources, TEST_OBJECT_NAME, "application/octet-stream");
    }

    private static /* synthetic */ void lambda$createEmptyObjects_doesNotIgnoreExceptions$7(GoogleCloudStorage gcs) throws Throwable {
        gcs.createEmptyObjects((List)ImmutableList.of((Object)TEST_RESOURCE_ID, (Object)TEST_RESOURCE_ID));
    }

    private static /* synthetic */ void lambda$createEmptyObject_alreadyExists_throwsException$6(GoogleCloudStorage gcs) throws Throwable {
        gcs.createEmptyObject(TEST_RESOURCE_ID);
    }

    private static /* synthetic */ void lambda$createEmptyObject_doesNotIgnoreExceptions$5(GoogleCloudStorage gcs) throws Throwable {
        gcs.createEmptyObject(TEST_RESOURCE_ID);
    }

    private static /* synthetic */ void lambda$createEmptyObject_mismatchedMetadata_doesNotIgnoreException$4(GoogleCloudStorage gcs, CreateObjectOptions createOptions) throws Throwable {
        gcs.createEmptyObject(TEST_RESOURCE_ID, createOptions);
    }

    private static /* synthetic */ void lambda$createBucket_illegalArguments$3(GoogleCloudStorage gcs) throws Throwable {
        gcs.createBucket("");
    }

    private static /* synthetic */ void lambda$createBucket_illegalArguments$2(GoogleCloudStorage gcs) throws Throwable {
        gcs.createBucket(null);
    }

    private static /* synthetic */ void lambda$createBucket_throwsIOException$1(GoogleCloudStorage gcs) throws Throwable {
        gcs.createBucket(TEST_BUCKET_NAME);
    }

    private static /* synthetic */ void lambda$createBucket_throwsFileAlreadyExistsException$0(GoogleCloudStorage gcs) throws Throwable {
        gcs.createBucket(TEST_BUCKET_NAME);
    }

    static {
        UPDATE_TIME = CREATE_TIME = Timestamp.newBuilder().build();
        TEST_BUCKET = Bucket.newBuilder().setName(TEST_BUCKET_NAME).setCreateTime(CREATE_TIME).setUpdateTime(UPDATE_TIME).build();
        TEST_BUCKET_WITH_OPTIONS = Bucket.newBuilder().setName("foo-bar-bucket").setStorageClass(BUCKET_STORAGE_CLASS).setLocation(BUCKET_LOCATION).setCreateTime(CREATE_TIME).setUpdateTime(UPDATE_TIME).setLifecycle(Bucket.Lifecycle.newBuilder().addRule(Bucket.Lifecycle.Rule.newBuilder().setAction(Bucket.Lifecycle.Rule.Action.newBuilder().setType("Delete")).setCondition(Bucket.Lifecycle.Rule.Condition.newBuilder().setAgeDays(10).build()).build()).build()).build();
        TEST_OBJECT = com.google.storage.v2.Object.newBuilder().setName(TEST_OBJECT_NAME).setBucket(BucketName.of((String)"", (String)TEST_BUCKET_NAME).toString()).setGeneration(123456L).setMetageneration(123L).setCreateTime(CREATE_TIME).setUpdateTime(UPDATE_TIME).setSize(1234L).build();
        transport = MockHttpTransportHelper.mockTransport((Object[])new Object[0]);
        mockStorage = new MockStorage();
    }
}

