/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.gcsio.GoogleCloudStorageClientGrpcDownscopingInterceptor;
import com.google.cloud.hadoop.util.AccessBoundary;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.SettableFuture;
import com.google.storage.v2.ComposeObjectRequest;
import com.google.storage.v2.DeleteObjectRequest;
import com.google.storage.v2.ReadObjectRequest;
import com.google.storage.v2.StartResumableWriteRequest;
import com.google.storage.v2.WriteObjectRequest;
import com.google.storage.v2.WriteObjectSpec;
import io.grpc.Attributes;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.Grpc;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.services.BinaryLogProvider;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.annotation.Nullable;
import junit.framework.TestCase;
import org.mockito.Mockito;

public class GoogleCloudStorageClientGrpcDownscopingInterceptorTest
extends TestCase {
    private static final Charset US_ASCII = StandardCharsets.US_ASCII;
    private AtomicReference<ClientCall.Listener<byte[]>> interceptedListener;
    private AtomicReference<Metadata> actualClientInitial;
    private AtomicReference<Object> actualRequest;
    private SettableFuture<Void> halfCloseCalled;
    private SettableFuture<Void> cancelCalled;
    private Channel channel;
    private DownscopeHandler handler;
    private GoogleCloudStorageClientGrpcDownscopingInterceptor interceptor;
    private Metadata clientInitial;
    private ClientCall.Listener<byte[]> listener;
    private SocketAddress peer = new InetSocketAddress("127.0.0.1", 1234);

    protected void setUp() throws Exception {
        this.interceptedListener = new AtomicReference();
        this.actualClientInitial = new AtomicReference();
        this.actualRequest = new AtomicReference();
        this.halfCloseCalled = SettableFuture.create();
        this.cancelCalled = SettableFuture.create();
        this.channel = new Channel(){

            public <RequestT, ResponseT> ClientCall<RequestT, ResponseT> newCall(MethodDescriptor<RequestT, ResponseT> methodDescriptor, CallOptions callOptions) {
                return new NoopClientCall<RequestT, ResponseT>(){

                    @Override
                    public void start(ClientCall.Listener<ResponseT> responseListener, Metadata headers) {
                        GoogleCloudStorageClientGrpcDownscopingInterceptorTest.this.interceptedListener.set(responseListener);
                        GoogleCloudStorageClientGrpcDownscopingInterceptorTest.this.actualClientInitial.set(headers);
                    }

                    @Override
                    public void sendMessage(RequestT message) {
                        GoogleCloudStorageClientGrpcDownscopingInterceptorTest.this.actualRequest.set(message);
                    }

                    @Override
                    public void cancel(String message, Throwable cause) {
                        GoogleCloudStorageClientGrpcDownscopingInterceptorTest.this.cancelCalled.set(null);
                    }

                    @Override
                    public void halfClose() {
                        GoogleCloudStorageClientGrpcDownscopingInterceptorTest.this.halfCloseCalled.set(null);
                    }

                    public Attributes getAttributes() {
                        return Attributes.newBuilder().set(Grpc.TRANSPORT_ATTR_REMOTE_ADDR, (Object)GoogleCloudStorageClientGrpcDownscopingInterceptorTest.this.peer).build();
                    }
                };
            }

            public String authority() {
                return "the-authority";
            }
        };
        this.handler = new DownscopeHandler();
        this.interceptor = new GoogleCloudStorageClientGrpcDownscopingInterceptor(this.handler.getDownscopeHandler());
        this.clientInitial = new Metadata();
        this.clientInitial.put(Metadata.Key.of((String)"a", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)"aaaaaaaaa");
        this.listener = new ClientCall.Listener<byte[]>(){

            public void onHeaders(Metadata headers) {
                super.onHeaders(headers);
            }
        };
    }

    public void testReadObjectRequest() {
        MethodDescriptor method = GoogleCloudStorageClientGrpcDownscopingInterceptorTest.getMethodDescriptor("google.storage.v2.Storage/ReadObject");
        ReadObjectRequest readObjectRequest = ReadObjectRequest.newBuilder().setObject(this.handler.getObjectName()).setBucket(this.handler.getFormattedBucketName()).build();
        ClientCall interceptedLoggingCall = this.interceptor.interceptCall(method, CallOptions.DEFAULT, this.channel);
        interceptedLoggingCall.start(this.listener, this.clientInitial);
        interceptedLoggingCall.sendMessage((Object)readObjectRequest);
        this.verify(interceptedLoggingCall, this.handler.getExpectedReadObjectHeader());
    }

    public void testWriteObjectRequest() {
        MethodDescriptor method = GoogleCloudStorageClientGrpcDownscopingInterceptorTest.getMethodDescriptor("google.storage.v2.Storage/WriteObject");
        WriteObjectRequest writeObjectRequest = WriteObjectRequest.newBuilder().setWriteObjectSpec(WriteObjectSpec.newBuilder().setResource(this.getObject()).build()).build();
        ClientCall interceptedLoggingCall = this.interceptor.interceptCall(method, CallOptions.DEFAULT, this.channel);
        interceptedLoggingCall.start(this.listener, this.clientInitial);
        interceptedLoggingCall.sendMessage((Object)writeObjectRequest);
        this.verify(interceptedLoggingCall, this.handler.getExpectedWriteObjectHeader());
    }

    public void testDeleteObjectRequest() {
        MethodDescriptor method = GoogleCloudStorageClientGrpcDownscopingInterceptorTest.getMethodDescriptor("google.storage.v2.Storage/DeleteObject");
        DeleteObjectRequest deleteObjectRequest = DeleteObjectRequest.newBuilder().setBucket(this.handler.getFormattedBucketName()).setObject(this.handler.getObjectName()).build();
        ClientCall interceptedLoggingCall = this.interceptor.interceptCall(method, CallOptions.DEFAULT, this.channel);
        interceptedLoggingCall.start(this.listener, this.clientInitial);
        interceptedLoggingCall.sendMessage((Object)deleteObjectRequest);
        this.verify(interceptedLoggingCall, this.handler.getExpectedDeleteObjectHeader());
    }

    public void testResumableUploadRequest() {
        MethodDescriptor method = GoogleCloudStorageClientGrpcDownscopingInterceptorTest.getMethodDescriptor("google.storage.v2.Storage/StartResumableWrite");
        StartResumableWriteRequest resumableWriteRequest = StartResumableWriteRequest.newBuilder().setWriteObjectSpec(WriteObjectSpec.newBuilder().setResource(this.getObject()).build()).build();
        ClientCall interceptedLoggingCall = this.interceptor.interceptCall(method, CallOptions.DEFAULT, this.channel);
        interceptedLoggingCall.start(this.listener, this.clientInitial);
        interceptedLoggingCall.sendMessage((Object)resumableWriteRequest);
        this.verify(interceptedLoggingCall, this.handler.getExpectedResumableUploadHeader());
    }

    public void testComposeObjectRequest() {
        MethodDescriptor method = GoogleCloudStorageClientGrpcDownscopingInterceptorTest.getMethodDescriptor("google.storage.v2.Storage/ComposeObject");
        ImmutableList sources = ImmutableList.of((Object)this.getSourceObject(), (Object)this.getSourceObject());
        ComposeObjectRequest composeObjectRequest = ComposeObjectRequest.newBuilder().setDestination(this.getObject()).addAllSourceObjects((Iterable)sources).build();
        ClientCall interceptedLoggingCall = this.interceptor.interceptCall(method, CallOptions.DEFAULT, this.channel);
        interceptedLoggingCall.start(this.listener, this.clientInitial);
        interceptedLoggingCall.sendMessage((Object)composeObjectRequest);
        this.verify(interceptedLoggingCall, this.handler.getExpectedComposeHeader((ImmutableList<ComposeObjectRequest.SourceObject>)sources));
    }

    private static MethodDescriptor getMethodDescriptor(String methodName) {
        return MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName(methodName).setRequestMarshaller((MethodDescriptor.Marshaller)Mockito.mock(MethodDescriptor.Marshaller.class)).setResponseMarshaller(BinaryLogProvider.BYTEARRAY_MARSHALLER).build();
    }

    private com.google.storage.v2.Object getObject() {
        return com.google.storage.v2.Object.newBuilder().setBucket(this.handler.getFormattedBucketName()).setName(this.handler.getObjectName()).build();
    }

    private ComposeObjectRequest.SourceObject getSourceObject() {
        return ComposeObjectRequest.SourceObject.newBuilder().setName(String.format("part-%s.part", ThreadLocalRandom.current().nextInt(1, 1000))).build();
    }

    private <ReqT> void verify(ClientCall<ReqT, byte[]> interceptedLoggingCall, String expectedAuthHeader) {
        String actualAuthHeader = (String)this.actualClientInitial.get().get(GoogleCloudStorageClientGrpcDownscopingInterceptor.AUTH_KEY);
        GoogleCloudStorageClientGrpcDownscopingInterceptorTest.assertEquals((String)expectedAuthHeader, (String)actualAuthHeader);
        interceptedLoggingCall.halfClose();
        byte[] response = "this is a response".getBytes(US_ASCII);
        this.interceptedListener.get().onMessage((Object)response);
    }

    private class NoopClientCall<RequestT, ResponseT>
    extends ClientCall<RequestT, ResponseT> {
        private NoopClientCall() {
        }

        public void start(ClientCall.Listener<ResponseT> listener, Metadata metadata) {
        }

        public void request(int i) {
        }

        public void cancel(@Nullable String s, @Nullable Throwable throwable) {
        }

        public void halfClose() {
        }

        public void sendMessage(RequestT requestT) {
        }
    }

    private static class DownscopeHandler {
        List<AccessBoundary> accessBoundaries;
        private String bucketName = String.format("bucket_%s", ThreadLocalRandom.current().nextInt(1, 1000));
        private String objectName = String.format("%s/dir/obj%s.text", this.getBucketName(), ThreadLocalRandom.current().nextInt(0, 100));

        DownscopeHandler() {
        }

        public Function<List<AccessBoundary>, String> getDownscopeHandler() {
            return new Function<List<AccessBoundary>, String>(){

                @Override
                public String apply(List<AccessBoundary> accessBoundaries) {
                    accessBoundaries = accessBoundaries;
                    StringBuilder sb = new StringBuilder();
                    for (AccessBoundary ab : accessBoundaries) {
                        sb.append(String.format("[%s;%s;%s]", ab.bucketName(), ab.objectName(), ab.action()));
                    }
                    return sb.toString();
                }
            };
        }

        public String getObjectName() {
            return this.objectName;
        }

        public String getBucketName() {
            return this.bucketName;
        }

        public String getFormattedBucketName() {
            return String.format("projects/_/buckets/%s", this.bucketName);
        }

        public String getExpectedReadObjectHeader() {
            return this.getHeader(AccessBoundary.Action.READ_OBJECTS);
        }

        private String getHeader(AccessBoundary.Action action) {
            return String.format("Bearer [%s;%s;%s]", this.bucketName, this.getObjectName(), action);
        }

        public String getExpectedWriteObjectHeader() {
            return this.getHeader(AccessBoundary.Action.WRITE_OBJECTS);
        }

        public String getExpectedDeleteObjectHeader() {
            return this.getHeader(AccessBoundary.Action.DELETE_OBJECTS);
        }

        public String getExpectedResumableUploadHeader() {
            return this.getHeader(AccessBoundary.Action.WRITE_OBJECTS);
        }

        public String getExpectedComposeHeader(ImmutableList<ComposeObjectRequest.SourceObject> sources) {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("[%s;%s;%s]", this.bucketName, this.getObjectName(), AccessBoundary.Action.WRITE_OBJECTS));
            for (ComposeObjectRequest.SourceObject so : sources) {
                sb.append(String.format("[%s;%s;%s]", this.bucketName, so.getName(), AccessBoundary.Action.READ_OBJECTS));
            }
            return String.format("Bearer %s", sb);
        }
    }
}

