/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.gcsio.FolderInfo;
import com.google.common.truth.Truth;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class FolderInfoTest {
    private final String BUCKET_NAME = "folder-info-test-bucket";
    private final String FOLDER_NAME = "test-parent-folder/test-folder-name";

    @Test
    public void checkForRootFolderWithNull() {
        Assert.assertThrows((String)"Folder resource has invalid bucket name", IllegalStateException.class, () -> new FolderInfo(FolderInfo.createFolderInfoObject(null, null)));
    }

    @Test
    public void checkForRootFolderWithEmptyString() {
        Assert.assertThrows((String)"Folder resource has invalid bucket name", IllegalStateException.class, () -> new FolderInfo(FolderInfo.createFolderInfoObject((String)"", (String)"")));
    }

    @Test
    public void checkForBucketWithNullFolder() {
        Assert.assertThrows((String)"Folder resource has invalid folder name", IllegalStateException.class, () -> new FolderInfo(FolderInfo.createFolderInfoObject((String)"folder-info-test-bucket", null)));
    }

    @Test
    public void checkForBucketWithEmptyFolder() {
        FolderInfo bucketFolderInfo = new FolderInfo(FolderInfo.createFolderInfoObject((String)"folder-info-test-bucket", (String)""));
        Truth.assertThat((String)bucketFolderInfo.getBucket()).isEqualTo((Object)"folder-info-test-bucket");
        Truth.assertThat((String)bucketFolderInfo.getFolderName()).isEqualTo((Object)"");
        Truth.assertThat((Boolean)bucketFolderInfo.isBucket()).isTrue();
        Truth.assertThat((String)bucketFolderInfo.getParentFolderName()).isEqualTo((Object)"");
    }

    @Test
    public void checkForNullBucket() {
        Assert.assertThrows((String)"Folder resource has invalid bucket name", IllegalStateException.class, () -> new FolderInfo(FolderInfo.createFolderInfoObject(null, (String)"test-parent-folder/test-folder-name")));
    }

    @Test
    public void checkForEmptyBucket() {
        Assert.assertThrows((String)"Folder resource has invalid bucket name", IllegalStateException.class, () -> new FolderInfo(FolderInfo.createFolderInfoObject((String)"", (String)"test-parent-folder/test-folder-name")));
    }

    @Test
    public void checkForFolder() {
        FolderInfo testFolderInfo = new FolderInfo(FolderInfo.createFolderInfoObject((String)"folder-info-test-bucket", (String)"test-parent-folder/test-folder-name"));
        Truth.assertThat((String)testFolderInfo.getBucket()).isEqualTo((Object)"folder-info-test-bucket");
        Truth.assertThat((String)testFolderInfo.getFolderName()).isEqualTo((Object)"test-parent-folder/test-folder-name/");
        Truth.assertThat((Boolean)testFolderInfo.isBucket()).isFalse();
        Truth.assertThat((String)testFolderInfo.getParentFolderName()).isEqualTo((Object)"test-parent-folder/");
    }

    @Test
    public void checkForFolderParent() {
        FolderInfo testFolderInfo = new FolderInfo(FolderInfo.createFolderInfoObject((String)"folder-info-test-bucket", (String)"test-parent-folder"));
        Truth.assertThat((String)testFolderInfo.getBucket()).isEqualTo((Object)"folder-info-test-bucket");
        Truth.assertThat((String)testFolderInfo.getFolderName()).isEqualTo((Object)"test-parent-folder/");
        Truth.assertThat((Boolean)testFolderInfo.isBucket()).isFalse();
        Truth.assertThat((String)testFolderInfo.getParentFolderName()).isEqualTo((Object)"");
    }
}

