/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.gcsio.FileAccessPatternManager;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.common.truth.Truth;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class FileAccessPatternManagerTest {
    private static final String BUCKET_NAME = "bucket-name";
    private static final String OBJECT_NAME = "object-name";
    private static final StorageResourceId RESOURCE_ID = new StorageResourceId("bucket-name", "object-name");

    @Test
    public void defaultAccessPatterns() {
        GoogleCloudStorageReadOptions readOptions = GoogleCloudStorageReadOptions.DEFAULT.toBuilder().setFadvise(GoogleCloudStorageReadOptions.Fadvise.SEQUENTIAL).build();
        FileAccessPatternManager fileAccessPattern = new FileAccessPatternManager(RESOURCE_ID, readOptions);
        Truth.assertThat((Boolean)fileAccessPattern.shouldAdaptToRandomAccess()).isFalse();
        readOptions = GoogleCloudStorageReadOptions.DEFAULT.toBuilder().setFadvise(GoogleCloudStorageReadOptions.Fadvise.RANDOM).build();
        fileAccessPattern = new FileAccessPatternManager(RESOURCE_ID, readOptions);
        Truth.assertThat((Boolean)fileAccessPattern.shouldAdaptToRandomAccess()).isTrue();
        readOptions = GoogleCloudStorageReadOptions.DEFAULT.toBuilder().setFadvise(GoogleCloudStorageReadOptions.Fadvise.AUTO).build();
        fileAccessPattern = new FileAccessPatternManager(RESOURCE_ID, readOptions);
        Truth.assertThat((Boolean)fileAccessPattern.shouldAdaptToRandomAccess()).isFalse();
        readOptions = GoogleCloudStorageReadOptions.DEFAULT.toBuilder().setFadvise(GoogleCloudStorageReadOptions.Fadvise.AUTO_RANDOM).build();
        fileAccessPattern = new FileAccessPatternManager(RESOURCE_ID, readOptions);
        Truth.assertThat((Boolean)fileAccessPattern.shouldAdaptToRandomAccess()).isTrue();
    }

    @Test
    public void testOverridenPattern() {
        GoogleCloudStorageReadOptions readOptions = GoogleCloudStorageReadOptions.DEFAULT.toBuilder().setFadvise(GoogleCloudStorageReadOptions.Fadvise.AUTO).build();
        long lastServedIndex = 10L;
        long currentPosition = 0L;
        FileAccessPatternManager fileAccessPattern = new FileAccessPatternManager(RESOURCE_ID, readOptions);
        Truth.assertThat((Boolean)fileAccessPattern.shouldAdaptToRandomAccess()).isFalse();
        fileAccessPattern.updateLastServedIndex(lastServedIndex);
        fileAccessPattern.updateAccessPattern(currentPosition);
        Truth.assertThat((Boolean)fileAccessPattern.shouldAdaptToRandomAccess()).isTrue();
        fileAccessPattern = new FileAccessPatternManager(RESOURCE_ID, readOptions);
        fileAccessPattern.overrideAccessPattern(false);
        fileAccessPattern.updateLastServedIndex(lastServedIndex);
        fileAccessPattern.updateAccessPattern(currentPosition);
        Truth.assertThat((Boolean)fileAccessPattern.shouldAdaptToRandomAccess()).isFalse();
        lastServedIndex = 10L;
        currentPosition = 11L;
        readOptions = GoogleCloudStorageReadOptions.DEFAULT.toBuilder().setFadvise(GoogleCloudStorageReadOptions.Fadvise.AUTO_RANDOM).setFadviseRequestTrackCount(1).build();
        fileAccessPattern = new FileAccessPatternManager(RESOURCE_ID, readOptions);
        Truth.assertThat((Boolean)fileAccessPattern.shouldAdaptToRandomAccess()).isTrue();
        fileAccessPattern.updateLastServedIndex(lastServedIndex);
        fileAccessPattern.updateAccessPattern(currentPosition);
        Truth.assertThat((Boolean)fileAccessPattern.shouldAdaptToRandomAccess()).isFalse();
        fileAccessPattern = new FileAccessPatternManager(RESOURCE_ID, readOptions);
        fileAccessPattern.overrideAccessPattern(true);
        Truth.assertThat((Boolean)fileAccessPattern.shouldAdaptToRandomAccess()).isTrue();
        fileAccessPattern.updateLastServedIndex(lastServedIndex);
        fileAccessPattern.updateAccessPattern(currentPosition);
        Truth.assertThat((Boolean)fileAccessPattern.shouldAdaptToRandomAccess()).isTrue();
    }

    @Test
    public void testAutoMode() {
        GoogleCloudStorageReadOptions readOptions = GoogleCloudStorageReadOptions.DEFAULT.toBuilder().setFadvise(GoogleCloudStorageReadOptions.Fadvise.AUTO).build();
        long lastServedIndex = 10L;
        long currentPosition = 0L;
        FileAccessPatternManager fileAccessPattern = new FileAccessPatternManager(RESOURCE_ID, readOptions);
        Truth.assertThat((Boolean)fileAccessPattern.shouldAdaptToRandomAccess()).isFalse();
        fileAccessPattern.updateLastServedIndex(lastServedIndex);
        fileAccessPattern.updateAccessPattern(currentPosition);
        Truth.assertThat((Boolean)fileAccessPattern.shouldAdaptToRandomAccess()).isTrue();
    }

    @Test
    public void testAutoRandomMode() {
        GoogleCloudStorageReadOptions readOptions = GoogleCloudStorageReadOptions.DEFAULT.toBuilder().setFadvise(GoogleCloudStorageReadOptions.Fadvise.AUTO_RANDOM).setFadviseRequestTrackCount(3).setInplaceSeekLimit(10L).build();
        FileAccessPatternManager fileAccessPattern = new FileAccessPatternManager(RESOURCE_ID, readOptions);
        long[] readIndexes = new long[]{0L, 1L, 2L, 3L, 4L, 0L, 1L, 2L, 3L, 4L};
        boolean[] expectedRandomAccess = new boolean[]{true, true, true, false, false, true, true, true, true, true};
        this.verifyAccessPattern(fileAccessPattern, readIndexes, expectedRandomAccess);
        readIndexes = new long[]{0L, 1L, 2L, 3L, 4L, 15L, 16L, 17L, 18L, 19L};
        expectedRandomAccess = new boolean[]{true, true, true, false, false, true, true, true, true, true};
        fileAccessPattern = new FileAccessPatternManager(RESOURCE_ID, readOptions);
        this.verifyAccessPattern(fileAccessPattern, readIndexes, expectedRandomAccess);
        readIndexes = new long[]{1L, 0L, 1L, 2L, 3L, 4L};
        expectedRandomAccess = new boolean[]{true, true, true, true, true, true};
        fileAccessPattern = new FileAccessPatternManager(RESOURCE_ID, readOptions);
        this.verifyAccessPattern(fileAccessPattern, readIndexes, expectedRandomAccess);
        readIndexes = new long[]{0L, 15L, 1L, 2L, 3L, 4L};
        expectedRandomAccess = new boolean[]{true, true, true, true, true, true};
        fileAccessPattern = new FileAccessPatternManager(RESOURCE_ID, readOptions);
        this.verifyAccessPattern(fileAccessPattern, readIndexes, expectedRandomAccess);
    }

    private void verifyAccessPattern(FileAccessPatternManager fileAccessPattern, long[] readIndexes, boolean[] expectedRandomAccessPattern) {
        for (int i = 0; i < readIndexes.length; ++i) {
            long currentPosition = readIndexes[i];
            fileAccessPattern.updateAccessPattern(currentPosition);
            Truth.assertThat((Boolean)fileAccessPattern.shouldAdaptToRandomAccess()).isEqualTo((Object)expectedRandomAccessPattern[i]);
            fileAccessPattern.updateLastServedIndex(currentPosition);
        }
    }
}

